/****************************************************************************
10 Yard Fight Driver.

L Taylor
J Clegg

Loosely based on the Kung Fu Master driver.

****************************************************************************/

#include "driver.h"
#include "Z80/Z80.h"
#include "sndhrdw/8910intf.h"
#include "vidhrdw/generic.h"


extern unsigned char *yard_scroll_x_low;
extern unsigned char *yard_scroll_x_high;
extern unsigned char *yard_scroll_y_low;
extern unsigned char *yard_sprite_priority; /* JB 970912 */

void yard_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
int yard_vh_start(void);
void yard_vh_stop(void);
void yard_vh_screenrefresh(struct osd_bitmap *bitmap);

extern unsigned char *mpatrol_io_ram;
extern unsigned char *mpatrol_sample_data;
extern unsigned char *mpatrol_sample_table;
int mpatrol_sh_init(const char *);
int mpatrol_sh_start(void);
int mpatrol_sh_interrupt(void);
void mpatrol_io_w(int offset, int value);
int mpatrol_io_r(int offset);
void mpatrol_sample_trigger_w(int offset,int value);
void mpatrol_sound_cmd_w(int offset, int value);



static struct MemoryReadAddress readmem[] =
{
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0x8000, 0x9fff, MRA_RAM },         /* Video and Color ram */
	{ 0xd000, 0xd000, input_port_0_r },	/* IN0 */
	{ 0xd001, 0xd001, input_port_1_r },	/* IN1 */
	{ 0xd002, 0xd002, input_port_2_r },	/* IN2 */
	{ 0xd003, 0xd003, input_port_3_r },	/* DSW1 */
	{ 0xd004, 0xd004, input_port_4_r },	/* DSW2 */
	{ 0xe000, 0xefff, MRA_RAM },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem[] =
{
	{ 0x0000, 0x7fff, MWA_ROM },
	{ 0x8000, 0x9fff, videoram_w, &videoram, &videoram_size },
	{ 0xc820, 0xc87f, MWA_RAM, &spriteram, &spriteram_size },
	{ 0xa000, 0xa000, MWA_RAM, &yard_scroll_x_low },
	{ 0xa200, 0xa200, MWA_RAM, &yard_scroll_x_high },
	{ 0xa400, 0xa400, MWA_RAM, &yard_scroll_y_low },
	{ 0xa800, 0xa800, MWA_RAM, &yard_sprite_priority }, /* JB 970912 */
	{ 0xd000, 0xd001, mpatrol_sound_cmd_w }, /* JB 971012 */
	{ 0xe000, 0xefff, MWA_RAM },
	{ -1 }	/* end of table */
};

static struct IOReadPort readport[] =
{
	{ -1 }	/* end of table */
};

static struct IOWritePort writeport[] =
{
	{ -1 }	/* end of table */
};

static struct MemoryReadAddress sound_readmem[] =
{
	{ 0x0000, 0x001f, mpatrol_io_r, &mpatrol_io_ram },
	{ 0x0080, 0x00ff, MRA_RAM },
	{ 0x8000, 0xffff, MRA_ROM },
	{ 0xe780, 0xe7bf, MRA_ROM, &mpatrol_sample_table },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress sound_writemem[] =
{
	{ 0x0000, 0x001f, mpatrol_io_w },
	{ 0x00c4, 0x00cb, mpatrol_sample_trigger_w, &mpatrol_sample_data },
	{ 0x0080, 0x00ff, MWA_RAM },
	{ 0x0801, 0x0802, MWA_NOP },
	{ 0x8000, 0xffff, MWA_ROM },
	{ -1 }	/* end of table */
};



INPUT_PORTS_START( yard_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	/* coin input must be active for 19 frames to be consistently recognized */
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_COIN3 | IPF_IMPULSE,
		"Coin Aux", IP_KEY_DEFAULT, IP_JOY_DEFAULT, 19 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x01, 0x01, "SW1A", IP_KEY_NONE )
	PORT_DIPSETTING( 0x01, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "SW2A", IP_KEY_NONE )
	PORT_DIPSETTING( 0x02, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_DIPNAME( 0x0c, 0x0c, "Time Reduced", IP_KEY_NONE )
	PORT_DIPSETTING( 0x0c, "Normal" )
	PORT_DIPSETTING( 0x08, "x 1.3" )
	PORT_DIPSETTING( 0x04, "x 1.5" )
	PORT_DIPSETTING( 0x00, "x 1.8" )
	/* TODO: support the different settings which happen in Coin Mode 2 */
	PORT_DIPNAME( 0xf0, 0xf0, "Coinage", IP_KEY_NONE ) /* mapped on coin mode 1 */
	PORT_DIPSETTING(    0xa0, "6 Coins/1 Credit" )
	PORT_DIPSETTING(    0xb0, "5 Coins/1 Credit" )
	PORT_DIPSETTING(    0xc0, "4 Coins/1 Credit" )
	PORT_DIPSETTING(    0xd0, "3 Coins/1 Credit" )
	PORT_DIPSETTING(    0xe0, "2 Coins/1 Credit" )
	PORT_DIPSETTING(    0xf0, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x70, "1 Coin/2 Credits" )
	PORT_DIPSETTING(    0x60, "1 Coin/3 Credits" )
	PORT_DIPSETTING(    0x50, "1 Coin/4 Credits" )
	PORT_DIPSETTING(    0x40, "1 Coin/5 Credits" )
	PORT_DIPSETTING(    0x30, "1 Coin/6 Credits" )
	PORT_DIPSETTING(    0x00, "Free Play" )
	/* settings 0x10, 0x20, 0x80, 0x90 all give 1 Coin/1 Credit */

	PORT_START	/* DSW2 */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x00, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Upright" )
	PORT_DIPSETTING(    0x02, "Cocktail" )
/* This activates a different coin mode. Look at the dip switch setting schematic */
	PORT_DIPNAME( 0x04, 0x04, "Coin Mode", IP_KEY_NONE )
	PORT_DIPSETTING(    0x04, "Mode 1" )
	PORT_DIPSETTING(    0x00, "Mode 2" )
	PORT_BITX(    0x08, 0x08, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Slow Motion", IP_KEY_NONE, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x08, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x10, 0x10, "SW5B", IP_KEY_NONE )
	PORT_DIPSETTING( 0x10, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_DIPNAME( 0x20, 0x20, "SW6B", IP_KEY_NONE )
	PORT_DIPSETTING( 0x20, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_BITX(    0x40, 0x40, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Invulnerability", IP_KEY_NONE, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x40, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BITX(    0x80, 0x80, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END

/* exactly the same as yard, only difference is the Allow Continue dip switch */
/* Also, the Cabinet dip switch doesn't seem to work. */
INPUT_PORTS_START( vsyard_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	/* coin input must be active for 19 frames to be consistently recognized */
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_COIN3 | IPF_IMPULSE,
		"Coin Aux", IP_KEY_DEFAULT, IP_JOY_DEFAULT, 19 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x01, 0x00, "Continue (Vs. Mode Only)", IP_KEY_NONE )
	PORT_DIPSETTING( 0x01, "No" )
	PORT_DIPSETTING( 0x00, "Yes" )
	PORT_DIPNAME( 0x02, 0x02, "SW2A", IP_KEY_NONE )
	PORT_DIPSETTING( 0x02, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_DIPNAME( 0x0c, 0x0c, "Time Reduced", IP_KEY_NONE )
	PORT_DIPSETTING( 0x0c, "Normal" )
	PORT_DIPSETTING( 0x08, "x 1.3" )
	PORT_DIPSETTING( 0x04, "x 1.5" )
	PORT_DIPSETTING( 0x00, "x 1.8" )
	/* TODO: support the different settings which happen in Coin Mode 2 */
	PORT_DIPNAME( 0xf0, 0xf0, "Coinage", IP_KEY_NONE ) /* mapped on coin mode 1 */
	PORT_DIPSETTING(    0xa0, "6 Coins/1 Credit" )
	PORT_DIPSETTING(    0xb0, "5 Coins/1 Credit" )
	PORT_DIPSETTING(    0xc0, "4 Coins/1 Credit" )
	PORT_DIPSETTING(    0xd0, "3 Coins/1 Credit" )
	PORT_DIPSETTING(    0xe0, "2 Coins/1 Credit" )
	PORT_DIPSETTING(    0xf0, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x70, "1 Coin/2 Credits" )
	PORT_DIPSETTING(    0x60, "1 Coin/3 Credits" )
	PORT_DIPSETTING(    0x50, "1 Coin/4 Credits" )
	PORT_DIPSETTING(    0x40, "1 Coin/5 Credits" )
	PORT_DIPSETTING(    0x30, "1 Coin/6 Credits" )
	PORT_DIPSETTING(    0x00, "Free Play" )
	/* settings 0x10, 0x20, 0x80, 0x90 all give 1 Coin/1 Credit */

	PORT_START	/* DSW2 */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x00, "Cabinet?", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Upright" )
	PORT_DIPSETTING(    0x02, "Cocktail" )
/* This activates a different coin mode. Look at the dip switch setting schematic */
	PORT_DIPNAME( 0x04, 0x04, "Coin Mode", IP_KEY_NONE )
	PORT_DIPSETTING(    0x04, "Mode 1" )
	PORT_DIPSETTING(    0x00, "Mode 2" )
	PORT_BITX(    0x08, 0x08, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Slow Motion", IP_KEY_NONE, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x08, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x10, 0x10, "SW5B", IP_KEY_NONE )
	PORT_DIPSETTING( 0x10, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_DIPNAME( 0x20, 0x20, "SW6B", IP_KEY_NONE )
	PORT_DIPSETTING( 0x20, "Off" )
	PORT_DIPSETTING( 0x00, "On" )
	PORT_BITX(    0x40, 0x40, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Invulnerability", IP_KEY_NONE, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x40, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BITX(    0x80, 0x80, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END



static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	1024,	/* 1024 characters */
	3,	/* 3 bits per pixel */
	{ 2*1024*8*8, 1024*8*8, 0 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 8*0, 8*1, 8*2, 8*3, 8*4, 8*5, 8*6, 8*7 },
	8*8	/* every char takes 8 consecutive bytes */
};
static struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	256,	/* 256 sprites */
	3,	/* 3 bits per pixel */
	{ 2*0x4000*8, 0x4000*8, 0 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 16*8+0, 16*8+1, 16*8+2, 16*8+3, 16*8+4, 16*8+5, 16*8+6, 16*8+7},
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8, 8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8 },
	32*8	/* every sprite takes 32 consecutive bytes */
};

/* there's nothing here, this is just a placeholder to let the video hardware */
/* pick the radar color table. */
static struct GfxLayout fakelayout =
{
	1,1,
	0,
	2,	/* 2 bits per pixel */
	{ 0 },
	{ 0 },
	{ 0 },
	0
};


static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x00000, &charlayout,           0, 32 },
	{ 1, 0x06000, &spritelayout,      32*8, 32 },
	{ 1, 0x08000, &spritelayout,      32*8, 32 },
	{ 0, 0,       &fakelayout,   32*8+32*8, 64 },
	{ -1 } /* end of array */
};



static unsigned char color_prom[] =
{
	/* 1c - chars palette low 4 bits */
	0x00,0x07,0x07,0x00,0x0F,0x07,0x00,0x00,0x00,0x09,0x0F,0x00,0x08,0x07,0x08,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0B,0x0B,0x0B,0x00,0x00,0x09,
	0x00,0x0F,0x08,0x07,0x06,0x07,0x02,0x00,0x00,0x03,0x07,0x03,0x07,0x02,0x06,0x00,
	0x00,0x0F,0x08,0x07,0x00,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x08,0x07,0x06,0x07,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 1d - chars palette high 4 bits */
	0x00,0x00,0x00,0x00,0x03,0x00,0x0C,0x00,0x00,0x08,0x0F,0x00,0x0F,0x0C,0x03,0x00,
	0x00,0x02,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x05,0x05,0x05,0x00,0x00,0x08,
	0x00,0x0F,0x0F,0x00,0x0A,0x0E,0x0E,0x02,0x00,0x00,0x0E,0x00,0x0E,0x0E,0x0A,0x02,
	0x00,0x0F,0x0F,0x00,0x0C,0x0A,0x0E,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0C,0x0F,0x00,0x0A,0x0E,0x0E,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 1f - sprites palette */
	0x00,0xC0,0xF8,0x47,0xFF,0x5B,0xEC,0x6F,0xC6,0x10,0x90,0xA0,0x00,0xBC,0x51,0x8A,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 2h - sprites lookup table */
	0x00,0x01,0x02,0x03,0x04,0x0C,0x05,0x06,0x00,0x0C,0x04,0x05,0x07,0x0C,0x03,0x06,
	0x00,0x08,0x09,0x01,0x02,0x0C,0x03,0x06,0x00,0x0C,0x04,0x06,0x01,0x04,0x00,0x00,
	0x00,0x0A,0x0E,0x04,0x02,0x00,0x00,0x00,0x00,0x04,0x01,0x07,0x03,0x06,0x05,0x0A,
	0x00,0x08,0x00,0x0A,0x00,0x00,0x07,0x00,0x00,0x00,0x0D,0x00,0x0A,0x00,0x00,0x03,
	0x00,0x08,0x0D,0x0A,0x0A,0x00,0x07,0x03,0x00,0x04,0x08,0x01,0x02,0x0A,0x06,0x0B,
	0x00,0x0C,0x04,0x05,0x07,0x0C,0x03,0x06,0x00,0x05,0x04,0x0F,0x07,0x0C,0x03,0x06,
	0x00,0x0F,0x04,0x09,0x07,0x0C,0x03,0x06,0x00,0x0C,0x04,0x0B,0x07,0x0C,0x03,0x06,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 2n - radar palette low 4 bits */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x08,0x08,0x08,0x00,0x08,0x08,0x08,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,
	0x00,0x0F,0x08,0x07,0x00,0x0F,0x08,0x07,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,
	0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,
	0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 2m - radar palette high 4 bits */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x0C,0x00,0x00,0x0F,0x0C,0x00,0x00,0x0F,0x0C,0x00,0x00,0x0F,0x0C,0x00,
	0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,0x00,0x0F,0x0C,0x0C,
	0x00,0x0F,0x0E,0x00,0x00,0x0F,0x0E,0x00,0x00,0x0C,0x0F,0x0F,0x00,0x0C,0x0F,0x0F,
	0x00,0x03,0x03,0x03,0x00,0x03,0x03,0x03,0x00,0x03,0x03,0x03,0x00,0x03,0x03,0x03,
	0x00,0x03,0x03,0x03,0x00,0x03,0x03,0x03,0x00,0x03,0x03,0x03,0x00,0x03,0x03,0x03,
	0x00,0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};


static struct MachineDriver machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			4000000,	/* 4 Mhz (?) */
			0,
			readmem,writemem,readport,writeport,
			interrupt,1
		},
		/* JB 971012 */
		{
			CPU_M6802 | CPU_AUDIO_CPU,
			1000000,	/* 1.0 Mhz ? */
			2,
			sound_readmem,sound_writemem,0,0,
			nmi_interrupt,68	/* 68 ints per frame = 4080 ints/sec */
		}
	},
	60,
	10,	/* 10 CPU slices per frame - enough for the sound CPU to read all commands */ /* JB 971012 */
	0,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 1*8, 31*8-1 },
	gfxdecodeinfo,
	256, 32*8+32*8+64*4,
	yard_vh_convert_color_prom,

	VIDEO_TYPE_RASTER,
	0,
	yard_vh_start,
	yard_vh_stop,
	yard_vh_screenrefresh,

	/* sound hardware */
	mpatrol_sh_init,
	/* JB 971012 */
	mpatrol_sh_start,
	AY8910_sh_stop,
	AY8910_sh_update
};


/***************************************************************************

  Game driver(s)

***************************************************************************/
ROM_START( yard_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "yf-a-3p", 0x0000, 0x2000, 0x1aa183d3 )
	ROM_LOAD( "yf-a-3n", 0x2000, 0x2000, 0xb2eef1ac )
	ROM_LOAD( "yf-a-3m", 0x4000, 0x2000, 0xaf85993d )

	ROM_REGION(0x12000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "yf-a-3e", 0x00000, 0x2000, 0xab018fe9 )	/* chars */
	ROM_LOAD( "yf-a-3d", 0x02000, 0x2000, 0x82a60c38 )
	ROM_LOAD( "yf-a-3c", 0x04000, 0x2000, 0xdcd73627 )
	ROM_LOAD( "yf-b-5b", 0x06000, 0x2000, 0x5331aec5 )	/* sprites */
	ROM_LOAD( "yf-b-5c", 0x08000, 0x2000, 0xc052c88c )
	ROM_LOAD( "yf-b-5f", 0x0a000, 0x2000, 0x7fdade5c )
	ROM_LOAD( "yf-b-5e", 0x0c000, 0x2000, 0x8ed559bd )
	ROM_LOAD( "yf-b-5j", 0x0e000, 0x2000, 0x687142a1 )
	ROM_LOAD( "yf-b-5k", 0x10000, 0x2000, 0x0143b99b )

	/* JB 971012 */
	ROM_REGION(0x10000)	/* 64k for sound cpu */
	/* should the samples be loaded here ??? */
	ROM_LOAD( "yf-s-3b", 0x8000, 0x2000, 0xbbb87550 )		/* samples (ADPCM 4-bit) */
	ROM_LOAD( "yf-s-1b", 0xa000, 0x2000, 0xec2129c1 )		/* samples (ADPCM 4-bit) */
	ROM_LOAD( "yf-s-3a", 0xc000, 0x2000, 0xf4962ed6 )		/* samples (ADPCM 4-bit) */
	ROM_LOAD( "yf-s-1a", 0xe000, 0x2000, 0xb2b58731 )
ROM_END


ROM_START( vsyard_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "yf-a-3n", 0x0000, 0x2000, 0x62af9fe3 )
	ROM_LOAD( "yf-a-3m", 0x2000, 0x2000, 0x05825f66 )
	ROM_LOAD( "yf-a-3k", 0x4000, 0x2000, 0xc22e2aca )

	ROM_REGION(0x12000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "yf-a-3a", 0x00000, 0x2000, 0x1be716f5 )	/* chars */
	ROM_LOAD( "yf-a-3c", 0x02000, 0x2000, 0x83060c38 )
	ROM_LOAD( "yf-a-3d", 0x04000, 0x2000, 0xdd373627 )
	ROM_LOAD( "yf-b-5c", 0x06000, 0x2000, 0x5331aec5 )	/* sprites */
	ROM_LOAD( "yf-b-5a", 0x08000, 0x2000, 0xc052c88c )
	ROM_LOAD( "yf-b-5e", 0x0a000, 0x2000, 0x7fdade5c )
	ROM_LOAD( "yf-b-5d", 0x0c000, 0x2000, 0x8ed559bd )
	ROM_LOAD( "yf-b-5j", 0x0e000, 0x2000, 0x687142a1 )
	ROM_LOAD( "yf-b-5h", 0x10000, 0x2000, 0x0143b99b )

	/* JB 971012 */
	ROM_REGION(0x10000)	/* 64k for sound cpu */
	/* should the samples be loaded here ??? */
	ROM_LOAD( "yf-s-3b", 0x8000, 0x2000, 0xbbb87550 )		/* samples (ADPCM 4-bit) */
	ROM_LOAD( "yf-s-1b", 0xa000, 0x2000, 0xec2129c1 )		/* samples (ADPCM 4-bit) */
	ROM_LOAD( "yf-s-3a", 0xc000, 0x2000, 0xf4962ed6 )		/* samples (ADPCM 4-bit) */
	ROM_LOAD( "yf-s-1a", 0xe000, 0x2000, 0xb2b58731 )
ROM_END


/* JB 971009 */
static int hiload(void)
{
	/* get RAM pointer (this game is multiCPU, we can't assume the global */
	/* RAM pointer is pointing to the right place) */
	unsigned char *RAM = Machine->memory_region[0];

	/* check if the hi score table has already been initialized */
	if (memcmp(&RAM[0xe600],"\x00\x65\x03",3) == 0 &&
			(RAM[0xe684] | RAM[0xe685] | RAM[0xe686]) != 0)	/* JB 971014 */
	{
		void *f;


		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&RAM[0xe600],6*23);
			RAM[0xe008] = RAM[0xe600];
			RAM[0xe009] = RAM[0xe601];
			RAM[0xe00a] = RAM[0xe602];
			osd_fclose(f);
		}

		return 1;
	}
	else return 0;	/* we can't load the hi scores yet */
}


/* JB 971009 */
static void hisave(void)
{
	void *f;
	/* get RAM pointer (this game is multiCPU, we can't assume the global */
	/* RAM pointer is pointing to the right place) */
	unsigned char *RAM = Machine->memory_region[0];


	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&RAM[0xe600],6*23);
		osd_fclose(f);
	}
	memset(&RAM[0xe600], 0, 6*23);	/* JB 971014 */
}


struct GameDriver yard_driver =
{
	"10 Yard Fight",
	"yard",
	"Lee Taylor\nJohn Clegg\nMirko Buffoni\nNicola Salmoria\nIshmair\nTim Lindquist (color info)\nAaron Giles (sound)\nKevin Brisley (hiscores)",
	&machine_driver,

	yard_rom,
	0, 0,
	0,
	0,	/* sound_prom */

	0/*TBR*/,yard_input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave /* JB 971009 */
};


struct GameDriver vsyard_driver =
{
	"10 Yard Fight (Vs. version)",
	"vsyard",
	"Lee Taylor\nJohn Clegg\nMirko Buffoni\nNicola Salmoria\nIshmair\nTim Lindquist (color info)\nAaron Giles (sound)\nKevin Brisley (hiscores)",
	&machine_driver,

	vsyard_rom,
	0, 0,
	0,
	0,	/* sound_prom */

	0/*TBR*/,vsyard_input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave /* JB 971009 */
};
