/***************************************************************************

Pendings.

background   color mapping table
sprite       color mapping table
sprite , background , font draeing position adjust
exchange sprite set 1 and 2
1P/2P start switch , blaster button (custom_ic)
sound support ( custom_ic sound command )
palette prom (I dont have)
sprite , font & background & scroll position adjust

general map
-----------+---+-----------------+-------------------------
   hex     |r/w| D D D D D D D D |
 location  |   | 7 6 5 4 3 2 1 0 | function
-----------+---+-----------------+-------------------------
0000-3FFF  | R | D D D D D D D D | CPU 1 master rom (16k)
0000-1FFF  | R | D D D D D D D D | CPU 2 motion rom (8k)
0000-0FFF  | R | D D D D D D D D | CPU 3 sound  rom (4k)
-----------+---+-----------------+-------------------------
6800-680F  | W | - - - - D D D D | Audio control
6810-681F  | W | - - - - D D D D | Audio control
-----------+---+-----------------+-------------------------
6820       | W | - - - - - - - D | 0 = Reset IRQ1(latched)
6821       | W | - - - - - - - D | 0 = Reset IRQ2(latched)
6822       | W | - - - - - - - D | 0 = Reset NMI3(latched)
6823       | W | - - - - - - - D | 0 = Reset #2,#3 CPU
-----------+---+-----------------+-------------------------
6830       | W |                 | watchdog reset
-----------+---+-----------------+-------------------------
7000       |R/W| D D D D D D D D | custom 06 Data
7100       |R/W| D D D D D D D D | custom 06 Command
7???                               CPU #1 NMI REQUEST
-----------+---+-----------------+-------------------------
7800-7FFF  |R/W| D D D D D D D D | 2k work ram
-----------+---+-----------------+-------------------------
8000-87FF  |R/W| D D D D D D D D | 2k playfeild RAM
-----------+---+-----------------+-------------------------
8000-877F  |R/W| D D D D D D D D | RAM
8780-87FF  |R/W| D D D D D D D D | 2k sprite RAM (X-POS)
9000-977F  |R/W| D D D D D D D D | RAM
9780-97FF  |R/W| D D D D D D D D | 2k sprite RAM (HSIZE,MODE ??)
A000-A77F  |R/W| D D D D D D D D | RAM
A780-A7FF  |R/W| D D D D D D D D | 2k sprite RAM (PIC)
-----------+---+-----------------+-------------------------
B000-BFFF  |R/W| D D D D D D D D | 4k playfeild RAM ( ATTRIB)
C000-CFFF  |R/W| D D D D D D D D | 4k playfeild RAM ( PIC )
-----------+---+-----------------+-------------------------
D000-D00F  | W | D D D D D D D D | A0->D8:background Y scroll position
D010-D01F  | W | D D D D D D D D | A0->D8:font Y scroll position ??
D020-D02F  | W | D D D D D D D D | A0->D8:background X scroll position ??
D030-D03F  | W | D D D D D D D D | A0->D8:font X scroll position ?
D070-D07F  | W |               D | display flip mode ?
-----------+---+-----------------+-------------------------
F000       | W | D D D D D D D D | planet map position low ?
F001       | W | D D D D D D D D | planet map position high ?
F000       | R | D D D D D D D D | planet map data low ?
F001       | R | D D D D D D D D | planet map data high ?
-----------+---+-----------------+-------------------------
Xevious memory map (preliminary)

  Z80-1:MASTER CPU
    0000H-3FFFH R   P-ROM
    4000H-FFFFH R/W shared area
  Z80-2:MOTION CUP
    0000H-1FFFH R   P-ROM
    4000H-FFFFH R/W shared area
  Z80-3:SOUND CPU
    0000H-1FFFH R   P-ROM
    4000H-FFFFH R/W shared area
  shared area.
    6800H-6807H R   DIP SWITCH READ
                      A0-2 : bit select(6800H=bit0 , 6801=bit1,6807=bit7)
                      D0   : DIP SW.A bit read
                      D1   : DIP SW.B bit read
                    DIP SW.A
                      Bit0 = BLASTER SWITCH
    6800H-680FH R   shadow(6800H-6807H)
    6800H-681FH W   Sound RAM0 (same to DIGDUG ?)
                      D0-3:data
    6810H-681FH W   Sound RAM1
                      D0-3:data
    6820H       W   MASTER-INTERRUPT CLEAR & ENABLE
                      D0 = 0:CLEAR & DISABLE / 1:ENABLE
    6821H       W   MOTION-INTERRUPT CLEAR & ENABLE
                      D0 = 0:CLEAR & DISABLE / 1:ENABLE
    6822H       W   SOUND -NMI CONTROLL
                      D0 = 0:NMI ON / 1:NMI OFF
    6823H       W   CPU 2,3 RESET CONTROLL
                      D0 = 0:RESET
    6830H-683F  W   WDR Watch dock timer clear
    6840H-6FFFH R/W shadow(6800H-603FH)
    7000H       R   custom-io data read ( after CPU #1 NMI )
    7000H       W   custom-io data write( after CPU #1 NMI )
    7100H       R   custom-io timming port
                     bit7  :1=busy ?
                     bit6  :1=busy ?
                     bit5  :1=busy ?
    7100H       W   custom-io command write
    7???H       W   sound ganarator (controll by custom_ic ?)
    7800H-7FFFH R/W S-RAM
    8000H-87FFh R/W ram ( master cpu )
    8780H-87FFH R/W sprite X position ( 80-bf:used by master,c0-ff:used by motion)
                      A0=0:sprite Y position (OFF = 0xef )
                      A0=1:sprite X position
    8800H-8FFFH R/W shadow(8000H-87FFH)
    9000H-97FFH R/W ram ( motion cpu )
    9780H-97FFH R/W sprite attribute
                      A0=0:attribute Y
                        bit0  :HSIZE  :sprite Y size ?
                        bit1  :HUNDZ  :?
                        bit2  :FLOP   :Y flip
                        bit3  :HUKAIRS:?
                        bit4-6:MD4-6  :?
                        bit7  :BIT3   :select sprite set (0=4M,4P,4R 3bit:1=4N 2bit )
                      A0=0:attribute X
                        bit0  :HSIZE  :sprite X size ?
                        bit1  :HUNDZ  :?
                        bit2  :FLOP   :X flip
                        bit3  :HUKAIRS:?
                        bit4-6:MD4-6  :?
                        bit7  :BIT3   :?
    9800H-9FFFH R/W shadow(9000H-97FFH)
    A000H-A7FFH R/W ram ( sound cpu , master cpu )
    A780H-a7FFH R/W sprite character nnumber
                      A0=0 character pattern name
                      A0=1 color map select
    A800H-AFFFH R/W shadow(A000H-A7FFH)
    B000H-BFFFH R/W background attrivute ( have 2 scroll planes ? )
                    D0-D1:COL0,1 palette set ?
                    D1-D5:ANI0-3 color code  ?( font,bg use )
                    D6   :ANF    X flip
                    D7   :PFF    Y flip
    C000H-CFFFH R/W background character ( have 2 scroll planes ? )
    D000H-D07FH  W  CRTC access? (custom-13)
    D???H        W  display flip select (TABLE 1P/2P mode)
                      bit0  :FLIP
    F000H        W  BS0 xevious planet map select low ?
    F001H        W  BB1 xeviosu planet map select high ?
    F000H        R  BB0 xevious planet map get low ?
    F001H        R  BS1 xevious planet map get high ?
    F002-FFFFH      shodow(F000H-F001H)

3)schematic diagram block.

   Sheet 4A : main cpu , address decoder(4000h-7fffh) , sram
   Sheet 4B : motion cpu
   Sheet 5A : sound cpu
   Sheet 5B : clock generator , 'digdug' sound , irq controller
   Sheet 6A : joystick read , dip switch , audio(TONE?) , NMI to master cpu
   Sheet 6B : address decoder (8000h-ffffh) , sprite ram r/w , disp. flip latch
   Sheet 7A : sprite drawing engine
   Sheet 7B : background ram , CRTC ?,graphic drawing engene ?
   Sheet 8A : background(&font) drawing engene
   Sheet 8B : display line buffer ?
   Sheet 9A : video dac ( palette rom )
   Sheet 9B : xevious planet map rom ?

P-ROMS in schematic

1M  master cpu rom 0000H-1FFFH
1L  master cpu rom 2000H-3FFFH
4C  motion cpu rom 0000H-1FFFH
2C  sound  cpu rom 0000H-1FFFH
8M  sound pcm rom ?
6M  sound pcm decode rom ?
4M  spright pattern low (BIT3=0,000-127)
4P  spright pattern low (BIT3=0,128-255)
4R  spright pattern high(BIT3=0)
      D0-3:000-127
      D4-7:128-255
4N  spright pattern (BIT3=1)
3L  spright color map table
3M  spright color map table
3D  background pattern bit0
3C  background pattern bit1
3B  background font pattern
4H  background color map table
4F  background color map table
6E  palette rom blue
6D  palette rom green
6A  palette rom red
2A  xevious planet map table ??
2B  xevious planet map table ??
2C  xevious planet map table ??

S-RAMS in schematic

1H  sram           7800H-7FFFH
7L  sound sram0    6800H-680FH
7K  sound sram1    6810H-681FH
2S  spright line   8000H-87FFH
2A  spright att    9000H-97FFH
2P  spright chr    A000H-A7FFH
2J  background ram B000H-B7FFH
2H  background ram B800H-BFFFH
2F  background ram C000H-C7FFH
2E  background ram C800H-CFFFH
5N,5M sprite display line buffer ? (even disp,odd draw)
6N,6M sprite display line buffer ? (even draw,odd disp)

*****************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sndhrdw/generic.h"
#include "sndhrdw/8910intf.h"


extern unsigned char *xevious_sharedram;
int  xevious_sharedram_r(int offset);
void xevious_sharedram_w(int offset,int data);
int  xevious_dsw_r(int offset);
void xevious_interrupt_enable_1_w(int offset,int data);
void xevious_interrupt_enable_2_w(int offset,int data);
void xevious_interrupt_enable_3_w(int offset,int data);
void xevious_bs_w(int offset,int data);
int  xevious_bb_r(int offset);
int xevious_customio_r(int offset);
int xevious_customio_data_r(int offset);
void xevious_customio_w(int offset,int data);
void xevious_customio_data_w(int offset,int data);
void xevious_halt_w(int offset,int data);
int  xevious_interrupt_1(void);
int  xevious_interrupt_2(void);
int  xevious_interrupt_3(void);
void xevious_init_machine(void);

extern unsigned char *xevious_vlatches;
void xevious_vh_latch_w(int offset, int data);

extern unsigned char *xevious_videoram2,*xevious_colorram2;
void xevious_videoram2_w(int offset,int data);
void xevious_colorram2_w(int offset,int data);
int  xevious_vh_start( void );
void xevious_vh_stop( void );
void xevious_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
void xevious_vh_screenrefresh(struct osd_bitmap *bitmap);

void pengo_sound_w(int offset,int data);
int pengo_sh_start(void);
void waveform_sh_stop(void);
void waveform_sh_update(void);
extern unsigned char *pengo_soundregs;



static struct MemoryReadAddress readmem_cpu1[] =
{
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0x6800, 0x6807, xevious_dsw_r },
	{ 0x7000, 0x700f, xevious_customio_data_r },
	{ 0x7100, 0x7100, xevious_customio_r },
	{ 0x7800, 0xcfff, xevious_sharedram_r },
	{ 0xf000, 0xffff, xevious_bb_r },
	{ -1 }	/* end of table */
};

static struct MemoryReadAddress readmem_cpu2[] =
{
	{ 0x0000, 0x1fff, MRA_ROM },
	{ 0x6800, 0x6807, xevious_dsw_r },
	{ 0x7800, 0xcfff, xevious_sharedram_r },
	{ 0xf000, 0xffff, xevious_bb_r },
	{ -1 }	/* end of table */
};

static struct MemoryReadAddress readmem_cpu3[] =
{
	{ 0x0000, 0x0fff, MRA_ROM },
	{ 0x7800, 0xcfff, xevious_sharedram_r },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem_cpu1[] =
{
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x6820, 0x6820, xevious_interrupt_enable_1_w },
	{ 0x6821, 0x6821, xevious_interrupt_enable_2_w },
	{ 0x6822, 0x6822, xevious_interrupt_enable_3_w },
	{ 0x6823, 0x6823, xevious_halt_w },			/* reset controll */
	{ 0x6830, 0x683f, MWA_NOP },				/* watch dock reset */
	{ 0x7000, 0x700f, xevious_customio_data_w },
	{ 0x7100, 0x7100, xevious_customio_w },
	{ 0x7800, 0xafff, xevious_sharedram_w, &xevious_sharedram },
	{ 0xb000, 0xb7ff, colorram_w, &colorram },
	{ 0xb800, 0xbfff, xevious_colorram2_w, &xevious_colorram2 },
	{ 0xc000, 0xc7ff, videoram_w, &videoram, &videoram_size },
	{ 0xc800, 0xcfff, xevious_videoram2_w, &xevious_videoram2 },
	{ 0xd000, 0xd07f, xevious_vh_latch_w, &xevious_vlatches }, /* ?? */
	{ 0xf000, 0xffff, xevious_bs_w },
	{ 0x8780, 0x87ff, MWA_RAM, &spriteram_2 },	/* here only */
	{ 0x9780, 0x97ff, MWA_RAM, &spriteram_3 },	/* to initialize */
	{ 0xa780, 0xa7ff, MWA_RAM, &spriteram, &spriteram_size },	/* the pointers */
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem_cpu2[] =
{
	{ 0x0000, 0x1fff, MWA_ROM },
	{ 0x6823, 0x6823, xevious_halt_w },			/* reset control */
	{ 0x6830, 0x683f, MWA_NOP },				/* watch dog reset */
	{ 0x7800, 0xafff, xevious_sharedram_w },
	{ 0xb000, 0xb7ff, colorram_w },
	{ 0xb800, 0xbfff, xevious_colorram2_w },
	{ 0xc000, 0xc7ff, videoram_w },
	{ 0xc800, 0xcfff, xevious_videoram2_w },
	{ 0xd000, 0xd07f, xevious_vh_latch_w, &xevious_vlatches }, /* ?? */
	{ 0xf000, 0xffff, xevious_bs_w },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem_cpu3[] =
{
	{ 0x0000, 0x0fff, MWA_ROM },
	{ 0x6800, 0x681f, pengo_sound_w, &pengo_soundregs },
	{ 0x6822, 0x6822, xevious_interrupt_enable_3_w },
	{ 0x7800, 0xcfff, xevious_sharedram_w },
	{ -1 }	/* end of table */
};



INPUT_PORTS_START( xevious_input_ports )
	PORT_START	/* DSW0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_DIPNAME( 0x02, 0x02, "Flags Award Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "No" )
	PORT_DIPSETTING(    0x02, "Yes" )
	PORT_DIPNAME( 0x0c, 0x0c, "Right Coin", IP_KEY_NONE )
	PORT_DIPSETTING(    0x0c, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x08, "1 Coin/2 Credit" )
	PORT_DIPSETTING(    0x04, "1 Coin/3 Credits" )
	PORT_DIPSETTING(    0x00, "1 Coin/6 Credits" )
	PORT_DIPNAME( 0x10, 0x10, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x10, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "Easy" )
	PORT_DIPSETTING(    0x60, "Normal" )
	PORT_DIPSETTING(    0x20, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	/* when switch is on Namco, high score names are 10 letters long */
	PORT_DIPNAME( 0x80, 0x80, "Copyright", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Namco" )
	PORT_DIPSETTING(    0x80, "Atari/Namco" )

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x03, "Left Coin", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "2 Coins/1 Credit" )
	PORT_DIPSETTING(    0x03, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x00, "2 Coins/3 Credits" )
	PORT_DIPSETTING(    0x02, "1 Coin/2 Credits" )
	/* TODO: bonus scores are different for 5 lives */
	PORT_DIPNAME( 0x1c, 0x1c, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "10000 40000" )
	PORT_DIPSETTING(    0x14, "10000 50000" )
	PORT_DIPSETTING(    0x10, "20000 50000" )
	PORT_DIPSETTING(    0x0c, "20000 70000" )
	PORT_DIPSETTING(    0x08, "20000 80000" )
	PORT_DIPSETTING(    0x1c, "20000 60000" )
	PORT_DIPSETTING(    0x04, "20000 and 60000" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPNAME( 0x60, 0x60, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "1" )
	PORT_DIPSETTING(    0x20, "2" )
	PORT_DIPSETTING(    0x60, "3" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x80, 0x80, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Upright" )
	PORT_DIPSETTING(    0x00, "Cocktail" )

	PORT_START	/* FAKE */
	/* The player inputs are not memory mapped, they are handled by an I/O chip. */
	/* These fake input ports are read by galaga_customio_data_r() */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1, 0, IP_KEY_PREVIOUS, IP_JOY_PREVIOUS, 0 )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* FAKE */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_COCKTAIL)
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_IMPULSE | IPF_COCKTAIL,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL, 0, IP_KEY_PREVIOUS, IP_JOY_PREVIOUS, 0 )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* FAKE */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_START1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x08, IP_ACTIVE_LOW, IPT_START2 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_COIN1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_COIN2 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x40, IP_ACTIVE_LOW, IPT_COIN3 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(    0x80, 0x80, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END

/* same as xevious, the only difference is DSW0 bit 7 */
INPUT_PORTS_START( xeviousn_input_ports )
	PORT_START	/* DSW0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_DIPNAME( 0x02, 0x02, "Flags Award Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "No" )
	PORT_DIPSETTING(    0x02, "Yes" )
	PORT_DIPNAME( 0x0c, 0x0c, "Right Coin", IP_KEY_NONE )
	PORT_DIPSETTING(    0x0c, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x08, "1 Coin/2 Credit" )
	PORT_DIPSETTING(    0x04, "1 Coin/3 Credits" )
	PORT_DIPSETTING(    0x00, "1 Coin/6 Credits" )
	PORT_DIPNAME( 0x10, 0x10, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x10, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "Easy" )
	PORT_DIPSETTING(    0x60, "Normal" )
	PORT_DIPSETTING(    0x20, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_DIPNAME( 0x80, 0x80, "Freeze?", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x03, "Left Coin", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "2 Coins/1 Credit" )
	PORT_DIPSETTING(    0x03, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x00, "2 Coins/3 Credits" )
	PORT_DIPSETTING(    0x02, "1 Coin/2 Credits" )
	/* TODO: bonus scores are different for 5 lives */
	PORT_DIPNAME( 0x1c, 0x1c, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "10000 40000" )
	PORT_DIPSETTING(    0x14, "10000 50000" )
	PORT_DIPSETTING(    0x10, "20000 50000" )
	PORT_DIPSETTING(    0x0c, "20000 70000" )
	PORT_DIPSETTING(    0x08, "20000 80000" )
	PORT_DIPSETTING(    0x1c, "20000 60000" )
	PORT_DIPSETTING(    0x04, "20000 and 60000" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPNAME( 0x60, 0x60, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "1" )
	PORT_DIPSETTING(    0x20, "2" )
	PORT_DIPSETTING(    0x60, "3" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x80, 0x80, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Upright" )
	PORT_DIPSETTING(    0x00, "Cocktail" )

	PORT_START	/* FAKE */
	/* The player inputs are not memory mapped, they are handled by an I/O chip. */
	/* These fake input ports are read by galaga_customio_data_r() */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1, 0, IP_KEY_PREVIOUS, IP_JOY_PREVIOUS, 0 )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* FAKE */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_COCKTAIL)
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_IMPULSE | IPF_COCKTAIL,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL, 0, IP_KEY_PREVIOUS, IP_JOY_PREVIOUS, 0 )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* FAKE */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_START1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x08, IP_ACTIVE_LOW, IPT_START2 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_COIN1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_COIN2 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x40, IP_ACTIVE_LOW, IPT_COIN3 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(    0x80, 0x80, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END

/* same as xevious, the only difference is DSW0 bit 7. Note that the bit is */
/* inverted wrt xeviousn. */
INPUT_PORTS_START( sxevious_input_ports )
	PORT_START	/* DSW0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_DIPNAME( 0x02, 0x02, "Flags Award Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "No" )
	PORT_DIPSETTING(    0x02, "Yes" )
	PORT_DIPNAME( 0x0c, 0x0c, "Right Coin", IP_KEY_NONE )
	PORT_DIPSETTING(    0x0c, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x08, "1 Coin/2 Credit" )
	PORT_DIPSETTING(    0x04, "1 Coin/3 Credits" )
	PORT_DIPSETTING(    0x00, "1 Coin/6 Credits" )
	PORT_DIPNAME( 0x10, 0x10, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x10, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "Easy" )
	PORT_DIPSETTING(    0x60, "Normal" )
	PORT_DIPSETTING(    0x20, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_DIPNAME( 0x80, 0x00, "Freeze?", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Off" )
	PORT_DIPSETTING(    0x80, "On" )

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x03, "Left Coin", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "2 Coins/1 Credit" )
	PORT_DIPSETTING(    0x03, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x00, "2 Coins/3 Credits" )
	PORT_DIPSETTING(    0x02, "1 Coin/2 Credits" )
	/* TODO: bonus scores are different for 5 lives */
	PORT_DIPNAME( 0x1c, 0x1c, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "10000 40000" )
	PORT_DIPSETTING(    0x14, "10000 50000" )
	PORT_DIPSETTING(    0x10, "20000 50000" )
	PORT_DIPSETTING(    0x0c, "20000 70000" )
	PORT_DIPSETTING(    0x08, "20000 80000" )
	PORT_DIPSETTING(    0x1c, "20000 60000" )
	PORT_DIPSETTING(    0x04, "20000 and 60000" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPNAME( 0x60, 0x60, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "1" )
	PORT_DIPSETTING(    0x20, "2" )
	PORT_DIPSETTING(    0x60, "3" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0x80, 0x80, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Upright" )
	PORT_DIPSETTING(    0x00, "Cocktail" )

	PORT_START	/* FAKE */
	/* The player inputs are not memory mapped, they are handled by an I/O chip. */
	/* These fake input ports are read by galaga_customio_data_r() */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1, 0, IP_KEY_PREVIOUS, IP_JOY_PREVIOUS, 0 )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* FAKE */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_COCKTAIL)
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_COCKTAIL)
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_IMPULSE | IPF_COCKTAIL,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL, 0, IP_KEY_PREVIOUS, IP_JOY_PREVIOUS, 0 )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* FAKE */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_START1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x08, IP_ACTIVE_LOW, IPT_START2 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_COIN1 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_COIN2 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(0x40, IP_ACTIVE_LOW, IPT_COIN3 | IPF_IMPULSE,
			IP_NAME_DEFAULT, IP_KEY_DEFAULT, IP_JOY_DEFAULT, 1 )
	PORT_BITX(    0x80, 0x80, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END



/* foreground characters */
static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	512,	/* 512 characters */
	1,	/* 1 bit per pixel */
	{ 0 },
	{ 7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	8*8	/* every char takes 8 consecutive bytes */
};
/* background tiles */
static struct GfxLayout bgcharlayout =
{
	8,8,	/* 8*8 characters */
	512,	/* 512 characters */
	2,	/* 2 bits per pixel */
	{ 0, 512*8*8 },
	{ 7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	8*8	/* every char takes 8 consecutive bytes */
};
/* sprite set #1 */
static struct GfxLayout spritelayout1 =
{
	16,16,	/* 16*16 sprites */
	128,	/* 128 sprites */
	3,	/* 3 bits per pixel */
	{ 128*64*8+4, 0, 4 },
	{ 39*8, 38*8, 37*8, 36*8, 35*8, 34*8, 33*8, 32*8,
		7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 8*8+0, 8*8+1, 8*8+2, 8*8+3,
			16*8+0, 16*8+1, 16*8+2, 16*8+3, 24*8+0, 24*8+1, 24*8+2, 24*8+3 },
	64*8	/* every sprite takes 128 consecutive bytes */
};
/* sprite set #2 */
static struct GfxLayout spritelayout2 =
{
	16,16,	/* 16*16 sprites */
	128,	/* 128 sprites */
	3,	/* 3 bits per pixel */
	{ 0, 128*64*8, 128*64*8+4 },
	{ 39*8, 38*8, 37*8, 36*8, 35*8, 34*8, 33*8, 32*8,
		7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 8*8+0, 8*8+1, 8*8+2, 8*8+3,
			16*8+0, 16*8+1, 16*8+2, 16*8+3, 24*8+0, 24*8+1, 24*8+2, 24*8+3 },
	64*8	/* every sprite takes 128 consecutive bytes */
};
/* sprite set #3 */
static struct GfxLayout spritelayout3 =
{
	16,16,	/* 16*16 sprites */
	64,	/* 64 sprites */
	3,	/* 3 bits per pixel (one is always 0) */
	{ 64*64*8, 0, 4 },
	{ 39*8, 38*8, 37*8, 36*8, 35*8, 34*8, 33*8, 32*8,
		7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 8*8+0, 8*8+1, 8*8+2, 8*8+3,
			16*8+0, 16*8+1, 16*8+2, 16*8+3, 24*8+0, 24*8+1, 24*8+2, 24*8+3 },
	64*8	/* every sprite takes 64 consecutive bytes */
};



static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x0000, &charlayout, 128*4+64*8,  64 },
	{ 1, 0x1000, &bgcharlayout,        0, 128 },
	{ 1, 0x3000, &spritelayout1,   128*4,  64 },
	{ 1, 0x5000, &spritelayout2,   128*4,  64 },
	{ 1, 0x9000, &spritelayout3,   128*4,  64 },
	{ -1 } /* end of array */
};



static unsigned char color_prom[] =
{
	/* 6A: palette red component */
	0xF0,0xF6,0xF3,0xF0,0xF5,0xFA,0xF2,0xF5,0xF9,0xFC,0xF4,0xF4,0xF9,0xF6,0xF5,0xF5,
	0xF7,0xF5,0xF5,0xF8,0xFD,0xFC,0xF7,0xF4,0xF2,0xF2,0xF2,0xF3,0xF5,0xF9,0xF7,0xF8,
	0xFA,0xF8,0xF7,0xF6,0xF7,0xF8,0xFF,0xF4,0xF3,0xF0,0xFD,0xF0,0xFA,0xF2,0xF0,0xFA,
	0xF2,0xF4,0xF5,0xFA,0xF8,0xF8,0xFF,0xFF,0xFF,0xF2,0xFE,0xFC,0xF0,0xFF,0xFE,0xF2,
	0xFC,0xFD,0xF0,0xF0,0xF4,0xF0,0xF0,0xF8,0xF6,0xF0,0xFC,0xF4,0xF5,0xF8,0xF7,0xF6,
	0xF2,0xF8,0xF2,0xF5,0xFB,0xFF,0xFC,0xF0,0xFA,0xF4,0xFE,0xFF,0xFF,0xFF,0xFC,0xFC,
	0xFF,0xFB,0xF7,0xF3,0xFF,0xF4,0xF4,0xF6,0xFA,0xFC,0xFA,0xF8,0xF0,0xF8,0xFF,0xF8,
	0xF4,0xF8,0xF4,0xF0,0xF0,0xF0,0xF0,0xF0,0xF4,0xF2,0xF8,0xF4,0xFF,0xFF,0xFF,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	/* 6D: palette green component */
	0xF0,0xF6,0xF8,0xFC,0xF2,0xFA,0xF7,0xF4,0xF9,0xFC,0xF8,0xF6,0xF9,0xF3,0xF5,0xF5,
	0xF8,0xF8,0xF8,0xF6,0xFB,0xF6,0xF4,0xF3,0xF2,0xF4,0xF6,0xF7,0xF9,0xF9,0xF8,0xF8,
	0xF8,0xF6,0xF6,0xF5,0xF7,0xF8,0xF0,0xF8,0xF7,0xF8,0xFB,0xF6,0xFB,0xF5,0xFC,0xF0,
	0xF4,0xF8,0xF5,0xFA,0xF8,0xF4,0xFF,0xFA,0xF6,0xF6,0xFA,0xF0,0xF0,0xFF,0xFE,0xF2,
	0xF6,0xFB,0xF5,0xF8,0xF4,0xFF,0xF8,0xF0,0xF0,0xF3,0xF4,0xF4,0xF5,0xF8,0xF7,0xF6,
	0xF2,0xF6,0xF5,0xF4,0xF7,0xF8,0xF4,0xFC,0xF6,0xF0,0xFE,0xFC,0xFC,0xFC,0xF8,0xFC,
	0xFF,0xFB,0xF7,0xF3,0xF8,0xF4,0xF4,0xF6,0xFA,0xFC,0xF8,0xF4,0xFF,0xF0,0xF0,0xF4,
	0xF2,0xF8,0xF4,0xF4,0xF8,0xF4,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xFF,0xFF,0xFA,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	/* 6E: palette blue component */
	0xF0,0xF6,0xFF,0xFC,0xF2,0xFA,0xFF,0xFF,0xF0,0xFC,0xF2,0xF0,0xF4,0xF2,0xF2,0xF5,
	0xF3,0xF3,0xF9,0xF0,0xF0,0xF0,0xF0,0xF2,0xF0,0xF0,0xF0,0xF1,0xFC,0xF7,0xF2,0xF2,
	0xF4,0xF2,0xF0,0xF0,0xF7,0xF8,0xF0,0xF7,0xFB,0xFC,0xF6,0xF8,0xFC,0xFA,0xF0,0xF0,
	0xF6,0xFB,0xF0,0xF0,0xF6,0xF4,0xF0,0xF0,0xF0,0xFA,0xF0,0xF0,0xFF,0xFF,0xFE,0xF2,
	0xF0,0xF0,0xF0,0xF0,0xF4,0xFF,0xFF,0xF0,0xF0,0xF0,0xF6,0xF6,0xF8,0xFA,0xF9,0xF8,
	0xF8,0xF2,0xFB,0xF0,0xF2,0xFF,0xF4,0xFF,0xF0,0xF0,0xF0,0xFA,0xF6,0xF4,0xF4,0xFC,
	0xF6,0xF4,0xF2,0xF3,0xF0,0xFC,0xF2,0xF4,0xF8,0xFA,0xF4,0xF2,0xF0,0xFF,0xFF,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF8,0xF4,0xF8,0xF4,0xF8,0xF4,0xF8,0xF4,0xFC,0xFA,0xF6,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	/* 4Hlow/4Fhigh: background tiles lookup table */
	0x0A,0x0B,0x0D,0x0E,0x0C,0x09,0x06,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0C,0x10,0x0B,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x1B,0x1A,0x0A,
	0x0A,0x28,0x09,0x06,0x00,0x00,0x00,0x00,0x0A,0x22,0x10,0x20,0x20,0x20,0x20,0x20,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0A,0x18,0x19,0x1B,0x06,0x09,0x05,0x07,0x0A,0x00,0x05,0x19,0x06,0x12,0x0C,0x00,
	0x05,0x1D,0x0C,0x00,0x06,0x18,0x19,0x1B,0x00,0x3D,0x03,0x0F,0x19,0x19,0x1A,0x1B,
	0x0C,0x0A,0x1B,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x18,0x1B,0x0A,
	0x0C,0x1D,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x20,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x20,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3D,0x02,0x00,
	0x00,0x3D,0x02,0x3C,0x3C,0x3D,0x02,0x00,0x00,0x3D,0x03,0x0F,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0F,0x0D,0x01,0x24,0x00,0x00,0x09,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0A,0x00,0x24,0x18,0x06,0x1C,0x05,0x05,0x00,0x00,0x05,0x00,0x06,0x09,0x24,0x00,
	0x00,0x1D,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3D,0x03,0x00,
	0x00,0x3D,0x03,0x3C,0x3C,0x3D,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 3Llow/3Mhigh: sprite lookup table */
	/* These are probably not the original PROMs. The transparency information */
	/* (bit 7) is missing. The 0x80 bytes are mine, needed to fix the targeting cursor */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x05,0x25,0x01,0x44,0x26,0x65,
	0x00,0x26,0x00,0x66,0x67,0x34,0x68,0x69,0x00,0x2F,0x00,0x66,0x67,0x34,0x68,0x69,
	0x00,0x47,0x00,0x66,0x67,0x34,0x68,0x69,0x00,0x48,0x00,0x66,0x67,0x34,0x68,0x69,
	0x00,0x00,0x00,0x66,0x67,0x34,0x68,0x69,0x00,0x3D,0x05,0x25,0x01,0x44,0x00,0x26,
	0x00,0x3D,0x05,0x25,0x01,0x44,0x00,0x2F,0x00,0x3D,0x05,0x25,0x01,0x44,0x00,0x47,
	0x00,0x3D,0x05,0x25,0x01,0x44,0x00,0x59,0x00,0x3D,0x05,0x25,0x01,0x44,0x00,0x00,
	0x00,0x05,0x01,0x3D,0x36,0x64,0x26,0x47,0x00,0x69,0x6A,0x6B,0x0D,0x59,0x00,0x26,
	0x00,0x26,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x3D,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x26,0x00,0x3D,0x00,0x00,0x00,0x00,0x00,0x2F,0x00,0x3D,0x00,0x00,0x00,0x00,
	0x00,0x47,0x00,0x3D,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x3D,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x3D,0x00,0x00,0x00,0x00,0x00,0x26,0x47,0x47,0x59,0x59,0x00,0x26,
	0x00,0x64,0x6F,0x6F,0x70,0x70,0x00,0x64,0x00,0x36,0x71,0x71,0x72,0x72,0x00,0x36,
	0x00,0x6C,0x43,0x43,0x73,0x73,0x00,0x6C,0x00,0x45,0x74,0x74,0x75,0x75,0x00,0x45,
	0x00,0x3C,0x76,0x76,0x77,0x77,0x00,0x3C,0x00,0x6D,0x78,0x78,0x79,0x79,0x00,0x6D,
	0x00,0x6E,0x7A,0x7A,0x7B,0x7B,0x00,0x6E,0x00,0x3D,0x00,0x66,0x67,0x34,0x68,0x69,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x09,0x46,0x09,0x00,0x00,0x00,0x00,0x00,0x09,0x80,0x09,0x00,0x00,0x00,0x00,
	0x00,0x64,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x3D,0x26,0x46,0x00,0x00,0x00,0x00,
	0x00,0x05,0x26,0x46,0x00,0x00,0x00,0x00,0x00,0x3D,0x26,0x00,0x00,0x00,0x00,0x00,
	0x00,0x26,0x3D,0x00,0x00,0x00,0x00,0x00,0x00,0x3D,0x46,0x00,0x00,0x00,0x00,0x00,
	0x00,0x46,0x3D,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x46,0x26,0x00,0x00,0x00,0x00,
	0x00,0x09,0x80,0x26,0x00,0x00,0x00,0x00,0x00,0x05,0x01,0x63,0x00,0x00,0x00,0x00,
	0x00,0x25,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x3D,0x09,0x05,0x25,0x01,0x44,0x69,
	0x00,0x3D,0x09,0x05,0x7C,0x7D,0x69,0x00,0x00,0x3D,0x7C,0x7D,0x5B,0x5C,0x7E,0x26,
	0x00,0x5D,0x26,0x2F,0x05,0x25,0x01,0x44,0x00,0x58,0x5C,0x2F,0x64,0x5E,0x01,0x00,
	0x00,0x2F,0x1F,0x60,0x7C,0x68,0x01,0x00,0x00,0x3D,0x2F,0x48,0x5F,0x05,0x25,0x01,
	0x00,0x2F,0x47,0x48,0x3D,0x5F,0x05,0x25,0x00,0x3D,0x5F,0x05,0x25,0x44,0x26,0x2F,
	0x00,0x5F,0x05,0x25,0x01,0x44,0x26,0x2F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};



/* waveforms for the audio hardware */
static unsigned char sound_prom[] =
{
	0xF9,0xFA,0xFB,0xFC,0xFD,0xFD,0xFE,0xFE,0xFE,0xFD,0xFD,0xFC,0xFB,0xFA,0xF9,0xF7,
	0xF5,0xF4,0xF3,0xF2,0xF1,0xF1,0xF0,0xF0,0xF0,0xF1,0xF1,0xF2,0xF3,0xF4,0xF5,0xF7,
	0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF7,0xFA,0xFC,0xFD,0xFE,0xFD,0xFC,0xFA,0xF7,0xF4,0xF2,0xF1,0xF0,0xF1,0xF2,0xF4,
	0xF7,0xFB,0xFD,0xFE,0xFD,0xFB,0xF7,0xF3,0xF1,0xF0,0xF1,0xF3,0xF7,0xFE,0xF7,0xF0,
	0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xFE,0xFE,0xFE,0xF0,0xF0,0xF0,0xFE,0xFE,0xFE,0xFE,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xFE,0xFE,0xF0,0xF0,0xFC,0xFC,0xFD,0xF3,0xFE,0xFE,0xFC,0xFC,0xFC,0xFC,0xFD,0xF7,
	0xF1,0xF2,0xF2,0xF2,0xF2,0xF0,0xF0,0xFB,0xF1,0xF2,0xF2,0xFE,0xFE,0xF0,0xF0,0xF7,
	0xFE,0xFC,0xF7,0xFA,0xFC,0xF7,0xF5,0xFC,0xFE,0xFD,0xF8,0xFA,0xFB,0xF6,0xF2,0xF7,
	0xFC,0xF8,0xF3,0xF4,0xF6,0xF1,0xF0,0xF3,0xF9,0xF7,0xF2,0xF4,0xF7,0xF2,0xF0,0xF7,
	0xFC,0xFE,0xFE,0xFE,0xFE,0xFC,0xFB,0xF9,0xF7,0xF6,0xF5,0xF5,0xF5,0xF6,0xF8,0xFA,
	0xFB,0xFB,0xF9,0xF6,0xF4,0xF2,0xF2,0xF2,0xF3,0xF5,0xF4,0xF3,0xF2,0xF1,0xF3,0xF7,
	0xF8,0xFB,0xFE,0xFD,0xF7,0xFD,0xFE,0xFD,0xFC,0xFB,0xF3,0xF2,0xF1,0xF0,0xF1,0xF7,
	0xF1,0xF0,0xF3,0xF6,0xF8,0xFE,0xFD,0xFC,0xFE,0xF8,0xF3,0xF0,0xF2,0xF1,0xF0,0xF6,
};



static struct MachineDriver machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			3125000,	/* 3.125 Mhz (?) */
			0,
			readmem_cpu1,writemem_cpu1,0,0,
			xevious_interrupt_1,100
		},
		{
			CPU_Z80,
			3125000,	/* 3.125 Mhz */
			2,	/* memory region #2 */
			readmem_cpu2,writemem_cpu2,0,0,
			xevious_interrupt_2,1
		},
		{
			CPU_Z80,
			3125000,	/* 3.125 Mhz */
			3,	/* memory region #3 */
			readmem_cpu3,writemem_cpu3,0,0,
			xevious_interrupt_3,2
		}
	},
	60,
	1,	/* TODO: higher values cause sound not to work and sprites to scroll jerkily. */
		/* Understand why. */
	xevious_init_machine,

	/* video hardware */
	28*8, 36*8, { 0*8, 28*8-1, 0*8, 36*8-1 },
	gfxdecodeinfo,
	256,128*4+64*8+64*2,
	xevious_vh_convert_color_prom,

	VIDEO_TYPE_RASTER,
	0,
	xevious_vh_start,
	xevious_vh_stop,
	xevious_vh_screenrefresh,

	/* sound hardware */
	0,
	pengo_sh_start,
	waveform_sh_stop,
	waveform_sh_update
};



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( xevious_rom )
	ROM_REGION(0x10000)	/* 64k for the first CPU */
	ROM_LOAD( "xe-1m-a.bin", 0x0000, 0x2000, 0x4a8335a7 )
	ROM_LOAD( "xe-1l-a.bin", 0x2000, 0x2000, 0xa35c0044 )

	ROM_REGION(0xb000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "xe-3b.bin",   0x0000, 0x1000, 0x7da40000 )	/* foreground characters */
	ROM_LOAD( "xe-3c.bin",   0x1000, 0x1000, 0x86acf050 )	/* bg pattern B0 */
	ROM_LOAD( "xe-3d.bin",   0x2000, 0x1000, 0xcae06a98 )	/* bg pattern B1 */
	ROM_LOAD( "xe-4m.bin",   0x3000, 0x2000, 0xf4396729 )	/* sprite set #1, planes 0/1 */
	ROM_LOAD( "xe-4r.bin",   0x5000, 0x2000, 0x4dc1265d )	/* sprite set #1, plane 2, set #2, plane 0 */
	ROM_LOAD( "xe-4p.bin",   0x7000, 0x2000, 0xb178ce72 )	/* sprite set #2, planes 1/2 */
	ROM_LOAD( "xe-4n.bin",   0x9000, 0x1000, 0x4b853bdf )	/* sprite set #3, planes 0/1 */
	/* 0xa000-0xafff empty space to decode sprite set #3 as 3 bits per pixel */

	ROM_REGION(0x10000)	/* 64k for the second CPU */
	ROM_LOAD( "xe-4c-a.bin", 0x0000, 0x2000, 0x37f5afeb )

	ROM_REGION(0x10000)	/* 64k for the audio CPU */
	ROM_LOAD( "xe-2c-a.bin", 0x0000, 0x1000, 0x66a1cf07 )

	ROM_REGION(0x4000)	/* gfx map */
	ROM_LOAD( "xe-2a.bin",   0x0000, 0x1000, 0xcbed7745 )
	ROM_LOAD( "xe-2b.bin",   0x1000, 0x2000, 0xbf84e836 )
	ROM_LOAD( "xe-2c.bin",   0x3000, 0x1000, 0x4e606118 )
ROM_END

ROM_START( xeviousn_rom )
	ROM_REGION(0x10000)	/* 64k for the first CPU */
	ROM_LOAD( "xe-1m-a.bin", 0x0000, 0x2000, 0x07dd0575 )
	ROM_LOAD( "xe-1l-a.bin", 0x2000, 0x2000, 0xff5e0eea )

	ROM_REGION(0xb000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "xe-3b.bin",   0x0000, 0x1000, 0x7da40000 )	/* foreground characters */
	ROM_LOAD( "xe-3c.bin",   0x1000, 0x1000, 0x86acf050 )	/* bg pattern B0 */
	ROM_LOAD( "xe-3d.bin",   0x2000, 0x1000, 0xcae06a98 )	/* bg pattern B1 */
	ROM_LOAD( "xe-4m.bin",   0x3000, 0x2000, 0xf4396729 )	/* sprite set #1, planes 0/1 */
	ROM_LOAD( "xe-4r.bin",   0x5000, 0x2000, 0x4dc1265d )	/* sprite set #1, plane 2, set #2, plane 0 */
	ROM_LOAD( "xe-4p.bin",   0x7000, 0x2000, 0xb178ce72 )	/* sprite set #2, planes 1/2 */
	ROM_LOAD( "xe-4n.bin",   0x9000, 0x1000, 0x4b853bdf )	/* sprite set #3, planes 0/1 */
	/* 0xa000-0xafff empty space to decode sprite set #3 as 3 bits per pixel */

	ROM_REGION(0x10000)	/* 64k for the second CPU */
	ROM_LOAD( "xe-4c-a.bin", 0x0000, 0x2000, 0xa4326478 )

	ROM_REGION(0x10000)	/* 64k for the audio CPU */
	ROM_LOAD( "xe-2c-a.bin", 0x0000, 0x1000, 0x66a1cf07 )

	ROM_REGION(0x4000)	/* gfx map */
	ROM_LOAD( "xe-2a.bin",   0x0000, 0x1000, 0xcbed7745 )
	ROM_LOAD( "xe-2b.bin",   0x1000, 0x2000, 0xbf84e836 )
	ROM_LOAD( "xe-2c.bin",   0x3000, 0x1000, 0x4e606118 )
ROM_END

ROM_START( sxevious_rom )
	ROM_REGION(0x10000)	/* 64k for the first CPU */
	ROM_LOAD( "cpu_3p.rom", 0x0000, 0x1000, 0x4d6fd3e9 )
	ROM_LOAD( "cpu_3m.rom", 0x1000, 0x1000, 0xd326bafc )
	ROM_LOAD( "cpu_2m.rom", 0x2000, 0x1000, 0xa196d09c )
	ROM_LOAD( "cpu_2l.rom", 0x3000, 0x1000, 0xfce2e698 )

	ROM_REGION(0xb000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "vid_3b.rom", 0x0000, 0x1000, 0x7da40000 )	/* foreground characters */
	ROM_LOAD( "vid_3c.rom", 0x1000, 0x1000, 0x86acf050 )	/* bg pattern B0 */
	ROM_LOAD( "vid_3d.rom", 0x2000, 0x1000, 0xcae06a98 )	/* bg pattern B1 */
	ROM_LOAD( "vid_4m.rom", 0x3000, 0x2000, 0xf4396729 )	/* sprite set #1, planes 0/1 */
	ROM_LOAD( "vid_4r.rom", 0x5000, 0x2000, 0x4dc1265d )	/* sprite set #1, plane 2, set #2, plane 0 */
	ROM_LOAD( "vid_4p.rom", 0x7000, 0x2000, 0xb178ce72 )	/* sprite set #2, planes 1/2 */
	ROM_LOAD( "vid_4n.rom", 0x9000, 0x1000, 0x4b853bdf )	/* sprite set #3, planes 0/1 */
	/* 0xa000-0xafff empty space to decode sprite set #3 as 3 bits per pixel */

	ROM_REGION(0x10000)	/* 64k for the second CPU */
	ROM_LOAD( "cpu_3f.rom", 0x0000, 0x1000, 0x2fcd5691 )
	ROM_LOAD( "cpu_3j.rom", 0x1000, 0x1000, 0xcca50ae5 )

	ROM_REGION(0x10000)	/* 64k for the audio CPU */
	ROM_LOAD( "cpu_2c.rom", 0x0000, 0x1000, 0x66a1cf07 )

	ROM_REGION(0x4000)	/* gfx map */
	ROM_LOAD( "vid_2a.rom", 0x0000, 0x1000, 0xcbed7745 )
	ROM_LOAD( "vid_2b.rom", 0x1000, 0x2000, 0xbf84e836 )
	ROM_LOAD( "vid_2c.rom", 0x3000, 0x1000, 0x4e606118 )
ROM_END



static const char *xevious_sample_names[] =
{
	"*xevious",
	"explo1.sam",	/* ground target explosion */
	"explo2.sam",	/* Solvalou explosion */
	0	/* end of array */
};



static int hiload(void) /* V.V */
{
	/* get RAM pointer (this game is multiCPU, we can't assume the global */
	/* RAM pointer is pointing to the right place) */
	unsigned char *RAM = Machine->memory_region[0];

	/* check if the hi score table has already been initialized */
	if (memcmp(&RAM[0x8024],"\x00\x40\x00",3) == 0 &&
			memcmp(&RAM[0x8510],"\x00\x40\x00",3) == 0)
	{
		void *f;


		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&RAM[0x8024],3);
			osd_fread(f,&RAM[0x8510],16*5);
			osd_fclose(f);
		}

		return 1;
	}
	else return 0;  /* we can't load the hi scores yet */
}



static void hisave(void) /* V.V */
{
	/* get RAM pointer (this game is multiCPU, we can't assume the global */
	/* RAM pointer is pointing to the right place) */
	unsigned char *RAM = Machine->memory_region[0];
	void *f;

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&RAM[0x8024],3);
		osd_fwrite(f,&RAM[0x8510],16*5);
		osd_fclose(f);
	}
}



struct GameDriver xevious_driver =
{
	"Xevious (Atari/Namco copyright)",
	"xevious",
	"Mirko Buffoni\nTatsuyuki Satoh\nNicola Salmoria\nValerio Verrando (high score save)",
	&machine_driver,

	xevious_rom,
	0, 0,
	xevious_sample_names,
	sound_prom,	/* sound_prom */

	0/*TBR*/,xevious_input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};

struct GameDriver xeviousn_driver =
{
	"Xevious (Namco copyright)",
	"xeviousn",
	"Mirko Buffoni\nTatsuyuki Satoh\nNicola Salmoria\nValerio Verrando (high score save)",
	&machine_driver,

	xeviousn_rom,
	0, 0,
	xevious_sample_names,
	sound_prom,	/* sound_prom */

	0/*TBR*/,xeviousn_input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};

struct GameDriver sxevious_driver =
{
	"Super Xevious",
	"sxevious",
	"Mirko Buffoni\nTatsuyuki Satoh\nNicola Salmoria\nValerio Verrando (high score save)",
	&machine_driver,

	sxevious_rom,
	0, 0,
	xevious_sample_names,
	sound_prom,	/* sound_prom */

	0/*TBR*/,sxevious_input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};
