#include <go32.h>
#include <sys/movedata.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

char *doublebuffer;

#include "palette.h"
#include "pcx.h"
#include "sprite.h"

#define flip(c) _dosmemputl(c, 64000/4, 0xA0000)

int main() {
    char palette[768];
    SPRITE sprite;

    doublebuffer=(char *)malloc(64000);
    if(doublebuffer==NULL) {
        printf("Ei tarpeeksi muistia kaksoipuskurin varaukseen!\n");
        return 1;
    }
    textmode(0x13);
    loadpcx("SPRITE.PCX", doublebuffer);
    loadpal("SPRITE.PCX", palette);
    setpal(palette);
    sload(&sprite, 160, 100, 1, 1, 16, 16, doublebuffer, 1, 1, 320, 8);
    loadpcx("BITBACK.PCX", doublebuffer);
    /* Lataus vasta kun bittikartta on otettu edellisest tiedostosta.
       Ei ladata palettia koska se on sama kuin edellisess PCX:ss. */

    while(!kbhit()) {
        sdraw(&sprite);
        waitsync();
        waitsync();
        flip(doublebuffer);
        shide(&sprite);
        smove(&sprite);
        sanimate(&sprite);
        if((sprite.x+sprite.xsize+sprite.xspeed)>320 ||
           sprite.x+sprite.xspeed<0)
            sprite.xspeed= -sprite.xspeed;
        if((sprite.y+sprite.ysize+sprite.yspeed)>200 ||
           sprite.y+sprite.yspeed<0)
            sprite.yspeed= -sprite.yspeed;
    }
    getch();
    fadetoblack(palette);
    textmode(0x3);

    return 0;
}
