CONGRATULATIONS ON YOUR CHOICE OF COMPILER. MAY IT GIVE YOU MANY YEARS OF
FAITHFUL SERVICE.
SPECIAL THANKS GOES TO MR DELORIE, MR SANDMANN AND MR TGR AND COUNTLESS
OTHER PEOPLE THAT HAVE MADE GCC POSSIBLE ON DOS PLATFORMS.
LET US TAKE A MOMENT TO REMEMBER RICHARD STALLMAN AND THE MANY WHO
WROTE PARTS OF GCC, LEST WE FORGET.
        AHMEN TO THAT!

        This document tries to describe some of the problems using
the GDB V4.12 debugger, ported to MSDOS with the DJGPP V2.0 enviornment.


        Written by Al-Junaid Haider Walker 6d/6m/95y.


QUICK START
===========

1) Well take a look at t.c that is a basic graphics mode test program.
   Add it to your program.
2) Make sure the supplied gdb.ini is in the directory you start your
   program to be debugged. You must have a DPMI server installed
   (QDPMI, 386Max, etc). Windows support is buggy at this point.
   Type the following to debug the program 'a.out' with arguments 'arg1 arg2' ;

   gdb a.out arg1 arg2

3) Gdb should start up. Go print out the "GDB QUICK REFERENCE" sheet if you
   are unsure how to drive gdb - it is a large and powerful beast. Here's
   a summary of the most used commands;

   help			-online help for gdb
   sh command		-execute DOS command
   b function_name	-put a break point at function_name()
   d			-delete all breakpoints
   d 1			-delete first breakpoint
   r			-run program until breakpoint is hit
   Ctrl-Break		-interupt program, and return to gdb (buggy)
   Ctrl-C		-strongly terminate program and gdb
   l			-list next lines of source code
   l function		-list source code for function
   p expr		-print the value of C(++) expression
   set variable=expr	-assign expression's value to variable
   s			-step to next line, and into calls
   n			-step to next line, and over calls
   fin			-finish execution of current function
   bt			-print your program's function call frames
   fr 1			-select the first call frame to degub
   c			-continue a text mode only program after a breakpoint
   v			-continue a graphics mode program after a breakpoint
   so file		-execute gdb commands from file
   disp expr		-display expression value after each breakpoint
   dis disp 2		-disable your first display expression
   info reg		-print out register values
   set $reg=expr	-set value of register, reg=eax,ebx
   disas 0x10 0x20	-disassemble addresses 0x10 to 0x20
   x /5w expr		-examine 5 32-bit words at address expr
   q			-quit debugging


GDB COMMAND LINE KEY BINDINGS:
-----------------------------

	C-P:	Ctrl+p	go to Previous line in history buffer
	backspace:	destructive backspace
	C-B:		non-destructive backspace (to edit history)
	C-E:		end of line
	C-D:		quit


FILES + ENVIORNMENT:
-------------------

	gdb.ini		'.gdbinit' file to read commands from when gdb is
			first started.
	%HOME%		enviornment variable pointing to where gdb.ini is
			located.





	Please read below to get a feel for whats
doing for gdb - there is a fair bit that needs clarifying before djgpp
gdb becomes a solid product. I might also be able to help in other
areas.

        email:  junaid@bambam.eng.monash.edu.au
                junaid@silas.cc.monash.edu.au
                junaid@hestia.cc.monash.edu.au

        paper mail:
                Al-Junaid Haider Walker,
                4 Hilton Ave,
                Springvale,
                Victoria 3171,
                Australia.

        The author claims all rights to this material, but offers no
        warranty of any kind and accepts no liability what so ever
        for its use and fitness for a purpose etc.



BUGS:
----

11) Build GDB;
	After removing debugging info, and when compiling with my modified
	makefiles that use "CFLAGS= -O2", gdb reduces to some
        871K, maybe gcc -vomit will reduce it some more, who knows what
	dj did to trim it down to 670K?
	During compiling 'set go32=topline' reveals at all times i
	have >700K free (this is for the huge file gdb/mdebugre.c,
	usually have >2M). This is on a 8M 486DX2-66, 500K
	hyper386 diskcache, 1.5M ramdrive, QEMM non-stealth v7.03.
	If you can do better, tell me, otherwise tune your config.
	I suggest you use an EMM, for some reason it provides more
	memory to go32. Compiling takes about half and hour,
	linking takes about 20 seconds.

INTERNAL CWSDPMI/LIB DBG BUGS;
	-cwsdpmi's command line buffer is very small so you may need to
	 use response files eg program.exe @response_file 
        -gdb catches SIGINT (CTRL-BREAK), but faults when try to continue
	 program (exactly same fault with fsdb, edebug32);

Stack Fault at eip=000845fd
eax=000000f7 ebx=000f924c ecx=000000a7 edx=00062660 esi=00000000 edi=000b3410
ebp=00051d84 esp=00051d74 cs=00a7 ds=00af es=00af fs=00cf gs=0000 ss=00f7
Call frame traceback EIPs:
  0x000845fd   _longjmp+25


        -gdb doesnt work reliably under MS windows 3.1. Probably the old gdb 
	 diffs are at fault since fsdb/edebug32 work OK.
	-a cwsdpmi program hangs if CTRL-C is pressed at an awkward time,
	 especially when system() or about to exit() i think.
	-  Pressing 'q' when using gdb's pager results in a SEGV. This is a
	   feature of the gdb FSF sources (i recall it happens under Linux).
	   Unfortunately this causes the inferior and gdb to terminate.
	   Its supposed to be a fool-proof method of returning control
	   back to the debugger. Probably will fix itself when go32targ.c
	   properly passes signals (SIGINT, SIGSEGV) onto gdb.
	   Here's what symify.exe has to say after typing
	   'disas main <return> q <return>';

0x165e <main+82>:       jbe    0x1662 <main+86>
---Type <return> to continue, or q <return> to quit---q
Cannot continue from exception, exiting due to signal 0123
General Protection Fault at eip=0007fda4
eax=00000002 ebx=000940bc ecx=04c48300 edx=0002c2d2 esi=00001660 edi=000539db
ebp=000fa114 esp=000fa0e4 cs=00a7 ds=00af es=00af fs=00cf gs=0000 ss=00af
Call frame traceback EIPs:
  0x0007fda4   __getopt_internal+280
  0x0007fa41   _getopt_long_only+25
  0x00001dfd   _main+289
  0x0002bab9   _request_quit+27
  0x0002c2d2   _gdb_printchar+500
  0x0002c440   _gdb_flush+116
  0x0002c673   _fputc_unfiltered+115
  0x0002c691   _vfprintf_filtered+19
  0x0002c6e8   _fprintf_filtered+18
  0x0001a6a0   _print_address+26
  0x0001c4d4   _print_frame_args+2718
 
e:\djgppv2>\djgppv2\cwsdpmi.exe
 
e:\djgppv2>symify -o z /djgpp/src/gdb-4.12/gdb/gdb
 


DJGPP SPECIFIC GDB SOURCE BUGS;
	-debugger doesnt catch many signals, causing the debugger to terminate
	 ungracefully with a frame dump.
        -V2.0 programs are 100K too big; seems to include C library debug
	 info as well. Need to recompile C library.
        -Source takes a long time to read probably related to
         LSEEK_NOT_LINEAR since the whole file has to be read, instead
	 of skipping about with lseek().
	-If you press CTRL-A or CTRL-B when gdb is starting up, it
	 will SEGV. Seems to be an archaic reminant in readline.c
	 (why here? CTRL-B is used for non-destructive backspace).
	-readline.c seems to be directly accessing the screen memory in
	 text mode. Why? the BIOS/DOS is still being used inbetween so
	 this is nothing to do with DOS reentrancy, and we shouldnt 
	 interupt the inferior in real-mode because we have no symbols
	 anyway. Readline library needs to be completely reworked and
	 reinvented , instead of hacked around for go32. Maybe use
	 the emx0.9a (0.8f has gdb v4.12 i think) termio emulation
	 library.
	-The PATH interpretation doesnt understand the DOS path
 	 properly. So all object files must be in the current directory.
	-I couldnt get gdb to demangle my C++ programs. 'info source'
	 says the source language is unknown. 'set language c++' has no
	 effect. What gives? This is for a file nammed t.cc .


GENERAL BUGS;


TODO:
----

*	Not much, just fix up the above bugs.
*	Remove m2 and Chill language support; there should be a cleaner
	way other than nop'ing out their functions, and undefining
	LANG_m2 and LANG_chill in language.h.
*	I dont think we need LSEEK_NOT_LINEAR in gdb/config/i386/xm-go32.h
	.Well at least emx0.9a doesnt use it and it has text file mode too.
	Set textmode fopen()'s to binary, and undefine LSEEK_NOT_LINEAR.
	Strip source files of '\r' or use an editor that strips.
	Or keep the '\r' and let the terminal emulator discard it.
*	Add a function in the C library that will install a exception
	handler that will dump core. Not installed while debugger is
	running, so it can handle the exceptions for itself. Put that in your
	pipe Watcom - nifty thing for customers to send you their core files!
*	Modify readline.c termio functions to execute one gdb command
	(which calls an inferior function) when the terminal is switched
	between gdb and inferior => corresponds to gdb which always
	runs in text mode, and the inferior that may be running in graphics
	mode.	
*	Stamp out those other benign debugers!
*	Add your wishlist here


FIXES:
-----

3d/6m/95y
	-Finally traced the bug in go32_store_registers() ;
	used inside set all registers loop called store_registers(regno),
	should be store_registers(r). This fixes calling inferior function
	bug, and 'set $reg=number' bug. Probably fixes many other bugs.
	Probably same bug in gdb sources for djgpp 1.12 maint3.
	Took me all day to find this one...insidious little centipede.
	-made some functions in go32targ.c static for safety.
	-modified readline.c to not use pokeb() etc because these routines
	 dont compile in V2.0 for some reason. Anyway used movedata()
	 as this is much faster and cleaner.
	-made a gdb/makefile.dos , as major changes to makefile.in is
	 a FSF no-no wrt alien OS's like MSDOS.
	-Tabs aren't expanded to spaces in output. Probably in readline
	 library because unix assumes the terminal driver will do it.
	 Anyway readline.c needs to be purged of go32 clutter, and put
	 in a seperate file (probably a unix termio stub) before the
	 FSF will consider including the changes. Seems to have fixed
	 itself.
5d/6m/95y
	-gdb/infrun.c has been modified to print out the 
	 'display expressions' before printing '\nBreakpoint 1,
	 main.c:23. 23 printf(hi)'. 
	 Lots of display expressions look better on top of the source
	 line (of minor importance) when debugging a complex breakpoint.
	 So usually 'display expressions' (which run quietly) 
	 get executed before anything is printed out. 
	 So we can 'display tx()' and that will save the graphics screen
	 and switch to text mode every time gdb receives control after
	 any type of breakpoint. The inferior will know what graphics
	 memory its using, what vga registers to tweak to get in and out
	 of mode 13/X/VESA, start display offset, panning etc. There's
	 no reason to let gdb know about this graphics magic.
	 Then we 'define v<enter>set $z=gr()<enter>continue<enter>end<enter>'
	 (which also runs silently) to restore the graphics screen, and
	 continue inferior execution. See gdb.ini and t.c to see how the
	 debugger can get the inferior to coperatively switch to and
	 from graphics mode. Press 'v' to continue inferior execution.
	 If there is no tx()/gx() function in your program then gdb
	 starts up normally, without any text-grahics mode hooks, so
	 you should use 'c' to continue your program, NOT 'v'.
	-'handle no/print' fixed to only cause set signal to no/print.
	 Doesnt seem to have any effect on SIGTRAP. gdb/infrun.c
	 modified. Sure if we 'handle SIGSEGV noprint' we wont be
	 informed that gdb has regained control due to a SIGSEGV,
	 but at least the graphics screen will not be messed up
	 with the 'Program received signal SEGV' message, before
	 the 'display tx()' saves the graphics screen, and switches to
	 text mode. However this is all academic since signals eventually
	 cause gdb to 'stack fault' when the inferior is continued.
9d/6m/95y
	-Fixed t.c get_tx_pal() - RAMDAC has a special read palette index
  	 register - can you read at one point and write at another
	 in the LUT? Just an idle thought.
	-cc1plus 2.6.3 is more careful about function arguments passed by
	 reference eg func( int &var )	. Unless the actual call
	 arguments match the type and signedness of the declaration,
	 the arg will be passed by value. 2.5.7 was a little more forgiving
	 and would have passed an unsigned by reference. You will get
	 warnings for doing this - dont ignore them!


