{ DUMPPPU.PAS }
{ Copyright (c) 1995,96 by Florian Klaempfl }
{ History:
     Januar 1995:   Version 0.1
     3.3.1995:      Version 0.15
        PPU-Format 8 wird untersttzt
        Prozeduroptionen werden aufgeschlsselt angezeigt
     14.3.1995:     Version 0.16
        Prozeduroption iocheck hinzugefgt
     31.3.1995:     Version 0.2
        space vor alle write eingefgt
        tclassdef wird eingelesen und angezeigt
     31.3.1995:     Version 0.25
        Aufzhltypen werden angezeigt
     31.3.1995:     Version 0.49
        Mengen werden angezeigt
     24.12.1995:    Version 0.5
        PPU-Format 9 wird untersttzt
        Rechtschreibfehler beseitigt
     6.3.1996:      Version 0.5.10
        PPU-Format 10 is supported
    25.3.1996:      Version 0.5.11
        translation to english
        PP-format 11 is supported
        new flags for procdefintion.option implemented
}
{$N+,E+,G+}
program dumpppu;

  var
     f : file;
     version : LongInt;

  const
     ibloadunit = 1;
     ibgrunddef = 2;
     ibpointerdef = 3;
     ibtypesym = 4;
     ibarraydef = 5;
     ibprocdef = 6;
     ibprocsym = 7;
     iblinkofile = 8;
     ibstringdef = 9;
     ibvarsym = 10;
     ibconstsym = 11;
     ibinitunit = 12;
     ibaufzaehlsym = 13;
     ibtypedconstsym = 14;
     ibrecorddef = 15;
     ibfiledef = 16;
     ibformaldef = 17;
     ibclassdef = 18;
     ibaufzaehldef = 19;
     ibsetdef = 20;
     ibprocvardef = 21;
     ibend = 255;

  function readlong : longint;

    var
       l : longint;

    begin
       blockread(f,l,4);
       readlong:=l;
    end;

  function readword : word;

    var
       w : word;

    begin
       blockread(f,w,2);
       readword:=w;
    end;

  function readdouble : double;

    var
       d : double;

    begin
       blockread(f,d,8);
       readdouble:=d;
    end;

  function readbyte : byte;

    var
       b : byte;

    begin
       blockread(f,b,1);
       readbyte:=b;
    end;

  function readstring : string;

    var
       s : string;

    begin
       s[0]:=chr(readbyte);
       blockread(f,s[1],ord(s[0]));
       readstring:=s;
    end;

  var
     space : string;
     read_member : boolean;

  procedure readandwriteref;

    var
       w : word;

    begin
       w:=readword;
       if w=$ffff then
         begin
            w:=readword;
            if w=$ffff then
              writeln('nil')
            else writeln('Local Definition No. ',w)
         end
       else writeln('Unit ',w,'  No.',readword)
    end;

  var
     b : byte;
     unitnumber : word;

  type
     tsettyp = (normset);

  procedure readin;

    var
       oldread_member : boolean;
       counter : word;

    procedure read_abstract_proc_def;

       var
          params : word;
          options : word;

       begin
          write(space,'  Return Type: ');
          readandwriteref;
          options:=readword;
          if options<>0 then
            begin
               writeln(space,'  Option: ');
               if (options and 1)<>0 then
                 writeln(space,'    Exception Treatment');
               if (options and 2)<>0 then
                 writeln(space,'    Virtual Method');
               if (options and 4)<>0 then
                 writeln(space,'    Parameters are not removed from the stack');
               if (options and 8)<>0 then
                 writeln(space,'    Constructor');
               if (options and $10)<>0 then
                 writeln(space,'    Destructor');
               if (options and $20)<>0 then
                 writeln(space,'    Internal Procedure');
               if (options and $40)<>0 then
                 writeln(space,'    Unit Program Will Export To (EXPORT)');
               if (options and $80)<>0 then
                 writeln(space,'    Procedure needs I/O-Checking');
               if (options and $100)<>0 then
                 writeln(space,'    Abstract method');
               if (options and $200)<>0 then
                 writeln(space,'    Interrupt handler procedure');
            end;
          params:=readword;
          writeln(space,'  Parameter Number: ',params);
          writeln(space,'  Parameter: ');
          while params>0 do
            begin
               write(space,'    Type: ',readbyte,'  ');
               readandwriteref;
               dec(params);
            end;
       end;

     var
        params : word;

    begin
       counter:=0;
       repeat
         b:=readbyte;
         if (b<>ibend) and (b<>ibloadunit) and (b<>ibinitunit) and (b<>iblinkofile) then
           begin
              write(space,'Definition No.',counter,': ');
              inc(counter);
           end;
         case b of
            ibloadunit : begin
                            writeln('Dependent on: ',readstring,' (',unitnumber,
                              ')  Memory Control Number: ',readlong);
                            inc(unitnumber);
                         end;
            ibpointerdef : begin
                              write(space,'Pointer Definition of ');
                              readandwriteref;
                           end;
            ibgrunddef : begin
                            write(space,'Basic type ');
                            case readbyte of
                               0 : writeln('uauto');
                               1 : writeln('u8bit');
                               2 : writeln('s32bit');
                               3 : writeln('s64real');
                               4 : writeln('uvoid');
                               5 : writeln('bool8bit');
                               6 : writeln('uchar');
                               7 : writeln('s8bit');
                               8 : writeln('s16bit');
                               9 : writeln('u16bit');
                            end;
                            writeln(space,'  Range: ',readlong,' to ',readlong);
                         end;
            ibarraydef : begin
                            writeln(space,'Array definition');
                            write(space,'  Element Type: ');
                            readandwriteref;
                            write(space,'  Area type: ');
                            readandwriteref;
                            writeln(space,'  Range: ',readlong,' to ',readlong);
                         end;
            ibprocdef : begin
                           writeln(space,'Unit Program Definition');
                           if version<8 then
                             begin
                                writeln(space,'  User Register: ',readbyte);
                                write(space,'  Return Type: ');
                                readandwriteref;
                                writeln(space,'  Option: ',readword);
                                writeln(space,'  Procedure Name  `       Name: ',readstring);
                                writeln(space,'  Number: ',readlong);
                                write(space,'  Next: ');
                                readandwriteref;
                                params:=readword;
                                writeln(space,'  Parameter Number: ',params);
                                writeln(space,'  Parameter: ');
                                while params>0 do
                                  begin
                                     write(space,'    Type: ',readbyte,'  ');
                                     readandwriteref;
                                     dec(params);
                                  end;
                             end
                           else
                             begin
                                read_abstract_proc_def;
                                writeln(space,'  User Register: ',readbyte);
                                writeln(space,'  Procedure Name: ',readstring);
                                writeln(space,'  Number: ',readlong);
                                write(space,'  Next: ');
                                readandwriteref;
                             end;
                        end;
            ibprocvardef : begin
                              writeln(space,'Procedure Variable Type');
                              read_abstract_proc_def;
                           end;
            ibstringdef : writeln(space,'Definition of string with length: ',readbyte);
            ibrecorddef : begin
                             writeln(space,'Definition of record with size: ',readlong);
                             oldread_member:=read_member;
                             read_member:=true;
                             space:=space+'    ';
                             readin;
                             dec(byte(space[0]),4);
                             read_member:=oldread_member;
                          end;
            ibclassdef : begin
                            writeln(space,'Class Definition The Great ',readlong);
                            writeln(space,'  Name of Class: ',readstring);
                            write(space,'  Super Class: ');
                            readandwriteref;
                            if version>=11 then
                              write(space,' Options: ',readword);
                            oldread_member:=read_member;
                            read_member:=true;
                            space:=space+'    ';
                            readin;
                            dec(byte(space[0]),4);
                            read_member:=oldread_member;
                         end;
            ibfiledef : begin
                           case readbyte of
                              0 : writeln(space,'Text file Definition');
                              1 : begin
                                     write(space,'File of Type ');
                                     readandwriteref;
                                  end;
                              2 : writeln(space,'Untyped File');
                           end;
                        end;
            ibformaldef : writeln(space,'Generic Definition (void-type)');
            ibaufzaehldef : begin
                               writeln(space,'Definition List');
                               writeln(space,'  Highest Element: ',readlong);
                            end;
            ibinitunit : writeln('Initialization: ',readstring);
            iblinkofile : writeln('Linked with: ',readstring);
            ibsetdef : begin
                          writeln(space,'Set Definition');
                          write(space,'  Element Type: ');
                          readandwriteref;
                          b:=readbyte;
                          case tsettyp(b) of
                             normset : writeln(space,'  Set with 256 Elements');
                             else
                               begin
                                  writeln('Invalid Unit Format');
                                  halt(1);
                               end;
                          end;
                       end;
            ibend : break;
            else
              begin
                 writeln('Invalid Unit Format');
                 halt(1);
              end;
         end;
       until false;
       repeat
         b:=readbyte;
         case b of
            ibtypesym : begin
                           writeln(space,'Type Symbol ',readstring);
                           write(space,'  Definition: ');
                           readandwriteref;
                        end;
            ibprocsym : begin
                           writeln(space,'Procedure Symbol ',readstring);
                           write(space,'  Definition: ');
                           readandwriteref;
                        end;
            ibconstsym : begin
                            writeln(space,'Constant Symbol ',readstring); 
                            if version<10 then
                              begin
                                 write(space,'  Value: ');
                                 case readbyte of
                                    0 : writeln(readlong);
                                    1 : writeln('"'+readstring+'"');
                                    2 : writeln(''''+chr(readbyte)+'''');
                                    3 : writeln(readdouble);
                                    4 : if readbyte=0 then writeln('FALSE')
                                      else writeln('TRUE');
                                 end;
                              end
                            else
                              begin
                                 write(space,'  Definition: ');
                                 b:=readbyte;
                                 readandwriteref;
                                 write(space,'  Value: ');
                                 case b of
                                    0 : begin
                                           write(space,'  Definition: ');
                                           readandwriteref;
                                           writeln(readlong);
                                        end;
                                    1 : writeln('"'+readstring+'"');
                                    2 : writeln(readdouble);
                                    3 : if readbyte=0 then writeln('FALSE')
                                      else writeln('TRUE');
                                    4 : writeln(readlong);
                                    5 : writeln(''''+chr(readbyte)+'''');
                                 end;
                              end;
                         end;
            ibvarsym : begin
                           writeln(space,'Variable Symbol ',readstring);
                           writeln(space,'  Type: ',readbyte);
                           if read_member then
                             writeln(space,'  Address: ',readlong);
                           write(space,'  Definition: ');
                           readandwriteref;
                        end;
            ibaufzaehlsym : begin
                               writeln(space,'Enumeration Symbol ',readstring);
                               write(space,'  Definition: ');
                               readandwriteref;
                               writeln(space,'  Value: ',readlong);
                            end;
            ibtypedconstsym : begin
                                 writeln(space,'Typed Constant ',readstring);
                                 write(space,'  Definition');
                                 readandwriteref;
                                 writeln(space,'  Label: ',readstring);
                              end;
            ibend : break;
            else
               begin
                  writeln('Invalid Unit Format');
                  halt(1);
               end;
         end;
       until false;
    end;

  var
     hs : string;
     w : word;

  begin
     writeln('PPU-Dump Version 0.5.11   Copyright (c) 1995,96 by Florian Klaempfl');
     writeln('                   Translated by Eric Molitor');
     writeln;
     if paramcount<>1 then
       begin
          writeln('DUMPPPU <File>');
          halt(1);
       end;
     assign(f,paramstr(1));
     reset(f,1);
     if (readbyte<>ord('P')) or
        (readbyte<>ord('P')) or
        (readbyte<>ord('U')) then
       begin
          writeln('No Valid PPU-Data');
          halt(1);
       end;
     hs:=chr(readbyte)+chr(readbyte)+chr(readbyte);
     val(hs,version,w);
     writeln('PPU-Format: ',version);
     writeln('Compiler Version: ',readbyte,'.',readbyte);
     write('Operating System: ');
     case readbyte of
        0 : write('DOS');
        1 : write('OS/2');
        2 : write('Linux');
        3 : write('Win32');
     end;
     readbyte;
     writeln;
     writeln('Control Number: ',readlong);
     readword;
     if version>=9 then
       writeln('Object Code Start: ',readlong);
     unitnumber:=1;
     space:='';
     read_member:=false;
     readin;
     close(f);
  end.
