{****************************************************************************

                   Copyright (c) 1993,96 by Florian Klmpfl

 ****************************************************************************}

unit asmbl;

  interface

  uses
     globals,scanner,asmgen,hcodegen,symtable,tree
{$ifdef i386}
       ,i386
{$else}
{$endif}
       ;


     function assemble : ptree;


  implementation


    function assemble : ptree;

      var
         s,hs : string;
         c : char;
         ende : boolean;
         sym : psym;
         code : pasmlist;
         l : longint;

      begin
         ende:=false;
         s:='';
         c:=asmgetchar;
         code:=new(pasmlist,init);
         while not(ende) do
           begin
              case c of
                 'A'..'Z','a'..'z','_' : begin
                      hs:='';
                      while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                         or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                         or ((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                         or (c='_') do
                        begin
                           inc(byte(hs[0]));
                           hs[length(hs)]:=c;
                           c:=asmgetchar;
                        end;
                      if upper(hs)='END' then ende:=true
                      else
                         begin
                            { access to local varaibles }
                            if assigned(aktprocsym) then
                              begin
                                 if (s[length(s)]<>'%') and
                                   (s[length(s)]<>'$') then
                                   begin
                                      sym:=aktprocsym^.definition^.localst^.search(upper(hs));
                                      if assigned(sym) then
                                        begin
                                           if sym^.typ=varsym then
                                             hs:='-'+tostr(pvarsym(sym)^.adresse)+'(%ebp)';
                                        end
                                      else
                                        begin
                                           sym:=aktprocsym^.definition^.parast^.search(upper(hs));
                                           if assigned(sym) then
                                             begin
                                                if sym^.typ=varsym then
                                                  begin
                                                     l:=pvarsym(sym)^.adresse;
                                                     { set offset }
                                                     inc(l,longint(aktprocsym^.definition^.parast^.name));
                                                     hs:=tostr(l)+'(%ebp)';
                                                  end;
                                             end
                                           else if upper(hs)='__SELF' then
                                             begin
                                                if assigned(procinfo._class) then
                                                  hs:=tostr(procinfo.ESI_offset)+'(%ebp)';
                                             end
                                           else if upper(hs)='__RESULT' then
                                             begin
                                                if assigned(procinfo.retdef) then
                                                  hs:=tostr(procinfo.retoffset)+'(%ebp)';
                                             end
                                           else if upper(hs)='__OLDEBP' then
                                             begin
                                                { complicate to check there }
                                                { we do it: }
                                                hs:=tostr(procinfo.framepointer_offset)+'(%ebp)';
                                             end;
                                        end;
                                   end;
                              end;
                            s:=s+hs;
                         end;
                   end;
                 ';' : begin
                           while c<>#10 do
                             c:=asmgetchar;
                       end;
                 #10 : begin
                          code^.concat(gennasmrec(DIRECT,S_NO,s));
                          s:='';
                          c:=asmgetchar;
                          write_line;
                       end;
                 #13 : c:=asmgetchar;
                 #26 : fatalerror(endoffile);
                 else
                   begin
                      inc(byte(s[0]));
                      s[length(s)]:=c;
                      c:=asmgetchar;
                   end;
              end;
           end;
         code^.insert(gennasmrec(DIRECT,S_NO,s));
         assemble:=genasmnode(code);
      end;

end.
