/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <errno.h>
#include <libc/dosio.h>

static unsigned char map[] = {
  /* 00-07 */ 0, EINVAL, ENOENT, ENOENT, ENFILE, EACCES, EBADF, EFAULT,
  /* 08-0f */ ENOMEM, EFAULT, EFAULT, EINVAL, EINVAL, EINVAL, EINVAL, ENODEV,
  /* 10-17 */ EBUSY, EXDEV, ENMFILE, EROFS, ENXIO, ENODEV, EINVAL, EINVAL,
  /* 18-1f */ EINVAL, EIO, EIO, EIO, EIO, EIO, EIO, EPERM,
  /* 20-27 */ EACCES, EACCES, ENXIO, EBADF, ENOLCK, EINVAL, EIO, ENOSPC,
  /* 28-2f */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* 30-37 */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EBUSY, ENXIO,
  /* 38-3f */ EINVAL, EIO, EIO, EIO, EIO, EAGAIN, EINVAL, ENOSPC,
  /* 40-47 */ EINVAL, EACCES, ENXIO, EINVAL, EINVAL, EINVAL, EBUSY, ENXIO,
  /* 48-4f */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* 50-57 */ EEXIST, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* 57-5f */ EINVAL, ENOSYS, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* 60-67 */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, ENODEV, EINVAL, EINVAL,
  /* 68-6f */ ENODEV, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL
	    };

int
__doserr_to_errno(int doserr)
{
  if (doserr >= 0 && doserr < sizeof(map)/sizeof(map[0]))
    return map[doserr];
  return EINVAL;
}
