/*
 *  General Midi sound bank for the Adlib FM synth.
 *
 *  Although I've put it in a header file, this should only be included
 *  once (in adlib.c). I just put it in a header to get it out of the way.
 */


static FM_INSTRUMENT fm_instrument[128] =
{
#if 1

   /* This set of GM instrument patches was provided by Jorrit Rouwe...
    */

   { 0x21, 0x21, 0x8f, 0x0c, 0xf2, 0xf2, 0x45, 0x76, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Acoustic Grand */
   { 0x31, 0x21, 0x4b, 0x09, 0xf2, 0xf2, 0x54, 0x56, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Bright Acoustic */
   { 0x31, 0x21, 0x49, 0x09, 0xf2, 0xf2, 0x55, 0x76, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Electric Grand */
   { 0xb1, 0x61, 0x0e, 0x09, 0xf2, 0xf3, 0x3b, 0x0b, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Honky-Tonk */
   { 0x01, 0x21, 0x57, 0x09, 0xf1, 0xf1, 0x38, 0x28, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Electric Piano 1 */
   { 0x01, 0x21, 0x93, 0x09, 0xf1, 0xf1, 0x38, 0x28, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Electric Piano 2 */
   { 0x21, 0x36, 0x80, 0x17, 0xa2, 0xf1, 0x01, 0xd5, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Harpsichord */
   { 0x01, 0x01, 0x92, 0x09, 0xc2, 0xc2, 0xa8, 0x58, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Clav */
   { 0x0c, 0x81, 0x5c, 0x09, 0xf6, 0xf3, 0x54, 0xb5, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Celesta */
   { 0x07, 0x11, 0x97, 0x89, 0xf6, 0xf5, 0x32, 0x11, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Glockenspiel */
   { 0x17, 0x01, 0x21, 0x09, 0x56, 0xf6, 0x04, 0x04, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Music Box */
   { 0x18, 0x81, 0x62, 0x09, 0xf3, 0xf2, 0xe6, 0xf6, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Vibraphone */
   { 0x18, 0x21, 0x23, 0x09, 0xf7, 0xe5, 0x55, 0xd8, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Marimba */
   { 0x15, 0x01, 0x91, 0x09, 0xf6, 0xf6, 0xa6, 0xe6, 0x00, 0x00, 0x04, 0, 0, 0 }, /* Xylophone */
   { 0x45, 0x81, 0x59, 0x89, 0xd3, 0xa3, 0x82, 0xe3, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Tubular Bells */
   { 0x03, 0x81, 0x49, 0x89, 0x74, 0xb3, 0x55, 0x05, 0x01, 0x00, 0x04, 0, 0, 0 }, /* Dulcimer */
   { 0x71, 0x31, 0x92, 0x09, 0xf6, 0xf1, 0x14, 0x07, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Drawbar Organ */
   { 0x72, 0x30, 0x14, 0x09, 0xc7, 0xc7, 0x58, 0x08, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Percussive Organ */
   { 0x70, 0xb1, 0x44, 0x09, 0xaa, 0x8a, 0x18, 0x08, 0x00, 0x00, 0x04, 0, 0, 0 }, /* Rock Organ */
   { 0x23, 0xb1, 0x93, 0x09, 0x97, 0x55, 0x23, 0x14, 0x01, 0x00, 0x04, 0, 0, 0 }, /* Church Organ */
   { 0x61, 0xb1, 0x13, 0x89, 0x97, 0x55, 0x04, 0x04, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Reed Organ */
   { 0x24, 0xb1, 0x48, 0x09, 0x98, 0x46, 0x2a, 0x1a, 0x01, 0x00, 0x0c, 0, 0, 0 }, /* Accoridan */
   { 0x61, 0x21, 0x13, 0x09, 0x91, 0x61, 0x06, 0x07, 0x01, 0x00, 0x0a, 0, 0, 0 }, /* Harmonica */
   { 0x21, 0xa1, 0x13, 0x92, 0x71, 0x61, 0x06, 0x07, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Tango Accordian */
   { 0x02, 0x41, 0x9c, 0x89, 0xf3, 0xf3, 0x94, 0xc8, 0x01, 0x00, 0x0c, 0, 0, 0 }, /* Acoustic Guitar(nylon) */
   { 0x03, 0x11, 0x54, 0x09, 0xf3, 0xf1, 0x9a, 0xe7, 0x01, 0x00, 0x0c, 0, 0, 0 }, /* Acoustic Guitar(steel) */
   { 0x23, 0x21, 0x5f, 0x09, 0xf1, 0xf2, 0x3a, 0xf8, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Electric Guitar(jazz) */
   { 0x03, 0x21, 0x87, 0x89, 0xf6, 0xf3, 0x22, 0xf8, 0x01, 0x00, 0x06, 0, 0, 0 }, /* Electric Guitar(clean) */
   { 0x03, 0x21, 0x47, 0x09, 0xf9, 0xf6, 0x54, 0x3a, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Electric Guitar(muted) */
   { 0x23, 0x21, 0x4a, 0x0e, 0x91, 0x84, 0x41, 0x19, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Overdriven Guitar */
   { 0x23, 0x21, 0x4a, 0x09, 0x95, 0x94, 0x19, 0x19, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Distortion Guitar */
   { 0x09, 0x84, 0xa1, 0x89, 0x20, 0xd1, 0x4f, 0xf8, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Guitar Harmonics */
   { 0x21, 0xa2, 0x1e, 0x09, 0x94, 0xc3, 0x06, 0xa6, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Acoustic Bass */
   { 0x31, 0x31, 0x12, 0x09, 0xf1, 0xf1, 0x28, 0x18, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Electric Bass(finger) */
   { 0x31, 0x31, 0x8d, 0x09, 0xf1, 0xf1, 0xe8, 0x78, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Electric Bass(pick) */
   { 0x31, 0x32, 0x5b, 0x09, 0x51, 0x71, 0x28, 0x48, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Fretless Bass */
   { 0x01, 0x21, 0x8b, 0x49, 0xa1, 0xf2, 0x9a, 0xdf, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Slap Bass 1 */
   { 0x21, 0x21, 0x8b, 0x11, 0xa2, 0xa1, 0x16, 0xdf, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Slap Bass 2 */
   { 0x31, 0x31, 0x8b, 0x09, 0xf4, 0xf1, 0xe8, 0x78, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Synth Bass 1 */
   { 0x31, 0x31, 0x12, 0x09, 0xf1, 0xf1, 0x28, 0x18, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Synth Bass 2 */
   { 0x31, 0x21, 0x15, 0x09, 0xdd, 0x56, 0x13, 0x26, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Violin */
   { 0x31, 0x21, 0x16, 0x09, 0xdd, 0x66, 0x13, 0x06, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Viola */
   { 0x71, 0x31, 0x49, 0x09, 0xd1, 0x61, 0x1c, 0x0c, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Cello */
   { 0x21, 0x23, 0x4d, 0x89, 0x71, 0x72, 0x12, 0x06, 0x01, 0x00, 0x02, 0, 0, 0 }, /* Contrabass */
   { 0xf1, 0xe1, 0x40, 0x09, 0xf1, 0x6f, 0x21, 0x16, 0x01, 0x00, 0x02, 0, 0, 0 }, /* Tremolo Strings */
   { 0x02, 0x01, 0x1a, 0x89, 0xf5, 0x85, 0x75, 0x35, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Pizzicato Strings */
   { 0x02, 0x01, 0x1d, 0x89, 0xf5, 0xf3, 0x75, 0xf4, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Orchestral Strings */
   { 0x10, 0x11, 0x41, 0x09, 0xf5, 0xf2, 0x05, 0xc3, 0x01, 0x00, 0x02, 0, 0, 0 }, /* Timpani */
   { 0x21, 0xa2, 0x9b, 0x0a, 0xb1, 0x72, 0x25, 0x08, 0x01, 0x00, 0x0e, 0, 0, 0 }, /* String Ensemble 1 */
   { 0xa1, 0x21, 0x98, 0x09, 0x7f, 0x3f, 0x03, 0x07, 0x01, 0x01, 0x00, 0, 0, 0 }, /* String Ensemble 2 */
   { 0xa1, 0x61, 0x93, 0x09, 0xc1, 0x4f, 0x12, 0x05, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* SynthStrings 1 */
   { 0x21, 0x61, 0x18, 0x09, 0xc1, 0x4f, 0x22, 0x05, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* SynthStrings 2 */
   { 0x31, 0x72, 0x5b, 0x8c, 0xf4, 0x8a, 0x15, 0x05, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Choir Aahs */
   { 0xa1, 0x61, 0x90, 0x09, 0x74, 0x71, 0x39, 0x67, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Voice Oohs */
   { 0x71, 0x72, 0x57, 0x09, 0x54, 0x7a, 0x05, 0x05, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Synth Voice */
   { 0x90, 0x41, 0x00, 0x09, 0x54, 0xa5, 0x63, 0x45, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Orchestra Hit */
   { 0x21, 0x21, 0x92, 0x0a, 0x85, 0x8f, 0x17, 0x09, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Trumpet */
   { 0x21, 0x21, 0x94, 0x0e, 0x75, 0x8f, 0x17, 0x09, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Trombone */
   { 0x21, 0x61, 0x94, 0x09, 0x76, 0x82, 0x15, 0x37, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Tuba */
   { 0x31, 0x21, 0x43, 0x09, 0x9e, 0x62, 0x17, 0x2c, 0x01, 0x01, 0x02, 0, 0, 0 }, /* Muted Trumpet */
   { 0x21, 0x21, 0x9b, 0x09, 0x61, 0x7f, 0x6a, 0x0a, 0x00, 0x00, 0x02, 0, 0, 0 }, /* French Horn */
   { 0x61, 0x22, 0x8a, 0x0f, 0x75, 0x74, 0x1f, 0x0f, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Brass Section */
   { 0xa1, 0x21, 0x86, 0x8c, 0x72, 0x71, 0x55, 0x18, 0x01, 0x00, 0x00, 0, 0, 0 }, /* SynthBrass 1 */
   { 0x21, 0x21, 0x4d, 0x09, 0x54, 0xa6, 0x3c, 0x1c, 0x00, 0x00, 0x08, 0, 0, 0 }, /* SynthBrass 2 */
   { 0x31, 0x61, 0x8f, 0x09, 0x93, 0x72, 0x02, 0x0b, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Soprano Sax */
   { 0x31, 0x61, 0x8e, 0x09, 0x93, 0x72, 0x03, 0x09, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Alto Sax */
   { 0x31, 0x61, 0x91, 0x09, 0x93, 0x82, 0x03, 0x09, 0x01, 0x00, 0x0a, 0, 0, 0 }, /* Tenor Sax */
   { 0x31, 0x61, 0x8e, 0x09, 0x93, 0x72, 0x0f, 0x0f, 0x01, 0x00, 0x0a, 0, 0, 0 }, /* Baritone Sax */
   { 0x21, 0x21, 0x4b, 0x09, 0xaa, 0x8f, 0x16, 0x0a, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Oboe */
   { 0x31, 0x21, 0x90, 0x09, 0x7e, 0x8b, 0x17, 0x0c, 0x01, 0x01, 0x06, 0, 0, 0 }, /* English Horn */
   { 0x31, 0x32, 0x81, 0x09, 0x75, 0x61, 0x19, 0x19, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Bassoon */
   { 0x32, 0x21, 0x90, 0x09, 0x9b, 0x72, 0x21, 0x17, 0x00, 0x00, 0x04, 0, 0, 0 }, /* Clarinet */
   { 0xe1, 0xe1, 0x1f, 0x09, 0x85, 0x65, 0x5f, 0x1a, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Piccolo */
   { 0xe1, 0xe1, 0x46, 0x09, 0x88, 0x65, 0x5f, 0x1a, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Flute */
   { 0xa1, 0x21, 0x9c, 0x09, 0x75, 0x75, 0x1f, 0x0a, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Recorder */
   { 0x31, 0x21, 0x8b, 0x09, 0x84, 0x65, 0x58, 0x1a, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Pan Flute */
   { 0xe1, 0xa1, 0x4c, 0x09, 0x66, 0x65, 0x56, 0x26, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Blown Bottle */
   { 0x62, 0xa1, 0xcb, 0x09, 0x76, 0x55, 0x46, 0x36, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Skakuhachi */
   { 0x62, 0xa1, 0xa2, 0x09, 0x57, 0x56, 0x07, 0x07, 0x00, 0x00, 0x0b, 0, 0, 0 }, /* Whistle */
   { 0x62, 0xa1, 0x9c, 0x09, 0x77, 0x76, 0x07, 0x07, 0x00, 0x00, 0x0b, 0, 0, 0 }, /* Ocarina */
   { 0x22, 0x21, 0x59, 0x09, 0xff, 0xff, 0x03, 0x0f, 0x02, 0x00, 0x00, 0, 0, 0 }, /* Lead 1 (square) */
   { 0x21, 0x21, 0x0e, 0x09, 0xff, 0xff, 0x0f, 0x0f, 0x01, 0x01, 0x00, 0, 0, 0 }, /* Lead 2 (sawtooth) */
   { 0x22, 0x21, 0x46, 0x89, 0x86, 0x64, 0x55, 0x18, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Lead 3 (calliope) */
   { 0x21, 0xa1, 0x45, 0x09, 0x66, 0x96, 0x12, 0x0a, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Lead 4 (chiff) */
   { 0x21, 0x22, 0x8b, 0x09, 0x92, 0x91, 0x2a, 0x2a, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Lead 5 (charang) */
   { 0xa2, 0x61, 0x9e, 0x49, 0xdf, 0x6f, 0x05, 0x07, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Lead 6 (voice) */
   { 0x20, 0x60, 0x1a, 0x09, 0xef, 0x8f, 0x01, 0x06, 0x00, 0x02, 0x00, 0, 0, 0 }, /* Lead 7 (fifths) */
   { 0x21, 0x21, 0x8f, 0x86, 0xf1, 0xf4, 0x29, 0x09, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Lead 8 (bass+lead) */
   { 0x77, 0xa1, 0xa5, 0x09, 0x53, 0xa0, 0x94, 0x05, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Pad 1 (new age) */
   { 0x61, 0xb1, 0x1f, 0x89, 0xa8, 0x25, 0x11, 0x03, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Pad 2 (warm) */
   { 0x61, 0x61, 0x17, 0x09, 0x91, 0x55, 0x34, 0x16, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Pad 3 (polysynth) */
   { 0x71, 0x72, 0x5d, 0x09, 0x54, 0x6a, 0x01, 0x03, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Pad 4 (choir) */
   { 0x21, 0xa2, 0x97, 0x09, 0x21, 0x42, 0x43, 0x35, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Pad 5 (bowed) */
   { 0xa1, 0x21, 0x1c, 0x09, 0xa1, 0x31, 0x77, 0x47, 0x01, 0x01, 0x00, 0, 0, 0 }, /* Pad 6 (metallic) */
   { 0x21, 0x61, 0x89, 0x0c, 0x11, 0x42, 0x33, 0x25, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Pad 7 (halo) */
   { 0xa1, 0x21, 0x15, 0x09, 0x11, 0xcf, 0x47, 0x07, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Pad 8 (sweep) */
   { 0x3a, 0x51, 0xce, 0x09, 0xf8, 0x86, 0xf6, 0x02, 0x00, 0x00, 0x02, 0, 0, 0 }, /* FX 1 (rain) */
   { 0x21, 0x21, 0x15, 0x09, 0x21, 0x41, 0x23, 0x13, 0x01, 0x00, 0x00, 0, 0, 0 }, /* FX 2 (soundtrack) */
   { 0x06, 0x01, 0x5b, 0x09, 0x74, 0xa5, 0x95, 0x72, 0x00, 0x00, 0x00, 0, 0, 0 }, /* FX 3 (crystal) */
   { 0x22, 0x61, 0x92, 0x8c, 0xb1, 0xf2, 0x81, 0x26, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* FX 4 (atmosphere) */
   { 0x41, 0x42, 0x4d, 0x09, 0xf1, 0xf2, 0x51, 0xf5, 0x01, 0x00, 0x00, 0, 0, 0 }, /* FX 5 (brightness) */
   { 0x61, 0xa3, 0x94, 0x89, 0x11, 0x11, 0x51, 0x13, 0x01, 0x00, 0x06, 0, 0, 0 }, /* FX 6 (goblins) */
   { 0x61, 0xa1, 0x8c, 0x89, 0x11, 0x1d, 0x31, 0x03, 0x00, 0x00, 0x06, 0, 0, 0 }, /* FX 7 (echoes) */
   { 0xa4, 0x61, 0x4c, 0x09, 0xf3, 0x81, 0x73, 0x23, 0x01, 0x00, 0x04, 0, 0, 0 }, /* FX 8 (sci-fi) */
   { 0x02, 0x07, 0x85, 0x0c, 0xd2, 0xf2, 0x53, 0xf6, 0x00, 0x01, 0x00, 0, 0, 0 }, /* Sitar */
   { 0x11, 0x13, 0x0c, 0x89, 0xa3, 0xa2, 0x11, 0xe5, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Banjo */
   { 0x11, 0x11, 0x06, 0x09, 0xf6, 0xf2, 0x41, 0xe6, 0x01, 0x02, 0x04, 0, 0, 0 }, /* Shamisen */
   { 0x93, 0x91, 0x91, 0x09, 0xd4, 0xeb, 0x32, 0x11, 0x00, 0x01, 0x08, 0, 0, 0 }, /* Koto */
   { 0x04, 0x01, 0x4f, 0x09, 0xfa, 0xc2, 0x56, 0x05, 0x00, 0x00, 0x0c, 0, 0, 0 }, /* Kalimba */
   { 0x21, 0x22, 0x49, 0x09, 0x7c, 0x6f, 0x20, 0x0c, 0x00, 0x01, 0x06, 0, 0, 0 }, /* Bagpipe */
   { 0x31, 0x21, 0x85, 0x09, 0xdd, 0x56, 0x33, 0x16, 0x01, 0x00, 0x0a, 0, 0, 0 }, /* Fiddle */
   { 0x20, 0x21, 0x04, 0x8a, 0xda, 0x8f, 0x05, 0x0b, 0x02, 0x00, 0x06, 0, 0, 0 }, /* Shanai */
   { 0x05, 0x03, 0x6a, 0x89, 0xf1, 0xc3, 0xe5, 0xe5, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Tinkle Bell */
   { 0x07, 0x02, 0x15, 0x09, 0xec, 0xf8, 0x26, 0x16, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Agogo */
   { 0x05, 0x01, 0x9d, 0x09, 0x67, 0xdf, 0x35, 0x05, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Steel Drums */
   { 0x18, 0x12, 0x96, 0x09, 0xfa, 0xf8, 0x28, 0xe5, 0x00, 0x00, 0x0a, 0, 0, 0 }, /* Woodblock */
   { 0x10, 0x00, 0x86, 0x0c, 0xa8, 0xfa, 0x07, 0x03, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Taiko Drum */
   { 0x11, 0x10, 0x41, 0x0c, 0xf8, 0xf3, 0x47, 0x03, 0x02, 0x00, 0x04, 0, 0, 0 }, /* Melodic Tom */
   { 0x01, 0x10, 0x8e, 0x09, 0xf1, 0xf3, 0x06, 0x02, 0x02, 0x00, 0x0e, 0, 0, 0 }, /* Synth Drum */
   { 0x0e, 0xc0, 0x00, 0x09, 0x1f, 0x1f, 0x00, 0xff, 0x00, 0x03, 0x0e, 0, 0, 0 }, /* Reverse Cymbal */
   { 0x06, 0x03, 0x80, 0x91, 0xf8, 0x56, 0x24, 0x84, 0x00, 0x02, 0x0e, 0, 0, 0 }, /* Guitar Fret Noise */
   { 0x0e, 0xd0, 0x00, 0x0e, 0xf8, 0x34, 0x00, 0x04, 0x00, 0x03, 0x0e, 0, 0, 0 }, /* Breath Noise */
   { 0x0e, 0xc0, 0x00, 0x09, 0xf6, 0x1f, 0x00, 0x02, 0x00, 0x03, 0x0e, 0, 0, 0 }, /* Seashore */
   { 0xd5, 0xda, 0x95, 0x49, 0x37, 0x56, 0xa3, 0x37, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Bird Tweet */
   { 0x35, 0x14, 0x5c, 0x11, 0xb2, 0xf4, 0x61, 0x15, 0x02, 0x00, 0x0a, 0, 0, 0 }, /* Telephone ring */
   { 0x0e, 0xd0, 0x00, 0x09, 0xf6, 0x4f, 0x00, 0xf5, 0x00, 0x03, 0x0e, 0, 0, 0 }, /* Helicopter */
   { 0x26, 0xe4, 0x00, 0x09, 0xff, 0x12, 0x01, 0x16, 0x00, 0x01, 0x0e, 0, 0, 0 }, /* Applause */
   { 0x00, 0x00, 0x00, 0x09, 0xf3, 0xf6, 0xf0, 0xc9, 0x00, 0x02, 0x0e, 0, 0, 0 }  /* Gunshot */

#else

   /*  This alternative patch set was taken from the MID-KIT library by
    *  John Pollard. These sounds were used by Allegro versions 2.2 and
    *  earlier.
    */
   { 0x21, 0x31, 0x4F, 0x00, 0xF2, 0xD2, 0x52, 0x73, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Acoustic Grand */
   { 0x01, 0x11, 0x4F, 0x00, 0xF1, 0xD2, 0x53, 0x74, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Bright Acoustic */
   { 0x13, 0x11, 0xC6, 0x00, 0xF2, 0xF1, 0xF5, 0xF5, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Electric Grand */
   { 0x31, 0x31, 0x8E, 0x80, 0xF1, 0xF3, 0xF9, 0xF9, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Honky-Tonk */
   { 0x01, 0x01, 0x4F, 0x04, 0xF1, 0xD2, 0x50, 0x7C, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Electric Piano 1 */
   { 0x02, 0x02, 0x22, 0x00, 0xF2, 0xF5, 0x13, 0x43, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Electric Piano 2 */
   { 0x31, 0x32, 0x8E, 0x80, 0xF1, 0xF3, 0xF9, 0xF9, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Harpsichord */
   { 0x01, 0x11, 0x49, 0x00, 0xF1, 0xF1, 0x53, 0x74, 0x01, 0x02, 0x06, 0, 0, 0 }, /* Clav */
   { 0x17, 0x12, 0x4F, 0x08, 0xF2, 0xF2, 0x61, 0x74, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Celesta */
   { 0x07, 0x12, 0x4F, 0x0A, 0xF2, 0xF2, 0x60, 0x72, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Glockenspiel */
   { 0x17, 0x12, 0x4F, 0x08, 0xF2, 0xF1, 0x61, 0xB2, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Music Box */
   { 0x93, 0x91, 0x97, 0x80, 0xAA, 0xAC, 0x12, 0x21, 0x02, 0x00, 0x0E, 0, 0, 0 }, /* Vibraphone */
   { 0x05, 0x01, 0x4E, 0x00, 0xDA, 0xF9, 0x25, 0x15, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Marimba */
   { 0x06, 0xC4, 0x00, 0x00, 0xFF, 0xF8, 0xF0, 0xB5, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Xylophone */
   { 0x17, 0x02, 0x4F, 0x10, 0xF2, 0xF2, 0x60, 0x72, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Tubular Bells */
   { 0x03, 0x17, 0x0F, 0x0B, 0xF1, 0xF2, 0x53, 0x74, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Dulcimer */
   { 0x64, 0x21, 0x86, 0x80, 0xFF, 0xFF, 0x0F, 0x0F, 0x00, 0x00, 0x01, 0, 0, 0 }, /* Drawbar Organ */
   { 0x24, 0x22, 0x80, 0x40, 0xFF, 0xFF, 0x0F, 0x0F, 0x00, 0x00, 0x01, 0, 0, 0 }, /* Percussive Organ */
   { 0x01, 0x31, 0x4F, 0x00, 0xF0, 0x90, 0xFF, 0x0F, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Rock Organ */
   { 0xB2, 0xB0, 0xC0, 0x80, 0x9F, 0xB4, 0x06, 0x0F, 0x01, 0x01, 0x09, 0, 0, 0 }, /* Church Organ */
   { 0x01, 0x33, 0x4F, 0x08, 0xF0, 0x90, 0xFF, 0x0F, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Reed Organ */
   { 0x24, 0x31, 0x4F, 0x10, 0xF2, 0x92, 0x0B, 0x0B, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Accoridan */
   { 0x21, 0x62, 0x15, 0x80, 0x51, 0x72, 0x03, 0x67, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Harmonica */
   { 0xE0, 0xE1, 0xCE, 0x00, 0xF5, 0xF4, 0xAF, 0x0F, 0x01, 0x01, 0x0C, 0, 0, 0 }, /* Tango Accordian */
   { 0x13, 0x11, 0x93, 0x80, 0xFF, 0xFF, 0x21, 0x03, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Acoustic Guitar(nylon) */
   { 0x11, 0x11, 0x8B, 0x80, 0xFF, 0xFF, 0x01, 0x03, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Acoustic Guitar(steel) */
   { 0x03, 0x11, 0x5E, 0x00, 0xF5, 0xF2, 0x71, 0x83, 0x01, 0x00, 0x0E, 0, 0, 0 }, /* Electric Guitar(jazz) */
   { 0x21, 0x06, 0x40, 0x80, 0xF1, 0xF4, 0x31, 0x44, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Electric Guitar(clean) */
   { 0x01, 0x01, 0x11, 0x00, 0xF2, 0xF5, 0x1F, 0x88, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Electric Guitar(muted) */
   { 0x31, 0x32, 0x48, 0x00, 0xF1, 0xF2, 0x53, 0x27, 0x00, 0x02, 0x06, 0, 0, 0 }, /* Overdriven Guitar */
   { 0x62, 0xE6, 0x40, 0x03, 0x91, 0xC1, 0x1A, 0x1A, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Distortion Guitar */
   { 0xE1, 0xE7, 0x16, 0x40, 0x71, 0xF0, 0xAE, 0x7E, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Guitar Harmonics */
   { 0x01, 0x00, 0x00, 0x00, 0x94, 0x83, 0xB6, 0x26, 0x00, 0x00, 0x01, 0, 0, 0 }, /* Acoustic Bass */
   { 0x00, 0x01, 0x23, 0x00, 0xC1, 0xF3, 0xEE, 0xDE, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Electric Bass(finger) */
   { 0x50, 0x00, 0x00, 0x00, 0xFB, 0xF3, 0x71, 0xB9, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Electric Bass(pick) */
   { 0x30, 0x20, 0x1E, 0x00, 0xF2, 0xF5, 0xEF, 0x78, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Fretless Bass */
   { 0x00, 0x11, 0x40, 0x00, 0x95, 0xFF, 0x88, 0x03, 0x01, 0x00, 0x06, 0, 0, 0 }, /* Slap Bass 1 */
   { 0x00, 0x00, 0x10, 0x00, 0xF5, 0xF5, 0xF7, 0xF7, 0x01, 0x02, 0x00, 0, 0, 0 }, /* Slap Bass 2 */
   { 0x11, 0x31, 0x05, 0x00, 0xF9, 0xF1, 0x25, 0x34, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Synth Bass 1 */
   { 0x00, 0x11, 0x4F, 0x00, 0xD5, 0xB3, 0x21, 0x01, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Synth Bass 2 */
   { 0x70, 0x20, 0x1C, 0x00, 0x51, 0xB4, 0x03, 0x67, 0x02, 0x02, 0x0E, 0, 0, 0 }, /* Violin */
   { 0xF0, 0xF1, 0xD0, 0x40, 0x52, 0x91, 0x11, 0xFE, 0x02, 0x01, 0x00, 0, 0, 0 }, /* Viola */
   { 0xB0, 0xB1, 0xC5, 0x80, 0x52, 0x71, 0x11, 0xFE, 0x01, 0x01, 0x00, 0, 0, 0 }, /* Cello */
   { 0xB0, 0xB0, 0xC5, 0x84, 0x52, 0x80, 0x11, 0xCF, 0x00, 0x01, 0x08, 0, 0, 0 }, /* Contrabass */
   { 0xB1, 0x61, 0x8B, 0x40, 0x71, 0x62, 0x11, 0x15, 0x00, 0x01, 0x06, 0, 0, 0 }, /* Tremolo Strings */
   { 0x31, 0x31, 0x9C, 0x80, 0xF1, 0xF5, 0xF9, 0xD5, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Pizzicato Strings */
   { 0x91, 0x61, 0x4F, 0x40, 0xB3, 0xF7, 0x23, 0x06, 0x01, 0x01, 0x06, 0, 0, 0 }, /* Orchestral Strings */
   { 0x10, 0x10, 0x25, 0x80, 0xF0, 0xD0, 0x05, 0x04, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Timpani */
   { 0x30, 0x20, 0x1C, 0x00, 0x51, 0x64, 0x00, 0x65, 0x02, 0x02, 0x0E, 0, 0, 0 }, /* String Ensemble 1 */
   { 0xB1, 0x61, 0x8B, 0x40, 0x71, 0x42, 0x11, 0x15, 0x00, 0x01, 0x06, 0, 0, 0 }, /* String Ensemble 2 */
   { 0x31, 0x62, 0x1C, 0x02, 0x75, 0x54, 0x03, 0x44, 0x01, 0x01, 0x0E, 0, 0, 0 }, /* SynthStrings 1 */
   { 0x21, 0x23, 0x16, 0x00, 0xB0, 0xD3, 0x81, 0x2C, 0x00, 0x01, 0x0C, 0, 0, 0 }, /* SynthStrings 2 */
   { 0x41, 0xC2, 0x4F, 0x40, 0x71, 0x62, 0x53, 0x7C, 0x08, 0x00, 0x00, 0, 0, 0 }, /* Choir Aahs */
   { 0x60, 0xE2, 0xA7, 0x81, 0x22, 0x10, 0xD6, 0x75, 0x01, 0x00, 0x00, 0, 0, 0 }, /* Voice Oohs */
   { 0x41, 0x42, 0x4F, 0x03, 0xF1, 0xF2, 0x73, 0x74, 0x01, 0x01, 0x06, 0, 0, 0 }, /* Synth Voice */
   { 0x00, 0x00, 0x0F, 0x00, 0x91, 0x82, 0x05, 0x06, 0x00, 0x03, 0x00, 0, 0, 0 }, /* Orchestra Hit */
   { 0x31, 0x62, 0x1C, 0x80, 0x41, 0xC2, 0x0B, 0x3B, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Trumpet */
   { 0xB1, 0x61, 0x1C, 0x80, 0x41, 0xB2, 0x1F, 0x3B, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Trombone */
   { 0x00, 0x21, 0x1D, 0x00, 0x52, 0xA3, 0x65, 0x76, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Tuba */
   { 0x21, 0x22, 0x19, 0x80, 0x43, 0xA5, 0x8C, 0x2F, 0x00, 0x01, 0x0C, 0, 0, 0 }, /* Muted Trumpet */
   { 0x21, 0x21, 0x9F, 0x80, 0x53, 0xBA, 0x5A, 0x1A, 0x00, 0x01, 0x0C, 0, 0, 0 }, /* French Horn */
   { 0xE1, 0xE1, 0x55, 0x0A, 0x91, 0xA1, 0xAE, 0x9E, 0x01, 0x00, 0x0E, 0, 0, 0 }, /* Brass Section */
   { 0x21, 0x61, 0x8E, 0x80, 0xBB, 0xB0, 0x29, 0x0A, 0x00, 0x00, 0x08, 0, 0, 0 }, /* SynthBrass 1 */
   { 0xE1, 0xE1, 0x16, 0x06, 0x71, 0xA1, 0xAE, 0x9E, 0x00, 0x01, 0x0A, 0, 0, 0 }, /* SynthBrass 2 */
   { 0xE0, 0xE2, 0x23, 0x00, 0x71, 0xA1, 0xAE, 0x9E, 0x02, 0x01, 0x0A, 0, 0, 0 }, /* Soprano Sax */
   { 0x01, 0x12, 0x4F, 0x00, 0x71, 0x92, 0x53, 0x7C, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Alto Sax */
   { 0x20, 0x32, 0x4E, 0x00, 0x71, 0x92, 0x68, 0x5E, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Tenor Sax */
   { 0x10, 0x50, 0x4F, 0x00, 0x71, 0x92, 0x5B, 0x7B, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Baritone Sax */
   { 0x21, 0x24, 0x96, 0x00, 0xF0, 0xC0, 0x09, 0x0A, 0x00, 0x01, 0x0A, 0, 0, 0 }, /* Oboe */
   { 0xB1, 0xA2, 0xC5, 0x00, 0x6E, 0xDB, 0x17, 0x0E, 0x00, 0x01, 0x02, 0, 0, 0 }, /* English Horn */
   { 0x30, 0x72, 0x4D, 0x00, 0xD5, 0x91, 0x19, 0x0A, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Bassoon */
   { 0x32, 0x61, 0x9A, 0x02, 0x51, 0xB2, 0x1B, 0x3B, 0x00, 0x00, 0x0C, 0, 0, 0 }, /* Clarinet */
   { 0x20, 0x22, 0x5B, 0x00, 0x00, 0xB0, 0x16, 0x15, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Piccolo */
   { 0x21, 0xA1, 0x83, 0x40, 0x74, 0xA5, 0x17, 0x17, 0x00, 0x01, 0x07, 0, 0, 0 }, /* Flute */
   { 0xE1, 0x60, 0xDB, 0x00, 0x7E, 0x86, 0x8F, 0x2A, 0x01, 0x00, 0x0E, 0, 0, 0 }, /* Recorder */
   { 0x20, 0xE1, 0x5B, 0x40, 0x00, 0x60, 0x16, 0x15, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Pan Flute */
   { 0x53, 0x00, 0x85, 0x00, 0x3F, 0x7E, 0x06, 0x07, 0x01, 0x00, 0x06, 0, 0, 0 }, /* Blown Bottle */
   { 0xE0, 0x61, 0xEC, 0x00, 0x6E, 0xA6, 0x8F, 0x2A, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Skakuhachi */
   { 0xF5, 0xF4, 0x9A, 0x40, 0x0C, 0x80, 0xC7, 0xA5, 0x00, 0x00, 0x0D, 0, 0, 0 }, /* Whistle */
   { 0x02, 0x11, 0x4F, 0x00, 0x71, 0x72, 0x53, 0x7C, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Ocarina */
   { 0x04, 0x02, 0x08, 0x00, 0xF8, 0xB2, 0x07, 0x74, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Lead 1 (square) */
   { 0x60, 0x60, 0x0B, 0x00, 0xF6, 0xA6, 0x4F, 0x0F, 0x01, 0x00, 0x02, 0, 0, 0 }, /* Lead 2 (sawtooth) */
   { 0x82, 0xF1, 0x90, 0x00, 0x68, 0xC7, 0x08, 0x08, 0x00, 0x00, 0x04, 0, 0, 0 }, /* Lead 3 (calliope) */
   { 0x50, 0x01, 0x80, 0x00, 0x55, 0x56, 0xF5, 0xE6, 0x00, 0x01, 0x08, 0, 0, 0 }, /* Lead 4 (chiff) */
   { 0x61, 0x22, 0x00, 0x00, 0x96, 0x65, 0x33, 0x2B, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Lead 5 (charang) */
   { 0x61, 0x22, 0x07, 0x00, 0xF6, 0xF6, 0x03, 0x16, 0x03, 0x00, 0x04, 0, 0, 0 }, /* Lead 6 (voice) */
   { 0x11, 0x01, 0x85, 0x00, 0xB3, 0xA1, 0xE1, 0xE4, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Lead 7 (fifths) */
   { 0x50, 0x71, 0x41, 0x00, 0xF2, 0xF2, 0xE2, 0xB2, 0x01, 0x00, 0x0A, 0, 0, 0 }, /* Lead 8 (bass+lead) */
   { 0xB4, 0xF6, 0x87, 0x00, 0xA4, 0x85, 0x02, 0x42, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Pad 1 (new age) */
   { 0xF0, 0xB0, 0xC0, 0x00, 0x41, 0xB2, 0x90, 0x05, 0x01, 0x00, 0x08, 0, 0, 0 }, /* Pad 2 (warm) */
   { 0x51, 0x00, 0x03, 0x01, 0xFF, 0xFF, 0x02, 0x04, 0x01, 0x01, 0x04, 0, 0, 0 }, /* Pad 3 (polysynth) */
   { 0xE1, 0xE0, 0xD0, 0x00, 0xF5, 0xF4, 0xAF, 0x0F, 0x00, 0x02, 0x0C, 0, 0, 0 }, /* Pad 4 (choir) */
   { 0xF4, 0xF1, 0x02, 0x00, 0x33, 0x53, 0x11, 0x2E, 0x02, 0x03, 0x03, 0, 0, 0 }, /* Pad 5 (bowed) */
   { 0x05, 0x43, 0x40, 0x00, 0xB3, 0xF2, 0xD3, 0x25, 0x00, 0x01, 0x02, 0, 0, 0 }, /* Pad 6 (metallic) */
   { 0x31, 0x10, 0x4D, 0x00, 0x72, 0x51, 0xCF, 0xEE, 0x03, 0x01, 0x02, 0, 0, 0 }, /* Pad 7 (halo) */
   { 0x00, 0x10, 0x12, 0x00, 0x10, 0x50, 0xFF, 0xFF, 0x00, 0x00, 0x0A, 0, 0, 0 }, /* Pad 8 (sweep) */
   { 0x7E, 0x61, 0x1A, 0x00, 0xFF, 0x6F, 0x0F, 0x0F, 0x00, 0x01, 0x0E, 0, 0, 0 }, /* FX 1 (rain) */
   { 0xF0, 0xF0, 0x41, 0x40, 0x31, 0x22, 0x11, 0x12, 0x00, 0x01, 0x02, 0, 0, 0 }, /* FX 2 (soundtrack) */
   { 0xB6, 0xF1, 0x4B, 0x00, 0xE5, 0x45, 0x03, 0x42, 0x02, 0x01, 0x06, 0, 0, 0 }, /* FX 3 (crystal) */
   { 0x72, 0x20, 0x18, 0x40, 0x58, 0x26, 0x00, 0x02, 0x01, 0x00, 0x06, 0, 0, 0 }, /* FX 4 (atmosphere) */
   { 0x50, 0xC5, 0x90, 0x00, 0xF9, 0xFF, 0x02, 0x01, 0x02, 0x00, 0x04, 0, 0, 0 }, /* FX 5 (brightness) */
   { 0x20, 0x00, 0x03, 0x00, 0x4D, 0xFF, 0x0F, 0x05, 0x00, 0x01, 0x02, 0, 0, 0 }, /* FX 6 (goblins) */
   { 0x35, 0xA2, 0xD7, 0x00, 0x7F, 0x35, 0x42, 0x21, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* FX 7 (echoes) */
   { 0x7C, 0x30, 0x40, 0x00, 0xF1, 0xF1, 0x03, 0x01, 0x03, 0x00, 0x06, 0, 0, 0 }, /* FX 8 (sci-fi) */
   { 0x01, 0x28, 0x40, 0x80, 0xF1, 0xF1, 0x53, 0x53, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Sitar */
   { 0x31, 0x13, 0x87, 0x80, 0xA1, 0x8D, 0x11, 0x43, 0x00, 0x00, 0x08, 0, 0, 0 }, /* Banjo */
   { 0x01, 0x37, 0x4F, 0x00, 0xF1, 0xF2, 0x53, 0x74, 0x00, 0x00, 0x06, 0, 0, 0 }, /* Shamisen */
   { 0x01, 0x21, 0x0B, 0x00, 0xF2, 0xF5, 0x1F, 0x88, 0x00, 0x01, 0x00, 0, 0, 0 }, /* Koto */
   { 0x02, 0x01, 0x99, 0x80, 0xF5, 0xF6, 0x55, 0x53, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Kalimba */
   { 0x31, 0xA1, 0x43, 0x00, 0x6E, 0xAB, 0x17, 0x0C, 0x01, 0x01, 0x02, 0, 0, 0 }, /* Bagpipe */
   { 0x31, 0x62, 0x19, 0x00, 0x55, 0x84, 0x03, 0x44, 0x02, 0x01, 0x0A, 0, 0, 0 }, /* Fiddle */
   { 0x81, 0x93, 0x4B, 0x00, 0x78, 0x85, 0x42, 0x55, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Shanai */
   { 0x07, 0x18, 0x46, 0x00, 0xF1, 0xFC, 0x72, 0x04, 0x02, 0x01, 0x00, 0, 0, 0 }, /* Tinkle Bell */
   { 0x0E, 0x0E, 0x00, 0x00, 0xF8, 0xF8, 0xF6, 0xF6, 0x00, 0x00, 0x00, 0, 0, 0 }, /* Agogo */
   { 0x03, 0x02, 0xC0, 0x00, 0x8F, 0x9F, 0x07, 0x05, 0x01, 0x01, 0x0A, 0, 0, 0 }, /* Steel Drums */
   { 0x02, 0x02, 0x00, 0x00, 0xC8, 0xF8, 0x97, 0x97, 0x00, 0x00, 0x01, 0, 0, 0 }, /* Woodblock */
   { 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0x07, 0x00, 0x01, 0x05, 0, 0, 0 }, /* Taiko Drum */
   { 0x01, 0x01, 0x00, 0x00, 0xD8, 0xD8, 0x96, 0x96, 0x0A, 0x00, 0x00, 0, 0, 0 }, /* Melodic Tom */
   { 0x09, 0x00, 0x00, 0x00, 0xF1, 0xF6, 0xB3, 0xB4, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Synth Drum */
   { 0x01, 0x00, 0x80, 0x00, 0x5F, 0x5F, 0x0B, 0x0F, 0x00, 0x03, 0x06, 0, 0, 0 }, /* Reverse Cymbal */
   { 0x51, 0x42, 0x00, 0x00, 0x66, 0x66, 0x05, 0x06, 0x02, 0x02, 0x02, 0, 0, 0 }, /* Guitar Fret Noise */
   { 0x54, 0x40, 0x0A, 0x00, 0x5F, 0x7F, 0x66, 0x07, 0x03, 0x00, 0x04, 0, 0, 0 }, /* Breath Noise */
   { 0x0E, 0x0E, 0x00, 0x00, 0x20, 0x21, 0x00, 0x01, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Seashore */
   { 0xC0, 0xFB, 0x51, 0x00, 0xF1, 0x94, 0x05, 0x23, 0x00, 0x00, 0x02, 0, 0, 0 }, /* Bird Tweet */
   { 0xFC, 0xF0, 0xC0, 0x00, 0xFF, 0xFF, 0x0F, 0x0F, 0x01, 0x03, 0x00, 0, 0, 0 }, /* Telephone ring */
   { 0xF0, 0xE2, 0x00, 0xC0, 0x1E, 0x11, 0x11, 0x11, 0x01, 0x01, 0x08, 0, 0, 0 }, /* Helicopter */
   { 0x7E, 0x6E, 0x00, 0x00, 0xFF, 0x5F, 0x0F, 0x0F, 0x00, 0x00, 0x0E, 0, 0, 0 }, /* Applause */
   { 0x0A, 0x86, 0x00, 0x00, 0xA0, 0xC5, 0xF0, 0x75, 0x00, 0x00, 0x0E, 0, 0, 0 }  /* Gunshot */

#endif
};



/* This set of GM percussion patches was provided partly by Jorrit Rouwe,
 * and partly taken from the SBTimbre utility...
 */

static FM_INSTRUMENT fm_drum[47] =
{
   { 0x10, 0x11, 0x22, 0x0b, 0xf8, 0xf3, 0x77, 0x06, 0x02, 0x00, 0x38, 0x87, 0x06, FM_BD }, /* Acoustic Bass Drum */
   { 0x10, 0x11, 0x22, 0x0b, 0xf8, 0xf3, 0x77, 0x06, 0x02, 0x00, 0x38, 0x87, 0x06, FM_BD }, /* Bass Drum 1 */
   { 0x02, 0x11, 0x07, 0x0b, 0xf9, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x38, 0x60, 0x0b, FM_TT }, /* Side Stick */
   { 0x00, 0x00, 0x00, 0x0b, 0xfc, 0xfa, 0x05, 0x17, 0x02, 0x00, 0x3e, 0xad, 0x0a, FM_SD }, /* Acoustic Snare */
   { 0x00, 0x01, 0x02, 0x0b, 0xff, 0xff, 0x07, 0x08, 0x00, 0x00, 0x30, 0x63, 0x0e, FM_SD }, /* Hand Clap */
   { 0x00, 0x00, 0x00, 0x0b, 0xfc, 0xfa, 0x05, 0x17, 0x02, 0x00, 0x3e, 0xad, 0x0e, FM_SD }, /* Electric Snare */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x57, 0x0d, FM_TT }, /* Low Floor Tom */
   { 0x01, 0x01, 0x03, 0x03, 0xb8, 0xb8, 0xb5, 0xb5, 0x01, 0x01, 0x0d, 0x57, 0x11, FM_CY }, /* Closed Hi-Hat */
   { 0x01, 0x01, 0x00, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0xb0, 0x0d, FM_TT }, /* High Floor Tom */
   { 0x01, 0x01, 0x08, 0x08, 0x88, 0x88, 0xa5, 0xa5, 0x01, 0x01, 0x03, 0x57, 0x11, FM_CY }, /* Pedal Hi-Hat */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x02, 0x0e, FM_TT }, /* Low Tom */
   { 0x01, 0x01, 0x09, 0x09, 0x86, 0x86, 0xa5, 0xa5, 0x01, 0x01, 0x03, 0x57, 0x11, FM_CY }, /* Open Hi-Hat */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x57, 0x11, FM_TT }, /* Low-Mid Tom */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0xb0, 0x11, FM_TT }, /* Hi-Mid Tom */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Crash Cymbal 1 */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x02, 0x12, FM_TT }, /* High Tom */
   { 0x01, 0x01, 0x82, 0x82, 0xf6, 0xf6, 0xd5, 0xd5, 0x01, 0x01, 0x03, 0x57, 0x11, FM_CY }, /* Ride Cymbal 1 */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Chinese Cymbal */
   { 0x0e, 0x0e, 0x07, 0x07, 0xb5, 0xb5, 0x15, 0x15, 0x01, 0x01, 0x0b, 0x57, 0x11, FM_CY }, /* Ride Bell */
   { 0x01, 0x01, 0x07, 0x07, 0x77, 0x77, 0x73, 0x73, 0x01, 0x01, 0x0b, 0x57, 0x11, FM_CY }, /* Tambourine */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Splash Cymbal */
   { 0x10, 0x10, 0x00, 0x00, 0x96, 0x96, 0x67, 0x67, 0x00, 0x00, 0x0a, 0xb0, 0x11, FM_SD }, /* Cowbell */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Crash Cymbal 2 */
   { 0x01, 0x01, 0x07, 0x07, 0xf9, 0xf9, 0xb5, 0xb5, 0x00, 0x00, 0x0b, 0x57, 0x11, FM_SD }, /* Vibraslap */
   { 0xd1, 0xd1, 0x05, 0x05, 0xe7, 0xe7, 0x65, 0x65, 0x01, 0x01, 0x0d, 0x57, 0x11, FM_SD }, /* Ride Cymbal 2 */
   { 0x01, 0x01, 0x00, 0x00, 0xe7, 0xe7, 0x94, 0x94, 0x00, 0x00, 0x03, 0x02, 0x12, FM_TT }, /* Hi Bongo */
   { 0x01, 0x01, 0x00, 0x00, 0xe7, 0xe7, 0x94, 0x94, 0x00, 0x00, 0x0b, 0x81, 0x11, FM_TT }, /* Low Bongo */
   { 0x01, 0x01, 0x00, 0x00, 0x96, 0x96, 0x67, 0x67, 0x00, 0x00, 0x0a, 0x02, 0x12, FM_TT }, /* Mute Hi Conga */
   { 0x01, 0x01, 0x00, 0x00, 0xb4, 0xb4, 0x26, 0x26, 0x00, 0x00, 0x0a, 0x02, 0x12, FM_TT }, /* Open Hi Conga */
   { 0x01, 0x01, 0x00, 0x00, 0xb4, 0xb4, 0x26, 0x26, 0x00, 0x00, 0x0a, 0x57, 0x11, FM_TT }, /* Low Conga */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x57, 0x11, FM_TT }, /* High Timbale */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x02, 0x0e, FM_TT }, /* Low Timbale */
   { 0x05, 0xa7, 0x00, 0x7f, 0xf6, 0x33, 0x56, 0x90, 0x00, 0x03, 0x00, 0x63, 0x0e, FM_TT }, /* High Agogo */
   { 0x05, 0xa7, 0x00, 0x7f, 0xf6, 0x33, 0x56, 0x90, 0x00, 0x03, 0x00, 0x93, 0x0b, FM_TT }, /* Low Agogo */
   { 0x00, 0x00, 0x2e, 0x2e, 0x8a, 0x8a, 0xec, 0xec, 0x02, 0x02, 0x0a, 0x57, 0x11, FM_HH }, /* Cabasa */
   { 0x00, 0x00, 0x2e, 0x2e, 0x8b, 0x8b, 0xe6, 0xe6, 0x02, 0x02, 0x0a, 0x57, 0x11, FM_HH }, /* Maracas */
   { 0x52, 0x52, 0x27, 0x27, 0x59, 0x59, 0x15, 0x15, 0x03, 0x03, 0x0b, 0x82, 0x16, FM_TT }, /* Short Whistle */
   { 0x52, 0x52, 0x27, 0x27, 0x48, 0x48, 0x14, 0x14, 0x03, 0x03, 0x0b, 0x82, 0x16, FM_TT }, /* Long Whistle */
   { 0x00, 0x00, 0x0e, 0x0e, 0x5a, 0x5a, 0xd6, 0xd6, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Short Guiro */
   { 0x10, 0x10, 0x0e, 0x0e, 0x53, 0x53, 0x9f, 0x9f, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Long Guiro */
   { 0x11, 0x11, 0x00, 0x00, 0xf5, 0xf5, 0x75, 0x75, 0x00, 0x00, 0x02, 0x02, 0x1a, FM_TT }, /* Claves */
   { 0x04, 0x04, 0x00, 0x00, 0xf8, 0xf8, 0xb6, 0xb6, 0x01, 0x01, 0x03, 0x57, 0x11, FM_TT }, /* Hi Wood Block */
   { 0x04, 0x04, 0x00, 0x00, 0xf8, 0xf8, 0xb7, 0xb7, 0x01, 0x01, 0x03, 0xca, 0x0d, FM_TT }, /* Low Wood Block */
   { 0x01, 0x01, 0x0b, 0x0b, 0x5e, 0x5e, 0xdc, 0xdc, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Mute Cuica */
   { 0x00, 0x00, 0x07, 0x07, 0x5c, 0x5c, 0xdc, 0xdc, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Open Cuica */
   { 0xc5, 0xd5, 0x4f, 0x10, 0xf6, 0xf6, 0x84, 0x84, 0x00, 0x00, 0x08, 0x02, 0x16, FM_BD }, /* Mute Triangle */
   { 0xc5, 0xd5, 0x4f, 0x10, 0xf6, 0xf6, 0x84, 0x72, 0x00, 0x00, 0x08, 0x02, 0x16, FM_BD }  /* Open Triangle */
};

