@ECHO OFF
REM ***************************
REM * Builds run-time library *
REM ***************************

IF "%1" == "/?" GOTO HELP
IF "%1" == "-?" GOTO HELP

IF EXIST "\VP\SOURCE\RTL\BLDRTL.PAS" GOTO BUILD
ECHO **Error**  Change to the drive where VP is installed and run BLDRTL again.
GOTO EXIT

:BUILD
ECHO  Creating OS/2 import library ...
CD \VP\LIB\OS2LIB
CALL OS2LIB

ECHO  Building run-time library ...
CD \VP\SOURCE\RTL
\VP\BIN\VPC BLDRTL /Q /B /O\VP\UNITS /$Speed+ /$SmartLink- /$D+ %1 %2 %3 %4 %5 %6 %7 %8 %9
DEL \VP\UNITS\BLDRTL.VPI

ECHO  Building DLL version of the run-time library ...
CD \VP\SOURCE\RTL
\VP\BIN\VPC VPRTL1B3 /Q /U\VP\UNITS /O\VP\OUT
IF ERRORLEVEL 1 GOTO ERROR
SET LIB=\VP\LIB
REM *** if you have LINK386 2.02.001+ you may use
REM *** /NOSECTORALIGN to shrink DLL in size
SET LINK386=/BAT /NOL /PM:NOVIO /A:4 /EXEPACK
IF ERRORLEVEL 1 GOTO ERROR
LINK386 @\VP\OUT\VPRTL1B3.LNK;
IF ERRORLEVEL 1 GOTO EXIT
\VP\BIN\IMPLIB \VP\LIB\VPRTL.LIB \VP\SOURCE\RTL\VPRTL1B3.DEF
IF ERRORLEVEL 1 GOTO ERROR
COPY \VP\OUT\VPRTL1B3.DLL \VP\BIN > NUL
DEL  \VP\OUT\VPRTL1B3.*
CD \VP
GOTO EXIT

:ERROR
ECHO !!! ERROR !!!
GOTO EXIT

:HELP
ECHO Builds Virtual Pascal run-time library. Generates OS/2 import library.
ECHO Usage: BLDRTL [VPC Options]
ECHO Where:
ECHO   VPC Options is the options to the command line compiler
ECHO By default, BLDRTL compiles all units to object files ($SmartLink-).
ECHO It enables source level debugging for RTL units. To enable smart
ECHO linking, specify /$SmartLink+ as a parameter to BLDRTL.

:EXIT
