// Sysbench main file
#define INCL_DOSMISC
#define INCL_DOSDEVICES
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES   /* Semaphore values */

#define INCL_WIN
#define INCL_PM
#define IDM_RESOURCE 1
#define INCL_GPI
#define INCL_GPILCIDS
#define INCL_GPIPRIMITIVES
#define INCL_GPICONTROL

#include <os2.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dive.h>
#include <fourcc.h>
#include "types.h"
#include "pmb.h"
#include "pmb_bench.h"
#include "pmb_datatype.h"

#define CLS_CLIENT   "SysBenchWindowClass"
#define SYSB_VER     "0.9.1c"
#define THR_DONE     (WM_USER + 1)
#define THR_UPDATE   (WM_USER + 2)
#define DISP_LINES (119)
#define MB           (1048576)
#define KB            1024
#define MN            1000000

// ********** IMPORTED FUNCTIONS
extern double pmb_diskio_disksize(int nr);
extern int pmb_diskio_nrdisks(void);
extern void logit(char* s);
extern void DoFileIOAll(void*);
extern void DoFileIO4(void*);
extern void DoFileIO8(void*);
extern void DoFileIO16(void*);
extern void DoFileIO32(void*);
extern void DoFileIO64(void*);

// ********** EXPORTED FUNCTIONS
void err(char* s);
void InfoBox(char* s);
void WarnBox(char* s);
void ErrorBox(char* s);
int gtWarp = 0;
ULONG ulDriveNum = 1;
ULONG ulDriveMap = 0;
ULONG ulDriveMap1 = 0;

// ********** LOCAL FUNCTIONS
static void SetTitle(char* s);
static void UpdateWindow(HPS hpsPaint, PRECTL pRect, s32 scrollValue);
static void Print(s32 row, s32 col, char* string, PRECTL pRect,
                  s32 scrollValue, HPS hpsPaint, s32 color);
static void SetMenuState(bool active);
static void UpdateAll(void);
static void SaveResults(void);
static void PrintFile(s32 newlines, s32 col, char* string, FILE* fp);
void _Optlink ShowWaitWindow(void*);
void _Optlink Flashlight(void*);
MRESULT APIENTRY fnShowWait(HWND, ULONG, MPARAM, MPARAM);
void _Optlink GetDriveInfo(void*);
PSZ DoScanConfigSys(PSZ, int);
void GetMachineStuff(HWND);
MRESULT APIENTRY fnMachineStuff (HWND, ULONG, MPARAM, MPARAM);

ULONG BootDriveLetter;
ULONG action, minfree, pdisknum, swapfilegrown = 0, maxswapfilesize = 0;
float startsize, fatcachesize, hpfscachesize;
char CSpath[_MAX_PATH];
ULONG value[QSV_MAX] = {0};
BYTE coproc;
int fatdisks = 0, hpfsdisks = 0, curdiskFAT = 0;
double fatdiskspace = 0, hpfsdiskspace = 0;
BOOL fileiodisabled = 0;
HWND hwndDlgB;
volatile int  flashit  = 0;
HEV hevEvent2 = 0, hevEvent3 = 0;

MRESULT EXPENTRY ClientWindowProc ( HWND hwndWnd,
   ULONG ulMsg,
   MPARAM mpParm1,
   MPARAM mpParm2 );

// ********** EXPORTED DATA
double test_time;
static HWND   hwndClient = NULLHANDLE;
static HWND   hwndVertScroll;
static HWND   hwndMenu;

// ********** LOCAL DATA
static bool thread_running;
static s32  fontW;
static s32  fontH;
static HPS  mainHps = NULLHANDLE;
//static HAB  hab = NULLHANDLE;
static s32 scroll = 0;
static s32 oldscroll = 0;
static  HWND        hwndFrame = NULLHANDLE;
ULONG       vernum[QSV_MAX] = {0};
char pszFullFile[CCHMAXPATH] = "RESULT.TXT";/* File filter string       */

HINI hini;
char* szIniFileName   = "SYSBENCH.INI";
char* pszApp          = "SYSBENCH";
char* pszKeyName      = "Name";
char* pszKeyMobo      = "Mobo";
char* pszKeyProcessor = "Processor";
char* pszKeyMake      = "Make";
char* pszKeyCache     = "Cache";
char* pszKeyChipset   = "Chipset";
char* pszKeyGraphics  = "Graphics";
char* pszKeyDisk      = "Disk";

char Machinename[100]     = "Unknown machine name";
char Moboname[100]        = "Unknown motherboard make";
char Processor[100]       = "Unknown processor";
char MachineMake[100]     = "Unknown machine manufacturer";
char CacheAmount[100]     = "Unknown external cache";
char Chipset[100]         = "Unknown motherboard chipset";
char Graphicscard[100]    = "Unknown graphics card";
char DiskController[100]  = "Unknown disk controller";

int NamedC = 0, MobodC = 0, ChipdC = 0, MakedC = 0, CachdC = 0, ProcdC = 0, GrapdC = 0, DiskdC = 0;
int MDataPrompt = 0;
ULONG Machnlen, Mobonlen, Procnlen, Mmaknlen, Cachnlen, Chipnlen, Grapnlen, Disknlen;

int AutoBench = 0;

struct glob_data data = {
  1,
  1,
  { 100, 100, 100, 100, 100, 100, 100, 100, 100, 100 },
  {
    {
      "Graphics",
      8,
      {
        { "BitBlt S->S cpy",  -1.0, MN, "Mpixels/s" },
        { "BitBlt M->S cpy",  -1.0, MN, "Mpixels/s" },
        { "Filled Rectangle", -1.0, MN, "Mpixels/s" },
        { "Pattern Fill",     -1.0, MN, "Mpixels/s" },
        { "Vertical Lines",   -1.0, MN, "Mpixels/s" },
        { "Horizontal Lines", -1.0, MN, "Mpixels/s" },
        { "Diagonal Lines",   -1.0, MN, "Mpixels/s" },
        { "Text Render",      -1.0, MN, "Mpixels/s" }
      },
      -1.0,
      "PM-marks"
    },
    {
      "CPU integer",
      4,
      {
        { "Dhrystone",      -1.0, MN, "VAX 11/780 MIPS" },
        { "Hanoi",          -1.0, 1, "moves/25 usec" },
        { "Heapsort",       -1.0, MN, "MIPS" },
        { "Sieve",          -1.0, MN, "MIPS" }
      },
      -1.0,
      "CPUint-marks"
    },
    {
      "CPU float",
      3,
      {
        { "Linpack",            -1.0, 1000, "MFLOPS" },
        { "Flops",              -1.0, MN, "MFLOPS" },
        { "Fast Fourier Tr.",   -1.0, 1, "VAX FFT's" }
      },
      -1.0,
      "CPUfloat-marks"
    },
    {
      "Direct Interface to video extensions - DIVE",
      3,
      {
        { "Video bus bandw.",    -1.0, MB, "MB/s" },
        { "DIVE fun",            -1.0, 1, "fps at 640x480x256"  },
        { "M->S, DD,   1.00:1",  -1.0, 1, "fps at 640x480x256"  }
      },
      -1.0,
      "DIVE-marks"
    },
    {
      "Disk I/O",
      4,
      {
        { "Avg. data access time",   -1.0, 1.0e-03, "ms" },
        { "Cache/Bus xfer rate  ",   -1.0, MB, "MB/s" },
        { "Average Transfer rate",   -1.0, MB, "MB/s" },
        { "Disk use CPU load    ",   -1.0, 1, "percent" }
      },
      -1.0,
      "DiskIO-marks"
    },
     {
      "File I/O - cache read - Drive C:",
      40,
      {
        { "4Kb seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "4Kb random N     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb random N     Y   ",  -1.0, KB, "KB/sec" },
        { "4Kb seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "4Kb random Y     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb random N     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb random N     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb random Y     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "16K random N     N   ",  -1.0, KB, "KB/sec" },
        { "16K random N     Y   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "16K random Y     N   ",  -1.0, KB, "KB/sec" },
        { "16K random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "32K random N     N   ",  -1.0, KB, "KB/sec" },
        { "32K random N     Y   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "32K random Y     N   ",  -1.0, KB, "KB/sec" },
        { "32K random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "64K random N     N   ",  -1.0, KB, "KB/sec" },
        { "64K random N     Y   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "64K random Y     N   ",  -1.0, KB, "KB/sec" },
        { "64K random Y     Y   ",  -1.0, KB, "KB/sec" },
      },
      -1.0,
      "File I/O-marks"
    },
    {
      "Memory",
      27,
      {
        { "5    kB copy", -1.0, MB, "MB/s" },
        { "10   kB copy", -1.0, MB, "MB/s" },
        { "20   kB copy", -1.0, MB, "MB/s" },
        { "40   kB copy", -1.0, MB, "MB/s" },
        { "80   kB copy", -1.0, MB, "MB/s" },
        { "160  kB copy", -1.0, MB, "MB/s" },
        { "320  kB copy", -1.0, MB, "MB/s" },
        { "640  kB copy", -1.0, MB, "MB/s" },
        { "1280 kB copy", -1.0, MB, "MB/s" },
        { "5    kB read", -1.0, MB, "MB/s" },
        { "10   kB read", -1.0, MB, "MB/s" },
        { "20   kB read", -1.0, MB, "MB/s" },
        { "40   kB read", -1.0, MB, "MB/s" },
        { "80   kB read", -1.0, MB, "MB/s" },
        { "160  kB read", -1.0, MB, "MB/s" },
        { "320  kB read", -1.0, MB, "MB/s" },
        { "640  kB read", -1.0, MB, "MB/s" },
        { "1280 kB read", -1.0, MB, "MB/s" },
        { "5    kB write", -1.0, MB, "MB/s" },
        { "10   kB write", -1.0, MB, "MB/s" },
        { "20   kB write", -1.0, MB, "MB/s" },
        { "40   kB write", -1.0, MB, "MB/s" },
        { "80   kB write", -1.0, MB, "MB/s" },
        { "160  kB write", -1.0, MB, "MB/s" },
        { "320  kB write", -1.0, MB, "MB/s" },
        { "640  kB write", -1.0, MB, "MB/s" },
        { "1280 kB write", -1.0, MB, "MB/s" },
      },
      -1.0,
      "Mem-marks"
    },
  }
};


INT main (int argc, char * argv[])
{
  FATTRS      fat;
  LONG        match;
  HMQ         hmq          = NULLHANDLE;
  HAB         hab          = NULLHANDLE;      /* PM anchor block handle         */
  HWND        hwndDeskTop;
  ERRORID     erridErrorCode;/* last error id code                   */
  ULONG       flCreate     = 0UL, ulPostCount = 0;
  BOOL        bLoop;
  QMSG        qmsg;
  RECTL       rect;
  s32         x,y,w,h, i;
  CHAR        tmp[256];
  int         rc           = 1, index = 0;
  APIRET      ulrc         = 0;
  BOOL        drivechecked = 0;
  DATETIME    datetime     = {0};
  FONTMETRICS fmMetrics ;

  if (argc > 1)
    {                                             /* if any argument passed */
    for(index = 1;index < argc;index++)
       {
       if (strcmpi(argv[index],"/all") == 0)
          {
          AutoBench = 1;                 /* set auto mode on */
          }
       else
          {
          if (strstr(strupr(argv[index]),"/R:"))
             {
             char* n1 = strstr(strupr(argv[index]), "/R:");
             n1 = n1 +3;
             strcpy(pszFullFile, n1);
             }
          }
       }                                 /* end for */
    }

  rc = DosQuerySysInfo(QSV_VERSION_MAJOR,
                      QSV_VERSION_MINOR,
                      (PVOID)vernum,
                      sizeof(ULONG)*QSV_MAX);

  if ((vernum[0] <= 20) &&
      (vernum[1] <  30))     /* if prior to Warp */
     {
     gtWarp = 0;
     }
  else
     {
     gtWarp = 1;
     }

  rc = DosCreateEventSem(NULL,          /* Unnamed semaphore            */
                        &hevEvent2,     /* Handle of semaphore returned */
                        DC_SEM_SHARED,  /* Indicate a shared semaphore  */
                        FALSE);         /* Put in RESET state           */

  _beginthread(ShowWaitWindow, NULL, START_STACKSIZE, NULL); /* show Wait... window */

  GetMachineInfo();                /* scan CONFIG.SYS for SWAPPATH etc. */

  DosSleep(500);                   /* give time for show wait thread to display dialog */

  ulrc = DosQueryCurrentDisk(&ulDriveNum, &ulDriveMap);

  DosError(FERR_DISABLEHARDERR);

  for (i = 2; i <= 25; i++)   /* do from first possible HD upwards */
     {
     if ( ((ulDriveMap << (31-i)) >> 31) ) /* if bit in drive array is on */
        {
        typedef struct _FSINFOBUF
           {  ULONG        ulVolser;   /* Volume serial number */
           VOLUMELABEL  vol;        /* Volume label         */
           } FSINFOBUF;
        typedef FSINFOBUF *PFSINFOBUF;
        char szDeviceName[3];
        FSINFOBUF VolumeInfo          = {0};        /* File system info buffer */
        BYTE         fsqBuffer[sizeof(FSQBUFFER2) + (3 * CCHMAXPATH)] = {0};
        ULONG        cbBuffer         = sizeof(fsqBuffer);        /* Buffer length) */
        PFSQBUFFER2  pfsqBuffer       = (PFSQBUFFER2) fsqBuffer;
        ULONG        ulOrdinal        = 0;     /* Ordinal of entry in name list      */
        PBYTE        pszFSDName       = NULL;  /* pointer to FS name                 */
        ULONG        aulFSInfoBuf[40] = {0};         /* File system info buffer     */

        ulrc = DosQueryFSInfo(i+1,
                             FSIL_VOLSER,      /* Request volume information */
                             &VolumeInfo,      /* Buffer for information     */
                             sizeof(FSINFOBUF));  /* Size of buffer          */

        if (ulrc != NO_ERROR)
           {
           if (ulrc == ERROR_BAD_NETPATH || ulrc == ERROR_NOT_READY || ulrc == ERROR_BAD_NET_NAME)
              {
              continue;
              }
           else
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", ulrc);
              logit(tmp);
              continue;
              }
           }

        szDeviceName[0] = 'A'+i;
        szDeviceName[1] = ':';
        szDeviceName[2] = (char)NULL;

        ulrc = DosQueryFSAttach(szDeviceName,   /* Logical drive of attached FS      */
                             ulOrdinal,       /* ignored for FSAIL_QUERYNAME       */
                             FSAIL_QUERYNAME, /* Return data for a Drive or Device */
                             pfsqBuffer,      /* returned data                     */
                             &cbBuffer);      /* returned data length              */

        if (ulrc != NO_ERROR)
           {
           sprintf(tmp, "DosQueryFSAttach error: return code = %u\n", ulrc);
           logit(tmp);
           return 1;
           }
        else
           {
           pszFSDName = (PBYTE)(pfsqBuffer->szName + pfsqBuffer->cbName + 1);
           }

        if (!strcmp(pszFSDName, "FAT"))
           {
           fatdisks++;
           curdiskFAT = 1;
           }
        else
           {
           if (!strcmp(pszFSDName, "HPFS"))
              {
              hpfsdisks++;
              curdiskFAT = 2;
              }
           else
              {
              curdiskFAT = 0; /*  if anything except FAT or HPFS */
              }
           }


        if (curdiskFAT)
           {
           rc = DosQueryFSInfo(i+1,            /* Drive number      */
                              FSIL_ALLOC,             /* Level 1 allocation info */
                              (PVOID)aulFSInfoBuf,    /* Buffer                  */
                              sizeof(aulFSInfoBuf));  /* Size of buffer          */

           if (rc != NO_ERROR)
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", rc);
              logit(tmp);
              return 1;
              }
           else
              {
              if (curdiskFAT == 1)
                 {
                 fatdiskspace = fatdiskspace + (aulFSInfoBuf[1] * aulFSInfoBuf[2] * (USHORT)aulFSInfoBuf[4])/(MB);
                 }
              if (curdiskFAT == 2)
                 {
                 hpfsdiskspace = hpfsdiskspace + (aulFSInfoBuf[1] * aulFSInfoBuf[2] * (USHORT)aulFSInfoBuf[4])/(MB);
                 }
              }

           if ((aulFSInfoBuf[1] * aulFSInfoBuf[3] * (USHORT)aulFSInfoBuf[4]) > (10 * MB)) /* if freespace > 10Mb */
              {
              ulDriveMap1 = ulDriveMap1 | (0x80000000 >> 31-i);
              }
           }
        }
     }

  DosError(FERR_ENABLEHARDERR);

  hab = WinInitialize ( 0UL );

  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("WinGetLastError after WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }

  hmq = WinCreateMsgQueue ( hab, 0UL );

  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("WinGetLastError after WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  rc = DosWaitEventSem(hevEvent2, 60000); /* wait 1 minute for flashlight thread */

  if (rc != NO_ERROR)
     {
     sprintf(tmp, "DosWaitEventSem returned rc = %d", rc);
     logit(tmp);
     return 1;
     }
  else
     {
     WinSendMsg(hwndDlgB, /* simulate pushing the non-existent button */
               WM_COMMAND,
               (MPARAM)MPFROMSHORT(IDD_SHOWWAIT5),
               (MPARAM)MPFROM2SHORT(CMDSRC_PUSHBUTTON, TRUE));
     rc = DosResetEventSem(hevEvent2,            /* reset him so we can wait again */
                          &ulPostCount);
     }

  rc = WinRegisterClass(hab,
                       CLS_CLIENT,
                       ClientWindowProc,
                       CS_SIZEREDRAW,       /*  CS_SYNCPAINT |  */
                       0UL );

  if ( rc != TRUE )
     {
     logit("WinRegisterClass failed") ;
     exit(4);
     }

  flCreate = FCF_TITLEBAR    |
             FCF_SYSMENU     |
             FCF_SIZEBORDER  |
             FCF_MENU        |
             FCF_MINMAX      |
             FCF_TASKLIST    |
             FCF_NOBYTEALIGN |
             FCF_VERTSCROLL;

  hwndDeskTop = WinQueryDesktopWindow(hab,
                                     NULLHANDLE);

  hwndFrame = WinCreateStdWindow(hwndDeskTop,
                                WS_VISIBLE,
                                &flCreate,
                                CLS_CLIENT,
                                SYSB_VER,
                                CS_SIZEREDRAW,
                                NULLHANDLE,
                                WND_MAIN,
                                &hwndClient );

  if ( hwndFrame == NULLHANDLE )
     {
     logit("hwndFrame is NULLHANDLE");
     exit(6);
     }

  mainHps = WinGetPS(hwndClient);

  fat.usRecordLength  = sizeof(FATTRS); /* sets size of structure   */
  fat.fsSelection     = 0;              /* uses default selection           */
  fat.lMatch          = 0;              /* does not force match             */
  fat.idRegistry      = 0;              /* uses default registry            */
  fat.usCodePage      = 0;              /* code-page 850                    */
  fat.lMaxBaselineExt = 12L;            /* requested font height is 12 pels */
  fat.lAveCharWidth   = 8L;             /* requested font width is 12 pels  */
  fat.fsType          = 0;              /* uses default type                */
  fat.fsFontUse       = 0;              /* doesn't mix with graphics */

  strcpy(fat.szFacename ,"System VIO");

  match = GpiCreateLogFont(mainHps,        /* presentation space               */
                          NULL,       /* does not use logical font name   */
                          1L,         /* local identifier                 */
                          &fat);      /* structure with font attributes   */

  // match should now be 2 == FONT_MATCH */

   if (match != FONT_MATCH)
      {
      logit("Can't get the right font");
      exit(1);
      }

  hwndMenu = WinWindowFromID(hwndFrame, FID_MENU);

  thread_running = true;               /* set drives info running */
  SetTitle("Initialising");
  SetMenuState(false);

  _beginthread(GetDriveInfo, NULL, START_STACKSIZE, NULL); /* get Drive information */

  GpiSetCharSet(mainHps, 1L);      /* sets font for presentation space */

  GpiQueryFontMetrics(mainHps,
                     sizeof ( fmMetrics ) ,
                     &fmMetrics ) ;

  fontH = (14 * fmMetrics.lMaxBaselineExt)/10;
  fontW = fmMetrics.lMaxCharInc;

  GpiSetBackMix( mainHps, BM_OVERPAINT );  // how it mixes,
  GpiSetMix( mainHps, FM_OVERPAINT );  // how it mixes,

  hwndVertScroll = WinWindowFromID( hwndFrame, FID_VERTSCROLL);

  WinQueryWindowRect(HWND_DESKTOP, &rect);

  w = 636;
  h = (rect.yTop-rect.yBottom) - 40;
  x = (rect.xRight-rect.xLeft)/2 - w/2;
  y = 40;

  WinSetWindowPos(hwndFrame,
                 false,
                 x,
                 y,
                 w,
                 h,
                 SWP_SIZE |
                 SWP_MOVE |
                 SWP_SHOW |
                 SWP_ACTIVATE);

  WinQueryWindowRect(hwndClient,
                    &rect);

  WinSendMsg( hwndVertScroll,
              SBM_SETSCROLLBAR,
              MPFROMSHORT(0),
              MPFROM2SHORT(0, (DISP_LINES * fontH) - (rect.yTop - rect.yBottom)));

  WinSendMsg( hwndVertScroll,
              SBM_SETTHUMBSIZE,
              MPFROM2SHORT(rect.yTop - rect.yBottom, DISP_LINES * fontH),
              NULL);

  rc = DosCloseEventSem(hevEvent2); /* close and delete semaphore */

  UpdateAll();

  if ( hwndFrame != NULLHANDLE )
     {
     bLoop = WinGetMsg ( hab,
                        &qmsg,
                        NULLHANDLE,
                        0,
                        0 );
     while ( bLoop )
        {
        WinDispatchMsg ( hab, &qmsg );
        bLoop = WinGetMsg ( hab,
                           &qmsg,
                           NULLHANDLE,
                           0,
                           0 );
        }

     WinReleasePS(mainHps);
     WinDestroyWindow ( hwndFrame );
     }

  WinDestroyMsgQueue ( hmq );
  WinTerminate ( hab );
  return 0;
}

MRESULT EXPENTRY ClientWindowProc ( HWND hwndWnd,
                                 ULONG ulMsg,
                                 MPARAM mpParm1,
                                 MPARAM mpParm2 )
{
  void *pv = null;
  static bool initialized = false;
  RECTL rect;
  s32 tmp, tmp1;
  bool updateScroll;
  QMSG qmsgPeek;
  bool fDone, exitmsg = 0;
  char tmps[512];
  HAB hab;

  switch ( ulMsg ) {

  case WM_CREATE:
    /* The client window has been created but is not visible yet.        */
    /* Initialize the window here.                                       */
    hab  = WinQueryAnchorBlock( hwndWnd);
    hini = PrfOpenProfile(hab, szIniFileName); /* open our profile file */

    Machnlen = sizeof(Machinename);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyName,
                            &Machinename,
                            &Machnlen))
       {
       strcpy(Machinename,    "Unknown machine");  /* fill in with defaults if not found */
       MDataPrompt = 1;
       }

    Mobonlen = sizeof(Moboname);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyMobo,
                            &Moboname,
                            &Mobonlen))
       {
       strcpy(Moboname,       "Unknown motherboard");
       MDataPrompt = 1;
       }

    Procnlen = sizeof(Processor);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyProcessor,
                            &Processor,
                            &Procnlen))
       {
       strcpy(Processor,      "Unknown processor");
       MDataPrompt = 1;
       }

    Mmaknlen = sizeof(MachineMake);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyMake,
                            &MachineMake,
                            &Mmaknlen))
       {
       strcpy(MachineMake,    "Unknown manufacturer");
       MDataPrompt = 1;
       }

    Cachnlen = sizeof(CacheAmount);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyCache,
                            &CacheAmount,
                            &Cachnlen))
       {
       strcpy(CacheAmount,    "Unknown external cache amount");
       MDataPrompt = 1;
       }

    Chipnlen = sizeof(Chipset);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyChipset,
                            &Chipset,
                            &Chipnlen))
       {
       strcpy(Chipset,        "Unknown motherboard chipset");
       MDataPrompt = 1;
       }

    Grapnlen = sizeof(Graphicscard);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyGraphics,
                            &Graphicscard,
                            &Grapnlen))
       {
       strcpy(Graphicscard,   "Unknown graphics card");
       MDataPrompt = 1;
       }

    Disknlen = sizeof(DiskController);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyDisk,
                            &DiskController,
                            &Disknlen))
       {
       strcpy(DiskController, "Unknown disk controller");
       MDataPrompt = 1;
       }

    PrfCloseProfile(hini);

    if (MDataPrompt)
       {
       WinPostMsg(hwndClient,
                 WM_COMMAND,                        /* and send ourselves a message to display dialog box */
                 (MPARAM)MPFROMSHORT(MI_MACHINE_DATA),  /* to be processed when we're initialised */
                 (MPARAM)0);
       }
    break;

  case WM_COMMAND:

    if (thread_running)
       {
       switch (SHORT1FROMMP(mpParm1))
          {
          case MI_PROJ_QUIT:
             WinPostMsg(hwndWnd, WM_CLOSE, NULL, NULL);
             break;

          case MI_PROJ_ABOUT:
          InfoBox("SysBench "SYSB_VER" maintained by\nTrevor Hemsley : 1996-05-18\nEmail: Trevor-Hemsley@dial.pipex.com\n\nOriginal code by Henrik Harmsen 1994-10-01.\n"
                "\nThanks to Kai Uwe Rommel for the disk IO tests, and Al Aburto for the CPU tests.");
             break;

          case MI_MACHINE_DATA:
             GetMachineStuff(hwndWnd);
             break;
          }
       return false;
       }

    tmp = MI_MENU_DISKIO_SELECT;
    tmp = data.nr_fixed_disks + MI_MENU_DISKIO_SELECT;

    if ((SHORT1FROMMP(mpParm1) > MI_MENU_DISKIO_SELECT) &&
        (SHORT1FROMMP(mpParm1) <= (data.nr_fixed_disks + MI_MENU_DISKIO_SELECT)))
       {
       s32 i, disk;
       i = data.nr_fixed_disks + MI_MENU_DISKIO_SELECT;
       disk = SHORT1FROMMP(mpParm1) - (MI_MENU_DISKIO_SELECT + 1);
       if (disk == data.selected_disk)
          return false;
       data.selected_disk = disk;
       for (i = 0; i < data.nr_fixed_disks; i++)
          {
          WinCheckMenuItem(hwndMenu,
                          MI_MENU_DISKIO_SELECT + i + 1,
                          false);
           }
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_DISKIO_SELECT + data.selected_disk + 1,
                       true);
       sprintf(data.c[comp_disk].title,
              "Disk I/O - disk %d: %5.0f MB",
              data.selected_disk+1,
              data.fixed_disk_size[data.selected_disk]/(KB));

       data.c[comp_disk].datalines[disk_avseek].value = -1.0;
       data.c[comp_disk].datalines[disk_busxfer].value = -1.0;
       data.c[comp_disk].datalines[disk_transf].value = -1.0;
       data.c[comp_disk].datalines[disk_cpupct].value = -1.0;
       data.c[comp_disk].total = -1.0;
       UpdateAll();
       return false;
       }

    if ((SHORT1FROMMP(mpParm1) > MI_MENU_FILEIO_SELECT) &&
        (SHORT1FROMMP(mpParm1) <= (MI_MENU_FILEIO_SELECT + 26)))
       {
       ULONG ulDriveNum1;
       ulDriveNum1 = SHORT1FROMMP(mpParm1) - MI_MENU_FILEIO_SELECT;
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_FILEIO_SELECT + ulDriveNum,
                       false);
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_FILEIO_SELECT + ulDriveNum1,
                       true);
       ulDriveNum = ulDriveNum1;
       DosSetDefaultDisk(ulDriveNum);
       sprintf(tmps, "File I/O - cache read - Drive %c:", 'A'+ ulDriveNum-1);
       strcpy(data.c[comp_file].title, tmps);
       UpdateAll();
       return false;
       }


    switch (SHORT1FROMMP(mpParm1))
       {
       case MI_PROJ_QUIT:
          sprintf(tmps,"");
          if (swapfilegrown)
             {
             sprintf(tmps, "Swapfile was larger than initial allocation after %u of these tests (maximum size was %uKB).\n\n",
                    swapfilegrown,
                    (maxswapfilesize/1024));
             exitmsg = 1;
             }

          if (fatcachesize)                           /* if any FAT cache allocated */
             {
             float ramsize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE];
             float cachepercent = ramsize / fatcachesize;
             BOOL cachewarn = 0;

             if (fatdisks)
                {
                if (ramsize >= (4 * MB) &&
                    ramsize <= (8 * MB) &&
                    fatcachesize >= (256 * KB))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 4-8Mb RAM you might want to set DISKCACHE=256 or less\n\n", tmps);
                    }
                if (ramsize >= ((8 * MB)+1) &&
                    ramsize <= (12 * MB) &&
                    fatcachesize >= (384 * KB))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 8-12Mb RAM you might want to set DISKCACHE=384 or less\n\n", tmps);
                    }
                if (ramsize >= ((12 * MB)+1) &&
                    ramsize <= (16 * MB) &&
                    fatcachesize >= (512 * KB))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 12-16Mb RAM you might want to set DISKCACHE=512 or less\n\n", tmps);
                    }
                if (ramsize >= ((16 * MB)+1) &&
                   cachepercent <= 10.1)
                   {
                   cachewarn = 1;
                   sprintf(tmps, "%sYour FAT diskcache is set to 10%% or more of your RAM\n\n", tmps);
                   }
                if (cachewarn)
                   {
                   sprintf(tmps, "%sDISKCACHE is set to %.0fKb of your total %.0uKb RAM\n\n",
                          tmps,
                          (fatcachesize/KB),
                          (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE]/KB));
                   exitmsg = 1;
                   }
                }
             else
                {
                sprintf(tmps, "%sDISKCACHE is set to %.0fKb but you have no FAT disks\n\n",
                       tmps,
                       (fatcachesize/KB));
                exitmsg = 1;
                }
             }

          if (hpfscachesize)
             {
             float ramsize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE];
             float cachepercent = ramsize / hpfscachesize;
             BOOL cachewarn = 0;

             if (hpfsdisks)
                {
                if (ramsize >= (4 * MB) &&
                    ramsize <= (8 * MB) &&
                    (hpfscachesize >= (48 * KB) && hpfscachesize <= (128 * KB) ))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 4-8Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 48 and 128\n\n", tmps);
                    }
                if (ramsize >= ((8 * MB)+1) &&
                    ramsize <= (12 * MB) &&
                    (hpfscachesize >= (128 * KB) && hpfscachesize <= (384 * KB)))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 8-12Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 128 and 384\n\n", tmps);
                    }
                if (ramsize >= ((12 * MB)+1) &&
                    ramsize <= (16 * MB) &&
                    (hpfscachesize >= (512 * KB) && hpfscachesize <= (1024 * KB)))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 12-16Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 512 and 1024\n\n", tmps);
                    }
                if (ramsize >= ((16 * MB)+1) &&
                    ramsize <= (24 * MB) &&
                    (hpfscachesize >= (1024 * KB) && hpfscachesize <= (1536 * KB)))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 16-24Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 1024 and 1536\n\n", tmps);
                    }
                if (ramsize >= ((24 * MB)+1) &&
                   (hpfscachesize >= (1536 * KB) && hpfscachesize <= (2048 * KB)-1 ))
                   {
                   cachewarn = 1;
                   sprintf(tmps, "%sWith more than 24Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 1536 and 2048\n\n", tmps);
                   }

                if (cachewarn)
                   {
                   sprintf(tmps, "%sHPFS.IFS /CACHE is set to %.0fKb of your total %.0uKb RAM\n\n",
                          tmps,
                          (hpfscachesize/KB),
                          (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE]/KB));
                   exitmsg = 1;
                   }
                }
             else
                {
                sprintf(tmps, "%sIFS=HPFS.IFS /CACHE is set to %.0fKb but you have no HPFS disks\n\n",
                       tmps,
                       (hpfscachesize/KB));
                exitmsg = 1;
                }
             }

          if (fatdiskspace > hpfsdiskspace)
             {
             if (fatcachesize < hpfscachesize)
                {
                sprintf(tmps, "%sYou have more FAT diskspace than HPFS but your DISKCACHE is less than your HPFS cache.\n\n", tmps);
                }
             }
          if (fatdiskspace < hpfsdiskspace)
             {
             if (fatcachesize > hpfscachesize)
                {
                sprintf(tmps, "%sYou have more HPFS diskspace than FAT but your DISKCACHE is greater than your HPFS cache.\n\n", tmps);
                }
             }

          if (data.c[comp_cpuint].total > 0)
             {
             if (data.c[comp_cpuint].total >= 40 &&
                 value[QSV_MAX_WAIT - QSV_BOOT_DRIVE] > 2)
                {
                sprintf(tmps, "%sBased on integer score consider setting MAXWAIT=2 instead of current setting of %d\n\n",
                       tmps,
                       value[QSV_MAX_WAIT - QSV_BOOT_DRIVE]);
                exitmsg = 1;
                }

             if (data.c[comp_cpuint].total >= 70 &&
                 value[QSV_MAX_WAIT - QSV_BOOT_DRIVE] > 1)
                {
                sprintf(tmps, "%sBased on integer score consider setting MAXWAIT=1 instead of current setting of %d\n\n",
                       tmps,
                       value[QSV_MAX_WAIT - QSV_BOOT_DRIVE]);
                exitmsg = 1;
                }

             if (data.c[comp_cpuint].total <= 39 &&
                 value[QSV_MAX_WAIT - QSV_BOOT_DRIVE] < 3)
                {
                sprintf(tmps, "%sBased on integer score consider setting MAXWAIT=3 instead of current setting of %d\n\n",
                       tmps,
                       value[QSV_MAX_WAIT - QSV_BOOT_DRIVE]);
                exitmsg = 1;
                }
             }

          if (exitmsg)
             {
             if (!AutoBench)
                {
                InfoBox(tmps); /* display diagnostic messages about system */
                }
             }

          WinPostMsg(hwndWnd, WM_CLOSE, NULL, NULL);
          break;

       case MI_PROJ_ABOUT:
          InfoBox("SysBench "SYSB_VER" maintained by\nTrevor Hemsley : 1996-05-18\nEmail: Trevor-Hemsley@dial.pipex.com\n\nOriginal code by Henrik Harmsen 1994-10-01.\n"
                "\nThanks to Kai Uwe Rommel for the disk IO tests, and Al Aburto for the CPU tests.");
          break;

       case MI_PROJ_SAVE:
          SaveResults();
          break;

       case MI_PROJ_ALL:
          SetTitle("Running All tests");
          SetMenuState(false);
          _beginthread(DoAll, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_BITBLIT_SS:
          SetTitle("Running BitBlit S->S");
          SetMenuState(false);
          _beginthread(DoGfxBlitBlitSS, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_BITBLIT_MS:
          SetTitle("Running BitBlit M->S");
          SetMenuState(false);
          _beginthread(DoGfxBlitBlitMS, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_FILLRECT:
          SetTitle("Running Filled Rectangle");
          SetMenuState(false);
          _beginthread(DoGfxFillRect, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_PATFIL:
          SetTitle("Running Pattern Fill");
          SetMenuState(false);
          _beginthread(DoGfxPatFil, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_VLINES:
          SetTitle("Running VerticalLines");
          SetMenuState(false);
          _beginthread(DoGfxVLines, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_HLINES:
          SetTitle("Running HorizontalLines");
          SetMenuState(false);
          _beginthread(DoGfxHLines, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_DLINES:
          SetTitle("Running DiagonalLines");
          SetMenuState(false);
          _beginthread(DoGfxDLines, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_TEXTRENDER:
          SetTitle("Running TextRender");
          SetMenuState(false);
          _beginthread(DoGfxTextRender, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_ALL:
          SetTitle("Running All Graphics tests");
          SetMenuState(false);
          _beginthread(DoAllGraphics, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_DHRY:
          SetTitle("Running Dhrystone");
          SetMenuState(false);
          _beginthread(DoCPUIntDhry, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_HANOI:
          SetTitle("Running Hanoi");
          SetMenuState(false);
          _beginthread(DoCPUIntHanoi, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_HEAPS:
          SetTitle("Running Heapsort");
          SetMenuState(false);
          _beginthread(DoCPUIntHeaps, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_SIEVE:
          SetTitle("Running Sieve");
          SetMenuState(false);
          _beginthread(DoCPUIntSieve, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_ALL:
          SetTitle("Running All CPU integer tests");
          SetMenuState(false);
          _beginthread(DoAllCPUInt, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_LINPACK:
          SetTitle("Running Linpack");
          SetMenuState(false);
          _beginthread(DoCPUFloatLinpack, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_FLOPS:
          SetTitle("Running FLOPS");
          SetMenuState(false);
          _beginthread(DoCPUFloatFlops, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_FFT:
          SetTitle("Running FFT");
          SetMenuState(false);
          _beginthread(DoCPUFloatFFT, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_ALL:
          SetTitle("Running All CPU float tests");
          SetMenuState(false);
          _beginthread(DoAllCPUFloat, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_5:
          SetTitle("Running Memcopy 5kB");
          SetMenuState(false);
          _beginthread(DoMem5, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_10:
          SetTitle("Running Memcopy 10kB");
          SetMenuState(false);
          _beginthread(DoMem10, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_20:
          SetTitle("Running Memcopy 20kB");
          SetMenuState(false);
          _beginthread(DoMem20, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_40:
          SetTitle("Running Memcopy 40kB");
          SetMenuState(false);
          _beginthread(DoMem40, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_80:
          SetTitle("Running Memcopy 80kB");
          SetMenuState(false);
          _beginthread(DoMem80, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_160:
          SetTitle("Running Memcopy 160kB");
          SetMenuState(false);
          _beginthread(DoMem160, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_320:
          SetTitle("Running Memcopy 320kB");
          SetMenuState(false);
          _beginthread(DoMem320, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_640:
          SetTitle("Running Memcopy 640kB");
          SetMenuState(false);
          _beginthread(DoMem640, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_1280:
          SetTitle("Running Memcopy 1280kB");
          SetMenuState(false);
          _beginthread(DoMem1280, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_5:
          SetTitle("Running Memory Read 5kB");
          SetMenuState(false);
          _beginthread(DoMemR5, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_10:
          SetTitle("Running Memory Read 10kB");
          SetMenuState(false);
          _beginthread(DoMemR10, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_20:
          SetTitle("Running Memory Read 20kB");
          SetMenuState(false);
          _beginthread(DoMemR20, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_40:
          SetTitle("Running Memory Read 40kB");
          SetMenuState(false);
          _beginthread(DoMemR40, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_80:
          SetTitle("Running Memory Read 80kB");
          SetMenuState(false);
          _beginthread(DoMemR80, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_160:
          SetTitle("Running Memory Read 160kB");
          SetMenuState(false);
          _beginthread(DoMemR160, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_320:
          SetTitle("Running Memory Read 320kB");
          SetMenuState(false);
          _beginthread(DoMemR320, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_640:
          SetTitle("Running Memory Read 640kB");
          SetMenuState(false);
          _beginthread(DoMemR640, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_1280:
          SetTitle("Running Memory Read 1280kB");
          SetMenuState(false);
          _beginthread(DoMemR1280, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_5:
          SetTitle("Running Memory Write 5kB");
          SetMenuState(false);
          _beginthread(DoMemW5, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_10:
          SetTitle("Running Memory Write 10kB");
          SetMenuState(false);
          _beginthread(DoMemW10, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_20:
          SetTitle("Running Memory Write 20kB");
          SetMenuState(false);
          _beginthread(DoMemW20, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_40:
          SetTitle("Running Memory Write 40kB");
          SetMenuState(false);
          _beginthread(DoMemW40, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_80:
          SetTitle("Running Memory Write 80kB");
          SetMenuState(false);
          _beginthread(DoMemW80, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_160:
          SetTitle("Running Memory Write 160kB");
          SetMenuState(false);
          _beginthread(DoMemW160, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_320:
          SetTitle("Running Memory Write 320kB");
          SetMenuState(false);
          _beginthread(DoMemW320, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_640:
          SetTitle("Running Memory Write 640kB");
          SetMenuState(false);
          _beginthread(DoMemW640, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_1280:
          SetTitle("Running Memory Write 1280kB");
          SetMenuState(false);
          _beginthread(DoMemW1280, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_ALL:
          SetTitle("Running All Memory tests");
          SetMenuState(false);
          _beginthread(DoAllMem, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_VIDEO_BW:
          SetTitle("Running Video Bandwidth");
          SetMenuState(false);
          _beginthread(DoDiveVBW, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_ROTATE_SCREEN:
          SetTitle("Running DIVE fun");
          SetMenuState(false);
          _beginthread(DoDiveRot, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_MS_11:
          SetTitle("Running DIVE M->S 1:1");
          SetMenuState(false);
          _beginthread(DoDiveMS11, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_ALL:
          SetTitle("Running All DIVE tests");
          SetMenuState(false);
          _beginthread(DoAllDIVE, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_AVSEEK:
          SetTitle("Running Average Data Access Time");
          SetMenuState(false);
          _beginthread(DoDiskIOAvSeek, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_CBXFER:
          SetTitle("Running Cache/Bus Transfer");
          SetMenuState(false);
          _beginthread(DoDiskCacheXfer, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_TRANS_SPEED:
          SetTitle("Running Max. transfer speed");
          SetMenuState(false);
          _beginthread(DoDiskIOTransSpeed, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_CPU_USAGE:
          SetTitle("Running CPU Usage percentage");
          SetMenuState(false);
          _beginthread(DoDiskIOCPUUsage, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_ALL:
          SetTitle("Running All disk I/O tests");
          SetMenuState(false);
          _beginthread(DoAllDiskIO, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_ALL:
          SetTitle("Running All file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIOAll, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_4KB:
          SetTitle("Running 4KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO4, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_8KB:
          SetTitle("Running 8KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO8, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_16KB:
          SetTitle("Running 16KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO16, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_32KB:
          SetTitle("Running 32KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO32, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_64KB:
          SetTitle("Running 64KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO64, null, START_STACKSIZE, pv);
          break;

       case MI_MACHINE_DATA:
          GetMachineStuff(hwndWnd);
          break;

/*       default:
          tmp = 1;
          break; */
       }
       break;

  case WM_PAINT:
     {
     FATTRS      fat;
     LONG        match;
     FONTMETRICS fmMetrics ;
     HPS               hpsPaint ;
     RECTL             rclRect ;
     RECTL             rclWindow ;
     ULONG             ulCharHeight ;
     HWND              hwndEnum ;
     HWND              hwndFrame ;
     HENUM             heEnum ;
     POINTL            point;
     HRGN              newHrgn, oldHrgn, dummy;
     s32               complexity;
     RECTL             clipRect;

     if (!initialized)
        {
        initialized = true;
        }

     hpsPaint = WinBeginPaint ( hwndWnd,
                             NULLHANDLE,
                             &rclRect ) ;

// This should work, but there was a bug in Warp II
//      newHrgn = GpiQueryClipRegion(hpsPaint);
//      complexity = GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
//      WinEndPaint(hpsPaint);

     GpiQueryClipBox(hpsPaint, &clipRect);
     clipRect.xRight++;
     clipRect.yTop++;
     newHrgn = GpiCreateRegion(mainHps, 1, &clipRect);
     GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
     if (NULLHANDLE != oldHrgn)
        {
        GpiDestroyRegion(mainHps, oldHrgn);
        }

     WinFillRect(mainHps, &rclRect, CLR_BLACK);

     WinQueryWindowRect ( hwndWnd, &rclWindow );
     UpdateWindow(mainHps,
                 &rclWindow,
                 scroll);

     oldscroll = scroll;
     WinEndPaint(hpsPaint);
     }
     break;

  case THR_DONE:
     SetTitle("Ready");
     SetMenuState(true);
     thread_running = false;
     if (AutoBench)
        {
        if (AutoBench == 2)
           {
           WinPostMsg(hwndClient,
                     WM_COMMAND,
                     (MPARAM)MPFROMSHORT(MI_PROJ_SAVE),
                     (MPARAM)MPFROM2SHORT(CMDSRC_MENU, TRUE));
           AutoBench++;
           }
        }

     break;

  case THR_UPDATE:
     UpdateAll();
     if (AutoBench)
        {
        if (AutoBench == 1)
           {
           WinPostMsg(hwndClient,
                     WM_COMMAND,
                     (MPARAM)MPFROMSHORT(MI_PROJ_ALL),
                     (MPARAM)MPFROM2SHORT(CMDSRC_MENU, TRUE));
           AutoBench++;
           }
        }
     break;

  case WM_SIZE:
     {
     s32 tmp;

     WinQueryWindowRect(hwndClient, &rect);

     tmp = DISP_LINES * fontH - (rect.yTop - rect.yBottom);

     if (tmp < 0)
        tmp = 0;
     if (scroll > tmp)
        scroll = tmp;

     WinSendMsg( hwndVertScroll,
               SBM_SETSCROLLBAR,
               MPFROMSHORT(scroll),
               MPFROM2SHORT(0, tmp));

     WinSendMsg( hwndVertScroll,
               SBM_SETTHUMBSIZE,
               MPFROM2SHORT(rect.yTop - rect.yBottom, DISP_LINES * fontH),
               NULL);

     }
     break;

  case WM_VSCROLL:
     updateScroll = false;
     WinQueryWindowRect(hwndClient, &rect);
     switch( SHORT2FROMMP( mpParm2) )
        {
        case SB_LINEUP:
          scroll -= fontH;
          updateScroll = true;;
          break;

        case SB_LINEDOWN:
          scroll += fontH;
          updateScroll = true;;
          break;

        case SB_PAGEUP:
          scroll -= rect.yTop-rect.yBottom;
          updateScroll = true;;
          break;

        case SB_PAGEDOWN:
          scroll += rect.yTop-rect.yBottom;
          updateScroll = true;;
          break;

        case SB_SLIDERTRACK:
        case SB_SLIDERPOSITION:
           scroll = SHORT1FROMMP( mpParm2);
           break;

        case SB_ENDSCROLL:
           break;
        default:
           break;
        }

    if (updateScroll)
       {
       WinQueryWindowRect(hwndClient, &rect);
       tmp = DISP_LINES * fontH - (rect.yTop - rect.yBottom);
       if (tmp < 0)
          tmp = 0;
       if (scroll > tmp)
          scroll = tmp;
       WinSendMsg( hwndVertScroll,
                  SBM_SETSCROLLBAR,
                  MPFROMSHORT(scroll),
                  MPFROM2SHORT(0, tmp));
       WinSendMsg( hwndVertScroll,
                  SBM_SETTHUMBSIZE,
                  MPFROM2SHORT(rect.yTop - rect.yBottom, DISP_LINES * fontH),
                  NULL);
       }

    tmp = DISP_LINES * fontH - (rect.yTop - rect.yBottom);
    if (scroll > tmp)
       scroll = tmp;
    if (scroll < 0)
       scroll = 0;

    WinScrollWindow(hwndClient,
                   0,
                   scroll-oldscroll,
                   NULL,
                   NULL,
                   NULLHANDLE,
                   NULL,
                   SW_INVALIDATERGN);

    WinUpdateWindow(hwndClient);
    break;

  case WM_ERASEBACKGROUND:
     return MRFROMSHORT ( false );  // No, we'll do this ourselves

  case WM_CHAR:
     if (!(CHARMSG(&ulMsg)->fs & KC_KEYUP))
        {
        switch (CHARMSG(&ulMsg)->vkey)
           {
           case VK_UP:
           case VK_DOWN:
           case VK_PAGEUP:
           case VK_PAGEDOWN:
              return WinSendMsg(hwndVertScroll, ulMsg, mpParm1, mpParm2);
           }
        }

  default:
     return WinDefWindowProc ( hwndWnd,
                              ulMsg,
                              mpParm1,
                              mpParm2 );
  }

  return MRFROMSHORT ( FALSE );
}

void PostFin(int onlyupdate)
{
if (onlyupdate)
   {
   WinPostMsg(hwndClient, THR_UPDATE, NULL, NULL);
   }
else
   {
   WinPostMsg(hwndClient, THR_DONE, NULL, NULL);
   }
}

void err(char* s)
{
logit(s);
ErrorBox(s);
exit(1);
}

void warn(char* s)
{
WarnBox(s);
}

static void SetTitle(char* s)
  {
  char tmp[100];
  sprintf(tmp, "SysBench %s - %s", SYSB_VER, s);
  WinSetWindowText(hwndFrame, tmp);
  }

static void UpdateWindow(HPS hpsPaint, PRECTL pRect, s32 scrollValue)
  {
  static char tmp[256];
  s32 i, comp;
  s32 line = 0;

  // print header

  line++;
  //  line++;

  for (comp = 0; comp < NUM_COMPONENTS; comp++)
     {
     // print title
     Print(line,
          1,
          data.c[comp].title,
          pRect,
          scrollValue,
          hpsPaint,
          CLR_GREEN);

     line++;
     // print lines of data
     for (i = 0; i < data.c[comp].ndatalines; i++)
        {
        if (data.c[comp].datalines[i].value < 0.0)
           sprintf(tmp, "%-21s :       --.---    %s",
                  data.c[comp].datalines[i].entry,
                  data.c[comp].datalines[i].unit);
        else
           sprintf(tmp, "%-21s : %12.3f    %s",
                  data.c[comp].datalines[i].entry,
                  data.c[comp].datalines[i].value / data.c[comp].datalines[i].unit_val,
                  data.c[comp].datalines[i].unit);
        Print(line,
             3,
             tmp,
             pRect,
             scrollValue,
             hpsPaint,
             CLR_WHITE);

        line++;
        }

     Print(line,
          3,
          "",
          pRect,
          scrollValue,
          hpsPaint,
          CLR_PALEGRAY);

     line++;
     if (data.c[comp].total < 0.0)
        sprintf(tmp, "Total                 :       --.---    %s",
               data.c[comp].unit_total);
     else
        sprintf(tmp, "Total                 : %12.3f    %s",
               data.c[comp].total,
               data.c[comp].unit_total);

     Print(line,
          3,
          tmp,
          pRect,
          scrollValue,
          hpsPaint,
          CLR_YELLOW);

     line++;
     line++;
     }
}

static void Print(s32 row, s32 col, char* string, PRECTL pRect, s32 scrollValue, HPS hpsPaint, s32 color)
  {
  RECTL printRect;

  printRect.xLeft = col * fontW;
  printRect.xRight = pRect->xRight;
  printRect.yTop = pRect->yTop - row * fontH + scrollValue;
  printRect.yBottom = printRect.yTop - fontH;

  WinDrawText(hpsPaint,
             -1,
             (PCH)string,
             &printRect,
             color,
             CLR_BLACK,
             DT_TOP |
             DT_LEFT);
  }

static void PrintFile(s32 newlines, s32 col, char* string, FILE* fp)
  {
  s32 i;
  for (i = 0; i < col; i++)
      fprintf(fp, " ");

  fprintf(fp, "%s", string);

  for (i = 0; i < newlines; i++)
      fprintf(fp, "\n");
  }

void InfoBox(char* s)
  {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Info",
                WND_MESSAGEB,
                MB_OK | MB_INFORMATION | MB_APPLMODAL | MB_MOVEABLE);
  }


void ErrorBox(char* s)
  {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Error !",
                WND_MESSAGEB,
                MB_OK | MB_ERROR | MB_APPLMODAL | MB_MOVEABLE);
  }


void WarnBox(char* s)
  {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Warning !",
                WND_MESSAGEB,
                MB_OK | MB_WARNING | MB_APPLMODAL | MB_MOVEABLE);
  }

void UpdateAll(void)
  {
  RECTL rclWindow, cliprect;
  HRGN  newHrgn, oldHrgn, dummy;
  s32 i, comp;
  bool calcav = true;

  // calculate averages
  for (comp = 0; comp < NUM_COMPONENTS; comp++)
     {
     calcav = true;
     for (i = 0; i < data.c[comp].ndatalines; i++)
        {
        calcav = calcav && (data.c[comp].datalines[i].value >= 0.0);
        }
     if (!calcav)
        continue;
     switch (comp)
        {
        case comp_gfx:
           data.c[comp_gfx].total = CalcGfxAv();
           break;
        case comp_cpuint:
           data.c[comp_cpuint].total = CalcCPUIntAv();
           break;
        case comp_cpufloat:
           data.c[comp_cpufloat].total = CalcCPUFloatAv();
           break;
        case comp_dive:
           data.c[comp_dive].total = CalcDIVEAv();
           break;
        case comp_disk:
           data.c[comp_disk].total = CalcDiskIOAv();
           break;
        case comp_file:
           data.c[comp_file].total = CalcFileIOAv();
           break;
        case comp_mem:
           data.c[comp_mem].total = CalcMemAv();
           break;
        }
     }

  // update screen
  WinQueryWindowRect ( hwndClient, &rclWindow ); // update whole window
  cliprect.xLeft = rclWindow.xLeft;
  cliprect.xRight = rclWindow.xRight+1;
  cliprect.yBottom = rclWindow.yBottom;
  cliprect.yTop = rclWindow.yTop+1;
  newHrgn = GpiCreateRegion(mainHps, 1, &cliprect);
  GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
  if (NULLHANDLE != oldHrgn)
     GpiDestroyRegion(mainHps, oldHrgn);
  UpdateWindow(mainHps, &rclWindow, scroll);
  oldscroll = scroll;
  }

static void SetMenuState(bool active)
  { // if active == true => all items enabled
    // otherw. all items but the about and close are disabled
  WinEnableMenuItem(hwndMenu, MI_PROJ_SAVE, active);
  WinEnableMenuItem(hwndMenu, MI_PROJ_ALL, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_GFX, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_CPUINT, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_CPUFLOAT, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_MEM, active);
  if (gtWarp)
     {
     WinEnableMenuItem(hwndMenu,
                      MI_MENU_DIVE,
                      active);
     }
  else
     {
     WinEnableMenuItem(hwndMenu,
                      MI_MENU_DIVE,
                      false);
     }
  if (data.nr_fixed_disks)
     WinEnableMenuItem(hwndMenu, MI_MENU_DISKIO, active);
  else
     WinEnableMenuItem(hwndMenu, MI_MENU_DISKIO, FALSE);
  if (!fileiodisabled)
     WinEnableMenuItem(hwndMenu, MI_MENU_FILEIO, active);
}


static void SaveResults(void)
  {
  FILE* fp;
  static char tmp[256];
  s32 i, comp;
  struct tm *newtime;
  time_t ltime;

  FILEDLG fild;            /* File dialog info structure           */
  char pszTitle[24] = "Save Results to file..."; /* Title of dialog              */
  HWND hwndDlg;            /* File dialog window */

  APIRET rc = 0UL, ret;
  double meg = MB;
  static DIVE_CAPS dc;
  float size;
  char  IDrive[2];

  memset(&fild, 0, sizeof(FILEDLG)); /* set fields in file dlg to zero */

  fild.cbSize   = sizeof(FILEDLG);       /* Size of structure        */
  fild.fl       = FDS_CENTER | FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB      ;
                                    /* FDS_* flags              */
  fild.pszTitle = pszTitle;         /* Dialog title string         */
  if (pszFullFile[1] == ':')
     {
     fild.pszIDrive = (char*)&IDrive;
     IDrive[0] = pszFullFile[0];
     IDrive[1] = pszFullFile[1];
     IDrive[2] = 0;
     strcpy(fild.szFullFile, pszFullFile+2);  /* Initial path,file name, or file filter */
     }
  else
     {
     strcpy(fild.szFullFile, pszFullFile);  /* Initial path,file name, or file filter */
     }

  if (!AutoBench)
     {
     hwndDlg = WinFileDlg(HWND_DESKTOP, hwndClient, &fild);

     if (hwndDlg && (fild.lReturn == DID_OK))
        {
        fp = fopen(fild.szFullFile, "wb");
        }
     else
        {
        return;
        }
     }
  else
     {
     fp = fopen(pszFullFile, "wb");
     }

  if (!fp)
     {
     WarnBox("Cannot open output file");
     return;
     }

  time(&ltime);
  newtime = localtime(&ltime);
  fprintf(fp, "\n\nSysbench " SYSB_VER " result file created %s\n", asctime(newtime));

  fprintf(fp, "Machine name    - %s\n"
              "Manufacturer    - %s\n"
              "Motherboard     - %s\n"
              "Chipset         - %s\n"
              "Processor       - %s\n"
              "External cache  - %s\n"
              "Graphics card   - %s\n"
              "Disk Controller - %s\n\n",
              Machinename,
              MachineMake,
              Moboname,
              Chipset,
              Processor,
              CacheAmount,
              Graphicscard,
              DiskController);

  fprintf(fp, "Machine data\n"
              "Coprocessor     = %s\n"
              "RAM             = %3.2f MB\n"
              "Priority        = %s\n"
              "Maxwait         = %d\n"
              "Timeslice       = (%d,%d)\n",
               (coproc ? "Yes" : "No"),
               (double)(value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE]+(384*KB))/meg,
               (value[QSV_DYN_PRI_VARIATION - QSV_BOOT_DRIVE] ? "Dynamic" : "Absolute"),
               value[QSV_MAX_WAIT - QSV_BOOT_DRIVE],
               value[QSV_MIN_SLICE - QSV_BOOT_DRIVE],
               value[QSV_MAX_SLICE - QSV_BOOT_DRIVE]);

  size = GetSwapFileSize();

  if (size)
     {
     fprintf(fp, "Swap file size  = %4.2fMB\n"
                 "  ...initially  = %4.2fMB\n",
                 (float)size/MB,
                 (float)startsize/MB);
     }
  else
     {
     fprintf(fp, "Unable to determine current swapfile size\n"
                 "   ...initially = %4.2fMB\n",
                 (float)startsize/MB);
     }

   if (gtWarp)
     {
     memset(&dc, 0, sizeof(dc));
     dc.ulStructLen    = sizeof(dc);
     dc.ulFormatLength = 0;
     ret = DiveQueryCaps(&dc, DIVE_BUFFER_SCREEN);
     if (DIVE_SUCCESS != ret)
        {
        if (ret == DIVE_ERR_INSUFFICIENT_LENGTH)
           {
           dc.pFormatData = calloc(dc.ulFormatLength,1);
           ret = DiveQueryCaps(&dc, DIVE_BUFFER_SCREEN); // let's try again
           if (DIVE_SUCCESS != ret)
              {
              err("Error in call to DiveQueryCaps()");
              }
           }
        else
           {
           err("Error in call to DiveQueryCaps()");
           }
        }

     fprintf(fp, "\nVideo data\n"
                 "Resolution      = %dx%dx%d bits/pixel\n",
            dc.ulHorizontalResolution,
            dc.ulVerticalResolution,
            dc.ulDepth);

     fprintf(fp, "Number planes   = %d\n"
                 "Screen Access   = %s\n"
                 "Bank Switched   = %s\n"
                 "Bytes/scanline  = %d\n"
                 "Aperture size   = %d\n\n",
            dc.ulPlaneCount,
            (dc.fScreenDirect ? "Direct" : "Not Direct"),
            (dc.fBankSwitched ? "Yes" : "No"),
            dc.ulScanLineBytes,
            dc.ulApertureSize);
     }
  else
     {
     fprintf(fp, "Video data not listed because OS/2 release less than Warp\n");
     }

  for (comp = 0; comp < NUM_COMPONENTS; comp++)
     {
     // print title
     PrintFile(1, 1, data.c[comp].title, fp);
     // print lines of data
     for (i = 0; i < data.c[comp].ndatalines; i++)
        {
        if (data.c[comp].datalines[i].value < 0.0)
           sprintf(tmp, "%-21s :       --.---    %s",
                  data.c[comp].datalines[i].entry,
                  data.c[comp].datalines[i].unit);
        else
           sprintf(tmp, "%-21s : %12.3f    %s",
                  data.c[comp].datalines[i].entry,
                  data.c[comp].datalines[i].value / data.c[comp].datalines[i].unit_val,
                  data.c[comp].datalines[i].unit);

        PrintFile(1, 3, tmp, fp);
        }
//  PrintFile(1, 3, "", fp);
     PrintFile(1, 3, "------------------------------------------------------------", fp);
     if (data.c[comp].total < 0.0)
        sprintf(tmp, "Total                 :       --.---    %s",
                data.c[comp].unit_total);
     else
        sprintf(tmp, "Total                 : %12.3f    %s",
               data.c[comp].total,
               data.c[comp].unit_total);
     PrintFile(2, 3, tmp, fp);
     }

  fclose(fp);

  if (AutoBench)
     {
     WinPostMsg(hwndClient,
               WM_COMMAND,
               (MPARAM)MPFROMSHORT(MI_PROJ_QUIT),
               (MPARAM)MPFROM2SHORT(CMDSRC_MENU, TRUE));
     }
}

PSZ DoScanConfigSys(PSZ Keyword, int notstart)
  {
  char CSPath[_MAX_PATH];
  FILE *fp;
  static char Buffer[1025];
  char *p;
  char* n1;
  int notstop = 1;

  CSPath[0] = (char)(BootDriveLetter + 'A'- 1);
  CSPath[1] = 0;
  strcat(CSPath, ":\\CONFIG.SYS");

  fp = fopen(CSPath, "r");
  if (!fp)
     {
     return  0;
     }

  while(fgets(Buffer, sizeof(Buffer), fp) )
     {
     if (Buffer[strlen(Buffer)-1] == '\n')
        {
        Buffer[strlen(Buffer)-1] = 0;
        }

     p = strupr(Buffer);
     n1 = strstr((char*)p, (char*)Keyword);

     if (n1)
        {
        if (n1 == p)               /* if keyword at start of line */
           {
           n1 = strstr(n1, "=");
           n1 = n1+1;
           fclose (fp);
           return (PSZ)n1;
           }
        else
           {
           if (notstart)
              {
              fclose(fp);
              return (PSZ)n1;
              }
           }
        }
     }
  fclose (fp); /* close file at end */
  return 0;
}

void GetMachineInfo(void)
{
PSZ Swappath, charsp = "SWAPPATH";
PSZ diskcache, hpfscache;

  char* n1;
  DosDevConfig(&coproc,DEVINFO_COPROCESSOR);

  DosQuerySysInfo(QSV_BOOT_DRIVE,
                 QSV_TOTPHYSMEM,
                 (PVOID)value,
                 sizeof(ULONG)*QSV_MAX);

  BootDriveLetter = value[QSV_BOOT_DRIVE - QSV_BOOT_DRIVE];

  Swappath = DoScanConfigSys(charsp, false);

  pdisknum = Swappath[0] - 'A' +1;

  sscanf(Swappath, "%s %u %f", CSpath, &minfree, &startsize);

  if (CSpath[strlen(CSpath)-1] == '\\')  /* if last character of path \ */
     {
     CSpath[strlen(CSpath)-1] = 0;       /* back up a bit */
     }

  startsize = startsize * 1024;

  strcat(CSpath, "\\swapper.dat");

  diskcache = DoScanConfigSys("DISKCACHE", false);

  if (diskcache)
     {
     char cache[12], rest[100];
     sscanf(diskcache, "%[^, ]s %s", cache, rest);
     if (strcmp(strupr(cache), "D"))
        {
        fatcachesize = atoi(cache) * KB;          /* hard coded cache size */
        }
     else
        {
        fatcachesize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] / 10;  /* cache size is 10% of RAM */
        if (fatcachesize > (14400 * KB))
           {
           fatcachesize = 14400 * KB;
           }
        if (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] >= ((6 * MB) +1) &&
            value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] <= (8 * MB))
           {
           fatcachesize = 512 * KB;
           }
        if (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] >= ((5 * MB) +1) &&
            value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] <= (6 * MB))
           {
           fatcachesize = 128 * KB;
           }
        if (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] <= (5 * MB))
           {
           fatcachesize = 64 * KB;
           }
        }
     }
  else
     {
     fatcachesize = 0;
     }

  hpfscache = DoScanConfigSys("HPFS.IFS", true);

  if (hpfscache)
     {
     n1 = strstr((char*)hpfscache, "/CACHE");
     if (!n1)
        {
        n1 = strstr((char*)hpfscache, "/C:");
        }

     if (n1)
        {
        char cache[12], rest[100];
        n1 = strstr(n1, ":");
        n1 = n1+1;
        sscanf(n1, "%s %s", cache, rest);
        hpfscachesize = atoi(cache) * KB;
        }
     else
        {
        hpfscachesize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] / 10;  /* cache size is 10% of RAM */
        if (hpfscachesize > (2048 * KB))
           {
           hpfscachesize = 2048 * KB;
           }
        }
     }
  else
     {
     hpfscachesize = 0;
     }
}


float GetSwapFileSize(void)
{
FILESTATUS3 pInfoBuf1;
if (!DosQueryPathInfo(CSpath,
                  FIL_STANDARD,
                  &pInfoBuf1,
                  sizeof(FILESTATUS3)))
     {
     return (float)pInfoBuf1.cbFile;
     }
  else
     {
     return 0;
     }
}


void _Optlink ShowWaitWindow(void* arg)
{
  HMQ         hmq = NULLHANDLE;
  HAB         hab = NULLHANDLE;      /* PM anchor block handle         */
  ERRORID erridErrorCode;
  APIRET      rc  = 0 ;

  hab = WinInitialize ( 0UL );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("ShowWaitWindow WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }
  hmq = WinCreateMsgQueue ( hab, 0UL );
  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("ShowWaitWindow WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  flashit = 1;

  rc = DosCreateEventSem(NULL,          /* Unnamed semaphore            */
                        &hevEvent3,     /* Handle of semaphore returned */
                        DC_SEM_SHARED,  /* Indicate a shared semaphore  */
                        FALSE);         /* Put in RESET state           */

  _beginthread(Flashlight, NULL, START_STACKSIZE, NULL); /* show Wait... window */

  hwndDlgB = WinLoadDlg(HWND_DESKTOP,
           HWND_DESKTOP,
           fnShowWait,
           NULLHANDLE,
           IDD_SHOWWAIT,
           NULL);

  rc = WinProcessDlg(hwndDlgB);

  flashit = 0;

  rc = DosWaitEventSem(hevEvent3, 60000);  /* wait for flashlight thread to end */

  rc = DosCloseEventSem(hevEvent3);

  WinDestroyMsgQueue ( hmq );
  WinTerminate ( hab );
  _endthread();
}


/* routine to handle messages from gathering info  box */
MRESULT APIENTRY fnShowWait (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
int rc = 0;
 switch (msg)
    {
    case WM_INITDLG:
       rc = DosPostEventSem(hevEvent2);  /* say we're ready to take close msg */
       break;

    case WM_COMMAND:
       switch (COMMANDMSG(&msg)->cmd)
          {
          case IDD_SHOWWAIT5:
             rc = WinSetFocus(HWND_DESKTOP,    /* due to an apparent bug in OS/2 that means that
                                                  the WinProcessDlg that invokes this msg handling routine
                                                  never ends if it doesn't have the focus when the
                                                  WinDismissDlg() is issued, let's give it the focus */
                             hwndDlgB);
             rc = WinDismissDlg(hwndDlgB, 0UL);  /* dismiss the dialog */
             flashit = 0;
             return 0L;
          }
       break;

    default:
       break;
    }
 return (MRESULT)WinDefDlgProc (hwnd, msg, mp1, mp2);
}                                       /* end PromptWinProc     */


void _Optlink Flashlight(void* arg)
{
  HMQ         hmq = NULLHANDLE;
  HAB         hab = NULLHANDLE;      /* PM anchor block handle         */
  ERRORID erridErrorCode;
  BOOL i = 0;

  hab = WinInitialize ( 0UL );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("Flashlight WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }
  hmq = WinCreateMsgQueue ( hab, 0UL );
  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("Flashlight WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  while (flashit)
     {
     WinShowWindow(WinWindowFromID(hwndDlgB, IDD_SHOWICON2), /* toggle LED window visibility */
                  (i%2));
     i++;
     DosSleep(500);
     }

  DosPostEventSem(hevEvent3);    /* allow parent thread to end */

  WinDestroyMsgQueue ( hmq );
  WinTerminate ( hab );
  _endthread();
}


void _Optlink GetDriveInfo(void* arg)
{
  HWND        hwndPullDown;
  CHAR        tmp[256];
  APIRET      ulrc         = 0;
  BOOL        drivechecked = 0;
  int         i            = 0;
  MENUITEM    mi;
  ERRORID     erridErrorCode;
  HMQ         hmq          = NULLHANDLE;
  HAB         hab          = NULLHANDLE;      /* PM anchor block handle         */

  hab = WinInitialize ( 0UL );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("GetDriveInfo WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }
  hmq = WinCreateMsgQueue ( hab, 0UL );
  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("GetDriveInfo WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  for (i = 2; i <= 25; i++)   /* do from first possible HD upwards */
     {
     if ( ((ulDriveMap1 << (31-i)) >> 31) ) /* if bit in drive array is on */
        {
        typedef struct _FSINFOBUF
           {  ULONG        ulVolser;   /* Volume serial number */
           VOLUMELABEL  vol;        /* Volume label         */
           } FSINFOBUF;
        typedef FSINFOBUF *PFSINFOBUF;
        double drivesize = 300;
        char szDeviceName[3];
        FSINFOBUF VolumeInfo = {0};        /* File system info buffer */
        BYTE         fsqBuffer[sizeof(FSQBUFFER2) + (3 * CCHMAXPATH)] = {0};
        ULONG        cbBuffer   = sizeof(fsqBuffer);        /* Buffer length) */
        PFSQBUFFER2  pfsqBuffer = (PFSQBUFFER2) fsqBuffer;
        ULONG        ulOrdinal        = 0;     /* Ordinal of entry in name list      */
        PBYTE        pszFSDName       = NULL;  /* pointer to FS name                 */
        ULONG        aulFSInfoBuf[40] = {0};         /* File system info buffer     */

        ulrc = DosQueryFSInfo(i+1,
                             FSIL_VOLSER,      /* Request volume information */
                             &VolumeInfo,      /* Buffer for information     */
                             sizeof(FSINFOBUF));  /* Size of buffer          */

        if (ulrc != NO_ERROR)
           {
           if (ulrc == ERROR_BAD_NETPATH || ulrc == ERROR_NOT_READY || ulrc == ERROR_BAD_NET_NAME)
              {
              continue;
              }
           else
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", ulrc);
              logit(tmp);
              continue;
              }
           }

        szDeviceName[0] = 'A'+i;
        szDeviceName[1] = ':';
        szDeviceName[2] = (char)NULL;

        ulrc = DosQueryFSAttach(szDeviceName,   /* Logical drive of attached FS      */
                             ulOrdinal,       /* ignored for FSAIL_QUERYNAME       */
                             FSAIL_QUERYNAME, /* Return data for a Drive or Device */
                             pfsqBuffer,      /* returned data                     */
                             &cbBuffer);      /* returned data length              */

        if (ulrc != NO_ERROR)
           {
           sprintf(tmp, "DosQueryFSAttach error: return code = %u\n", ulrc);
           logit(tmp);
           return;
           }
        else
           {
           pszFSDName = (PBYTE)(pfsqBuffer->szName + pfsqBuffer->cbName + 1);
           }

        if (!strcmp(pszFSDName, "FAT"))
           {
           curdiskFAT = 1;
           }
        else
           {
           if (!strcmp(pszFSDName, "HPFS"))
              {
              curdiskFAT = 2;
              }
           else
              {
              curdiskFAT = 0; /*  if anything except FAT or HPFS */
              }
           }

        if (curdiskFAT)
           {
           ulrc = DosQueryFSInfo(i+1,            /* Drive number      */
                                FSIL_ALLOC,             /* Level 1 allocation info */
                                (PVOID)aulFSInfoBuf,    /* Buffer                  */
                                sizeof(aulFSInfoBuf));  /* Size of buffer          */

           if (ulrc != NO_ERROR)
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", ulrc);
              logit(tmp);
              }
           else
              {
              drivesize = (aulFSInfoBuf[1] * aulFSInfoBuf[2] * (USHORT)aulFSInfoBuf[4])/(MB);
              /* (Sectors per allocation unit) * number of allocationunits * (Bytes per sector) */
              }

           if ((aulFSInfoBuf[1] * aulFSInfoBuf[3] * (USHORT)aulFSInfoBuf[4]) > (10 * MB)) /* if freespace > 10Mb */
              {
              char drive[3];
              drive[0] = 'A'+i;
              drive[1] = ':';
              drive[2] = 0;
              sprintf(tmp, "Drive % 4s % 7.0f MB", drive, drivesize);  /* print menu item inc. size */
              if (WinSendMsg(hwndMenu,
                            MM_QUERYITEM,
                            MPFROM2SHORT(MI_MENU_FILEIO_SELECT, TRUE),
                            (MPARAM)&mi))
                 {
                 hwndPullDown   = mi.hwndSubMenu;
                 mi.iPosition   = MIT_END;
                 mi.afStyle     = MIS_TEXT;
                 mi.afAttribute = (ULONG)NULL;
                 mi.id          = (ULONG)MI_MENU_FILEIO_SELECT+1+i;
                 mi.hwndSubMenu = (HWND)NULL;
                 mi.hItem       = (ULONG)NULL;
                 WinSendMsg(hwndPullDown,
                           MM_INSERTITEM,
                           (MPARAM)&mi,
                           (MPARAM)tmp);
                 if (i == ulDriveNum-1)
                    {
                    sprintf(tmp, "File I/O - cache read - Drive %c:", 'A'+ulDriveNum-1);
                    strcpy(data.c[comp_file].title, tmp);
                    drivechecked = 1;
                    WinCheckMenuItem(hwndMenu,
                                    MI_MENU_FILEIO_SELECT + ulDriveNum,
                                    true);
                    }
                 }
              else
                 {
                 erridErrorCode = WinGetLastError(hab);
                 }
              }
           }
        }
     }

  if (!drivechecked)      /* if current drive didn't have enough space */
     {
     SHORT sState;
     for (i = 3; i <= 26; i++)
        {
        sState = (SHORT)WinSendMsg(hwndMenu,
                                  MM_ISITEMVALID,
                                  MPFROM2SHORT(MI_MENU_FILEIO_SELECT + i, TRUE),
                                  MPFROMSHORT(0));
        if (sState)
           {
           ulDriveNum = i; /* set to first drive with enough space */
           sprintf(tmp, "File I/O - cache read - Drive %c:", 'A'+ulDriveNum-1);
           strcpy(data.c[comp_file].title, tmp);
           drivechecked = 1;
           WinCheckMenuItem(hwndMenu,
                           MI_MENU_FILEIO_SELECT + ulDriveNum,
                           true);
           DosSetDefaultDisk(ulDriveNum);
           break;         /* drop out of for (i = 3; i <= 26) */
           }
        }
     }

  if (!drivechecked) /* still ?! */
     {
     fileiodisabled = 1;
     }

  data.nr_fixed_disks = pmb_diskio_nrdisks();
  if (data.nr_fixed_disks > MAX_FIXED_DISKS)
     {
     logit("Number of fixed disks is too high");
     exit(1);
     }

  for (i = 0; i < data.nr_fixed_disks; i++)
     {
     data.fixed_disk_size[i] = pmb_diskio_disksize(i);
     sprintf(tmp, "Disk %d: %5.0f MB", i+1, data.fixed_disk_size[i]/(KB));
     if (WinSendMsg(hwndMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(MI_MENU_DISKIO_SELECT, TRUE),
               (MPARAM)&mi))
        {
        hwndPullDown   = mi.hwndSubMenu;
        mi.iPosition   = MIT_END;
        mi.afStyle     = MIS_TEXT;
        mi.afAttribute = (ULONG)NULL;
        mi.id          = (ULONG)MI_MENU_DISKIO_SELECT+1+i;
        mi.hwndSubMenu = (HWND)NULL;
        mi.hItem       = (ULONG)NULL;
        WinSendMsg(hwndPullDown,
                  MM_INSERTITEM,
                  (MPARAM)&mi,
                  (MPARAM)tmp);
        }
     }

  if (!data.nr_fixed_disks)
     {
     WinSendMsg(hwndMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(MI_MENU_DISKIO_SELECT, TRUE),
               (MPARAM) &mi);

    hwndPullDown   = mi.hwndSubMenu;
    mi.iPosition   = MIT_END;
    mi.afStyle     = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id          = MI_MENU_DISKIO_SELECT+1;
    mi.hwndSubMenu = null;
    mi.hItem       = 0;
    WinSendMsg(hwndPullDown,
              MM_INSERTITEM,
              (MPARAM) &mi,
              (MPARAM)"No fixed disks found");
    }
 else
    {
    WinCheckMenuItem(hwndMenu,
                    MI_MENU_DISKIO_SELECT + 1,
                    true);
    data.selected_disk = 0;
    sprintf(data.c[comp_disk].title,
           "Disk I/O - disk %d: %5.0f MB",
           data.selected_disk+1,
           data.fixed_disk_size[data.selected_disk]/(KB));
    }
// DosSleep(30000);
 WinSendMsg(hwndClient,
           THR_DONE,
           (MPARAM)0,
           (MPARAM)0);

 WinSendMsg(hwndClient,
           THR_UPDATE,
           (MPARAM)0,
           (MPARAM)0);

 WinDestroyMsgQueue ( hmq );
 WinTerminate ( hab );

 _endthread();
}


void GetMachineStuff(HWND hwnd)
{
  HAB         hab = NULLHANDLE;      /* PM anchor block handle         */
  ERRORID erridErrorCode;
  APIRET      rc  = 0 ;
  HWND        hwndDlgM;

  hab = WinQueryAnchorBlock( hwnd );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("GetMachineInfo WinQueryAnchorBlock returned %x\n", erridErrorCode);
     exit(2);
     }

  hwndDlgM = WinLoadDlg(HWND_DESKTOP,
           HWND_DESKTOP,
           fnMachineStuff,
           NULLHANDLE,
           IDD_MACHINE_DATA,
           NULL);

  rc = WinProcessDlg(hwndDlgM);
}


/* routine to handle messages from gathering info  box */
MRESULT APIENTRY fnMachineStuff (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
int rc = 0;
HAB hab = WinQueryAnchorBlock(hwnd);

 switch (msg)
    {
    case WM_INITDLG:
       WinSendDlgItemMsg(hwnd, IDD_MACH_NAMED,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_NAMED),
                       Machinename);
       WinSendDlgItemMsg(hwnd, IDD_MACH_MOBOD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_MOBOD),
                       Moboname);
       WinSendDlgItemMsg(hwnd, IDD_MACH_CHIPD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_CHIPD),
                       Chipset);
       WinSendDlgItemMsg(hwnd, IDD_MACH_MAKED,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_MAKED),
                       MachineMake);
       WinSendDlgItemMsg(hwnd, IDD_MACH_CACHD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_CACHD),
                       CacheAmount);
       WinSendDlgItemMsg(hwnd, IDD_MACH_PROCD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_PROCD),
                       Processor);
       WinSendDlgItemMsg(hwnd, IDD_MACH_GRAPD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_GRAPD),
                       Graphicscard);
       WinSendDlgItemMsg(hwnd, IDD_MACH_DISKD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_DISKD),
                       DiskController);
       break;

    case WM_CONTROL:
        {
        switch (SHORT1FROMMP(mp1))
           {
           case IDD_MACH_NAMED:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 NamedC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_NAMED), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_MOBOD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 MobodC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_MOBOD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_CHIPD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 ChipdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_CHIPD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_MAKED:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 MakedC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_MAKED), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_CACHD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 CachdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_CACHD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_PROCD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 ProcdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_PROCD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_GRAPD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 GrapdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_GRAPD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_DISKD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 DiskdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_DISKD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;
           }
        }

    case WM_COMMAND:
       switch (COMMANDMSG(&msg)->cmd)
          {
          case IDD_DID_OK:
             {
             if (NamedC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_NAMED),
                                  sizeof(Machinename),
                                  Machinename);
                 }

             if (MobodC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_MOBOD),
                                  sizeof(Moboname),
                                  Moboname);
                 }

             if (ChipdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_CHIPD),
                                  sizeof(Chipset),
                                  Chipset);
                 }

             if (MakedC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_MAKED),
                                  sizeof(MachineMake),
                                  MachineMake);
                 }

             if (CachdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_CACHD),
                                  sizeof(CacheAmount),
                                  CacheAmount);
                 }

             if (ProcdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_PROCD),
                                  sizeof(Processor),
                                  Processor);
                 }

             if (GrapdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_GRAPD),
                                  sizeof(Graphicscard),
                                  Graphicscard);
                 }

             if (DiskdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_MACH_DISKD),
                                  sizeof(DiskController),
                                  DiskController);
                 }
             hini = PrfOpenProfile(hab, szIniFileName); /* open our profile file */
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyName,
                                &Machinename,
                                sizeof(Machinename));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyMobo,
                                &Moboname,
                                sizeof(Moboname));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyProcessor,
                                &Processor,
                                sizeof(Processor));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyMake,
                                &MachineMake,
                                sizeof(MachineMake));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyCache,
                                &CacheAmount,
                                sizeof(CacheAmount));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyChipset,
                                &Chipset,
                                sizeof(Chipset));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyGraphics,
                                &Graphicscard,
                                sizeof(Graphicscard));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyDisk,
                                &DiskController,
                                sizeof(DiskController));
             PrfCloseProfile(hini);

             rc = WinDismissDlg(hwnd, 0UL);  /* dismiss the dialog */
             return 0L;
             }
             break;

          case IDD_DID_CANCEL:
             rc = WinDismissDlg(hwnd, 0UL);  /* dismiss the dialog */
             return 0L;
          }
       break;

    default:
       break;
    }
 return (MRESULT)WinDefDlgProc (hwnd, msg, mp1, mp2);
}                                       /* end PromptWinProc     */


