

#define INCL_DOS
#define INCL_DOSFILEMGR
//#define INCL_DOSNLS        /* National Language Support values */
#define INCL_DOSERRORS     /* DOS error values */
#define INCL_DOSSEMAPHORES   /* Semaphore values */
#define INCL_DOSDATETIME     /* Timer support    */
#define INCL_DOSMEMMGR

#include <stdio.h>
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
//#include <stdarg.h>

#define FILESIZE 4*1024*1024

HEV     hevEvent1     = 0;                   /* Event semaphore handle    */
HTIMER  htimerEvent1  = 0;                   /* Timer handle              */
ULONG   ulPostCount   = 0;                   /* Semaphore post count      */
volatile int Timeout  = 0;

void _Optlink TimeThread(void*);
double DoFileIO(ULONG, BOOL, BOOL, BOOL);
extern double dtime(void);
extern void logit(char*);


void _Optlink TimeThread(void* arg)
{
APIRET     rc;
DATETIME   datetime = {0};
    rc = DosCreateEventSem(NULL,           /* Unnamed semaphore            */
                           &hevEvent1,     /* Handle of semaphore returned */
                           DC_SEM_SHARED,  /* Indicate a shared semaphore  */
                           FALSE);         /* Put in RESET state           */

    rc = DosStartTimer(15000L,             /* 15 second interval            */
                      (HSEM)hevEvent1,     /* Semaphore to post            */
                      &htimerEvent1);      /* Timer handler (returned)     */

    rc = DosWaitEventSem(hevEvent1, SEM_INDEFINITE_WAIT); /* Wait indefinitely for timer or post */

    rc = DosResetEventSem(hevEvent1,        /* Reset the semaphore         */
                         &ulPostCount);     /* And get count (should be 1) */
    Timeout = 0;                            /* stop disk i/o loop */

    rc = DosStopTimer(htimerEvent1);       /* Stop the timer             */

    rc = DosCloseEventSem(hevEvent1);      /* Get rid of semaphore       */

    _endthread();

 }


double DoFileIO(ULONG buffersize, BOOL cache, BOOL reading, BOOL random)
{
PVOID dummy;
ULONG iocount     = 0;
HFILE hFilehandle = 0;
ULONG ulAction    = 0;
ULONG ulOpenmode  = 0;
ULONG ulActual    = 0;
ULONG ulPosition  = 0;
APIRET  rrc       = 0;
char filename[15] = "diskte$t.tmp";
char tmp[256];
double starttime, endtime, elaptime;
ULONG  numblks    = FILESIZE/buffersize;
int    i          = 0;

 rrc = DosAllocMem(&dummy,             /* place to put data buffer ptr */
                  buffersize,
                  PAG_WRITE | PAG_COMMIT); /* we want to write to it and we want it now */

 if (rrc != NO_ERROR)
    {
    sprintf(tmp, "DosAllocMem failed with return code %d", rrc);
    logit(tmp);
    return 0;
    }

 memset(dummy, 0, buffersize);      /* set data buffer to zeros */

 ulOpenmode = OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE; /* set open mode */

 if (!cache)
    {
    ulOpenmode = ulOpenmode | OPEN_FLAGS_WRITE_THROUGH | OPEN_FLAGS_NO_CACHE; /* if not caching disable it */
    }

 if (random)
    {
    ulOpenmode = ulOpenmode | OPEN_FLAGS_RANDOM;
    }
 else
    {
    ulOpenmode = ulOpenmode | OPEN_FLAGS_SEQUENTIAL;
    }

 sprintf(filename, "dis%05u.tmp", buffersize);  /* choose filename */

 if (!reading)  /* if not reading */
    {
    rrc = DosOpen(filename,         /* open file for write */
                 &hFilehandle,
                 &ulAction,
                 FILESIZE,
                 FILE_ARCHIVED | FILE_NORMAL,
                 OPEN_ACTION_CREATE_IF_NEW |
                 OPEN_ACTION_OPEN_IF_EXISTS,
                 ulOpenmode,
                 0L);
    }
 else        /* if reading file */
    {
    rrc = DosOpen(filename,
                 &hFilehandle,
                 &ulAction,
                 FILESIZE,
                 FILE_NORMAL,
                 OPEN_ACTION_FAIL_IF_NEW |
                 OPEN_ACTION_OPEN_IF_EXISTS,
                 ulOpenmode,
                 0L);
    }

 if (rrc != NO_ERROR)
    {
    sprintf(tmp, "DosOpen of file %s for %s failed with return code %d", filename,
          reading ? "write" : "read",
          rrc);
    logit(tmp);
    DosFreeMem(dummy); /* free of buffer */
    return 0;
    }

 starttime = dtime();   /* log start time of actual i/o loop */

 while (Timeout)        /* do until timer pops */
    {
    if (!reading)       /* if writing file */
       {
       if (random)      /* randomly */
          {
          int rnm = rand() / (RAND_MAX/(numblks-1)); /* set record number between 0 and numblks-1 */
          if (rnm > numblks-1)
             {
             logit("Oops, managed to generate a file pointer beyond EOF");
             }
          ulPosition = rnm * buffersize;            /* set byte displacement into file */
          rrc = DosSetFilePtr(hFilehandle, ulPosition, FILE_BEGIN, &ulActual); /* point there */
          if (rrc != NO_ERROR)
             {
             sprintf(tmp, "DosSetFilePtr write random error code %d", rrc);
             }
          }      /* end if random write */

       memset(dummy, iocount, sizeof(iocount)); /* make this buffer different from last */

       rrc = DosWrite(hFilehandle,              /* write data */
                     dummy,
                     buffersize,
                     &ulActual);

       if (rrc == NO_ERROR)
          {
          iocount++;    /* increment count if OK */
          }
       else
          {
          sprintf(tmp, "DosWrite error code %d", rrc);
          logit(tmp);
          DosFreeMem(dummy); /* free of buffer */
          return 0;
          }

       if (!(iocount%numblks) && !random) /* if sequential access and eof */
          {
          ulPosition = 0;
          rrc = DosSetFilePtr(hFilehandle, 0, FILE_BEGIN, &ulActual); /* start at beginning again */
          if (rrc != NO_ERROR)
             {
             sprintf(tmp, "DosSetFilePtr write eof error code %d", rrc);
             logit(tmp);
             }
          }
       }
    else   /* if reading from file */
       {
       if (random)
          {
          int rnm = rand() / (RAND_MAX/(numblks-1)); /* set blknumber between start and eof */
          if (rnm > numblks-1)
             {
             logit("Oops, managed to generate a file pointer beyond EOF");
             }
          ulPosition = rnm * buffersize;              /*  set byte displacement */
          rrc =DosSetFilePtr(hFilehandle, ulPosition, FILE_BEGIN, &ulActual);
          if (rrc != NO_ERROR)
             {
             sprintf(tmp, "DosSetFilePtr read random error code %d", rrc);
             logit(tmp);
             }
          }

       rrc = DosRead(hFilehandle,      /* read data */
               dummy,
               buffersize,
               &ulActual);

       if (rrc != NO_ERROR)
          {
          sprintf(tmp, "DosRead error code %d", rrc);
          logit(tmp);
          DosFreeMem(dummy); /* free of buffer */
          return 0;
          }
       else
          {
          iocount++; /* increment counter if OK */
          }
       if (ulActual < buffersize)  /* if data read < amount requested */
          {
          ulPosition = 0;
          rrc = DosSetFilePtr(hFilehandle, 0, FILE_BEGIN, &ulPosition);  /* reset to start of file */
          if (rrc != NO_ERROR)
             {
             sprintf(tmp, "DosSetFilePtr read eof error code %d", rrc);
             logit(tmp);
             }
          }
       }
    }

 endtime = dtime();  /* log time at end of disk i/o loop */

 DosClose(hFilehandle); /* close file */

 if (reading)
    {
    if (random)
       {
       if (cache)
          {
          DosDelete(filename); /* if last use of file */
          }
       }
    }

 DosFreeMem(dummy); /* free of buffer */

 elaptime = endtime-starttime;  /* get elapsed time for i/o */

 return (((double)buffersize*(double)iocount)/elaptime); /* return kb/sec */

}


