
/* Main benchmark file */

#define INCL_DOSMISC
#define INCL_DOSPROCESS
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include "types.h"
#include "pmb_bench.h"
#include "pmb_datatype.h"


#define KB 1024
#define MB (1204*1204)
#define d1 (12345678.901*(((double)rand())/RAND_MAX+0.5))
#define d2 (12.345678901*(((double)rand())/RAND_MAX+0.5))
#define MIN_DHRY_TIME 10.0
#define MIN_MEASURE 0.1
#define MARGINAL 1.1

static bool mult;  // true -> runs multiple tests in one thread
static void* p;
double mh, mv, md, mm, mc;

extern void PostFin(int);
double dtime(void);
static void EndBench(void);
extern double pmb_fft(void);
extern double pmb_flops(void);
extern double pmb_linpack(void);
extern double pmb_dhry(int);
extern double pmb_hanoi(void);
extern double pmb_heaps(void);
extern double pmb_sieve(void);
extern double pmb_diskio_avseek(int);
extern double pmb_buscache_xfer(int);
extern double pmb_diskio_transfer(int);
extern double pmb_diskio_cpupct(int);
extern double pmb_dive_bw(void);
extern double pmb_dive_rot(void);
extern double pmb_dive_ms11(void);
extern double pmb_gfx_bitblitss(void);
extern double pmb_gfx_bitblitms(void);
extern double pmb_gfx_dlines(void);
extern double pmb_gfx_hlines(void);
extern double pmb_gfx_patrect(void);
extern double pmb_gfx_fillrect(void);
extern double pmb_gfx_textrender(void);
extern double pmb_gfx_vlines(void);
extern double pmb_memspeed(s32);
extern double pmb_memspeedr(s32);
extern double pmb_memspeedw(s32);
extern void _Optlink TimeThread(void*);
extern double DoFileIO(ULONG, BOOL, BOOL, BOOL);

void DoFileIO4(void*);
void DoFileIO8(void*);
void DoFileIO16(void*);
void DoFileIO32(void*);
void DoFileIO64(void*);
void DoFileIOBuf(ULONG);
void DoFileIOAll(void*);

extern struct glob_data data;
extern int gtWarp;
extern ULONG swapfilegrown;
extern ULONG maxswapfilesize;
extern float startsize;
extern volatile int Timeout;
extern BOOL fileiodisabled;

double rt;

void DoAll(void* p)
{
  mult = true;
  DoAllGraphics(p);
  DoAllCPUInt(p);
  DoAllCPUFloat(p);
  DoAllDIVE(p);
  DoAllDiskIO(p);
  DoFileIOAll(p);
  DoAllMem(p);
  mult = false;
  PostFin(false);
}


void DoAllCPUFloat(void* p)
{
  if (!mult)
     {
     mult = true;
     DoCPUFloatLinpack(p);
     DoCPUFloatFlops(p);
     DoCPUFloatFFT(p);
     mult = false;
     PostFin(false);
     }
  else
     {
     DoCPUFloatLinpack(p);
     DoCPUFloatFlops(p);
     DoCPUFloatFFT(p);
     }
}


void DoAllCPUInt(void* p)
{
  if (!mult)
     {
     mult = true;
     DoCPUIntDhry(p);
     DoCPUIntHanoi(p);
     DoCPUIntHeaps(p);
     DoCPUIntSieve(p);
     mult = false;
     PostFin(false);
     }
  else
     {
     DoCPUIntDhry(p);
     DoCPUIntHanoi(p);
     DoCPUIntHeaps(p);
     DoCPUIntSieve(p);
     }
}


void DoAllDIVE(void* p)
{
  if (!mult)
     {
     mult = true;
     DoDiveVBW(p);
     DoDiveRot(p);
     DoDiveMS11(p);
     mult = false;
     PostFin(false);
     }
  else
     {
     DoDiveVBW(p);
     DoDiveRot(p);
     DoDiveMS11(p);
     }
  }


void DoAllDiskIO(void* p)
{
  if (!mult)
     {
     mult = true;
     DoDiskIOAvSeek(p);
     DoDiskCacheXfer(p);
     DoDiskIOTransSpeed(p);
     DoDiskIOCPUUsage(p);
     mult = false;
     PostFin(false);
     }
  else
     {
     DoDiskIOAvSeek(p);
     DoDiskCacheXfer(p);
     DoDiskIOTransSpeed(p);
     DoDiskIOCPUUsage(p);
     }
}


void DoAllGraphics(void* p)
{
  if (!mult)
     {
     mult = true;
     DoGfxBlitBlitSS(p);
     DoGfxBlitBlitMS(p);
     DoGfxFillRect(p);
     DoGfxPatFil(p);
     DoGfxVLines(p);
     DoGfxHLines(p);
     DoGfxDLines(p);
     DoGfxTextRender(p);
     mult = false;
     PostFin(false);
     }
  else
     {
     DoGfxBlitBlitSS(p);
     DoGfxBlitBlitMS(p);
     DoGfxFillRect(p);
     DoGfxPatFil(p);
     DoGfxVLines(p);
     DoGfxHLines(p);
     DoGfxDLines(p);
     DoGfxTextRender(p);
     }
}


void DoAllMem(void* p)
{
  if (!mult)
     {
     mult = true;
     DoMem5(p);
     DoMem10(p);
     DoMem20(p);
     DoMem40(p);
     DoMem80(p);
     DoMem160(p);
     DoMem320(p);
     DoMem640(p);
     DoMem1280(p);
     DoMemR5(p);
     DoMemR10(p);
     DoMemR20(p);
     DoMemR40(p);
     DoMemR80(p);
     DoMemR160(p);
     DoMemR320(p);
     DoMemR640(p);
     DoMemR1280(p);
     DoMemW5(p);
     DoMemW10(p);
     DoMemW20(p);
     DoMemW40(p);
     DoMemW80(p);
     DoMemW160(p);
     DoMemW320(p);
     DoMemW640(p);
     DoMemW1280(p);
     mult = false;
     PostFin(false);
     }
  else
     {
     DoMem5(p);
     DoMem10(p);
     DoMem20(p);
     DoMem40(p);
     DoMem80(p);
     DoMem160(p);
     DoMem320(p);
     DoMem640(p);
     DoMem1280(p);
     DoMemR5(p);
     DoMemR10(p);
     DoMemR20(p);
     DoMemR40(p);
     DoMemR80(p);
     DoMemR160(p);
     DoMemR320(p);
     DoMemR640(p);
     DoMemR1280(p);
     DoMemW5(p);
     DoMemW10(p);
     DoMemW20(p);
     DoMemW40(p);
     DoMemW80(p);
     DoMemW160(p);
     DoMemW320(p);
     DoMemW640(p);
     DoMemW1280(p);
     }
}


void DoCPUFloatFFT(void* p)
{
  data.c[comp_cpufloat].datalines[cpufloat_fft].value = pmb_fft();
  EndBench();
}


void DoCPUFloatFlops(void* p)
{
  data.c[comp_cpufloat].datalines[cpufloat_flops].value = pmb_flops();
  EndBench();
}


void DoCPUFloatLinpack(void* p)
{
  data.c[comp_cpufloat].datalines[cpufloat_linpack].value = pmb_linpack();
  EndBench();
}


void DoCPUIntDhry(void* p)
{
  double t1, t2, r, tot_time;
  int loops;
  int notstop = 1;
  loops = 1000;

  while (notstop)
     {
     t1 = dtime();
     r = pmb_dhry(loops);
     t2 = dtime();
     tot_time = (t2-t1);
     if (((tot_time) < MIN_DHRY_TIME) || (r < 0))
        {
        if ((tot_time) < MIN_MEASURE)
           {
           loops = MIN_DHRY_TIME/MIN_MEASURE*loops;
           }
        else
           {
           loops = MIN_DHRY_TIME*MARGINAL/(tot_time)*loops;
           }
        }
     else
         {
         break;
         }
     }
  data.c[comp_cpuint].datalines[cpuint_dhrystone].value = r;
  EndBench();
}


void DoCPUIntHanoi(void* p)
{
  data.c[comp_cpuint].datalines[cpuint_hanoi].value = pmb_hanoi();
  EndBench();
}


void DoCPUIntHeaps(void* p)
{
  data.c[comp_cpuint].datalines[cpuint_heapsort].value = pmb_heaps();
  EndBench();
}


void DoCPUIntSieve(void* p)
{
  data.c[comp_cpuint].datalines[cpuint_sieve].value = pmb_sieve();
  EndBench();
}


void DoDiskIOAvSeek(void* p)
{
  data.c[comp_disk].datalines[disk_avseek].value = (pmb_diskio_avseek(data.selected_disk)/(10*1000));
  EndBench();
}


void DoDiskCacheXfer(void* p)
{
  data.c[comp_disk].datalines[disk_busxfer].value = (pmb_buscache_xfer(data.selected_disk)*KB);
  EndBench();
}


void DoDiskIOTransSpeed(void* p)
{
  data.c[comp_disk].datalines[disk_transf].value = (pmb_diskio_transfer(data.selected_disk)*KB);
  EndBench();
}


void DoDiskIOCPUUsage(void* p)
{
  data.c[comp_disk].datalines[disk_cpupct].value = (pmb_diskio_cpupct(data.selected_disk));
  EndBench();
}


void DoDiveVBW(void* p)
  {
  double r = -1;
  if (gtWarp)
     {
     r = pmb_dive_bw();
     if (r < 0)
        {
        r = -1.0;
        }
     }
  data.c[comp_dive].datalines[dive_videobw].value = r;
  EndBench();
}


void DoDiveRot(void* p)
{
  double r = -1;
  if (gtWarp)
     {
     r = pmb_dive_rot();
     if (r < 0)
        {
        r = -1.0;
        }
     }
  data.c[comp_dive].datalines[dive_rotate].value = r;
  EndBench();
}


void DoDiveMS11(void* p)
{
  double r = 1;
  if (gtWarp)
     {
     r = pmb_dive_ms11();
     if (r < 0)
        {
        r = -1.0;
        }
     }
  data.c[comp_dive].datalines[dive_ms_11].value = r;
  EndBench();
}


void DoGfxBlitBlitSS(void* p)
{
  data.c[comp_gfx].datalines[gfx_bitblt_SS].value = pmb_gfx_bitblitss();
  EndBench();
}


void DoGfxBlitBlitMS(void* p)
{
  data.c[comp_gfx].datalines[gfx_bitblt_MS].value = pmb_gfx_bitblitms();
  EndBench();
}


void DoGfxDLines(void* p)
{
  data.c[comp_gfx].datalines[gfx_dlines].value = pmb_gfx_dlines();
  EndBench();
}


void DoGfxHLines(void* p)
{
  data.c[comp_gfx].datalines[gfx_hlines].value = pmb_gfx_hlines();
  EndBench();
}


void DoGfxPatFil(void* p)
{
  data.c[comp_gfx].datalines[gfx_patt_fill].value = pmb_gfx_patrect();
  EndBench();
}

void DoGfxFillRect(void* p)
{
  data.c[comp_gfx].datalines[gfx_filled_rect].value = pmb_gfx_fillrect();
  EndBench();
}


void DoGfxTextRender(void* p)
{
  data.c[comp_gfx].datalines[gfx_textrender].value = pmb_gfx_textrender();
  EndBench();
}


void DoGfxVLines(void* p)
{
  data.c[comp_gfx].datalines[gfx_vlines].value = pmb_gfx_vlines();
  EndBench();
}


void DoMem5(void* p)
{
  data.c[comp_mem].datalines[mem_5].value = pmb_memspeed(5*KB);
  EndBench();
}


void DoMem10(void* p)
{
  data.c[comp_mem].datalines[mem_10].value = pmb_memspeed(10*KB);
  EndBench();
}


void DoMem20(void* p)
{
  data.c[comp_mem].datalines[mem_20].value = pmb_memspeed(20*KB);
  EndBench();
}


void DoMem40(void* p)
{
  data.c[comp_mem].datalines[mem_40].value = pmb_memspeed(40*KB);
  EndBench();
}


void DoMem80(void* p)
{
  data.c[comp_mem].datalines[mem_80].value = pmb_memspeed(80*KB);
  EndBench();
}


void DoMem160(void* p)
{
  data.c[comp_mem].datalines[mem_160].value = pmb_memspeed(160*KB);
  EndBench();
}


void DoMem320(void* p)
{
  data.c[comp_mem].datalines[mem_320].value = pmb_memspeed(320*KB);
  EndBench();
}


void DoMem640(void* p)
{
  data.c[comp_mem].datalines[mem_640].value = pmb_memspeed(640*KB);
  EndBench();
}


void DoMem1280(void* p)
{
  data.c[comp_mem].datalines[mem_1280].value = pmb_memspeed(1280*KB);
  EndBench();
}


void DoMemR5(void* p)
{
  data.c[comp_mem].datalines[memr_5].value = pmb_memspeedr(5*KB);
  EndBench();
}


void DoMemR10(void* p)
{
  data.c[comp_mem].datalines[memr_10].value = pmb_memspeedr(10*KB);
  EndBench();
}


void DoMemR20(void* p)
{
  data.c[comp_mem].datalines[memr_20].value = pmb_memspeedr(20*KB);
  EndBench();
}


void DoMemR40(void* p)
{
  data.c[comp_mem].datalines[memr_40].value = pmb_memspeedr(40*KB);
  EndBench();
}


void DoMemR80(void* p)
{
  data.c[comp_mem].datalines[memr_80].value = pmb_memspeedr(80*KB);
  EndBench();
}


void DoMemR160(void* p)
{
  data.c[comp_mem].datalines[memr_160].value = pmb_memspeedr(160*KB);
  EndBench();
}


void DoMemR320(void* p)
{
  data.c[comp_mem].datalines[memr_320].value = pmb_memspeedr(320*KB);
  EndBench();
}


void DoMemR640(void* p)
{
  data.c[comp_mem].datalines[memr_640].value = pmb_memspeedr(640*KB);
  EndBench();
}


void DoMemR1280(void* p)
{
  data.c[comp_mem].datalines[memr_1280].value = pmb_memspeedr(1280*KB);
  EndBench();
}


void DoMemW5(void* p)
{
  data.c[comp_mem].datalines[memw_5].value = pmb_memspeedw(5*KB);
  EndBench();
}


void DoMemW10(void* p)
{
  data.c[comp_mem].datalines[memw_10].value = pmb_memspeedw(10*KB);
  EndBench();
}


void DoMemW20(void* p)
{
  data.c[comp_mem].datalines[memw_20].value = pmb_memspeedw(20*KB);
  EndBench();
}


void DoMemW40(void* p)
{
  data.c[comp_mem].datalines[memw_40].value = pmb_memspeedw(40*KB);
  EndBench();
}


void DoMemW80(void* p)
{
  data.c[comp_mem].datalines[memw_80].value = pmb_memspeedw(80*KB);
  EndBench();
}


void DoMemW160(void* p)
{
  data.c[comp_mem].datalines[memw_160].value = pmb_memspeedw(160*KB);
  EndBench();
}


void DoMemW320(void* p)
{
  data.c[comp_mem].datalines[memw_320].value = pmb_memspeedw(320*KB);
  EndBench();
}


void DoMemW640(void* p)
{
  data.c[comp_mem].datalines[memw_640].value = pmb_memspeedw(640*KB);
  EndBench();
}


void DoMemW1280(void* p)
{
  data.c[comp_mem].datalines[memw_1280].value = pmb_memspeedw(1280*KB);
  EndBench();
}

void DoFileIOAll(void* p)
{
if (!fileiodisabled)
   {
   if (!mult)
      {
      mult = true;
      DoFileIO4(p);
      DoFileIO8(p);
      DoFileIO16(p);
      DoFileIO32(p);
      DoFileIO64(p);
      mult = false;
      PostFin(false);
      }
   else
      {
      DoFileIO4(p);
      DoFileIO8(p);
      DoFileIO16(p);
      DoFileIO32(p);
      DoFileIO64(p);
      }
   }
}


void DoFileIO4(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(4096);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(4096);
    }
}


void DoFileIO8(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(8192);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(8192);
    }
}


void DoFileIO16(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(16384);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(16384);
    }
}


void DoFileIO32(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(32768);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(32768);
    }
}


void DoFileIO64(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(65536);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(65536);
    }
}


void DoFileIOBuf(ULONG buffersize)
{
int n, linenum;
BOOL cache, random, reading;

for (cache = 0; cache <= 1; cache++)        /* toggle cache off then on for each */
   {
   for (random = 0; random <= 1; random++)     /* toggle sequential or random access */
      {
      for (reading = 0; reading <= 1; reading++)  /* toggle writing or reading */
         {
         Timeout = 1;           /* show timer not popped */
         n = frexp(buffersize/4096, &linenum);
         linenum = ((linenum - 1) * 8) + (cache * 4) + (random * 2) + (reading);
         _beginthread(TimeThread, NULL, 8192, NULL);                             /* start timer thread */
         data.c[comp_file].datalines[linenum].value = DoFileIO(buffersize, cache, reading, random); /* go do current test */
         EndBench();                                                             /* update display */
         }
      }
   }
}


void DoRef1Info(void)
{
}

void DoRef1Load(void)
{
}


void DoRef2Info(void)
{
}


void DoRef2Load(void)
{
}


double CalcGfxAv(void)
{
  return (
          (data.c[comp_gfx].datalines[gfx_bitblt_SS].value * 10) +
          (data.c[comp_gfx].datalines[gfx_bitblt_MS].value * 8) +
          (data.c[comp_gfx].datalines[gfx_filled_rect].value * 7) +
          (data.c[comp_gfx].datalines[gfx_patt_fill].value * 4) +
          (data.c[comp_gfx].datalines[gfx_vlines].value * 5) +
          (data.c[comp_gfx].datalines[gfx_hlines].value * 5) +
          (data.c[comp_gfx].datalines[gfx_dlines].value * 4) +
          (data.c[comp_gfx].datalines[gfx_textrender].value * 8)
         ) / 51 / 1.0e6;
}


double CalcCPUIntAv(void)
{
  return (
          (data.c[comp_cpuint].datalines[cpuint_dhrystone].value * 12) +
          (data.c[comp_cpuint].datalines[cpuint_hanoi].value * 5 * 1.0e6)+
          (data.c[comp_cpuint].datalines[cpuint_heapsort].value * 6) +
          (data.c[comp_cpuint].datalines[cpuint_sieve].value * 6)
         ) / 29 / 1.0e6;
}


double CalcCPUFloatAv(void)
{
  return (
          (data.c[comp_cpufloat].datalines[cpufloat_linpack].value * 10 * 1000) +
          (data.c[comp_cpufloat].datalines[cpufloat_flops].value * 20) +
          (data.c[comp_cpufloat].datalines[cpufloat_fft].value * 9 * 1.0e6)
         ) / 39 / 1.0e6;
}


double CalcMemAv(void)
{
  return (
          (data.c[comp_mem].datalines[mem_5].value * 7) +
          (data.c[comp_mem].datalines[mem_10].value * 8) +
          (data.c[comp_mem].datalines[mem_20].value * 7) +
          (data.c[comp_mem].datalines[mem_40].value * 7) +
          (data.c[comp_mem].datalines[mem_80].value * 6) +
          (data.c[comp_mem].datalines[mem_160].value * 5) +
          (data.c[comp_mem].datalines[mem_320].value * 4) +
          (data.c[comp_mem].datalines[mem_640].value * 4) +
          (data.c[comp_mem].datalines[mem_1280].value * 3) +
          (data.c[comp_mem].datalines[memr_5].value * 7) +
          (data.c[comp_mem].datalines[memr_10].value * 8) +
          (data.c[comp_mem].datalines[memr_20].value * 7) +
          (data.c[comp_mem].datalines[memr_40].value * 7) +
          (data.c[comp_mem].datalines[memr_80].value * 6) +
          (data.c[comp_mem].datalines[memr_160].value * 5) +
          (data.c[comp_mem].datalines[memr_320].value * 4) +
          (data.c[comp_mem].datalines[memr_640].value * 4) +
          (data.c[comp_mem].datalines[memr_1280].value * 3) +
          (data.c[comp_mem].datalines[memw_5].value * 7) +
          (data.c[comp_mem].datalines[memw_10].value * 8) +
          (data.c[comp_mem].datalines[memw_20].value * 7) +
          (data.c[comp_mem].datalines[memw_40].value * 7) +
          (data.c[comp_mem].datalines[memw_80].value * 6) +
          (data.c[comp_mem].datalines[memw_160].value * 5) +
          (data.c[comp_mem].datalines[memw_320].value * 4) +
          (data.c[comp_mem].datalines[memw_640].value * 4) +
          (data.c[comp_mem].datalines[memw_1280].value * 3)
         ) / (51*3.0) / MB;
}


double CalcDIVEAv(void)
{
  return (
          (data.c[comp_dive].datalines[dive_videobw].value * 10) +
          (data.c[comp_dive].datalines[dive_rotate].value * 3 * 1.0e6) +
          (data.c[comp_dive].datalines[dive_ms_11].value * 10 * 1.0e6)
         ) / 43 / 1.0e6;
}


double CalcDiskIOAv(void)
{
  double x;
  x =     ((1/(data.c[comp_disk].datalines[disk_avseek].value / 1.0e-3)) * 1.0e9 / 20.0) +
          (data.c[comp_disk].datalines[disk_busxfer].value * 1) +
          (data.c[comp_disk].datalines[disk_transf].value * 5);

  return (x + ( x / (data.c[comp_disk].datalines[disk_cpupct].value * 5) ) ) / 1.0e6;
}


double CalcFileIOAv(void)
{
  double x = 0;
  int linenum, i, j, k, l;

  for (i = 0; i <= 4; i++) /* for number of buffer sizes */
     {
     for (j = 0; j <= 1; j++) /* cached or not */
        {
        for (k = 0; k <= 1; k++) /* seq or random */
           {
           for (l = 0; l <= 1; l++) /* writing or reading */
              {
              linenum = (i * 8) + (j * 4) + (k * 2) + (l);
              x = x + (data.c[comp_file].datalines[linenum].value / KB);
              }
           }
        }
     }
  return (x / 40);   /* total divided by # of tests */
}


double dtime(void)
{
   return ((double)clock())/CLOCKS_PER_SEC;
/*
   ULONG value[QSV_MAX] = {0};
   APIRET rc = 0UL;

   rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, (PVOID)value, sizeof(ULONG));

   return((double)*value/CLOCKS_PER_SEC); */
}


double rtime(void)
{
   return ((double)clock())/CLOCKS_PER_SEC;
/*
   ULONG value[QSV_MAX] = {0};
   APIRET rc = 0UL;

   rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, (PVOID)value, sizeof(ULONG));

   return((double)*value); */
}


void logit(char* s)
{
  FILE* f;
  f = fopen("sb_error.log", "a+");
  if (!f)
     {
     exit(234);
     }
  fprintf(f, "%s\n", s);
  fclose(f);
}


static void EndBench(void)
{
  float size = GetSwapFileSize();

  if (startsize < size)
     {
     swapfilegrown++;
     if (size > maxswapfilesize)
        {
        maxswapfilesize = size;
        }
     }

  if (!mult)
     {
     PostFin(true);
     PostFin(false);
     _heapmin();        /* free off memory allocated by previous test */
     }
  else
     {
     PostFin(true);
     DosSleep(500); // wait for the window thread to update the screen
     _heapmin();        /* free off memory allocated by previous test */
     }
}

