/* diskacc2.c - direct disk access library for OS/2 2.x protected mode.
 *
 * Author:  Kai Uwe Rommel <rommel@ars.muc.de>
 * Created: Fri Jul 08 1994
 */

static char *rcsid =
"$Id: diskacc2.c,v 1.2 1995/12/31 21:50:58 rommel Exp $";
static char *rcsrev = "$Revision: 1.2 $";

/*
 * $Log: diskacc2.c,v $
 * Revision 1.2  1995/12/31 21:50:58  rommel
 * added physical/logical mode parameter
 *
 * Revision 1.1  1994/07/08 21:34:12  rommel
 * Initial revision
 * 
 */

#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_NOPM
#include <os2.h>
#include <string.h>
#include <ctype.h>

#include "diskacc2.h"

#define PHYSICAL     0x1000
#define CATEGORY(x)  (((x) & PHYSICAL) ? IOCTL_PHYSICALDISK : IOCTL_DISK)
#define HANDLE(x)    ((x) & ~PHYSICAL)

#pragma pack(1)

typedef struct
{
  BYTE   bCommand;
  USHORT usHead;
  USHORT usCylinder;
  USHORT usFirstSector;
  USHORT cSectors;
  struct
  {
    USHORT usSectorNumber;
    USHORT usSectorSize;
  }
  TrackTable[64];
}
TRACK;

ULONG DosDevIOCtl32(PVOID pData, ULONG cbData, PVOID pParms, ULONG cbParms,
		    ULONG usFunction, HFILE hDevice)
{
  ULONG ulParmLengthInOut = cbParms, ulDataLengthInOut = cbData;
  return DosDevIOCtl(HANDLE(hDevice), CATEGORY(hDevice), usFunction,
		     pParms, cbParms, &ulParmLengthInOut, 
		     pData, cbData, &ulDataLengthInOut);
}

static int test_sector(int handle, int side, int track, int sector)
{
  char buffer[1024];
  TRACK trk;

  trk.bCommand      = 0;
  trk.usHead        = side;
  trk.usCylinder    = track;
  trk.usFirstSector = 0;
  trk.cSectors      = 1;

  trk.TrackTable[0].usSectorNumber = sector;
  trk.TrackTable[0].usSectorSize   = 512;

  return DosDevIOCtl32(buffer, sizeof(buffer), &trk, sizeof(trk), 
		       DSK_READTRACK, handle) == 0;
}

int DskOpen(char *drv, int logical, int lock, 
	    unsigned *sides, unsigned *tracks, unsigned *sectors)
{
  BIOSPARAMETERBLOCK bpb;
  DEVICEPARAMETERBLOCK dpb;
  HFILE handle;
  USHORT physical;
  ULONG action;
  BYTE cmd = logical;

  if (isalpha(drv[0]) && drv[1] == ':' && drv[2] == 0)
  {
    if (DosOpen(drv, &handle, &action, 0L, FILE_NORMAL, FILE_OPEN,
		OPEN_FLAGS_DASD | OPEN_FLAGS_FAIL_ON_ERROR |
		OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE, 0L))
      return -1;
  }
  else if (drv[0] == '$' && isdigit(drv[1]) && drv[2] == ':' && drv[3] == 0)
  {
    if (DosPhysicalDisk(INFO_GETIOCTLHANDLE, &physical, sizeof(physical), 
			drv + 1, strlen(drv + 1) + 1))
      return -1;
    handle = physical | PHYSICAL;
  }
  else
    return -1;

  if (handle & PHYSICAL)
  {
    if (DosDevIOCtl32(&dpb, sizeof(dpb), &cmd, sizeof(cmd), 
		      DSK_GETDEVICEPARAMS, handle))
    {
      DosPhysicalDisk(INFO_FREEIOCTLHANDLE, NULL, 0, &physical, sizeof(physical));
      return -1;
    }

    *sectors = dpb.cSectorsPerTrack;
    *tracks  = dpb.cCylinders;
    *sides   = dpb.cHeads;
  }
  else
  {
    if (DosDevIOCtl32(&bpb, sizeof(bpb), &cmd, sizeof(cmd), 
		      DSK_GETDEVICEPARAMS, handle))
    {
      DosClose(handle);
      return -1;
    }

    *sectors = bpb.usSectorsPerTrack;
    *tracks  = bpb.cCylinders;
    *sides   = bpb.cHeads;
  }


  if (lock && DosDevIOCtl32(0L, 0, &cmd, sizeof(cmd), DSK_LOCKDRIVE, handle))
  {
    if (handle & PHYSICAL)
      DosPhysicalDisk(INFO_FREEIOCTLHANDLE, NULL, 0, &physical, sizeof(physical));
    else
      DosClose(handle);
    return -1;
  }

  if (*sectors >= 15) /* 360k floppies ... */
    if (!test_sector(handle, 0, 0, 15))
    {
      if (*sectors == 15)
        *tracks = 40;

      *sectors = 9;
    }

  return handle;
}

int DskClose(int handle)
{
  BYTE cmd = 0;
  USHORT physical = handle & ~PHYSICAL;

  DosDevIOCtl32(0L, 0, &cmd, sizeof(cmd), DSK_UNLOCKDRIVE, handle);

  if (handle & PHYSICAL)
    return DosPhysicalDisk(INFO_FREEIOCTLHANDLE, NULL, 0, 
			   &physical, sizeof(physical));
  else
    return DosClose(handle);
}

int DskRead(int handle, unsigned side, unsigned  track,
            unsigned sector, unsigned nsects, void *buf)
{
  TRACK trk;
  unsigned cnt;

  trk.bCommand      = 0;
  trk.usHead        = side;
  trk.usCylinder    = track;
  trk.usFirstSector = 0;
  trk.cSectors      = nsects;

  for (cnt = 0; cnt < nsects; cnt++)
  {
    trk.TrackTable[cnt].usSectorNumber = sector + cnt;
    trk.TrackTable[cnt].usSectorSize   = 512;
  }

  return DosDevIOCtl32(buf, nsects * 512, &trk, sizeof(trk), 
                       DSK_READTRACK, handle);
}

int DskWrite(int handle, unsigned side, unsigned  track,
             unsigned sector, unsigned nsects, void *buf)
{
  TRACK trk;
  unsigned cnt;

  trk.bCommand      = 0;
  trk.usHead        = side;
  trk.usCylinder    = track;
  trk.usFirstSector = 0;
  trk.cSectors      = nsects;

  for (cnt = 0; cnt < nsects; cnt++)
  {
    trk.TrackTable[cnt].usSectorNumber = sector + cnt;
    trk.TrackTable[cnt].usSectorSize   = 512;
  }

  return DosDevIOCtl32(buf, nsects * 512, &trk, sizeof(trk), 
                       DSK_WRITETRACK, handle);
}


/* end of diskacc2.c */
