/* Installation Script for PM Checksum */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

call SysCls

say "Please choose your language.       Bitte whlen Sie eine Sprache."
say "----------------------------       ------------------------------"
say " "
say "        E = English                          D = Deutsch"

language=""
do while \ ((language="D") | (language="E"))
  pull language
end

call SysCls

dest="C:\CHECKSUM"

if language="E" then
do
  say "Welcome to PM Checksum installation."
  say " "
  say "Please enter the destination directory (default: " dest ") "
end
else
do
  say "Willkommen bei der Installation von PM Checksum."
  say " "
  say "Bitte geben Sie das Zielverzeichnis ein (Standard: " dest ") "
end

pull dest
if dest="" then dest="C:\CHECKSUM"

say " "

if language="E" then
do
  say "PM Checksum will be installed in " dest
end
else
do
  say "PM Checksum wird in " dest " installiert"
end

say " "

interpret '"unrar.exe t -y checksum.rar >nul"'
if \rc=0 then signal broken

call SysMkDir dest
call SysFileDelete dest"\checksum.exe"
call SysFileDelete dest"\checksum.inf"
call SysFileDelete dest"\checksum.hlp"

if language="E" then
do
  interpret '"unrar.exe x -o+ -y checksum.rar check_e.* "dest ">nul"'
  interpret '"ren " dest"\check_e.exe checksum.exe >nul"'
  interpret '"ren " dest"\check_e.inf checksum.inf >nul"'
  interpret '"ren " dest"\check_e.hlp checksum.hlp >nul"'
end
else
do
  interpret '"unrar.exe x -o+ -y checksum.rar check_d.* " dest ">nul"'
  interpret '"ren " dest"\check_d.exe checksum.exe >nul"'
  interpret '"ren " dest"\check_d.inf checksum.inf >nul"'
  interpret '"ren " dest"\check_d.hlp checksum.hlp >nul"'
end

interpret '"unrar.exe x -o+ -y checksum.rar md5.dll " dest ">nul"'
interpret '"unrar.exe x -o+ -y checksum.rar chklist.exe " dest ">nul"'
interpret '"unrar.exe x -o+ -y checksum.rar *.prf " dest ">nul"'

call SysFileTree "CHECKSUM.EXP","dateiliste","OF","*****"
if dateiliste.0=1 then interpret '"copy checksum.exp " dest ">nul"'

/* Den Ordner anlegen */
klasse='WPFolder'
titel='PM Checksum'
ort='<WP_DESKTOP>'
param='OBJECTID=<PMC_ORDNER>;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='PM Checksum'
ort='<PMC_ORDNER>'
param='PROGTYPE=PM;EXENAME='dest'\CHECKSUM.EXE;STARTUPDIR='dest';ASSOCFILTER=*.PRF'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Hilfeobjekt anlegen */
klasse='WPProgram'
titel='PM Checksum Information'
ort='<PMC_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='dest';PARAMETERS='dest'\CHECKSUM.INF;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

klasse='WPDataFile'
param=''

/* Referenzen fr die Profildateien erzeugen */
call SysFileTree dest"\*.PRF","dateiliste","OF","*****"
do i=1 to dateiliste.0
  rc=SysCreateObject(klasse,dateiliste.i,ort,param,mode)
end

if language="E" then
do
  say " "
  say "PM Checksumm successfully installed!"
end
else
do
  say " "
  say "PM Checksum wurde erfolgreich installiert!"
end

exit

Fehler:
say " "
if language="E" then
do
  say "An error occured during install. Please try again."
end
else
do
  say "Bei der Installation ist ein Fehler aufgetreten."
  say "Bitte versuchen Sie es nochmal."
end

exit

broken:
say " "
if language="E" then
do
  say "The archive is broken. Please download again."
end
else
do
  say "Das Installationsarchiv ist leider beschdigt."
  say "Bitte besorgen Sie sich eine intakte Version."
end

exit

