.imd PC2.h
:userdoc.
:title.PC/2 Help Program
:body.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help with F1, the mouse, the smarticon or the keyboard.            *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_HELP..PC/2 Help for Help
:lines align=center.
:color fc=red.
PC/2 - Program Commander/2 Version 1.90
for IBM OS/2 2.x, 3.x Presentation Manager
Copyright (C) by Roman Stangl May, 1995
:color fc=default.
:elines.
:p.Please select one of the following topics for further information:
:ul compact.
:li.:link reftype=hd res=&ID_ABOUTDIALOG..About the utility PC/2:elink.
:li.:link reftype=hd res=&ID_INSTALLATIONHELP..Installing PC/2:elink.
:li.:link reftype=hd res=&ID_GENERALHELP..Using PC/2 as a WPS addon:elink.
:li.:link reftype=hd res=&ID_CONCEPTSHELP..Concepts of the Popup Menu:elink.
:li.:link reftype=hd res=&ID_USINGHELP..Starting a Program from PC/2:elink.
:li.:link reftype=hd res=&ID_CONFIGDIALOG..Setting up the Popup Menu:elink.
:ul compact.
:li.:link reftype=hd res=&MIID_MENUDIALOG..Adding a Submenu:elink.
:li.:link reftype=hd res=&PIID_PROGRAMDIALOG..Adding a Program:elink.
:li.:link reftype=hd res=&MDID_CONTROLDIALOG..Adding Popup Menu controls:elink.
:li.:link reftype=hd res=&RDID_RESORTDIALOG..Resorting a (Sub)menu:elink.
:li.:link reftype=hd res=&SUID_STARTUPDIALOG..Runtime parameters:elink.
:eul.
:li.:link reftype=hd res=&ID_DESKTOPDIALOG..Setting up the Desktop:elink.
:li.:link reftype=hd res=&ID_OVERVIEWHELP..PC/2's Desktop Overview Window:elink.
:li.:link reftype=hd res=&ID_PC2SPOOLERWINDOW..PC/2's Spooler Control window:elink.
:li.:link reftype=hd res=&ID_COMPATIBILITY..PC/2's compatibility to other applications:elink.
:li.:link reftype=hd res=&ID_ERRORHELP..Error Messages:elink.
:li.:link reftype=hd res=&ID_FAQ..Questions &amp. Answers:elink.
:eul.
:note.
PC/2 contains :hp8."WPS 2 PC/2":ehp8. WorkPlace Shelll migration tool in its package.
For further information about WPS 2 PC/2 select :hp9.Help:ehp9. from
the WPS Object WPS 2 PC/2 itself.
WPS 2 PC/2 is installed on your Desktop during installation of the
PC/2 package.

:p.:link reftype=hd res=&ID_HELP..<Backward>:elink.
                                :link reftype=hd res=&ID_ABOUTDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the About PC/2 dialog box.                               *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_ABOUTDIALOG..Help for About PC/2
:lines align=center.
:color fc=red.
PC/2 - Program Commander/2 Version 1.90
for IBM OS/2 2.x, 3.x Presentation Manager
Copyright (C) by Roman Stangl Roman May, 1995
:color fc=default.
:elines.
:p.E-Mail:
:ul.
:li.InterNet: rstangl@vnet.ibm.com
:li.IBM VNET: 61821799 at VIEVMA
:li.FidoNet: Roman Stangl @ 2&colon.310/14 LA BAMBA BBS Tel.: (Int. Code +43 +1 +6156811)
:li.FidoNet: Roman Stangl @ IBM Austria National Support BBS Tel.: (Int. Code +43 +1 +21145-6600)
:eul.
:p.The PC/2 package (consisting of the OS/2 PM application PC/2 and
the WPS program Object WPS 2 PC/2) is classified as Freeware.
Under the copyright, you are allowed and encouraged to freely use, distribute or modify
this program under the following conditions:
:ul compact.
:li.The complete source code and all executables must be included. This rule also applies
for any modifications/recompilitions you've made.
Just drop me a short note descibing the changes.
:li.You may only charge for the costs of duplicating. :hp4.Distribution on InterNet, FidoNet
or similar is preferred.:ehp4. Therefore, this program must not be sold by immoral "Public
Domain &amp. ShareWare" dealers that charge a price way over the actual duplication costs.
:li.:hp4.Any:ehp4. commercial use is prohibited without contacting me beforehand, except
for incorporating the concept or code in any future release of OS/2 by IBM.  This however this
clause doesn't apply to individual private use.
:li.You don't want to port this utility to MS Windows, Windows NT (Nice Try), or
Windows96 (or whatever "Chicago" will be called when it is ready)
:eul.
:p.You are encouraged to upload this utility to your favorite file-server or
BBS. Please dooublecheck that no file from this archive is missing, if you
change the archive to a different compression scheme.
Please retain the same name, regardless of the compression method you use.
PC/'2 archive is named PC2vxyy.ZIP, where x is the major and yy the minor version,
e.g. 190 for version 1.90 (PC2v190.ZIP).
:p.If you find this program useful and want to honor many weeks of work writing
this utility, you are welcome to send me a small fee of about 50 to 150 Austrian
Schillings (about 5 to 15 dollars) to my home address. Of course you don't need
to pay again, when a new release of PC/2 comes out.
Please send any donations in cash - it is a lot of trouble to work with foreign
money orders or equivalent, here in Austria, plus the banks charge an arm and a leg!
:p.Suggestions are welcome.
Because of the Freeware status of PC/2 I am :hp4.not:ehp4. going to send new
versions or anything else by mail (which is likely to become a never ending story),
however I try to do my best to do support via E-Mail.  As my time is limited, contributors'
get priority treatment.
:p.Thanks to all those people who sent me proposals and bug reports to improve this
utility!
Special thanks to Mario Semo, Carrick von Schoultz and Markus Hof, Roman Fischer,
Alex Stewart, Ingo Pflanz, Rolf Knebel, Michael Wakunda, Stefan Hora,
Monte Copeland, Roland Emmerich and Joe Hartman (thanks Joe, without your
support, PC/2 and its documentation would not have experienced such a quality improvement)
who gave me advice, source code,
valuable hints, or other support to improve PC/2
:p.Also, thanks to anyone who makes "undocumented" information available, too!
:p.My home address is:
:sl compact.
:li.    Roman Stangl
:li.    Strebersdorferstrasse 46
:li.    A-2103  Langenzersdorf, Austria
:esl.
:p.:link reftype=hd res=&ID_HELP..<Backward>:elink.
                                :link reftype=hd res=&ID_INSTALLATIONHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for PC/2 installation.                                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_INSTALLATIONHELP..Installing PC/2
:p.You have obviously started PC/2 once, because you are reading this help panel.
The installation is straight forward, with a REXX script that installs PC/2.
However here are some points to take note of:
:ul.
:li.The installation installs an icon on the Desktop and starts the help panels
of PC/2. To ensure that OS/2 starts PC/2 automatically the next time you boot your
system, you must start PC/2 again (you then can notice that the background behind
the icon changes).
:p.If you have added :hp4.SET RESTARTOBJECTS=STARTUPFOLDERSONLY:ehp4.
in your :hp9.CONFIG.SYS:ehp9. then you :hp2.must:ehp2. add a shadow of PC/2
to your startup folder to ensure PC/2 is started the next time you boot OS/2.
:li.PC/2 requires access to the :hp4.PC2HOOK.DLL:ehp4. and :hp4.PC2SPOOL.DLL:ehp4. files.
PC/2 tries to find these files either in the current directory
when the :hp4.LIBPATH:ehp4. environment variable contains :hp4..;:ehp4., or in a path
that is included in the :hp4.LIBPATH:ehp4. environment variable.
:p.PC/2 will
not be able to run if :hp4.PC2HOOK.DLL:ehp4. can't be loaded, and won't be
able to provide the PC/2 Spooler Control Window, if :hp4.PC2SPOOL.DLL:ehp4. can't
be loaded.
:p.The file :hp4.PC2.HLP:ehp4. may be either accessible in the directory,
where PC/2 is started from, or in a path that is included in the environment
variable :hp4.HELP:ehp4..
:p. If you have problems running PC/2, ensure
that the working directory of PC/2 is accessible by these variables
in your :hp9.CONFIG.SYS:ehp9..
:li.The installation program assumes that you are using the default profile :hp9.PC2.CFG:ehp9.
containing a standard pre-defined Popup Menu. If you want to use another Popup Menu,
you have to restart PC/2 and add your preferred profile as a commandline option.
Click to the next help panel to get more information about commandline parameters.
You may also use your favorite editor to import one profile into another, but
you have to ensure that you don't violate the syntax rules of the profile.
:li.PC/2 looks for its initialization file, :hp9.PC2.INI:ehp9. in the directory
where PC/2 was started from.
:li.You can only run one copy of PC/2 concurrently.
:li.If you select a DOS or WIN-OS2 Program to be started via PC/2, the time-slice of their
sessions is optimized (the DOS-Settings are modified to
:hp4.IDLE_SECONDS=5 IDLE_SENSITIVITY=100:ehp4.) to get better performance.
This is useful for most DOS games.
:li.You may :hp2.use PC/2 with or without the WPS installed:ehp2.,
:hp2.you may even use PC/2 as
a replacement for the WPS:ehp2.. To do so, you must install PC/2 first. Then you have
to ensure that :hp4.PC2HOOK.DLL:ehp4. and :hp4.PC2SPOOL.DLL:ehp4. are accessible by PC/2.
You also have to ensure that :hp4.PC2.HLP:ehp4. is accessible in the PC/2 directory, or
in a path pointed to by the :hp4.HELP:ehp4. environment
variable in your :hp9.CONFIG.SYS:ehp9. file. Then replace the statement
:p.:hp4.SET RUNWORKPLACE=C&colon.\OS2\PMSHELL.EXE:ehp4. with
:p.:hp4.SET RUNWORKPLACE=[path]PC2.EXE:ehp4. or
:p.:hp4.SET RUNWORKPLACE=[directory]PC2.EXE:ehp4.
:p.where where :hp4.[path]:ehp4. is the full pathname of the directory (including
the drive letter, e.g. C&colon.\PMAPPS\PC2\PC2.EXE) and :hp4.[directory]:ehp4. is the
pathname of the directory (excluding the drive letter, e.g. \PMAPPS\PC2\PC2.EXE)
you installed PC/2.
:warning.
If you specify only the directory you installed PC/2 into, then be sure that this
directory is found on your boot drive.
:ewarning.
This feature is useful when using PC/2 as the shell process for an OS/2 maintenance
setup created by :hp4.BOOTOS2:ehp4..
See the :link reftype=hd res=&ID_COMPATIBILITY..compatibility section :elink.
for more information.
:p.The next time you boot, PC/2 will be started as a replacement for the WPS.
Be careful, OS/2 seems to dislike any parameters added to the program
started as a replacement for the WPS!
Of course, you can start the WPS from a command prompt by typing
:hp4.START PMSHELL:ehp4. or add a corresponding entry to PC/2.
:p.:warning.
When running PC/2 as the Workplace Shell process, you can't terminate
PC/2, because the WPS process should not terminate, neither by closing
PC/2 from the Window List, nor by closing it from the :hp9.Exit:ehp9.
smarticon or the :hp9.Exit OS/2:ehp9. menuentry.
Any WPS process will automatically be restarted by OS/2 immediately following its
termination (you may notice this fact when the WPS traps, it will restart
immediately, and rebuild your desktop).
:warning.:hp4.PC/2 has not been tested on all OS/2 versions or installed software
and hardware :ehp4.(simply because I don't have them):hp4., so there is no guarantee
of PC/2 being bugfree!:ehp4..
:eul.
:p.:link reftype=hd res=&ID_ABOUTDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_GENERALHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected general help from the PC/2 main help panel.                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_GENERALHELP..General Help for PC/2
:p.PC/2 - Program Commander is an addon or replacement for the WPS (Workplace Shell).
The user can configure a Popup Menu that will appear when mouse button 1 is clicked
anywhere on the Desktop. From this freely configurable Popup Menu, you can select
an entry - which is launched immediately.
:p.PC/2 lets you define Hotkeys too. Pressing the Hotkey defined for a program the
program is switched into the foreground or, if it is not already running, launched
immediately.
:p.PC/2 also allows you to expand the Desktop up to an 81-fold Virtual
Desktop, you may define Hotkeys to switch to an application on any Virtual Desktop
by a simple keypress.
:p.You may also switch to any Virtual Desktop directly by doubleclicking with mouse
button 1 on PC/2's Overview Window.
:p.PC/2 also enables you to define a UNIX-style behavior of switching the input focus
from one window to another. This allows you to have the input focus in a window which
is not the topmost window. (Sounds complicated, but try it; you'll like it!)
:p.PC/2 additionally provides a simple Spooler interface. You can manage the printer
queues and jobs on your local machine - a necessity when using PC/2 as a WPS
replacement (because without the WPS you have no spooler available unless you use
PC/2's spooler interface).
:p.PC/2 allows you to customize the fonts used by the Popup Menu, the Overview
Window and the Spooler window, just by dragging fonts from the Font Palette to
PC/2.
:p.:hp2.Warning:ehp2.! On some display drivers you may not be able to set up every font
lable in the Font Palette exactly. Instead, you may just get a similar font.
:p.For example. the Popup Menu might look like:
:artwork name='Pc2ipc01.bmp' align=left.
:p.You have selected the item :hp4.Prompts:ehp4., which is a Submenu containing
seven more items. E.g., the item :hp4.OS/2 Window:ehp4. starts a windowed OS/2
command prompt, when selected. This Popup Menu is fully configurable - you may add,
change or remove items. An item can either be a Submenu containing more items,
the name of a program, or a Menu Control.
:p.The complete Popup Menu can be modified, but the Menu Control :hp9.Desktop Menu:ehp9.
must be defined before the Popup Menu will be displayed after mouse button 1 clicks.
If you have not defined this Menu Control, the :hp9.Setup:ehp9. dialog appears after
mouse button 1 clicks enabling you to add this control.
:p.Your configuration is read from the default profile :hp9.PC2.CFG:ehp9. each time
PC/2 is started and saved every time you :hp9.save:ehp9. your changes.
You can of course overwrite the default
configuration filename to a file named :hp4.Filename.ext:ehp4. by invoking PC/2 with
the following commandline option:
:p.:hp4.PC2 [-Profile Filename.ext]:ehp4. or
:p.:hp4.PC2 [/Profile Filename.ext]:ehp4.
:p.where :hp4.Filename.ext:ehp4. conforms to a filename of a PC/2 profile. Both FAT
and HPFS filename naming conventions are accepted. A few
sample configuration files are provided in this package.
:p.As the default, the Popup Menu appears if you double-click once on the Desktop,
if no option, or the following option is specified:
:p.:hp4.PC2 [-DoubleClick]:ehp4. or
:p.:hp4.PC2 [/DoubleClick]:ehp4.
:p.You may select a single-click instead, by invoking PC/2 with the following
commandline option:
:p.:hp4.PC2 [-SingleClick]:ehp4. or
:p.:hp4.PC2 [/SingleClick]:ehp4.
:p.Please be sure not to combine both click behavior options.
If you don't specify this option, a user-modifiable default behavior is taken
from :hp9.PC2.INI:ehp9..
Of course the options changing the click behavior and the configuration
filename options may be combined.
:p.You may disable that PC/2 automatically starts the sessions having
the style :hp9.Autostart:ehp9., but PC/2 does preserve this style in
the configuration file save.
This may prove useful when customizing the Popup Menu.
To disable the :hp9.Autostart:ehp9. style, invoke PC/2 with the following
commandline option:
:p.:hp4.PC2 [-NoAutostart]:ehp4. or
:p.:hp4.PC2 [/NoAutostart]:ehp4.
:p.You may also select the behavior to ignore the :hp9.Autostart:ehp9. style, by
selection of the :hp9.Ignore Autostart:ehp9. checkbox on the
:link reftype=hd res=&DDID_PAGE1..Virtual Desktop Settings:elink. dialog.
:p.Because some people use PC/2 as a WPS replacement, PC/2 contains a
Menuitem to ShutDown OS/2. By selecting this entry, it is safe to power off your PS/2 or
PC after all disk activity has been stopped, although no windows are closed.
If you run PC/2 as a WPS replacement, you may want to start the WPS either by
starting :hp4.PMSHELL.EXE:ehp4. from a command prompt or by starting a
:hp4.PMSHELL:ehp4. Menuitem with PC/2.
You then can follow the WPS initialization by heavy disk access and
buildup of your Desktop with objects.
PC/2 requires to "see" the Desktop (in technical terms the window handle
of the Desktop) to be able to catch mouse button 1 clicks. If you start
the WPS, the Desktop also undergoes changes too. Therefore, PC/2 checks regularly if the
Desktop has changed, so you may have to wait a little bit
after the WPS was started, before PC/2 recognizes mouse clicks again..
:p.I would strongly recommend starting PC/2 during OS/2 boot. If you don't
want to use the default profile, don't forget to add :hp4./Profile Filename.exe:ehp4.
to the :hp4.Parameters:ehp4. entryfield in the Settings of PC/2.
:p.The reason why I wrote this utility was primarily that many programs
installed on a system require many folders and icons on the Desktop. But to
start a program, I don't want to open and close folders, so I made shadows on
the Desktop messing it up, and adding overhead, thereby slowing things down.
:p.Using PC/2 as a WPS replacement, you will get:
:ul compact.
:li.a remarkable performance increase and boot time decrease, especially on systems
equipped with less than 8 MB memory,
:li.improved overall system performance and response times due to less
swapping.
:li.the ability to run multimedia or network software with acceptable
performance, even with 8 MB or less,
:li.or the ability to create a maintainance partition (for example by using
:link reftype=hd res=&ID_COMPATIBILITY..BOOTOS2:elink.) without losing immediate
access to your favorite programs.
:eul.
:p.The solution I prefer, is to click on the Desktop - this gives me an
immediate menu, from which I can easily select an application to be launched from
this menu, or alternatively launch (or switch) to an application by simply pressing
a Hotkey.
So PC/2 will help you to start your programs more quickly, without needing to open
and close folders, and all the overhead of the WPS. Of course, to gain this speed, and
and overhead savings, you lose some of the "niceties" of the WPS, for instance, you can't
start applications from icons.
:p.:link reftype=hd res=&ID_INSTALLATIONHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_CONCEPTSHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected concepts from the PC/2 main help panel.                            *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_CONCEPTSHELP..Concepts of PC/2
:p.The basic idea behind PC/2 is to have a configurable Popup Menu available
to start programs quickly, without having to open and close folders.
:p.The Popup Menu, popped up when you click with mouse button 1 anywhere on
the Desktop (just like button 2 for the Desktop Menu), consists of :hp4.menu items:ehp4.
(sometimes called :hp4.menuentries:ehp4.).
An item may be a Submenu, which contains further items, or the title of
an Application, or Menu Control items. A Submenu contains of a little arrow right
beside the title of the Submenu. (Mouse button 1 is on most systems the left
mouse button.)
:p.To change the font of the Popup Menu, drag a font from the Font Palette to
the smarticon bar of PC/2's Overview Window. This font will be saved when you
exit PC/2.
:p.You can imagine this Popup Menu as a tree, with Submenus as branches,
and applications as leaves on
a particular branch. PC/2 allows you to freely build your own tree. To do so
you have to click on the Desktop with the left mouse button and select
:hp4.Setup&rarrow.Config Menu:ehp4. from the Popup Menu. A dialog box appears, where you
can add, modify or remove Submenus and Applications. The listbox displays all
Submenus and Applications of one level (like a cut through the tree). Of
course you may change this level up and down.
:p.Note: You must have defined the Menu :hp4.Configure Menu:ehp4. before PC/2 will display
its Popup Menu on mouse button 1 clicks. If you don't define it, PC/2
displays its Setup dialog after each click until you have added this control.
:p.:link reftype=hd res=&ID_GENERALHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_USINGHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for starting a program from PC/2.                             *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_USINGHELP..Help for starting a program via PC/2
:p.After you have configured the PC/2 Popup Menu, you click on the Desktop
with mouse button 1, select the Application you want to start and click on it.
The Application will be started as if you were clicking on an icon.
:p.One advantage starting an Application this way is that you can manipulate
many startup parameters governing how the Application is started.  This is one thing you can't do with
many icons. E.g., you can start it invisibly (useful for a backup program), and making
it only visible by selecting it from the window list. You may also specify the size
of the Application or that you want to start it in the background. You can even set its priority
or define a Hotkey to switch to it.
:p.You can also start WPS Objects that are not Folder (WPFolder class) or Program
(WPProgram class) type WPS Objects, if they have an ObjectID defined.
Most OS/2 WPS Objects get installed with a predefined ObjectID by default during
installation (see :hp4.OS2_20.RC:ehp4. for a more detailed information), and many
applications (e.g. IBM C Set++, Toolkit, ...) defined an ObjectID for their WPS
Objects too.
:p.Folder or Program WPS Objects and other WPS Objects that have a defined
ObjectID can be dumped automatically by WPS 2 PC/2, to create corresponding
Popup Menu entries.
:p.You can also open any WPS Folder by PC/2 after dragging the folder onto PC/2
to create a corresponding menuentry.
:warning.
You can start WPS Objects via their ObjectID and open folders only if the WPS is running,
because only the WPS can process the request made by PC/2 to open them.
:ewarning.
:p.To close an Application, select the corresponding option from the Application
or terminate it from the Window List.
Alternatively, you may use PC/2's :hp9.Kill:ehp9. smarticon to close the application's window.
:p.:link reftype=hd res=&ID_CONCEPTSHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_CONFIGDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Configuration/Setup PC/2 dialog box.                 *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_CONFIGDIALOG..Help for PC/2 Setup
:p.In the listbox, all Submenus and Applications of one level (imagine a cut
through the tree) are displayed. A Submenu has an arrow right beside it.
:p. For instance, assume
the listbox contains 6 Submenus and 2 Applications resulting in the following Popup Menu:
:artwork name='Pc2ipc02.bmp' align=left.
:p.Select the item :hp4.Config Menu:ehp4. to configure the items appearing in the
Popup Menu. The :hp9.Setup:ehp9. dialog appears, allowing you to adjust all items of
the current level.
:p.You may want to get into the Submenu :hp4.Prompts:ehp4.. Just select the Submenu
:hp4.Prompts:ehp4. and click on the button :hp4.Level Down >>:ehp4.. The listbox
will now be filled with all Submenus and Applications of the Submenu :hp4.Prompts:ehp4..
To get one level up, simply press :hp4.<< Level Up:ehp4.. If nothing seems to
change, you may be either at the highest level (the root of the tree) or at
the deepest level (a leaf of the tree) of a Submenu.
:p.To configure the Popup Menu, just select an item and/or invoke functions by
selecting the following pushbuttons..
:dl tsize=12 break=fit.
:dthd.:hp4.Pushbutton&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Level Down:ehp9.
:dd.After selecting a Submenu, click on :hp9.Level Down:ehp9.. The listbox contents
are replaced with the Menuentries of the Submenu.
:p.You may alternatively doubleclick on a Submenu to change to.
:dt.:hp9.Level Up:ehp9.
:dd.Selecting :hp9.Level Up:ehp9. chains up into the next upper Submenu level, unless
the root level is reached.
:dt.:hp9.Add Submenu:ehp9.
:dd.To add a Submenu, press the button :hp9.Add Submenu:ehp9..
The :hp4.Menu Installation:ehp4. dialog is displayed, allowing you to add a new
Submenu. After pressing :hp4.Ok:ehp4. in that dialog, the Submenu
will be inserted either :hp4.after:ehp4. the selected item, or at
the end of the list, if no item was selected.
:dt.:hp9.Add Program:ehp9.
:dd.To add an application, press the button :hp9.Add Program:ehp9..
The :hp4.Program Installation:ehp4. dialog is displayed, allowing you to add a new
Application. After pressing :hp4.Ok:ehp4. in that dialog, the
Application will be inserted :hp2.after:ehp2. the selected item, or at
the end of the list, if no item was selected.
:dt.:hp9.Add Control:ehp9.
:dd.To add a Control press the button :hp4.Add Control:ehp4., and a dialog
appears, allowing you to add Menu Controls predefined by PC/2.
:dt.:hp9.Change Entry:ehp9.
:dd.To change a Menuentry that corresponds to an executable application, select
the application and then invoke :hp9.Change Entry:ehp9. to display the
:hp4.Program Installation:ehp4. dialog.
:p.Alternatively, you may just doubleclick on a Menuentry to display the
:hp4.Program Installation:ehp4. dialog.
:dt.:hp9.Remove Entry:ehp9.
:dd.,To remove an application or an empty Submenu, select the Menuitem and click
on the button :hp9.Remove Entry:ehp9..
:dt.:hp9.Resort Menu:ehp9.
:dd.To resort a Submenu press the button :hp4.Resort Menu:ehp4..
A new dialog is displayed allowing you to resort the currently listed Submenu.
Press here to get more information about the
:link reftype=hd res=&RDID_RESORTDIALOG..Resort:elink. dialog.
:edl.
:p.If the listbox is empty, you can't remove or change anything. You also can't
select any item, but in this case, you can add a Submenu or an Application by
just pressing the buttons, without needing to select an item.
:dl tsize=12 break=fit.
:dt.:artwork name='Wps2Pc2.bmp' runin align=left.(WPS 2 PC/2's icon)
:dd.By using the listbox on this dialog page together with WPS 2 PC/2, you can
easily convert WPS Objects into menuitems for PC/2's Popup Menu.
Assuming that you have extracted details about WPS Objects by dropping them
onto WPS 2 PC/2's icon on the Desktop, just drag them from WPS 2 PC/2's
:hp9.Status:ehp9. bitmap and drop it onto the :hp9.Submenu/Program Configuration:ehp9.
listbox.
PC/2 then generates Popup Menu items automatically and adds them to your Popup Menu.
This lets you copy the settings of WPS Objects easily, without entering them
manually.
:p.For more information about WPS 2 PC/2 just select help from the
WPS 2 PC/2 WPS Object, which you can install by PC/2's
installation program, if it is missing.
:edl.
:p.Once you have configured your tree of Submenus and Applications, just press
:hp4.Save:ehp4. to bring them into effect and save them to the profile, :hp2.or:ehp2.
:hp4.Cancel:ehp4. to make them temporarily effective, but without saving them
to the profile on disk.
:p.:link reftype=hd res=&CDID_HELP_1..Example 1:elink.
     :link reftype=hd res=&CDID_HELP_2..Example 2:elink.
:p.:link reftype=hd res=&ID_CONCEPTSHELP..<Backward>:elink.
                                :link reftype=hd res=&MIID_MENUDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected example 1 from the Setup PC/2 help.                                *
.*--------------------------------------------------------------------------------------*

:h2 res=&CDID_HELP_1..Setup example 1
:p.Assume the listbox contains the following items resulting in the following Popup Menu:
:artwork name='Pc2ipc03.bmp' align=left.
:p.You want to remove the Submenu :hp4.References:ehp4., rename the Submenu
:hp4.Tools:ehp4. to :hp4.Utilities:ehp4. and add a Submenu :hp4.Demos:ehp4..
:ol compact.
:li.Select the item :hp4.References:ehp4.. You can now press the button
:hp4.Remove Entry:ehp4. to remove the submenu, but only if this Submenu is empty.
If it isn't empty, get into this Submenu by pressing :hp4.Level Down >>:ehp4.
and remove all items.
:li.To rename :hp4.Tools:ehp4. to :hp4.Utilities:ehp4. select the item
:hp4.Tools:ehp4. and press the button :hp4.Change Entry:ehp4.. A dialog box
appears allowing you to rename this item.
:li.Select the item, after which you want to insert the new Submenu. Then press
the button :hp4.Add Submenu:ehp4. to add one. A dialog box appears allowing you
to enter the title of a new Submenu.
:eol.

.*--------------------------------------------------------------------------------------*
.* The user selected example 2 from the Setup PC/2 help.                                *
.*--------------------------------------------------------------------------------------*

:h2 res=&CDID_HELP_2..Setup example 2
:p.Assume that you have remove all items, leading to an empty listbox. Now
you want to add the Applications :hp4.Backup:ehp4. and :hp4.Terminal:ehp4..
:ol compact.
:li.The listbox is empty, so you can't select any item. Just press the
button :hp4.Add Program:ehp4. and a dialog box appears, allowing you to
enter all the data required for the new Application.
:li.Now the listbox contains the item :hp4.Backup:ehp4., select it and
press the button :hp4.Add Program:ehp4. a second time. Again you get
a dialog box, where you enter the data for the Application :hp4.Terminal:ehp4..
:eol.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Menu installation PC/2 dialog box.                   *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&MIID_MENUDIALOG..Help for PC/2 Menu Installation
:p.This dialog is used to get a name for a Submenu, which is then added to the
Popup Menu. You can enter whatever you like, e.g to make a Submenu that contains
OS/2 utilities you might enter :hp4.Utilities:ehp4..
:p.If you have chosen in the previous dialog to change the name of a Submenu, then
overwrite the pre-entered text.
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered.
:p.:link reftype=hd res=&MIID_HELP_1..Examples:elink.
:p.:link reftype=hd res=&ID_CONFIGDIALOG..<Backward>:elink.
                                :link reftype=hd res=&PIID_PROGRAMDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected examples from the Menu installation PC/2 help.                     *
.*--------------------------------------------------------------------------------------*

:h2 res=&MIID_HELP_1..Menu installation examples
:p.Assume you have entered the following Submenu Titles:
:dl tsize=12 break=fit.
:dthd.:hp4.Title&colon.
:ddhd.Purpose&colon.:ehp4.
:dt.Prompts
:dd.You want to add a Submenu named :hp4.Prompts:ehp4., that contains OS/2 and DOS
fullscreen and windowed command prompts.
:dt.Spreadsheets
:dd.You want to add a Submenu named :hp4.Spreadsheets:ehp4. for your spreadsheet
programs, such as Lotus 123/G or Excel.
:edl.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation PC/2 dialog box.                *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&PIID_PROGRAMDIALOG..Help for PC/2 Program Installation
:p.This dialog is a notebook consisting of the following pages:

:dl tsize=12 break=fit.
:dthd.:hp4.Page&colon.
:ddhd.Tab title&colon.:ehp4.
:dt.:hp9.Application:ehp9.
:dd.This page is used to define an application's title, path, filename,
working directory, command-line parameters and DOS settings.
:dt.:hp9.Session:ehp9.
:dd.This page determines the type of session you want to add. Select
between PM, OS/2, DOS and WIN-OS2 sessions.
:dt.:hp9.Style:ehp9.
:dd.This page can be used to define the appearance of an application. If the
application doesn't overwrite attributes, you may define the style, size and
position.
:dt.:hp9.Hotkey:ehp9.
:dd.This page is used to define a Hotkey which will switch to the application
and bring it into the foreground.
:warning.
If you don't have filled in the :hp9.Window Name:ehp9. entryfield correctly
on this notebook page, you will not be able to use PC/2 features successfully,
including Hotkeys, specifying the sessions startup position or keeping the
session on the active Desktop.
I strongly recommend to read the online help, including the Frequently
asked chapter, carefully.
:ewarning.
:dt.:hp9.Priority:ehp9.
:dd.This page can be used to overwrite the default priority assigned to an
application.
:warning text='Caution:'.Changing the priority may cause serious problems, because
the application may be set to consume the full CPU!
:ewarning.
:dt.:hp9.Environment:ehp9.
:dd.This page is used to add environment variables to, or to replace the
environment inherited from PC/2 to the application started from
PC/2's Popup Menu.
:edl.
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered in all notebook pages.
:p.For more information about one of the above notebook pages, select:
:ul compact.
:li.:link reftype=hd res=&PIID_PAGE1..Application Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE2..Session Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE3..Style Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE4..Hotkey Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE5..Priority Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE6..Environment Settings:elink.
:eul.
:p.:link reftype=hd res=&PIID_EXAMPLE1..Example 1:elink.
:p.:link reftype=hd res=&MIID_MENUDIALOG..<Backward>:elink.
                                :link reftype=hd res=&MDID_CONTROLDIALOG..<Forward>:elink.


.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Application notebook page.      *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE1..Application Settings
:p.This dialog is used to get the title, the path and filename, the working
directory and parameters of a Menuitem, which is then added to the Popup Menu.
:p.For a normal user it is the easiest way to use the following guidelines.
According to the type of application you add, some fields may not be editable
or visible:
:dl tsize=12 break=fit.
:dthd.:hp4.Fieldname&colon.
:ddhd.You would enter&colon.:ehp4.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.Here you enter the name which should appear on the applications's titlebar,
which may be overwritten by some applications.
For OS/2 and DOS windows, this will also be the title in the window list.
You may also name the Objects here, you want to add.
:p.For better navigation through the Popup Menu, you may add a tilde (~).
When a menuentry has a tilde before a letter, the letter is treated as a
mnemonic. After activating the Popup Menu, you can type a mnemonic defined
for a session to start it, instead of selecting it with the mouse or
keyboard.
:p.When defining a mnemonic, ensure that the entryfield :hp9.Window Name:ehp9.
on the :link reftype=hd res=&PIID_PAGE4..:hp4.Hotkey Settings:ehp4.:elink.
page is filled in correctly.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.Here you enter the fully qualified path and filename. E.g., you might enter
:hp4.c&colon.\os2\cmd.exe:ehp4. to obtain an OS/2 command prompt, or
:hp4.c&colon.\os2\mdos\qbasic.exe:ehp4. to start the basic interpreter.
:p.If the executable is located in the path specified in the
:hp9.Working Directory:ehp9. entryfield, you may supply the executable's name
excluding path information.
:p.Here you also enter the name of WPS Objects.
WPS Objects are referred either by their defined Object ID (Identity) e.g
:hp4.<WP_DRIVES>:ehp4. or :hp4.<WP_INST>:ehp4. for preinstalled Objects,
of e.g. :hp4.<WP_USER_CALC>:ehp4. or :hp4.<WP_WIN_PBRUSH>:ehp4. which
can be extracted by the WPS 2 PC/2 WPS Object, unless they
represent Folder or Program objects (then their settings are taken instead
of their ObjectID, which may be available too).
Preinstalled WPS Objects usually have a defined name; you may need to take a
look into the file :hp4.OS2_20.RC:ehp4. to get further information.
:p.PC/2 can only launch WPS Objects named by their defined ID, so be careful
to get either the correct ID from :hp4.OS2_20.RC:ehp4. or by extracting the
WPS Object in question by using WPS 2 PC/2.
You can't use the Program Template to create Objects if you want them to
add to PC/2, because PC/2 can't define the Object ID of such Objects,
so try to use any installation routine that probably creates a Program object
with an ObjectID.
:p.Here you would also enter the path and filename of a seamless WIN-OS2
application. WIN-OS2 applications prefixed by a :hp4.!:ehp4. (exclamation mark)
immediately before the filename get started minimized, applications
prefixed by a :hp4.^:ehp4. (caret) get started maximized. 
To start more than one application, separate applications by a
:hp4.,:ehp4. (comma). (By the way, this is a feature of OS/2 and should be therefore
also available for your WIN-OS2 WPS Objects!)
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.Here you enter the directory where the EXE, HLP and DLL files of your
application are located. Before the application is started, a change drive
and change directory call is made to make this directory the working directory.
:dt.:hp9.Parameters&colon.:ehp9.
:dd.Here you enter the parameters passed to the application. PC/2 allows you
to be asked for commandline parameters before the application is invoked.
Press on :link reftype=hd res=&SUID_STARTUPDIALOG..Commandline Parameters:elink.
to find out more about this feature. Assume that you want
to use VIEW.EXE to view the command reference.  You would enter:
:p.:hp4.c&colon.\os2\book\cmdref.inf:ehp4..
:p.If you have selected the WIN-OS2 Program Manager :hp4.PROGMAN.EXE:ehp4.
to be started as a seamless WIN-OS2 application, you may enter 1 and only
1 additional WIN-OS2 application.  This application will be started by the Program
Manager in the same WIN-OS2 session. The Program Manager itself will be
started minimized. You may also change the application's style by using
:hp4.!:ehp4., :hp4.^:ehp4. and :hp4.,:ehp4. characters as described in
:hp9.Path and Filename:ehp9..
:dt.:hp9.DOS Settings&colon.:ehp9.
:dd.Selecting this pushbutton opens the standard OS/2 DOS settings dialog
(OS/2 DOS support must be installed of course). You can then customize the
DOS settings exactly as you would do with a WPS program Object. The settings
are then set into the multiline entryfield. You can of course write them by
hand, but this is discouraged, because of spelling mistakes easily made.
DOS settings are valid for DOS applications, and WIN-OS2 is just a special
DOS application. By default, for a new DOS application the DOS Settings
:hp4.IDLE_SECONDS=5:ehp4. and :hp4.IDLE_SENSITIVITY=100:ehp4. are defined.
:p.As seamless WIN-OS2 sessions are also DOS type sessions, you may strongly
want to adjust the Settings of WIN-OS2 sessions for better WIN-OS2 performance
than the default settings, e.g you may want to increase the memory by
adding DPMI_MEMORY_LIMIT=8.
:dt.:hp4.File Find:ehp4.&colon.
:dd.If you click on this button, the standard file dialog of OS/2 is displayed
where you can select the application you want to install. The application
parameters (e.g path) will then be inserted automatically in the
corresponding entryfields.
:dt.Drag &amp. Drop:
:dd.You can alternatively use the Drag &amp. Drop operation to create a Program
Popup Menu entry.
There are 3 basic kind of objects you may want to drop onto this notebook page:
:p.1. Program objects, which are *.EXE or *.COM files of PM, OS/2 windowed, DOS
or WIN-OS2 applications.
Just select one application from, say, a Drives object or from
a filemanager, drag it into the dialog over any area that accepts it and
drop it.
:p.2. Batch file objects, which are *.CMD or *.BAT type batch files for OS/2 and
DOS command processors (CMD.EXE and COMMAND.COM).
These batch files are automatically installed to be run through a copy of their
command processors (see the online OS/2 command reference for more information
about CMD.EXE and COMMAND.COM).
:p.3. WPS Folder Objects, which are opened by the WPS on request of PC/2 when
selected from the Popup Menu.
If the WPS is not running, PC/2 can't open menuentries of this type.
:p.You can't create a menuentry for any object of a different type by dropping
them onto this dialog, you have to use WPS 2 PC/2 in this case.
Data extracted from the WPS by WPS 2 PC/2 can then be dropped onto
PC/2's :link reftype=hd res=&ID_CONFIGDIALOG..Setup dialog:elink..
:p.The notebook settings will be adjusted according to the application you dragged into.
:edl.
:p.For a power user, the data entered may be less. Because the OS/2 API
DosStartSession() is used to start the application, all rules for this
API apply as described in the toolkit. Hence you may leave the entryfield
Path and Filename blank and then select from the
:link reftype=hd res=&PIID_PAGE2..Session Settings:elink. group an
OS/2 or DOS fullscreen or window, to get a command prompt.
:p.You may also start an application indirectly through a secondary command
processor by specifying :hp4.c&colon.\os2\cmd.exe:ehp4. as the Path and Filename and
use then the :hp4./C:ehp4. or :hp4./K:ehp4. option of CMD.EXE in the
Parameters entryfield.
(For further information, type :hp4.start view cmdref cmd:ehp4. in an OS/2
command prompt, to get online information about the command processor.)
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Session notebook page.          *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE2..Session Settings
:p.Here you can select the type of application you want to add.
By default, PC/2 tries to determine the type of an application you installed
via the standard file dialog or via Drag &amp. Drop.
:dl tsize=12 break=fit.
:dthd.:hp4.Option&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Determined by WPS:ehp9.
:dd.This default selection lets the WPS choose the type of application when
started.
:dt.:hp9.OS/2 Full-Screen:ehp9.
:dd.The session is a command session, started in full-screen.
:dt.:hp9.OS/2 Window:ehp9.
:dd.The session is a command session, started in a window on PM.
:dt.:hp9.Presentation Manager:ehp9.
:dd.The session is graphical PM application.
:dt.:hp9.DOS Full-Screen:ehp9.
:dd.The session is a DOS command session, started in full-screen.
:dt.:hp9.DOS Window:ehp9.
:dd.The session is a DOS command session, started in a window on PM.
:dt.:hp9.WPS Object:ehp9.
:dd.The Object-ID of the WPS Object to be started is contained in the entryfield
:hp9.Path and Filename&colon.:ehp9.. The session can only be started when the
Object-ID is assigned.
:dt.:hp9.Seamless WIN-OS2:ehp9.
:dd.The session is a seamless WIN-OS2 session. Be sure that your graphics
adapter supports such sessions. Currently all seamless WIN-OS2 sessions
are separate sessions.
:dt.:hp9.Real Mode:ehp9.
:dd.The seamless WIN-OS2 session is started in Real Mode. Real Mode compatibility
is only provided by OS/2 2.0.
:dt.:hp9.Standard Mode:ehp9.
:dd.The seamless WIN-OS2 session is started in Standard Mode.
:dt.:hp9.386 Enhanced Mode:ehp9.
:dd.The seamless WIN-OS2 session is started in 386 Enhanced Mode. 386 Enhanced
mode compatibility is only provided by OS/2 2.1.
:dt.:hp9.Separate Session:ehp9.
:dd.When checked, the seamless WIN-OS2 session in :hp9.Standard Mode:ehp9.
or :hp9.386 Enhanced Mode:ehp9. is started in a separate session (loading
another copy of the WIN-OS2 environment) otherwise the session is started
into a common WIN-OS2 session (loading the WIN-OS2 environment only once).
:edl.
:p.You generally have to verify that the Program Type setting corresponds
to the application you installed, for most programs you can use
:hp9.Determined by WPS:ehp9. if you aren't sure.
:p.According to the Program Type that is selected, some settings may not
be editable or visible.
:p.OS/2 and DOS Fullscreen or Windows are only used if you want to start
a command prompt as the application. In this case, you would usually enter in the
the entryfield Path and Filename of the group Program Data, the path of
the corresponding command processor. An advanced technique to select the
type of command processor only with these radiobuttons is described under
the group :hp9.Program Type:ehp9..
:p.To add a seamless WIN-OS2 session without a corresponding WPS Object
defined, select the :hp9.Seamless WIN-OS2:ehp9. radiobutton.
Another group of buttons will be enabled, allowing you the select the
Settings of the WIN-OS2 session.
Although there is a :hp9.Separate Session:ehp9. checkbox, seamless WIN-OS2
sessions will currently always be started as separate sessions.
:warning.
Under OS/2 2.0 GA, seamless WIN-OS2 sessions may only be started with
the WPS running, otherwise the system hangs.
There also seems to be a problem with a real mode session, because
such a WIN-OS2 session starts to load, but doesn't finish successfully.
Under OS/2 2.1 GA you may start seamless WIN-OS2 sessions with or without
the WPS installed.
:ewarning.
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Style notebook page.            *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE3..Style Settings
:p.You can select one of the radiobuttons and any of the checkboxes to
define the style the application should be started with.
:warning.
PC/2 can only request that an application is started by OS/2 with the
selected style, but it can not force the application not to overwrite
these recommendations.
:p.Some applications overwrite the default style settings, for example by
reading them from a profile, and adjust themselfs immediately before
becoming visible.
PC/2 won't be able to prevent applications from doing this, for example,
no-one will be able to move PC/2's :hp9.Overview Window:ehp9. outside
of the Desktop, because PC/2 itself rejects such manipulations.
:ewarning.
PC/2 can't force such applications to accept the styles you selected.
:dl tsize=12 break=fit.
:dthd.:hp4.Option&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Restored:ehp9.
:dd.The default style defined by the session itself is used.
:dt.:hp9.Maximized:ehp9.
:dd.The session's default style is modified to maximized.
:dt.:hp9.Minimized:ehp9.
:dd.The session's default style is modified to minimized.
:dt.:hp9.Invisible:ehp9.
:dd.The window created by the application is invisible.
:dt.:hp9.No Autoclose:ehp9.
:dd.The window created by the application is not terminated when the application
shuts down.
:dt.:hp9.Background:ehp9.
:dd.The window is created in the background.
This option may be useful for sessions that get started by a :hp9.Hotkey:ehp9. on a
:hp9.Virtual Desktop:ehp9., to avoid switching the focus from the current Desktop.
:dt.:hp9.Autostart:ehp9.
:dd.A session marked with this setting will by started automatically by
PC/2 during PC/2's invocation. This feature works similar as the
:hp4.startup folder:ehp4. of the WPS.
:dt.:hp9.User defined Size &amp. Position:ehp9.
:dd.The session's default size and position is modified to the values entered.
PC/2 forces the window to the entered position, even when the application overwrites
these values. You may specify a position relative to the origin of the Virtual
Desktops (the "middle" Desktop of the 9 Virtual Desktops), useful when the.
:link reftype=hd res=&ID_DESKTOPDIALOG..Virtual Desktop:elink. feature is
enabled.
:edl.
:p.E.g. if you selected :hp9.Minimized:ehp9., :hp9.Invisible:ehp9. and
:hp9.Background:ehp9. buttons, the application will be started minimized, in the
background and invisible (this may make sense for a backup program).
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Hotkey notebook page.           *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE4..Hotkey Settings
:p.PC/2 supports the definition of Hotkeys to switch from the current
application to other applications just by pressing a Hotkey. If the Hotkeyed session
is on another Virtual Desktop, PC/2 switches to this Desktop and switches
the application into the foreground.
:warning.
Hotkeys defined are detected by PC/2 systemwide, that is they may be stolen from
any PM applications, unless the application has defined an accelerator for this
Hotkey, or you have selected :hp9.No systemwide Hotkeys:ehp9. on the
:link reftype=hd res=&DDID_PAGE3..General PC/2 Settings:elink. notebook page.
:ewarning.
PC/2 supports :hp4.0:ehp4. ... :hp4.9:ehp4. and :hp4.A:ehp4. ... :hp4.Z:ehp4.
in combination with either the :hp4.CTRL:ehp4.-Key or the :hp4.ALT:ehp4.-Key
as Hotkeys, giving you 72 different Hotkeys at maximum.
This set of keys is the optimum compromise between CPU requirements and
keys available on all possible keyboard layouts.
:p.If PC/2 can't detect the application running the pressed Hotkey is defined for,
it starts the application as if it was invoked by PC/2's Popup Menu.
Starting applications by pressing a Hotkey is another alternative delivered by PC/2,
when invoking programs
delivered by PC/2.
:p.PC/2 allows you to mark the application as non-movable around the Virtual Desktop.
By defining this style, the application always keeps on the active Desktop, regardless
what :link reftype=hd res=&ID_DESKTOPDIALOG..Virtual Desktop:elink. you are
switching to.
:dl tsize=12 break=fit.
:dthd.:hp4.Control&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Window Name:ehp9.
:dd.If you have either marked the application as non-movable, defined a Hotkey or
a mnemonic, you must fill this entryfield with a string that equals or is part of
either the application's name on its titlebar or the application's name in the Window List.
If you use one of the two features and you leave the entryfield empty, PC/2 copies the
string from the :hp9.Program Title:ehp9. entryfield into the :hp9.Window Name:ehp9.
entryfield, when you press :hp4.Ok.:ehp4. after automatically removing the tilde
defined for the mnemonic.
:p.Be sure that the string you entered matches only with the current application, because
the first match of this string with any applications's titlebar or its entry in the
window list will be used.
You may want to start your application without these options first, to get its titlebar
name or its entry in the window list.
:warning.I strongly recommend you fill in this entryfield if you experience unexpected results.
PC/2 uses the :hp9.Window Name:ehp9. to identify the current sessions for all running sessions.
:ewarning.
:dt.:hp9.Keep on active Desktop:ehp9.
:dd.Checking this flag keeps the application always on the current Desktop regardless
to which :hp9.Virtual Desktop:ehp9. you move.
:dt.:hp9.Enable Hotkey:ehp9.
:dd.This flag says you want to define a Hotkey for this application. The controls
necessary to define the Hotkey will be enabled.
You may want to select the session started in background, if it will get started
on a :hp9.Virtual Desktop:ehp9., to avoid losing focus from the current Desktop.
:dt.:hp9.Default:ehp9.
:dd.Once you press the Hotkey, the Desktop is switched to the :hp9.Virtual Desktop:ehp9. the
application is located on and activates it.
:dt.:hp9.Maximized:ehp9.
:dd.The same as for :hp9.Default:ehp9. is done, but the applications window is maximized
too.
:dt.:hp9.Restore:ehp9.
:dd.The same as for :hp9.Default:ehp9. is done, but the application's window is restored
too.
:dt.:hp9.CTRL-Key:ehp9.
:dd.You define a Hotkey which ranges from :hp4.0:ehp4. ... :hp4.9:ehp4. and
:hp4.A:ehp4. ... :hp4.Z:ehp4. in conjunction with the :hp4.CTRL:ehp4.-Key.
:dt.:hp9.ALT-Key:ehp9.
:dd.You define a Hotkey which ranges from :hp4.0:ehp4. ... :hp4.9:ehp4. and
:hp4.A:ehp4. ... :hp4.Z:ehp4. in conjunction with the :hp4.ALT:ehp4.-Key.
:p.You must select a key in the range between :hp4.0:ehp4. and :hp4.9:ehp4.
or :hp4.A:ehp4. ... :hp4.Z:ehp4. from the dropdown box, which in
conjunction with the :hp4.CTRL:ehp4.-key or :hp4.ALT:ehp4.-key is used to switch to the
application.
You can define 72 different keys this way as the maximum.
:dt.:hp9.Current Window List:ehp9.
:dd.To define the style non-movable or the Hotkey, you may start the application first
without these options and grab its titlebar name from its window or its window
list name from the :hp9.Current Window List:ehp9..
:edl.
:p.PC/2 prior to version 1.90, PC/2 could not detect Hotkeys pressed in OS/2
or DOS windows, but for other windows, when you have defined a Hotkey,
you had just to press the key on the keyboard that has the defined Hotkey
character labeled on.
Said otherwise, this approach was NLS-independent.
:p.Version 1.90 and above of PC/2 is also able to detect Hotkeys in
OS/2 or DOS windows, but now you have to define the Hotkeys based on the US-keyboard.
The new approach of detecting Hotkeys is now NLS-dependent.
:p.To explain this in more detail, assume that you have a :hp4.German keyboard:ehp4..
A German keyboard looks like the US-keyboard, but has the keys :hp4.Y:ehp4. and
:hp4.Z:ehp4. exchanged, that is the :hp4.Y:ehp4. key is on a German keyboard where
the :hp4.Z:ehp4. key is on a US-keyboard and vice versa.
Now assume you want to define for a program the :hp4.Z:ehp4. key as a Hotkey.
Because the :hp4.Z:ehp4. key on a German keyboard is at the position of the
:hp4.Y:ehp4. key on a US-keyboard, you have to define the letter :hp4.Y:ehp4.
in this dialog's drop-down box, but to use the Hotkey you have to press
:hp4.CTRL:ehp4. or :hp4.ALT:ehp4. in conjunction with the :hp4.Z:ehp4. key.
:p.I'm sorry that this is a bit complicated, but the only way I have found out
to detect Hotkeys both in PM and OS/2 or DOS windows is by using the
:hp4.Scan-Code:ehp4. of a key, which is the same for a key at a certain
physical position on the keyboard for all languages, regardless which
NLS-dependent letter is printed on.
Which letter is printed on a certain physical key on a keyboard is dependent on
the country the keyboard is used at.
Similar, because PC/2 detects the physical position of a key on the
keyboard and not the letter printed on, you have to translate the Hotkey's letter
to the position of the physical key on a US-keyboard that has this letter printed on.
:p.:warning text='Caution!'. All keys defined as Hotkeys in PC/2
are no longer available for other applications, because once a key is
defined as Hotkey no other application except PC/2 gets this key.
This is a limitation of the Hotkey feature, because only this way PC/2
can ensure that if a Hotkey is defined, the Desktop switches to this application.
The Hotkey launches the application, if the application, the Hotkey is defined for,
is not running.
If you need a certain key, which is defined as a Hotkey in PC/2,
change the Hotkey to an unused key.
:p.Even if a :hp4.Hotkey:ehp4. is defined, you may pass this key to a application,
when the :hp4.SHIFT:ehp4.-key is pressed and hold before the Hotkey. When PC/2
detects :hp4.SHIFT:ehp4. is pressed together with the Hotkey, it ignores the
Hotkey by passing it to the application that currently has the focus.
:ewarning.
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Priority notebook page.         *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE5..Priority Settings
:p.PC/2 allows you to specify the priority of the applications you start via the
Popup Menu. OS/2 has the following priority classes and deltas to select from:
:dl tsize=12 break=fit.
:dthd.:hp4.Priority Class&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Idle time:ehp9.
:dd.:hp4.Idle-time:ehp4. is the lowest priority class a session or thread can run under OS/2.
You may use this option for task that should only be performed if enough CPU-resource is
available, i.e. for a background NFS (Network File System) Server or BBS.
:dt.:hp9.Regular:ehp9.
:dd.If not specified otherwise, the priority class :hp4.Regular:ehp4. is the default class of all
sessions and threads. For this default class, the priority delta of 0 is the default.
:dt.:hp9.No Change:ehp9.
:dd.This option just doesn't change the priority. The application is started with
priority class Regular and priority delta 0.
:dt.:hp9.Time Critical:ehp9.
:dd.:hp4.Time-critical:ehp4. priority class is used for time-critical sessions. Examples
may be real-time data acquisition.
:dt.:hp9.Foreground Server:ehp9.
:dd.:hp4.Foreground Server:ehp4. is the highest priority class available and should be only
used for small assembly language applications because they really eat up the CPU time.
:dt.:hp9.Priority Delta:ehp9.
:dd.The priority delta selectable between 0 and 31 is defined for each priority class.
I.e., a session with Regular priority class and priority delta 25 has a lower priority
than a session with Time-critical priority class and priority delta 3.
:edl.
:p.:warning text='Extreme caution!'. Changing the priority from the default selection
may cause serious performance impacts on your system. Be very carefully when
selecting higher priorities, because the higher the priority, the higher the CPU time-slice
a session consumes deteriorating overall system performance.
:p.:hp2.Note!:ehp2. You can't change the priority of DOS session
(and WIN-OS2 sessions are DOS sessions)
because allowing this would lock PM for unknown reasons.
:ewarning.
:p.For example, if you set an OS/2 command prompt to a Time-critical priority, you may
not be able to switch to other sessions until the command prompt is waiting for input.
:p.Press :hp4.Ok:ehp4. to accept, or press :hp4.Cancel:ehp4. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Environment notebook page.      *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE6..Environment Settings
:p.PC/2 allows you to specify the environment of the applications you start.
If you don't specify any special environment settings, the
the started application inherits the environment of PC/2.
PC/2 itself inherits its environment from the process it was started from,
which is either the WPS or the OS/2 Shell process itself.
:p.You may either add settings to the settings that already get inherited from
PC/2, or you may replace settings defined in PC/2's environment
with a different value, or you may modify existing settings with additional values..
:p.For OS/2 versions 3.00 (WARP) and above, you may also specify the settings
:hp4.BEGINLIBPATH:ehp4. and :hp4.ENDLIBPATH:ehp4., which are not part of the process's
environment, but are actually the process's information area, to be technically exact.
Even if both are not part of the environment, PC/2 and the OS/2 command
processor :hp4.CMD.EXE:ehp4. allow you to treat both settings like environment
variables, because this is more consistent for the user.
:warning.
The :hp4.BEGINLIBPATH:ehp4. and :hp4.ENDLIBPATH:ehp4. settings are not available
for OS/2 2.x, because the Operating System doesn't support it, and will be ignored
for these versions.
:ewarning.
An entry in the environment specifies the value of a environment variable, and entry
has therefore the following form:
:p.:hp4.ENVIRONMENTVARIABLE=VALUE:ehp4.
:p.where :hp4.ENVIRONMENTVARIABLE:ehp4. is the name of a environment variable and
:hp4.VALUE:ehp4. is the value it gets assigned.
You may replace :hp4.VALUE:ehp4. by anything you want, but ensure that you use
the correct spelling.
Both :hp4.ENVIRONMENTVARIABLE:ehp4. and :hp4.VALUE:ehp4. are case sensitive, and
both get inherited to the started process with case sensitivity preserved.
Part of :hp4.VALUE:ehp4. may also be :hp4.%ENVIRONMENTVARIABLE:ehp4. which gets
replaced by the :hp4.VALUE:ehp4. of the same :hp4.ENVIRONMENTVARIABLE:ehp4. of the
parent process.
:p.For example, to add the environment variable :hp4.MYPROG:ehp4. with the value
:hp4.MyValue:ehp4. you'd write:
:p.:hp4.MyProg=MyValue:ehp4.,
:p.or to replace the :hp4.PATH:ehp4. environment variable of PC/2's
environment you could write:
:p.:hp4.PATH=C&colon.\&semi.D&colon.\MYPROG&semi.D&colon.\MYPROG\DLL&semi.:ehp4.,
:p.or to append the path :hp4.X&colon.\TOOLS&semi.:ehp4. before and
:hp4.Z&colon.\NETWORK\&semi.:ehp4. after the existing :hp4.DPATH:ehp4.
environment variable of PC/2's environment, you may write:
:p.:hp4.DPATH=Z&colon.\NETWORD\&semi.%DPATH%X&colon.\TOOLS&semi.:ehp4..
:warning.
You can't replace the :hp4.LIBPATH:ehp4. variable, which, although it's treated like a
environment variable in :hp9.CONFIG.SYS:ehp9., but does not belong to a process's
environment, but to the process itself.
The :hp4.LIBPATH:ehp4. is a systemwide resource.
:ewarning.

.*--------------------------------------------------------------------------------------*
.* The user selected examples from the Program installation PC/2 help.                  *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_EXAMPLE1..Program installation example 1
:p.Assume you want to add Lotus 123/G:
:dl tsize=12 break=fit.
:dthd.:hp4.Fieldname&colon.
:ddhd.You would enter&colon.:ehp4.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.Lotus 123/G:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.c&colon.\123g\123g.exe:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.:hp4.c&colon.\123g:ehp4.
:dt.:hp9.Parameters&colon.:ehp9.
:dd.(none)
:edl.
:p.Lotus 123/G is a Presentation Manager application so you would select
:hp4.Presentation Manager:ehp4. as program type. The program style may be
:hp4.Maximized:ehp4., because more information is visible. The priority
may be left at the default selection :hp4.No Change:ehp4..
:p.Assume you want to add the WPS Object System Clock (located in the
folder :hp4.OS/2 System&rarrow.System Setup:ehp4.):
:dl tsize=12 break=fit.
:dthd.:hp4.Fieldname&colon.
:ddhd.You would enter&colon.:ehp4.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.System Clock:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.<WP_CLOCK>:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.(n/a)
:dt.:hp9.Parameters&colon.:ehp9.
:dd.(n/a)
:edl.
:p.The System Clock is a WPS Object, so :hp4.WPS Object:ehp4. is
selected as the program type.
You may have to look into the file :hp4.OS2_20.RC:ehp4. to get the defined
name of preinstalled WPS Objects.
Most settings are not available for WPS Objects.
:p.Assume you want to add the WPS clock object with the ObjectID :hp4.<WP_CLOCK>:ehp4..
First you must extract the ObjectID by using WPS 2 PC/2.
Then drag the extracted object from the WPS 2 PC/2 window onto
PC/2's Setup dialog, to create a menuentry within the Popup Menu.
After you have created the clock menuentry, you can view its settings by
editing the menuentry:
:dl tsize=12 break=fit.
:dthd.:hp4.Fieldname&colon.
:ddhd.You would enter&colon.:ehp4.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.System Clock:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.<WP_CLOCK>:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.(n/a)
:dt.:hp9.Parameters&colon.:ehp9.
:dd.(n/a)
:edl.
:p.The System Clock is a WPS Object, so :hp4.WPS Object:ehp4.
is used as the program type.
Assuming that you extracted the ObjectID as outlined
before, then the Object ID is :hp4.<WP_CLOCK>:ehp4..
:p.Sorry, this may be a little complicated, but it is the only way
to get a known Object ID.
:p.Assume you want to add the WIN-OS2 Program Manager.
Open the Program Installation dialog, and either enter the path information
(e.g c&colon.\os2\mdos\winos2\progman.exe) or drag :hp4.PROGMAN.EXE:ehp4.
into.
If you have entered the data manually, you also must check the
seamless WIN-OS2 session.
Further assume that you want in the same WIN-OS2 session to also start the
WIN-OS2 File Manager :hp4.WINFILE.EXE:ehp4. -  then you'd add it to the
Parameters entryfield:
:dl tsize=12 break=fit.
:dthd.:hp4.Fieldname&colon.
:ddhd.You would enter&colon.:ehp4.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.Prog &amp. File Manager:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.c&colon.\os2\mdos\winos2\progman.exe:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.:hp4.c&colon.\os2\mdos\winos2:ehp4.
:dt.:hp9.Parameters&colon.:ehp9.
:dd.:hp4.winfile.exe:ehp4.
:edl.
:p.You can only add a single Parameter to the WIN-OS2 Program Manager.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Control Addition PC/2 dialog box.                    *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&MDID_CONTROLDIALOG..Help for PC/2 Control Addition
:p.This dialog allows you to add Menu Control items to PC/2's Popup Menu. Except for
:hp9.Break Separator:ehp9. and :hp9.Menu Separator:ehp9., you may only add 1 instance
of the Menu Control to the Popup Menu.
The Menu Control :hp9.Configure Popup Menu Settings:ehp9. must be added
to the Popup Menu in order that PC/2 displays the Popup Menu after mouse button 1
clicks, otherwise the :link reftype=hd res=&ID_CONFIGDIALOG..Setup dialog:elink. will
be invoked after each mouse click until you have added this Menu Control. PC/2
supports the following Menu Controls:
:dl tsize=12 break=fit.
:dthd.:hp4.Control&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Menu Settings:ehp9.
:dd.This button is used to add the Menu Control to be able to configure the Popup Menu
via the Setup dialog.
:dt.:hp9.Desktop Settings:ehp9.
:dd.This button is used to add the Menu Control to configure the Virtual Desktop feature.
:dt.:hp9.About PC/2:ehp9.
:dd.This button adds the About PC/2 Menu Control.
:dt.:hp9.ShutDown OS/2:ehp9.
:dd.This button adds a Menu Control, which, when selected, displays a message box allowing
you to shutdown OS/2 just by clicking on :hp4.Ok:ehp4. or pressing the :hp4.Enter:ehp4. key.
:dt.:hp9.Help:ehp9.
:dd.This button adds the online help Menu Control item.
:dt.:hp9.Exit:ehp9.
:dd.This button is used to add the Menu Control to be able to exit PC/2 via a
message box by just clicking on :hp4.Ok:ehp4. or pressing the :hp4.Enter:ehp4. key.
:p.When running PC/2 as the WPS process, this menuitem will be disabled, because
a WPS process should not terminate.
:dt.:hp9.Break Separator:ehp9.
:dd.This button is used to add one break separator Menu Control. You may add this
Menu Control to convert a large single-column menu to a smaller multi-column menu.
This Control is a Menu Control that you may add as often you prefer. I suggest to
use this Control only to break Menuitems not being a Submenu.
:dt.:hp9.Menu Separator:ehp9.
:dd.This button is used to add one separator Menu Control. You may add this Menu Control
to enhance the readability of the Popup Menu. This Control is a Menu Control that
you may add as often you prefer.
:edl.
:p.Press :hp4.Ok:ehp4. to accept or press :hp4.Cancel:ehp4. to ignore your modifications.
:p.:link reftype=hd res=&PIID_PROGRAMDIALOG..<Backward>:elink.
                                :link reftype=hd res=&RDID_RESORTDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Resort PC/2 dialog box.                              *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&RDID_RESORTDIALOG..Help for PC/2 Resort
:p.This dialog box contains two listboxes, the left one that displays the currently
available Menuentries and the right one that displays the currently resorted
Menuentries.
Select one or more Menuentries from the left listbox and press the
:hp4.Reorder:ehp4. button, to resort it to the right listbox.
For the remaining Menuentry(ies) repeat this procedure, until the left listbox is empty.
Instead of selecting a Menuentry and then clicking on the :hp4.Reorder:ehp4.
button, you may doubleclick on a Menuentry.
:p.You can cancel the resort before you have done any sort, but you have to resort
the complete Submenu once you made one resort operation.
:p.All sorted Menuentries in the right listbox can't be started with PC/2 until
you complete the resort by pressing :hp4.OK:ehp4..
:warning.
You have to press :hp4.OK:ehp4. in the :link reftype=hd
res=&ID_CONFIGDIALOG..Setup Dialog:elink. to write the resorted Menuentries
structure to the configuration file.
:p.Because a Break Separator is a style of the preceding Menuentry, you can't
resort a Break Separator standalone, you can only resort its :hp2.owning:ehp2. menuentry
which automatically resorts the Break Separator too.
:ewarning.
:p.:link reftype=hd res=&MDID_CONTROLDIALOG..<Backward>:elink.
                                :link reftype=hd res=&SUID_STARTUPDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Startup Parameters dialog box.                       *
.*--------------------------------------------------------------------------------------*

:h1 res=&SUID_STARTUPDIALOG..Help for PC/2 Startup Parameters
:p.PC/2 allows you to replace the commandline parameters of your application
completely or partly.
:p. For example, assume you have a TCP/IP communications package installed on your
system. You also have added an Menuitem that starts a file transfer program named
:hp4.FTP:ehp4.. :hp4.FTP:ehp4. requires the name of the host
you want to connect to, as a parameter.
To prompt you for this parameter immediately before :hp4.FTP:ehp4. is started,
you would modify the parameters entryfield of the PC/2 Program Installation
dialog like :hp4.[Please enter host address]:ehp4.
:p.Further assume that you selected the Menuitem :hp4.FTP:ehp4. from the
Popup Menu. Just before :hp4.FTP:ehp4. is started, a dialog box is displayed,
requesting the host address from you. You would type something like
:hp4.ftp.cdrom.com:ehp4., then the file transfer program will be invoked
as if you typed :hp4.FTP ftp.cdrom.com:ehp4. from a commandline.
:p.Generally, the syntax for the commandline parameters is:
:p.:hp4.Parameter(s) 1 [Text] Parameter(s) 2:ehp4.
:p.Assume you typed :hp4.FirstFile.doc:ehp4. as the first, and
:hp4.ThirdFile.doc:ehp4. as the second parameter.
You would be asked by a dialog box what to replace :hp4.[Text]:ehp4. with.
Assume you entered :hp4.MyFile.doc:ehp4. then the program will be invoked
with the commandline parameters :hp4.FirstFile.doc MyFile.doc ThirdFile.doc:ehp4..
The string :hp4.[Text]:ehp4. would have been replaced by :hp4.MyFile.doc:ehp4..
Of course both parameters may be omitted, both may contain more than one parameter
or only one of them may present. Omitting :hp4.[Text]:ehp4. would start the
application without asking you for a commandline parameter prior.
:p.You may also use this dialog to add a second WIN-OS2 application to a
WIN-OS2 session, if the first application is the WIN-OS2 Program Manager.
:p.PC/2 allows you to edit commandline parameters similar to the WPS (open
the Settings notebook of any application,
position the cursor into the Parameters entryfield and
press F1 or Help to get further information).
:p.Press :hp4.Acceot:ehp4. to accept the parameters you entered, or press
:hp4.Ignore:ehp4. to replace the user editable Parameter(s)
with an empty string.
:p.:link reftype=hd res=&RDID_RESORTDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_DESKTOPDIALOG..<Forward>:elink.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Desktop Setup PC/2 dialog box.                       *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_DESKTOPDIALOG..Help for PC/2 Desktop Setup
:p.PC/2 supports :hp9.Sliding Focus:ehp9. and :hp9.Virtual
Desktops:ehp9..
:p.The :hp9.Sliding Focus:ehp9. gives you a behavior you may know from X-Windows -
you don't have to click on a window to activate it and to switch the input focus
to it - the window below the mouse pointer is automatically activated.
Just move the mouse pointer from one window to another to switch the input focus.
You'll notice that the window below the mouse pointer always has a highlighted
frame, which OS/2 uses to signal the active window as having the input focus.
You may use the :hp4.SHIFT:ehp4.-key to temporarily suspend the :hp9.Sliding Focus:ehp9.,
which you may find useful for some programs, e.g. online help displayed with
:hp4.VIEW.EXE:ehp4., because OS/2 doesn't expect mouse movements to switch
the active window.
:p.A :hp9.Virtual Desktop:ehp9. is a Desktop enhancement that expands the size of
your display and controls which part of the virtual display is covered by your
physical screen.
:artwork name='Pc2Win.bmp' align=left.
For example assume that you are running OS/2 on an XGA-2 at a resolution of 1024 * 768
pixels.
Your display has then 1024 columns and 768 rows of pixels, giving you a
Desktop where application windows can be seen.
We will call this the physical Desktop.
Of course you can start windows outside this Desktop, on one of the :hp9.Virtual
Desktop:ehp9.s, but you won't be able to see them unless you switch to this Desktop.
:p.To summarize the graphics, assume you are using an XGA-2 display adapter at a
resolution of 1024 * 768 points:
:ol.
:li.The physical Desktop, that is the screen you are currently looking
into is located at the center of all :hp9.Virtual Desktop:ehp9.s, after invoking PC/2
The lower left point of is then the origin in the :hp9.Virtual Desktop:ehp9. with
coordinates of (0, 0).
All coordinates on the :hp9.Virtual Desktop:ehp9. are then counted relative to this
absolute origin, counting positive on the right and upper direction and negative to
the lower and bottom direction.
:li.The :hp9.Virtual Desktop:ehp9. to the left to your Display after starting PC/2
has negative horizontal coordinates.
In our example, this point would be (-1024, 0).
:li.The :hp9.Virtual Desktop:ehp9. right to your Display after starting PC/2
has the absolute coordinates of (1024, 0) in our example.
:p.On a VGA screen at a resolution of 640 * 480 the coordinates would be (640, 0), as
you have hopefully assumed.
:li.When you are using OS/2, you have usually a physical Desktop in front
of you, where the WPS (WorkPlace Shell) is running.
After invoking PC/2, the WPS is drawn on the :hp9.Overview Window:ehp9.
with the name :hp4.Desktop:ehp4..
Behind the WPS, which is a Presentation Manager application just covering the
while screen, is the image of the physical Desktop, named :hp4.Display:ehp4.,
but it is covered by the WPS, so you can't see it.
:p.Now assume you move the physical Desktop onto the :hp9.Virtual Desktop:ehp9.
where the IBM Web Explorer, (named IBM WebE in our graphics), runs.
The physical Desktop will then be at :hp4.2:ehp4. in our graphics, and you
would be able to see its name :hp9.Display:ehp9. then, because it is not longer covered
by the WPS.
:eol.
:p.Simply speaking, imagine the :hp9.Virtual Desktop:ehp9. as an up to 9 * 9 array of Desktops,
with the physical Desktop, that is the display, just covering 1 of all
:hp9.Virtual Desktop:ehp9.s.
You just navigate your display around within the :hp9.Virtual Desktop:ehp9.s as you
would do on a map from sector to sector.
Distributing applications on the :hp9.Virtual Desktop:ehp9.s simply helps you to
avoid having all application's windows on your display.
:p.Now assume that you move the physical Desktop left, all windows you have
started will move right, so some shift out on the right side and some shift in
on the left side of your display.
:p.Controlling the windows is exactly that what PC/2 does for you.
If you move your mouse pointer on the leftmost column of your display
(column 0), all windows move rightward, as the physical Desktop moves
leftward within the :hp9.Virtual Desktop:ehp9..
The same principle is used on the rightmost columns and the top and
bottom rows.
If you move your mouse pointer into a corner of your display, the physical Desktop
even will move in two directions, leading to a horizontal and a
vertical movement.
:p.Of course you can only move your physical Desktop in one direction,
as long as this movement keeps it within the :hp9.Virtual Desktop:ehp9., whose
size you can select from 1 * 1 up to 9 * 9.
:p.The :hp9.Sliding Focus:ehp9. gives you a behavior you may know from X-Windows,
you don't have to click on a window to activate it, the window below the mouse
pointer is automatically activated.
Just move the mouse pointer from one window to another, to switch the input focus.
:p.All settings are saved and will be used when PC/2 is loaded unless you have
specified a different behavior with the
:link reftype=hd res=&SUID_STARTUPDIALOG..Commandline Parameters:elink..
:warning text='Caution:'.You may want to disable the :hp9.Sliding Focus:ehp9.
on a machine used for development. When using a debugger (e.g. IPMD) your
machine is likely to lock with the :hp9.Sliding Focus:ehp9. enabled.
:p.You can use the :hp9.Virtual Desktop:ehp9. on a development machine, just
avoid switching between Desktops when a debugger is active.
:p.Trap popup screens also make changes in the focus order so I would suggest
you use the keyboard to dismiss these dialogs.
:p.For more information selecte help for one of following notebook pages:
:ul compact.
:li.:link reftype=hd res=&DDID_PAGE1..Virtual Desktop Settings:elink.
:li.:link reftype=hd res=&DDID_PAGE2..Physical Desktop Settings:elink.
:li.:link reftype=hd res=&DDID_PAGE3..General PC/2 Settings:elink.
:eul.
:ewarning.
:p.Once you have configured the notebook pages, just press
:hp4.Save:ehp4. to bring them into effect and save them to the profile, :hp2.or:ehp2.
:hp4.Cancel:ehp4. to make them temporarily effective, but without saving them
to the profile :hp9.PC2.INI:ehp9. on disk.
If your INI file is corrupted, PC/2 assumes default values, which
you then can edit and save to a new INI file.
:p.:link reftype=hd res=&SUID_STARTUPDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_OVERVIEWHELP..<Forward>:elink.


.*--------------------------------------------------------------------------------------*
.* The user selected help from the Desktop Configuration Virtual Desktop Settings       *
.* notebook page.                                                                       *
.*--------------------------------------------------------------------------------------*
:h2 res=&DDID_PAGE1..Virtual Desktop Settings
:p.This dialog is used to control the Virtual Desktop feature of PC/2.
:dl tsize=12 break=fit.
:dthd.:hp4.Fieldname&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Virtual Desktop:ehp9.
:dd.Select this checkbox to enable the :hp4.Virtual Desktop:ehp4. feature of
PC/2.
:dt.:hp9.Move OS/2's Desktop:ehp9.
:dd.This checkbox allows you to move the Desktop within the Virtual Desktop
like any other window. The Desktop is another name for the WPS (WorkPlace-Shell).
You may check this option if you don't need the services provided by the WPS
on all Virtual Desktops.
:dt.:hp9.Click to Move:ehp9.
:dd.If you prefer to click to a surrounding row or column, before the physical
Desktop is moved, select this option, otherwise you can change to another
Virtual Desktop by just moving the mouse pointer on a surrounding row or
column of your Display.
:dt.:hp9.Overview Window:ehp9.
:dd.You may also want an Overview Window, that contains the current
layout of the Virtual Desktop.
Select this checkbox to enable this feature.
You may doubleclick with mouse button 1 on any of the up to 81 :hp4.Virtual
Desktop:ehp4.s to immediately switch to this Desktop.
commandline option, to move the physical Desktop.
:dt.:hp9.Expand WPS to Virtual Desktop:ehp9.
:dd.When selecting this feature, the WPS is expanded to the size of the
Virtual Desktop. You may then distribute WPS Objects to any of the Virtual
Desktops. If you have a scroll bar on your WPS, this feature removes the
scrollbar when your WPS completely fits into the Virtual Desktop.
:dt.:hp9.Desktop Scrolling:ehp9.
:dd.The scrollbar :hp9.Desktop Scrolling:ehp9. enables you to define the
scrolling factor that is applied to your Virtual Desktop, when switching to
the next Virtual Desktop, by clicking on a surrounding row or column.
You can select between 0 and 100 % with 5% increments, with 100 % being the
default one.
:dt.:hp9.Virtual Desktop count:ehp9.
:dd.These two spinbuttons enable you to define the number of Virtual Desktops in
horizontal direction and vertical direction, both in the range of 1 to 9.
The first spinbutton determines the number of Virtual Desktops in the horizontal
direction, the second spinbutton the number of Virtual Desktops in the vertical
direction.
:dt.:hp9.Single Click:ehp9.
:dd.Select this option if you want to activate the Popup Menu or
switch to another Virtual Desktop with a single click with mouse button 1.
:dt.:hp9.Double Click:ehp9.
:dd.Select this option if you want to activate the Popup Menu or
switch to another Virtual Desktop with a double click with mouse button 1.
:dt.:hp9.Preselection:ehp9.
:dd.Check this item if you want PC/2 to automatically select the first entry
of your Popup Menu for you. If the first item is a submenu, it will be opened
automatically.
:dt.:hp9.Sliding Focus:ehp9.
:dd.Select this checkbox to enable the :hp9.Sliding Focus:ehp9. feature of
PC/2.
:p.Note! Even if this setting is enabled, you can temporarily prevent the
focus from moving by holding down the :hp4.SHIFT:ehp4.-key when moving the
mouse.
:dt.:hp9.Preserve Z-Order:ehp9.
:dd.To preserve the Z-Order of the windows, that is, the order in which a window in
the foreground overlaps a window behind, also check the :hp9.Preserve Z-Order:ehp9.
checkbox.
:p.Note! Even if this setting is enabled, you can temporarily prevent changes
of the Z-Order by holding down the :hp4.SHIFT:ehp4.-key when moving the
mouse.
:dt.:hp9.Hide Titlebar:ehp9.
:dd.To hide the titlebar of PC/2's Overview Window select this option. This increases
the space available to paint a reduced image of the Virtual Desktops.
:dt.:hp9.Hide Smarticons:ehp9.
:dd.To hide the smarticon bar of PC/2's Overview Window select this option. This
increases the space available to paint a reduced image of the Virtual Desktops too,
at the cost of not being able to manipulate PM windows on the Overview Window.
:edl.
:p.Press :hp4.Save:ehp4. to accept the configuration and save it into :hp9.PC2.INI:ehp9.,
or press :hp4.Cancel:ehp4. to ignore any changes you made.
If your INI file is corrupted, PC/2 assumes default values, which
you then can edit and save to a new INI file.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Desktop Configuration Physical Desktop Settings      *
.* notebook page.                                                                       *
.*--------------------------------------------------------------------------------------*
:h2 res=&DDID_PAGE2..Physical Desktop Settings
:p.This dialog is used to control the physical Virtual Desktop feature of PC/2.
:dl tsize=12 break=fit.
:dthd.:hp4.Control&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.OS/2's Desktop Name:ehp9.
:dd.PC/2 has to know the name of this Desktop, so you have to ensure that
you type its name in the entryfield.
Under OS/2 2.0 it's usually named :hp4.OS/2 2.0 Desktop:ehp4., but
it changes under OS/2 2.1 to :hp4.Desktop:ehp4., if you haven't installed
it over an existing OS/2 2.0 system.
You may rename the Desktop by clicking with mouse button 2 on the Desktop
selecting :hp4.Desktop&rarrow.Settings:ehp4. (or :hp4.Settings:ehp4. under OS/2 Warp)
and selecting the General notebook page.
Changing the title can be used to replace :hp4.OS/2 2.0 Desktop:ehp4.
by :hp4.Desktop:ehp4..
Also ensure that you translate it into your national language, if you
don't use an English OS/2 version.
:dt.:hp9.Window List Name:ehp9.
:dd.PC/2 also must know the name of the Window List.
The Window List is usually named :hp4.Window List:ehp4. but you have to
ensure that it is translated into your national language, if you don't
use an English OS/2 version.
:dt.:hp9.Button 2 titlebar click lowers Z-order:ehp9.
:dd.Select this checkbox if you want to click down mouse button 2 on any window's
titlebar to set this window to the bottom of all windows. This moves the window
you clicked on behind all other windows, lowering its Z-Order to the minimum.
The window under the mouse pointer is moved to the foreground and activated, if
it is not the same you clicked on.
:p.By holding the :hp4.Ctrl:ehp4.-key while clicking with mouse button 2 on
a window's titlebar, the window under the mouse pointer gets not moved to the
foreground and activated. This allows you to kick a window into the background
without affecting the Z-order of other windows.
:p.By holding the :hp4.Alt:ehp4.-key while clicking with mouse button 2 on
a window's titlebar, the titlebar acts as if you haven't checked PC/2's
option :hp9.Button 2 titlebar click lowers Z-order:ehp9.. This allows you to move
the window or activate any special features the window supports.
:dt.:hp9.Keep on top:ehp9.
:dd.Select this option if you want the Overview Window to always stay on
the top of the Desktop, even if another window has the focus.
:dt.:hp9.Use Spooler Control Window:ehp9.
:dd.PC/2 provides a Spooler Control Window, which allows you to manage the
printer queues and jobs of your local workstation.
This feature is primarily to provide printer management, when PC/2 is
running as a WPS replacement, because the standard OS/2 Spooler management
is a SOM application, and requires the WPS to be running.
:p.By default PC/2 starts the Spooler Control Window only, when PC/2 is
running as a WPS replacement.
When selecting this checkbox, the PC/2 Spooler Control Window is also
available when you run PC/2 on top of the WPS (which increases PC/2's
memory requirements slightly).
Changes of this setting aren't available immediately, but the next time
you start PC/2.
:dt.:hp9.Background Bitmap:ehp9.
:dd.Check this option to add the background Bitmap support of PC/2. PC/2
then allows you to define a bitmap, which is displayed on PM background.
PM background means all the background of OS/2 that is not covered by the
WPS. For example if you have 3 Virtual Desktops, having the WPS as the
centered one, then the 2 Virtual Desktops beside the WPS will display the
background bitmap.
:dt.:hp9.Normal:ehp9.
:dd.This option displays the bitmap unsized. The bitmap is centered.
:dt.:hp9.Scaled:ehp9.
:dd.This option scales the bitmap so that is covers the complete screen.
:dt.:hp9.Tiled:ehp9.
:dd.The bitmap is tiled covering the complete screen with the tile count
selected in the :hp9.Tile count:ehp9. spinbutton. You can select a tile
count of 1 to 99 although OS/2 seems to limit this to about 20.
:p.:warning text='Caution!'.Under OS/2 3.00 Warp this seems to hang OS/2
completely, requiring a soft reset.
A defect (PMR 4X472) has been opened against OS/2 Warp, so this may be fixed by a
future CSD (Corrective Service Diskette).
:p.This bug is not a problem of PC/2, since it works correctly under
OS/2 2.x.
:ewarning.
:dt.:hp9.Find Bitmap...:ehp9.
:dd.Select this pushbutton to use the standard OS/2 file dialog to locate
the bitmap file you want to display.
:dt.:hp9.Path to Bitmap:ehp9.
:dd.Either fill this entryfield by selecting a bitmap with the file
dialog by clicking on :hp9.Find Bitmap...:ehp9. or enter the fully qualified
path to  the bitmap manually.
:edl.
:p.Press :hp4.Save:ehp4. to accept the configuration and save it into :hp9.PC2.INI:ehp9.,
or press :hp4.Cancel:ehp4. to ignore any changes you made.
If your INI file is corrupted, PC/2 assumes default values, which
you then can edit and save to a new INI file.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Desktop Configuration General PC/2 Settings notebook *
.* page.                                                                                *
.*--------------------------------------------------------------------------------------*
:h2 res=&DDID_PAGE3..General PC/2 Settings
:p.This dialog is used to control PC/2 settings that have a general character.
:dl tsize=12 break=fit.
:dthd.:hp4.Control&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Normal ShutDown (WPS method):ehp9.
:dd.Check this item if you want PC/2 to perform a Shutdown of OS/2
the way the WPS does, when selecting ShutDown from its context menu.
When this item is checked, and you select :hp9.ShutDown:ehp9. from PC/2's
Popup Menu or SmartIcon, OS/2 informs all application that OS/2 is going to
shut down, giving them a chance to write unsaved changes to disk.
Some applications, e.g. OS/2 command processors, even ask if you are sure
to close them.
:dt.:hp9.Ignore Autostart:ehp9.
:dd.Check this item to ignore the :hp9.Autostart:ehp9. style of applications
in PC/2's Popup Menu, without having to remove this style
from all applications individually.
You may find this feature useful when temporarily exiting PC/2
and reloading PC/2 without launching the applications having the
:hp9.Autostart:ehp9. style set a second time.
:p.You may also specify the commandline option :hp4.-NoAutostart:ehp4., as
described in :link reftype=hd res=&ID_GENERALHELP..General Help for PC/2:elink.,
to get the same behaviour.
:dt.:hp9.No systemwide Hotkeys:ehp9.
:dd.Check this item to allow PC/2 Hotkeys to be detected only, if
either PC/2, the Window List, PM or the WPS is active window when pressing a
Hotkey.
This prevents PC/2 from stealing Hotkeys from your application
software you are working with.
:p.For example, if you have defined the Hotkey :hp4.CTRL+U:ehp4. to
start a host upload program, you usually don't want to invoke this upload,
when pressing :hp4.CTRL+U:ehp4. in :hp4.EPM:ehp4. to undo a typing mistake.
:edl.
:p.Press :hp4.Save:ehp4. to accept the configuration and save it into :hp9.PC2.INI:ehp9.,
or press :hp4.Cancel:ehp4. to ignore any changes you made.
If your INI file is corrupted, PC/2 assumes default values, which
you then can edit and save to a new INI file.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for PC/2's Overview Window.                                   *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_OVERVIEWHELP..Help for PC/2 Overview Window
:p.PC/2's Desktop Overview Window displays a sized image of all windows available on
all Virtual Desktops and allows direct manipulation.
Of course PC/2's Overview Window must be enabled before it is displayed.
:p.To change the font of the Overview Window just drag a font from the Font
Palette to the Overview Window. This font will be saved the next time you exit
PC/2.
:p.The Overview Window is controlled by smarticons, located at the top of the window.
The currently active smarticon is framed and pressed. If mouse button 2 is pressed
on a window, the action corresponding to the active smarticon is performed.
:p.To perform actions on the windows displayed in PC/2's Desktop Overview Window, the
following smarticons may be used:
:dl tsize=12 break=fit.
:dthd.:hp4.Icon&colon.
:ddhd.Description&colon.:ehp4.
:dt.:artwork name='Exit.bmp' runin align=left.:hp9.Exit PC/2:ehp9.
:dd.Click on this smarticon to exit PC/2.
:p.When running PC/2 as the WPS process, this smarticon will be disabled,
because the WPS (or WPS replacement) process should not terminate.
:dt.:artwork name='Move.bmp' runin align=left.:hp9.Move window:ehp9.
:dd.Selecting this icon changes the pointer to a window pointer cursor, allowing you
to select and move a window by clicking and holding mouse button 2.
:dt.:artwork name='Hide.bmp' runin align=left.:hp9.Hide window:ehp9.
:dd.Selecting this icon changes the pointer to a window pointer cursor, allowing you
to select and hide a window by clicking mouse button 2 on it.
The window can be made visible again by selecting it from the Window List.
:dt.:artwork name='Top.bmp' runin align=left.:hp9.Set to top:ehp9.
:dd.Selecting this icon changes the pointer to a cross wires cursor, allowing you to
move a window on the top of the Desktop by clicking mouse button 2 on it.
:dt.:artwork name='Bottom.bmp' runin align=left.:hp9.Set to bottom:ehp9.
:dd.Selecting this icon changes the pointer to a cross wires cursor, allowing you to
move a window to the bottom of the Desktop by clicking mouse button 2 on it.
:dt.:artwork name='Close.bmp' runin align=left.:hp9.Kill a session:ehp9.
:dd.Selecting this icon changes the pointer to a cross wires cursor, allowing you to
terminate a window by clicking mouse button 2 on it.
:dt.:artwork name='Maximize.bmp' runin align=left.:hp9.Maximize window:ehp9.
:dd.Selecting this icon changes the pointer to a cross wires cursor, allowing you to
maximize a window by clicking mouse button 2 on it.
:dt.:artwork name='Minimize.bmp' runin align=left.:hp9.Minimize window:ehp9.
:dd.Selecting this icon changes the pointer to a cross wires cursor, allowing you to
minimize a window by clicking mouse button 2 on it.
:dt.:artwork name='Restore.bmp' runin align=left.:hp9.Restore window:ehp9.
:dd.Selecting this icon changes the pointer to a cross wires cursor, allowing you to
restore a window by clicking mouse button 2 on it.
:dt.:artwork name='ShutDown.bmp' runin align=left.:hp9.ShutDown OS/2:ehp9.
:dd.Selecting this icon changes the pointer to a window pointer cursor and displays
a message box asking to continue ShutDown of OS/2.
If you chose to continue ShutDown, OS/2 closes all file buffers and suspends all
disk access without closing the running applications.
This ShutDown method shuts down OS/2 immediately without any further user interaction,
however active programs do not get informed to write unsaved data to disk.
:p.When activating the :hp9.Ignore Autostart:ehp9. checkbox, PC/2 doesn't
ask you to continue ShutDown of OS/2, but performs a ShutDown as the WPS does.
This is described in more detail at the
:link reftype=hd res=&DDID_PAGE1..Virtual Desktop Settings:elink. help.
This ShutDown method may take a while and usually required user interaction,
however all applications get the chance to write unsaved data to disk.
:dt.:artwork name='Help.bmp' runin align=left.:hp9.PC/2 Help:ehp9.
:dd.Selecting this icon changes the pointer to a window pointer cursor and displays
PC/2's online help you are reading now.
:edl.
:p.:link reftype=hd res=&ID_DESKTOPDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_PC2SPOOLERWINDOW..<Forward>:elink.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for the Spooler window.                                       *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************
:h1 res=&ID_PC2SPOOLERWINDOW..PC/2's Spooler Control Window
:p.PC/2 supports a Spooler Control Window, which is simply a container filled
with the available printer queue and job information available on the local
machine PC/2 is running.
:p.To change the font of the Spooler Control Window, just drag a font
from the Font Palette to the Spooler Control Window container. This
font will be saved the next time you exit PC/2.
The PC/2 Spooler was primarily added to be able to manage print jobs on systems
PC/2 is running as a WPS replacement. Any WPS replacement has to start the
OS/2 spooler and provide a mechanism to manage print jobs.
:p.To be able to display PC/2's Spooler Control Window, you must select the
menuitem :hp9.PC/2 Spooler:ehp9. from PC/2's Popup Menu (of course you have to
add this menuitem via the
:link reftype=hd res=&MDID_CONTROLDIALOG..Control Addition:elink. dialog.
:p.If the container is empty, PC/2 can't find any printer queue on your local
workstation.
:dl tsize=12 break=fit.
:dthd.:hp4.Menuentry&colon.
:ddhd.Description&colon.:ehp4.
:dt.:hp9.Refresh:ehp9.
:dd.Select this item to refresh the Spooler window container immediately from
the real-time printer queue status of the local workstation. When you don't select
this item, the Spooler window container gets refreshed regularly.
:dt.:hp9.Hold job:ehp9.
:dd.Select this item to set the currently selected job(s) to hold status.
:dt.:hp9.Release job:ehp9.
:dd.Select this item to set the currently selected job(s) to normal status
(this request will be ignored for jobs being in the normal status).
:dt.:hp9.Delete job:ehp9.
:dd.Select this item to delete the currently selected job(s). The jobs will be
removed from the printer queue by the OS/2 spooler in a few seconds.
:dt.:hp9.Hold queue:ehp9.
:dd.Select this item to suspend the currently selected queue(s). All jobs running
in these queues will suspended from printing, too.
:dt.:hp9.Release queue:ehp9.
:dd.Select this item to set the currently selected queue(s) to the normal status
(this request will be ignored for queues being in the normal status).
:dt.:hp9.Help:ehp9.
:dd.Selecting this item just displays the online help panel you are currently
reading.
:edl.
:p.:link reftype=hd res=&ID_OVERVIEWHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_COMPATIBILITY..<Forward>:elink.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected compatibility information                                          *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_COMPATIBILITY..PC/2's Compatibility with other applications
:p.This section provides information about compatibility with some (but certainly not
all) useful packages. (EWS is the abbrevation for Employee Written Software, a
program of IBM to promote programs written by its emplyees outside of IBM.
OS2TOOLS is the OS/2 utilities archive on the IBM internal use only IBMPC conference
disk.)
:dl tsize=12 break=fit.
:dthd.:hp4.Program&colon.
:ddhd.Compatibility information.:ehp4.
:dt.:hp9.BOOTOS2:ehp9.
:dd.This package, available as EWS (or from OS2TOOLS), allows you to create a bootable
system to either diskette or harddisk. 
The bootable system can range from a single command prompt, over a PM to
a complete WPS setup. This is useful for creating a bootable maintenance partition on
a logical FAT (because HPFS requires a CHKDSK when not shut down correctly) drive
(requiring under 10 MB disc space), allowing you to recover a
unbootable production partition (e.g. changes in CONFIG.SYS which made it unbootable)
or to remove files, which would have been locked when booting from your production partition.
:p.After creating a PM setup, the standard OS/2 command processor
CMD.EXE is your Workplace Shell process.
:p.By replacing the line :hp4.SET RUNWORKPLACE=\OS2\CMD.EXE:ehp4., which
:hp4.BOOTOS2:ehp4. creates in your :hp9.CONFIG.SYS:ehp9., by
:hp4.SET RUNWORKPLACE=\PC2\PC2.EXE:ehp4., assuming you have installed PC/2 into the
directory :hp4.\PC2:ehp4. on the boot drive, PC/2 will be a more comfortable
Workplace Shell process. You can of course copy your existing :hp9.PC2.CFG:ehp9. file
to this directory, to continue fast access to your favorite programs.
:dt.:hp9.IPFCPREP:ehp9.
:dd.This package, available as EWS (or from OS2TOOLS) is a great help for writing
online help panels (that is compiling *.IPF files into *.HLP files).
This package contains a preprocessor that adds conditional compiling, macros and
some more things, which the IPFC (Information Presentation Facility Compiler) is
definitely missing.
:dt.:hp9.PMPRINTF:ehp9.
:dd.This package, available as EWS (or from OS2TOOLS) is a great help for debugging
PM programs.
This package contains an object named :hp4.PRINTF.OBJ:ehp4., which can be linked in
into an executable to replace the standard C-function printf(), which writes to
stdout, by a printf() that forwards the output into the window of a PM server
application.
This allows real-time traces of stdout output, which you can get otherwise for PM
programs only by redirecting stdout to a file, and analysing the file afterwards.
:dt.:hp9.PMSPY:ehp9.
:dd.This package, available from OS2TOOLS is a great help for debugging
PM messaging.
This package consists of a spy, which allows you the see (of course you may define
filters to see only some of) all PM messages sent within a process and between processes.
:dt.:hp9.PMTREE:ehp9.
:dd.This package, available as EWS (or from OS2TOOLS) or is a great help for analysis
of the hierarchy of all PM windows and within PM windows.
It allows you to see which controls a window consist of, and which styles, resources,
process IDs, window text, position and size,... are assigned to a window.
:dt.:hp9.OS/2 2.x:ehp9.
:dd.PC/2 was successfully tested with OS/2 2.10 and 2.11 US. It may also be compatible
with OS/2 2.00, but this was not tested.
:dt.:hp9.OS/2 WARP:ehp9.
:dd.PC/2 is fully compatible with OS/2 WARP. Using previous versions of PC/2
(1.70 and before) may cause problems when using the :hp4.Virtual Desktop:ehp4..
Of course, you can continue to use the Launchpad together with PC/2.
:edl.
:p.:link reftype=hd res=&ID_PC2SPOOLERWINDOW..<Backward>:elink.
                                :link reftype=hd res=&ID_FAQ..<Forward>:elink.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected error help.                                                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_ERRORHELP..Help for PC/2 Errors
:p.PC/2 can't verify all user input for validity, so some user input may cause
some PC/2 functions to fail. In this case, a message box is displayed containing
the module and the sourcecode linenumber that failed. Also, an error message is
displayed, containing which error occurred and what should be done to resolve the
problem.
:p.E.g. you might've configured to start the program :hp4.VIEW.EXE:ehp4. by
writing :hp4.c&colon.\os3\view.exe:ehp4. in the entryfield :hp9.Path and Filename:ehp9.
in the Program Installation dialog. This of course leads to an error, because when
OS/2 tries to start this item, it can't find the directory :hp4.\os3\:ehp4. simply
because it should read :hp4.\os2\:ehp4.. A message box is displayed saying an
error occurred, and that the user input should be corrected.
:p.Some messages aren't even errors, just warnings (e.g. the message that informs
you that the file PC2.INI does not exist or must be updated from a previous version
of PC/2).
:p.:link reftype=hd res=&ID_COMPATIBILITY..<Backward>:elink.
                                :link reftype=hd res=&ID_FAQ..<Forward>:elink.

:h2 res=&HELP_PC2LOADED..Help for running PC/2
:p.PC/2 detected that one instance of PC/2 is already running
in your system. PC/2 can only be run once concurrently, this instance
will therefore shutdown itself.
:p.Please ensure that only one instance of PC/2 gets started concurrently,
to avoid this error message.
This limitation also applies when running two different versions of PC/2,
which also may trap all instances of PC/2 due to version incompatibilities.

:h2 res=&HELP_DLLLOADED..Help for loading DLLs
:p.PC/2 requires access to the DLL :hp4.PC2HOOK.DLL:ehp4..
OS/2 reported that this DLL or a function within this DLL couldn't be loaded
successfully.
:p.Please ensure that :hp4.PC2HOOK.DLL:ehp4. is in the directory PC/2
was started from.
You should also ensure that you don't use the DLL from another version of PC/2,
because they are very likely incompatible.
You can check the version by comparing the file dates, which should be
identical.

:h2 res=&HELP_PC2INI..Help for accessing PC2.INI
:p.A problem occurred accessing the profile :hp9.PC2.INI:ehp9..
You will usually get this message when :hp9.PC2.INI:ehp9. can't be accessed,
either because PC/2 can't read from it, or write to it.
:p.When you are running PC/2 for the first time, this message just
informs you that an empty or non-existant profile was found.
Once you enter some configuration data, PC/2 will then create
this file, which will then be used for future invocations.

:h2 res=&HELP_PC2SPOOLDLL..Help for loading PC2SPOOL.DLL
:p.PC/2 requires access to the DLL :hp8.PC2SPOOL.DLL:ehp8..
OS/2 reported that this DLL or a function within this DLL couldn't be loaded
successfully.
:p.Please ensure that :hp8.PC2SPOOL.DLL:ehp8. is in the directory PC/2
was started from.
You should also ensure that you don't use the DLL from another version of PC/2,
because they are likely incompatible.
You can check the version by comparing the file dates, which should be
identical.
:p.This message is only informational - you may continue using PC/2,
however the :hp9.Spooler:ehp9. interface is disabled.

:h2 res=&HELP_PC2THREAD..Help for creating working thread
:p.To improve overall system performance, OS/2 was designed to support multithreading
for applications.
PC/2 also uses this feature, to perform time-intensive tasks with a
second working thread, to avoid unresponsiveness of PM.
:p.During creation of this working thread, an error occurred.
PC/2 will not be able to continue.
:p.You may have run out of resources - close some windows or applications
and retry.
You may have run out of threads; if you are using applications that take
full power using multiple threads, increase the :hp4.THREADS:ehp4. count
in your :hp9.CONFIG.SYS:ehp9. then.

:h2 res=&HELP_PC2CFG..Help for accessing PC2.CFG
:p.A problem occurred accessing the profile :hp9.PC2.CFG:ehp9., or the profile you specified
using the :hp4.-Profile:ehp4. commandline parameter.
You will usually get this message when :hp9.PC2.CFG:ehp9. can't be accessed,
either because PC/2 can't read from or write to.
:p.When you are running PC/2 for the first time, this message just
informs you that an empty or non-existant profile was found.
Once you enter some configuration data, PC/2 will create this file,
and use it for future invocations.

:h2 res=&HELP_PC2HOOK..Help for PC/2's hooks
:p.PC/2 requires to be able to hook into two hooks provided by OS/2 - (the
Input hook and the Sendmessage hook), in order to intercept mouse movements,
key presses and window positioning.
:p.If you experience this error during initialization of PC/2, you
can't continue.
Ensure that :hp4.PC2HOOK.DLL:ehp4. is accessible in the directory you installed
PC/2 into, and rerun PC/2 again.
:p.If you experience this error during shutdown of PC/2 it is
recommended to shut down OS/2 to avoid possible data loss.

:h2 res=&HELP_CREATEDIALOG..Help for dialog creation
:p.You selected an option that required further user intervention.
PC/2 tried to load a dialog window to get the necessary user
input, but loading the dialog failed.
:p.You may have run out of resources.  Close some windows and applications and
retry again.

:h2 res=&HELP_SETPATH..Help for changing directory
:p.PC/2 tried to change the current working directory on a drive.
OS/2 reported that a call accessing the directories was unsuccessful, however you may
ignore this message and continue your work.
:p.You may notice that a selected session didn't get started, or the working
directory on a drive wasn't changed correctly.

:h2 res=&HELP_PRIORITY..Help for changing priority
:p.PC/2 allows you to specify the priority for some session types,
which required PC/2 to change its priority, because the current
priority gets inherited to sessions started by PC/2
:p.You may ignore this message and continue your work, however a shut down is
suggested to avoid potential data loss.

:h2 res=&HELP_LAUNCH..Help for starting a session
:p.An error occurred when PC/2 tried to launch the selected session.
You may verify the parameters you entered for the session and retry the
operation.
:p.If a module name is given, that is a DLL of the product to be started,
you may have to add this DLL to a path pointed to by the LIBPATH environment
variable, or alternatively specify the BEGINLIBPATH or ENDLIBPATH settings
under OS/2 Warp.
:p.You may also check the following items:
:ul.
:li.Is the executable's name correctly spelled?
:li.If you don't have specified a working directory, does the executable's name
include full path information?
:li.Is the working directory spelled correctly?
:li.Are all DLLs required by the application accessible for the OS/2 loader?
(Refer to your application's documentation on how to install the product correctly.)
:li.Is the application's environment specified correctly?
:li.Is the application's session type specified correctly?
:li.Have you tried to start the application through a command processor (CMD.EXE
for OS/2 programs, or COMMAND.COM for DOS programs)?
:li.Have you tried to start the application using the same parameters as entered in
the application's Program Installation notebook in a command processor window?
:eul.
:p.If the failure persists, you may have run out of resources, close some
windows and applications and retry again.
You may have run out of threads.  If you are using applications that take
full power using multiple threads, increase the :hp4.THREADS:ehp4. count
in your :hp9.CONFIG.SYS:ehp9. then.

:h2 res=&HELP_MEDIA..Help for accessing media
:p.PC/2 tried to access removable or non-removeable media to
determine the media's parameters.
OS/2 reported that a call accessing the media was unsuccessful, however you may
ignore this message and continue your work.
:p.You may notice that a selected session didn't get started, or the working
directory on a drive wasn't changed correctly.

:h2 res=&HELP_PC2RUNNINGASWPS..Help for PC/2 as WorkPlace process
:p.When running PC/2 as WorkPlace Shell (WPS) process, you will not
be able to close, and therefore terminate, PC/2.
PC/2 will ignore any requests to close from the Window List and the Menuentry
and Smarticon to close PC/2 are disabled during PC/2's initialization.
:p.This is not a limitation of PC/2, OS/2 always restarts the application
configured as the WorkPlace process, when this process terminates for some reason.
You may have noticed that the WPS itself gets restarted when it traps due to
an error caused by itself or its registered WPS Objects.
:p.If you no longer want to use PC/2 as the WorkPlace process, please
refer to :link reftype=hd res=&ID_INSTALLATIONHELP..Installing PC/2:elink. on how
to undo the changes you made to use the PC/2 as the WorkPlace process.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected FAQ help.                                                          *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_FAQ..Help Questions &amp. Answers
:p.The following questions and answers is the online help version of
:hp4.PC2.FAQ:ehp4..
:p.
:font facename=Courier size=8x4.
:xmp.
.im ..\PC2.FAQ
:exmp.
:font facename=default size=0x0.
:p.:link reftype=hd res=&ID_ERRORHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_HELP..<Forward>:elink.


:euserdoc.

