/* REXX */

parse arg oldini newini tmpini garbage

if (tmpini = "" ) | (garbage <> "") then signal usage

say
say "Merging your customizations:"
say "  from: " oldini 
say "  into: " newini 
say "  using:" tmpini " as a template"
say

/* Load RexxUtil extensions */
if RxFuncQuery("SysLoadFuncs") then do
    say "loading RexxUtil extensions..."
    call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    if result \= "0" then do
        say "error loading RexxUtil.dll"
        exit
    end
    call SysLoadFuncs
end

/* read old 'nftp.ini' and gather meaningful strings in it */
/*say "Your customized lines to be migrated into new file :"
say copies("-", 70)*/
signal off notready
i = 0
do forever
    lin = linein(oldini)
    if (left(lin,1) <> "[") & (left(lin,1) <> ";") & (verify(lin, " ") <> 0) then 
       do
         input.i = lin
         i = i + 1
       end
    if lin = "" & left(stream(oldini),5) <> "READY" then leave
end
call stream oldini, "C", "CLOSE"
nlines = i
/*say copies("-", 70)*/

/* updating ooooold things */

do i = 0 to nlines-1
   if substr(input.i, 1, 15) = "bookmarks-file=" then
      do
        n = pos(".mrk", input.i)
        if n <> 0 then input.i = overlay(".bmk", input.i, n)
      end
end

/* filter out new file and merge customizations into it */
Call SysFileDelete newini
do forever
    lin = linein(tmpini)
    ln = pos("=", lin)
    if left(lin,1) = ";" & length(lin) > 1 & ln > 1 then
    do i = 0 to nlines-1
        if substr(lin, 2, ln-1) = left(input.i,ln-1) then
        do
            say "updating" input.i
            lin = input.i
        end
    end
    rc = lineout(newini, lin)
    if lin = "" & left(stream(tmpini),5) <> "READY" then leave
end
call stream tmpini, "C", "CLOSE"
call stream newini, "C", "CLOSE"

return

usage:
    
    say
    say "Usage: updini <old-nftp.ini> <new-nftp.ini> <template-nftp.ini>"
    say "Merges old and new NFTP.INIs. All parameters are obligatory."

    exit 1
