/*
 REXX program to extract statistics from NFTP.FLS file     Version 0.2
 Freely distributable, but copyright by Tth Ferenc <etus@alarmix.net>
 Please mail any suggestinos and/or bug report to the author.
 
 To do:
 - option to count uploads/downloads separately
 - option to sort sites according to speed or down/upload size
 - option to list only specified time interval or sites
 */

inputfile = "list.txt"
outputfile = "nftp.sta"

"@del" outputfile ">nul 2>&1"

parse arg inputfiles

if inputfiles="" then
do
    say
    say "NFTP statistics requires a parameter: the name of the log file."
    say "This can contain wildcard characters, so you can process more files easily."
    exit
end

"@copy "inputfiles" list.txt > nul"

noecho = LINEOUT(outputfile, "Date      Megabyte     average speed (cps)")
noecho = LINEOUT(outputfile, "------------------------------------------")

/* Calculate the number of files and store their date/time, size etc. */
files=1
DO WHILE LINES(inputfile) > 0
    line = LINEIN(inputfile)
    month.files = SUBSTR(line, 4, 2)
    year.files = SUBSTR(line, 7, 2)
    time.files = SUBSTR(line, 10, 5)
    size.files = SUBSTR(line, 16, 9)
    if pos("(", line) = 0 then
    do
    /* old style log without speed */
        speed.files = 1
        site.files = SUBSTR(line, 27, POS(":", line, 27)-27)
    end
    else
    do
    /* new style with speed */
        speed.files = SUBSTR(line, 26, 7)
        site.files = SUBSTR(line, 40, POS(":", line, 40)-40)
    end
    if speed.files = 0 then speed.files = 1
    site = site.files
    bytespersite.site=0
    timepersite.site=0
    files=files+1
    END
files=files-1
month=month.1
year=year.1
bytes=0
time=0
total=0
totaltime=0

/* summary */
do counter=1 to files
    site = site.counter
    bytespersite.site=bytespersite.site + size.counter
    timepersite.site=timepersite.site+size.counter/speed.counter
    
    if (month.counter = month) & (year.counter = year) then do
        bytes=bytes+size.counter
        time=time+size.counter/speed.counter
    end
    else
    do
        if time=0 then time=1
        speed=FORMAT(bytes/time,16,0)
        if speed > 999 then speed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(speed)), 3)),16)
        byte=FORMAT(bytes/1024/1024,8,2)
        donotecho = LINEOUT(outputfile, month"/"year||byte||speed)
        
        total=total+byte
        totaltime=totaltime+time
        month=month.counter
        year=year.counter
        bytes=size.counter
        time=size.counter/speed.counter
    end
    END

if time=0 then time=1
speed=FORMAT(bytes/time,16,0)
if speed > 999 then speed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(speed)), 3)),16)
byte=FORMAT(bytes/1024/1024,8,2)
donotecho = LINEOUT(outputfile, month"/"year||byte||speed)

noecho = LINEOUT(outputfile, "")
noecho = LINEOUT(outputfile, "Site                                      Megabyte     average speed (cps)")
noecho = LINEOUT(outputfile, "--------------------------------------------------------------------------")
noecho = LINEOUT(outputfile, "")

do numsites=1 to files
    site=site.numsites
    if numsites > 1 then
    do
        check = numsites -1 
        do while (site.check <> site) & (check > 0)
            check = check - 1
        end
    end
    
    if (site.check<>site) then do
        if timepersite.site=0 then timepersite.site=1
        speed=FORMAT(bytespersite.site/timepersite.site,16,0)
        if speed > 999 then speed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(speed)), 3)),16)
        byte=FORMAT(bytespersite.site/1024/1024,8,2)
        if speed=1 then speed=""
        donotecho = LINEOUT(outputfile, overlay(" ", site,38,0)||byte||"    "||speed)
    end
end

totalspeed=FORMAT(total*1024*1024/totaltime,16,0)
if totalspeed > 999 then totalspeed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(totalspeed)), 3)),16)
noecho = LINEOUT(outputfile, "--------------------------------------------------------------------------")
noecho = LINEOUT(outputfile, "Total           " right(total, 31) right(totalspeed, 19))
noecho = LINEOUT(list.txt)
"@del list.txt"
EXIT
