/*

  REXX Script to install Internet Adventurer - and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "-----------------------------"
say "|                           |"
say "|   Thank you for chosing   |"
say "|                           |"
say "| Internet Adventurer v0.96 |"
say "|                           |"
say "-----------------------------"
say ""
say "-----------------------------"
say "| Installing...             |"
say "-----------------------------"

dir = directory() || '\'

dir2 = substr(dir, 1, 2) || '"' || substr(dir, 3, length(dir)-2)
say ""
say "-----------------------------"
say "| Creating folders...       |"
say "-----------------------------"
call SysCreateObject "WPFolder", "Internet" || d2c(10) || "Adventurer", "<WP_DESKTOP>", "OBJECTID=<INETADVFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "backfldr.bmp,T;ICONFILE=" || dir || "INETADV.ICO", "replace"
call SysCreateObject "WPFolder", "Utilities", "<INETADVFOLDER>", "OBJECTID=<INETADVUTILS>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "backfldr.bmp,T", "replace"

say ""
say "-----------------------------"
say "| Creating program icons... |"
say "-----------------------------"
call SysCreateObject "WPProgram", "Uninstall", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS= /C" dir2 || 'UNINST.CMD"', "replace"
call SysCreateObject "WPProgram", "Restore Configuration", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C" dir2 || 'COPYINI.CMD" INETADV.INI OS2' || ";STARTUPDIR=" || dir, "replace"
call SysCreateObject "WPProgram", "Backup Configuration", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C" dir2 || 'COPYINI.CMD" OS2 INETADV.INI' || ";STARTUPDIR=" || dir, "replace"
call SysCreateObject "WPProgram", "Edit quicklist.txt", "<INETADVUTILS>", "EXENAME=E.EXE;PARAMETERS=" || dir || "QUICKLST.TXT;STARTUPDIR=" || dir, "replace"
call SysCreateObject "WPProgram", "Import quicklist" || d2c(10) || "from quicklist.txt", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'QIMPORT.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Export quicklist" || d2c(10) || "to quicklist.txt", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'QEXPORT.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Import quicklist" || d2c(10) || "from WebExplorer", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'IMPORT.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Import quicklist" || d2c(10) || "from Netscape", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'IMPNETSC.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Restore original quicklist" || d2c(10) || "Warning: Current will be lost", "<INETADVUTILS>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'qimport.cmd" orgquick.lst replace;STARTUPDIR=' || dir, "replace"

call SysCreateObject "WPProgram", "Internet Adventurer", "<INETADVFOLDER>", "EXENAME=" || dir || "INETADV.EXE;STARTUPDIR=" || dir
call SysCreateObject "WPProgram", "Internet Adventurer" || d2c(10) || "(with Netscape)", "<INETADVFOLDER>", "EXENAME=" || dir || "INETADV.EXE;STARTUPDIR=" || dir || ";PARAMETERS=/P:iaplugns.cfg"
call SysCreateObject "WPProgram", "Readme", "<INETADVFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir2 || 'README.TXT"', "replace"
call SysCreateObject "WPProgram", "Internet Adventurer" || d2c(10) || "Documentation", "<INETADVFOLDER>", "EXENAME=VIEW.EXE;PARAMETERS=" || dir2 || 'INETADV.INF"', "replace"
call SysCreateObject "WPProgram", "Get legal and" || d2c(10) || "Register", "<INETADVFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir2 || 'REGISTER.TXT"', "replace"
call SysCreateObject "WPProgram", "Register Online", "<INETADVFOLDER>", "EXENAME=" || dir || "PURCHASE.EXE;STARTUPDIR=" || dir
call SysCreateObject "WPProgram", "License" || d2c(10) || "Agreement", "<INETADVFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir2 || 'LICENSE.TXT"', "replace"

if (stream('article.dat', 'c', 'query exists') \= '' & stream('news.p', 'c', 'query exists') \= '') then do
   say ""
   say "Delete news database ? (must be done when installing over v0.25 or v0.26)"
   parse upper pull answer .

   if left(answer, 1) \= 'Y' then do
      say "Installation completed - not deleting news database"
      exit
   end

   say "Deleting news database"
   'del art*'
   'del newsgrp.*'
   'del news.p'
end

if (stream('quicklst.dat', 'c', 'query exists') = '') then do
   say "Installing default quicklist database"
   'cmd /c qimport.cmd orgquick.lst replace'
end

say ""
say "-----------------------------"
say "|                           |"
say "| Installation completed!   |"
say "|                           |"
say "| To start, doubleclick on  |"
say "| the Internet Adventurer   |"
say "| folder on your desktop    |"
say "|                           |"
say "-----------------------------"
