/*

  REXX Script to copy Internet Adventurer settings from one .INI file to
  to another

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

parse upper arg from to
if from = '' | to = '' then do
   say "Syntax: COPYINI <from> <to>"
   say "Where <from> = From .INI name (or OS2) for OS2.INI"
   say "Where <to>   = To .INI name (or OS2) for OS2.INI"
   say "Example: COPYINI inetadv.ini OS2"
   exit
end

say "Copying Internet Adventurer settings from" from "to" to

if from = 'OS2' then
   from = 'USER'
if to = 'OS2' then
   to = 'USER'

APP = "Internet Adventurer"

call SysIni FROM, APP, 'All:', 'Keys'
if Result \= 'ERROR:' then do
   do i = 1 to Keys.0
      val = SysIni(from, APP, Keys.i)
      call SysIni to, APP, Keys.i, val
   end
end

say 'Copying completed'
