/*

  REXX Script to list Internet Adventurer settings 

  Written by Juergen Hermann | http://www.schiele-ct.de/jh | IRC: SNIBRIL

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

parse upper arg inifile
if inifile = '' then do
    say "Syntax: LISTINI <name>"
    say "Where <name> = .INI name (or OS2) for OS2.INI"
    say "Example: LISTINI OS2"
    exit 1
end

if inifile = 'OS2' then inifile = 'USER'

Z   = '00'x
APP = "Internet Adventurer"
say "/*" APP "settings in" inifile "("space(date(),1,'-') time()") */"
say "Z = '00'x"

rc = SysIni(inifile, APP, 'All:', 'Keys')
if rc \= 'ERROR:' then do
    do i = 1 to Keys.0
        val = SysIni(inifile, APP, Keys.i)

        if rc \= 'ERROR:' then do
            if val = '' then val = '""'
            else do
                valx = left(val, length(val)-1)
                valz = right(val,1)

                if valz = Z & verify(valx, xrange('20'x,'7F'x) ,
                        || '') == 0 then
                    val = quotify(valx)'Z'
                else 
                    val = '"'c2x(val)'"x'
                say 'call SysIni' quotify(inifile)','  quotify(APP)',' ,
                                  quotify(Keys.i)',' val
                end
            end
        else say "/* Can't get data or key" Keys.i "*/"
        end
    say '/* Listing complete */'
    end
else say "/* Can't get application keys */"

exit 0

quotify: procedure
    return translate(space('"'translate(arg(1),'0120'x, '2022'x)'"', 2,'"'), ,
                     ' ','01'x)
