/* 

Import WebExplorers's quicklist into Internet Adventurer !
by Kim Rasmussen - based upon another rexx script by Eony G. Flatscher

Original comment:

program: wequickl.cmd
type:    REXXSAA-OS/2
purpose: read WebExplorer's quicklist entries and generate 
WPS-URL-objects
version: 1.0
date:    1995-06-05

usage:   wequickl
         ... generates WPS-URL-objects from WE-quicklist in explore.ini
author:  Rony G. Flatscher, Wirtschaftsuniversitaet/Vienna

standard disclaimer:

All rights reserved, copyrighted 1995, no guarantee that it works without
errors, etc. etc.

donated to the public domain granted that you are not charging anything
(money etc.) for it and derivates based upon it, as you did not write it,
etc. if that holds you may bundle it with commercial programs too
*/

 
IF RxFuncQuery('SysLoadFuncs') THEN
DO
    /* load the RexxUtil-load-function                                        */
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    /* load all the Sys* utilities via "SysLoadFuncs"                         */
    CALL SysLoadFuncs
END

say "Trying to load/register Internet Adventurer REXX API"
if RxFuncQuery("IARX_Register") <> 0 then do
   rc = RxFuncAdd("IARX_Register","IA_UTILS","IARX_Register")
   if rc <> 0 then do
      say "-------------------------------------"
      say "Error loading Internet Adventurer API"
      say "-------------------------------------"
      exit(1)
   end
end

rc = IARX_Register();
if rc then do
   say "-------------------------------------"
   say "Error loading Internet Adventurer API"
   say "-------------------------------------"
   exit(1)
end

say "Opening database"
ptr = IARX_QOpenDatabase();
if length(ptr) > 0 then do
   say "-------------------------------------"
   say "Opening database gave this:" ptr
   say "-------------------------------------"
   exit(1)
end

say "Database opened"
                                             /* get full path for explore.ini */
explore_ini = VALUE("ETC", , "OS2ENVIRONMENT") || "\explore.ini"

IF STREAM(explore_ini, "C", "QUERY EXISTS") = "" THEN
   CALL error explore_ini": WebExplorer INI-file does not exist !"

/* get quicklist entries (titles and URLs)                                    */

i = 0                                           /* counter for array index    */
quicklist_found = 0                             /* boolean, false             */
quicklist.0 = 0                                 /* indicate no items in array */
url_next    = 0                                 /* indicate if URL expected   */

CALL STREAM explore_ini, "C", "OPEN READ"       /* open file for reading only */
DO WHILE CHARS(explore_ini) > 0                 /* as long as lines left      */
   line = LINEIN(explore_ini)                   /* read line                  */

   IF LEFT(line, 1) = "[" THEN                  /* new section found          */
   DO
      IF \quicklist_found THEN                  /* quicklist section ?        */
      DO
         IF TRANSLATE(line) = "[QUICKLIST]" THEN  /* is it the quicklist part?*/
            quicklist_found = 1
         ITERATE                                /* jump to top, read next line*/
      END
      ELSE                                      /* quicklist section is over  */
         LEAVE
   END

   IF \quicklist_found THEN ITERATE             /* skip line                  */

   IF \url_next THEN                            /* title in hand              */
   DO
      i = i + 1                                 /* new entry, increase index  */
      PARSE VAR line "quicklist= " title        /* parse URL itself           */
      quicklist.i.eTitle = title                /* save title of URL          */
   END
   ELSE
      quicklist.i.eURL   = line                 /* save URL                   */

   url_next = \url_next                         /* switch boolean value       */
END

quicklist.0 = MAX(0, i - 1)                     /* save # of items in array   */
CALL STREAM explore_ini, "C", "CLOSE"           /* close input file           */

IF quicklist.0 = 0 THEN
   CALL error explore_ini || ": no quicklist items found!"


q.id = 0
q.parent = 0
q.children = 0
q.type = 0
q.title = "Imported from WebExplorer"
q.nick = ""
q.url = ""

rc = IARX_QCreate("q")
if rc <> 0 then do
   say "Unable to create group - aborting..."
   rc = IARX_QCloseDatabase()
   exit
end

parent_id = q.id

/* create WE-objects, if they don't exist yet in top folder 
*******************/
DO i = quicklist.0 TO 1 BY -1                   /* loop over array            */
   SAY right(i,3) quicklist.i.eTitle            /* show index, URL-title      */
   SAY right("", 3) quicklist.i.eURL            /* show URL                   */

   q.id = 0
   q.parent = parent_id
   q.children = 0
   q.type = 1
   q.title = quicklist.i.eTitle
   q.nick = ""
   q.url = quicklist.i.eURL

   rc = IARX_QCreate("q")
   if rc <> 0 then
      say "Can't create item - error" rc
   else
      say "Item created"
end

SAY
SAY "total of" quicklist.0 "quicklist entries processed."

rc = IARX_QCloseDatabase()
EXIT

/*
   little procedure, to tell whether creation was successfully, 
   expects boolean (0 = false, 1 = true)
*/
FEEDBACK_MESSAGE: PROCEDURE
   IF ARG(1) THEN RETURN "successful."
             ELSE RETURN "*** NOT succesful *** (one reason: maybe it exists ?)"
/*
   procedure to tell error and exit with a negative return code
*/
ERROR:
   SAY "ERROR:" ARG(1) "aborting ..."
   rc = IARX_QCloseDatabase()
   EXIT -1





