/* error.c
   Error code translation.
   */

#define INCL_DOSERRORS
#include <os2.h>

#include "error.h"
#include "MacFS/errors.h"

/* Translate MacFS error code to an OS/2 error code. */
int os2_error(int macfs_error)
{
  int rc;

  if(macfs_error >= 0)
    return NO_ERROR;

  switch(macfs_error) {
  case READVIFAILED:
  case READVIOUTOFMEM:
  case READSECTFAILED:
    rc = ERROR_READ_FAULT;
    break;

  case WRITEVIFAILED:
  case WRITEVIOUTOFMEM:
  case WRITESECTFAILED:
  case WRITESECTUNBUFFAILED:
    rc = ERROR_WRITE_FAULT;
    break;

  case WRITEPROTECT:
    rc = ERROR_WRITE_PROTECT;
    break;

  case NOTHFSDISK:
  case INITREADWRITEFAILED:
  case INVALIDSTATEREC:
  case CLOSEREADWRITEFAILED:
    rc = ERROR_GEN_FAILURE;
    break;

  case MGROWNOTENOUGHSPACE:
    rc = ERROR_DISK_FULL;
    break;

  default:
    rc = -1;
  }

  return rc;
}



