#include "../defs.h"
#include "../mountrec.h"
#include "../Lock/lock.h"
#include "local_btree.h"
#include "../errors.h"



static int PhysicToCatalogRecord(BYTE *p_rec, int rec_len, 
				 CATALOG_RECORD *cat);

static int CatalogRecordToPhysic(CATALOG_RECORD *cat, BYTE *p_rec, 
				 int* rec_len); 


int    GetCatalogRecord(MOUNT_RECORD *mnt, LONGWORD parentid, 
			char* name, CATALOG_RECORD *cat,
			LONGWORD *foundparentid,
			char * foundnamebuff)  {

BYTE *p_rec;
BT_KEY key, found_key;
int err, out, rec_len;
SEARCH_STACK_ELEM stack[BT_MAX_DEPTH+1];
BYTE buffer[BT_NODESIZE];

  CHKERR(KeyBldCat(parentid, name, key)); /* Build the search key */

  lock(mnt->catalog.tree_lock);
					/* Search for the key */
  out = BT_Search(mnt, &(mnt->catalog), key, &p_rec, &rec_len, 
		  stack, found_key, buffer);  

  unlock(mnt->catalog.tree_lock);

  switch(out) {
  case 0:
  case BT_FOUNDLESS:
    CHKERR(KeyUnBldCat(found_key, foundparentid, foundnamebuff)); 
    CHKERR( PhysicToCatalogRecord( p_rec, rec_len, cat));
    return(out);
  default:
    return(out);
  }  

}


int    PutCatalogRecord(MOUNT_RECORD *mnt,LONGWORD parentid,
			char* name, CATALOG_RECORD *cat)  {

int err;
BT_KEY key;
BYTE rec[MAX_RECORD_LENGTH];		/* A full catalog record */
int len1, len2;


  CHKERR(KeyBldCat(parentid, name, key)); /* Build the search key */

  bcopy(key, rec, len1 = KeyLength(key));

  CHKERR(CatalogRecordToPhysic(cat, & rec[len1], &len2));
  lock(mnt->catalog.tree_lock);

  err = BT_PutRecord(mnt, & mnt->catalog, key, rec, len1 + len2);

  unlock(mnt->catalog.tree_lock);
  return err;
}


int    DelCatalogRecord(MOUNT_RECORD *mnt,LONGWORD parentid,
			char* name)  {

int err;
BT_KEY key;


  CHKERR(KeyBldCat(parentid, name, key)); /* Build the search key */

  lock(mnt->catalog.tree_lock);

  err = BT_DelRecord(mnt, & mnt->catalog, key);

  unlock(mnt->catalog.tree_lock);

  return err;
}





static int PhysicToCatalogRecord(BYTE *p_rec, 
				 int rec_len,
				 CATALOG_RECORD *cat)  {
                                        /* Fill the catalog record */
					/* structure from the physical */
					/* structure */
int i;

  cat->cdrType   = GetByte(& p_rec[CDR_TYPE]);
  cat->cdrResrv2 = GetByte(& p_rec[CDR_RESRV2]);

  switch(cat->cdrType) {
  case CDR_DIR:
    if(rec_len < DIR_RESRV + 16)
      return(BT_BADRECORD);

    cat->U.cdrDirRec.dirFlags    = GetWord(& p_rec[DIR_FLAGS]);
    cat->U.cdrDirRec.dirVal      = GetWord(& p_rec[DIR_VAL]);
    cat->U.cdrDirRec.dirDirID    = GetLongWord (& p_rec[DIR_DIRID]);
    cat->U.cdrDirRec.dirCrDat    = GetDate(& p_rec[DIR_CRDAT]);
    cat->U.cdrDirRec.dirMdDat    = GetDate(& p_rec[DIR_MDDAT]);
    cat->U.cdrDirRec.dirBkDat    = GetDate(& p_rec[DIR_BKDAT]);
    bcopy( & p_rec[DIR_USRINFO], cat->U.cdrDirRec.dirUsrInfo, 
	  sizeof(cat->U.cdrDirRec.dirUsrInfo));
    bcopy( & p_rec[DIR_FNDRINFO], cat->U.cdrDirRec.dirFndrInfo, 
	  sizeof(cat->U.cdrDirRec.dirFndrInfo));
    for(i=0;i <4;i++)
      cat->U.cdrDirRec.dirResrv[i] = GetLongWord(& p_rec[DIR_RESRV + 4*i]);

    break;

  case CDR_FILE:
    if(rec_len < FIL_RESRV + 4)
      return(BT_BADRECORD);

    cat->U.cdrFilRec.filFlags = GetByte(& p_rec[FIL_FLAGS]);
    cat->U.cdrFilRec.filTyp = GetByte(& p_rec[FIL_TYP]);
    bcopy( & p_rec[FIL_USRWDS], cat->U.cdrFilRec.filUsrWds,
	  sizeof(cat->U.cdrFilRec.filUsrWds));
    cat->U.cdrFilRec.filFlNum = GetLongWord(& p_rec[FIL_FLNUM]);
    cat->U.cdrFilRec.filStBlk = GetWord(& p_rec[FIL_STBLK]);
    cat->U.cdrFilRec.filLgLen = GetLongWord(& p_rec[FIL_LGLEN]);
    cat->U.cdrFilRec.filPyLen = GetLongWord(& p_rec[FIL_PYLEN]);
    cat->U.cdrFilRec.filRStBlk = GetLongWord(& p_rec[FIL_RSTBLK]);
    cat->U.cdrFilRec.filRLgLen = GetLongWord(& p_rec[FIL_RLGLEN]);
    cat->U.cdrFilRec.filRPyLen = GetLongWord(& p_rec[FIL_RPYLEN]);
    cat->U.cdrFilRec.filCrDat = GetDate(& p_rec[FIL_CRDAT]);
    cat->U.cdrFilRec.filMdDat = GetDate(& p_rec[FIL_MDDAT]);
    cat->U.cdrFilRec.filBkDat = GetDate(& p_rec[FIL_BKDAT]);
    bcopy( & p_rec[FIL_FNDRINFO], cat->U.cdrFilRec.filFndrInfo, 
	  sizeof(cat->U.cdrFilRec.filFndrInfo));
    cat->U.cdrFilRec.filClpSize = GetWord(& p_rec[FIL_CLPSIZE]);
    
    for(i=0;i<3;i++)  {
      cat->U.cdrFilRec.filExtRec[i].first  = GetWord(& p_rec[FIL_EXTREC + 
							     4*i]);
      cat->U.cdrFilRec.filExtRec[i].length = GetWord(& p_rec[FIL_EXTREC +
							     4*i+2]);
    }
    for(i=0;i<3;i++)  {
      cat->U.cdrFilRec.filRExtRec[i].first  = GetWord(& p_rec[FIL_REXTREC +
							      4*i]);
      cat->U.cdrFilRec.filRExtRec[i].length = GetWord(& p_rec[FIL_REXTREC +
							      4*i+2]);
    }
    cat->U.cdrFilRec.filResrv = GetLongWord(& p_rec[FIL_RESRV]);
    break;

  case CDR_DTHREAD:
    if(rec_len < THD_CNAME + 32)
      return(BT_BADRECORD);

    for(i=0;i<2;i++)
      cat->U.cdrThdRec.thdResrv[i] = GetLongWord(& p_rec[THD_RESRV+4*i]);

    cat->U.cdrThdRec.thdParID = GetLongWord(& p_rec[THD_PARID]);
    GetString(& p_rec[THD_CNAME], cat->U.cdrThdRec.thdCName);
    break;

  case CDR_FTHREAD:
    if(rec_len < THD_CNAME + 32)
      return(BT_BADRECORD);

    for(i=0;i<2;i++)
      cat->U.cdrFThdRec.fthdResrv[i] = GetLongWord(& p_rec[THD_RESRV+4*i]);

    cat->U.cdrFThdRec.fthdParID = GetLongWord(& p_rec[THD_PARID]);
    GetString(& p_rec[THD_CNAME], cat->U.cdrFThdRec.fthdCName);
    break;


  default:
    return(BT_BADCATALOGTYPE);
  }
  return 0;
}




static int CatalogRecordToPhysic(CATALOG_RECORD *cat, BYTE *p_rec, 
				 int* rec_len)  {



int i;

    	 PutByte(cat->cdrType ,& p_rec[CDR_TYPE]);
  	 PutByte(cat->cdrResrv2 ,& p_rec[CDR_RESRV2]);

  switch(cat->cdrType) {
  case CDR_DIR:
    *rec_len = DIR_RESRV +16;

    PutWord(cat->U.cdrDirRec.dirFlags ,& p_rec[DIR_FLAGS]);
    PutWord(cat->U.cdrDirRec.dirVal ,& p_rec[DIR_VAL]);
    PutLongWord (cat->U.cdrDirRec.dirDirID , & p_rec[DIR_DIRID]);
    PutDate(cat->U.cdrDirRec.dirCrDat , & p_rec[DIR_CRDAT]);
    PutDate(cat->U.cdrDirRec.dirMdDat , & p_rec[DIR_MDDAT]);
    PutDate(cat->U.cdrDirRec.dirBkDat , & p_rec[DIR_BKDAT]);
    bcopy( cat->U.cdrDirRec.dirUsrInfo, & p_rec[DIR_USRINFO], 
	  sizeof(cat->U.cdrDirRec.dirUsrInfo));
    bcopy( cat->U.cdrDirRec.dirFndrInfo,& p_rec[DIR_FNDRINFO],  
	  sizeof(cat->U.cdrDirRec.dirFndrInfo));

    for(i=0;i <4;i++)
      PutLongWord(cat->U.cdrDirRec.dirResrv[i], & p_rec[DIR_RESRV + 4*i]);

    break;
    
  case CDR_FILE:
    *rec_len = FIL_RESRV +4;
    
    PutByte(cat->U.cdrFilRec.filFlags , & p_rec[FIL_FLAGS]);
    PutByte(cat->U.cdrFilRec.filTyp , & p_rec[FIL_TYP]);
    bcopy( cat->U.cdrFilRec.filUsrWds, & p_rec[FIL_USRWDS], 
	  sizeof(cat->U.cdrFilRec.filUsrWds));
    PutLongWord(cat->U.cdrFilRec.filFlNum , & p_rec[FIL_FLNUM]);
    PutWord(cat->U.cdrFilRec.filStBlk ,& p_rec[FIL_STBLK]);
    PutLongWord(cat->U.cdrFilRec.filLgLen , & p_rec[FIL_LGLEN]);
    PutLongWord(cat->U.cdrFilRec.filPyLen , & p_rec[FIL_PYLEN]);
    PutLongWord(cat->U.cdrFilRec.filRStBlk , & p_rec[FIL_RSTBLK]);
    PutLongWord(cat->U.cdrFilRec.filRLgLen , & p_rec[FIL_RLGLEN]);
    PutLongWord(cat->U.cdrFilRec.filRPyLen , & p_rec[FIL_RPYLEN]);
    PutDate(cat->U.cdrFilRec.filCrDat , & p_rec[FIL_CRDAT]);
    PutDate(cat->U.cdrFilRec.filMdDat , & p_rec[FIL_MDDAT]);
    PutDate(cat->U.cdrFilRec.filBkDat , & p_rec[FIL_BKDAT]);
    bcopy( cat->U.cdrFilRec.filFndrInfo, & p_rec[FIL_FNDRINFO], 
	  sizeof(cat->U.cdrFilRec.filFndrInfo));
    PutWord(cat->U.cdrFilRec.filClpSize , & p_rec[FIL_CLPSIZE]);
    
    for(i=0;i<3;i++)  {
      PutWord(cat->U.cdrFilRec.filExtRec[i].first , & p_rec[FIL_EXTREC + 
							  4*i]);
      PutWord(cat->U.cdrFilRec.filExtRec[i].length , & p_rec[FIL_EXTREC +
							   4*i+2]);
    }
    for(i=0;i<3;i++)  {
      PutWord(cat->U.cdrFilRec.filRExtRec[i].first, & p_rec[FIL_REXTREC +
							   4*i]);
      PutWord(cat->U.cdrFilRec.filRExtRec[i].length, & p_rec[FIL_REXTREC +
							     4*i+2]);
    }
    PutLongWord(cat->U.cdrFilRec.filResrv, & p_rec[FIL_RESRV]);
    break;
    
  case CDR_DTHREAD:
    *rec_len = THD_CNAME + 32;
    
    for(i=0;i<2;i++)
      PutLongWord(cat->U.cdrThdRec.thdResrv[i], & p_rec[THD_RESRV + 4*i]);

    PutLongWord(cat->U.cdrThdRec.thdParID, & p_rec[THD_PARID]);
    PutString(cat->U.cdrThdRec.thdCName, & p_rec[THD_CNAME]);
    break;

  case CDR_FTHREAD:
    *rec_len = THD_CNAME + 32;

    for(i=0;i<2;i++)
      PutLongWord(cat->U.cdrFThdRec.fthdResrv[i], & p_rec[THD_RESRV + 4*i]);

    PutLongWord(cat->U.cdrFThdRec.fthdParID, & p_rec[THD_PARID]);
    PutString(cat->U.cdrFThdRec.fthdCName, & p_rec[THD_CNAME] );
    break;


  default:
    return(BT_BADCATALOGTYPE);
  }
  return 0;
}
