
#define SEEKFROMBEGINING  0
#define SEEKFROMEND       1
#define SEEKFROMCURPOS    2



#ifdef USER
int macseek(MFILE *mfile,
	    SIGNEDLONGWORD offset,
	    int whence);
/* You guessed it. */
#endif

int mread(MOUNT_RECORD *mr, 
	  CATALOG_RECORD *cr, 
	  LONGWORD start, 
	  LONGWORD numbytes, 
	  BYTE *buf,
	  LONGWORD *bytesactuallyread);
/* Reads bytes from start to start+numbytes-1 into buf.  The return value
   is nozero if an error occurred.
*/

#ifdef USER
int macread(MFILE *mfile,
	    LONGWORD numbytes,
	    BYTE *buf,
	    LONGWORD *bytesactuallyread);
#endif

int mwrite(MOUNT_RECORD *mr,
	   CATALOG_RECORD *cr,
	   LONGWORD start,
	   LONGWORD numbytes,
	   BYTE *buf,
	   LONGWORD *bytesactuallywritten);
/* Writes bytes in buf to disk from start to start+numbytes-1.  The value
   returned is nonzero if an error occurred.
*/

#ifdef USER
int macwrite(MFILE *mfile,
	     LONGWORD numbytes,
	     BYTE *buf,
	     LONGWORD *bytesactuallywritten);
#endif

int getcompleteedlist(MOUNT_RECORD *mr,
		      CATALOG_RECORD *cr,
		      EXTENT_DESCRIPTOR **edlist);
/* Returns all of the extents of the file in cr.  Positive return
   is number of extents, negative is error.
*/


int mgrowfile(MOUNT_RECORD *mr,
		CATALOG_RECORD *cr,
		WORD newnumblocks);
/* Tries to grow the file to the new number of blocks.  If and only if
   it grows to the full requested size is the return code 0.  If the
   return code is a BTREE_* error, the growth failed and the file system
   is probably inconsistent.  mgrow does not do truncation - if you try,
   you will get back MGROWDOESNTTRUNC.  MGROWNOTENOUGHSPACE means there
   wasn't enough space on the disk to grow the file, but the disk remains
   consistent.  Any other return means the disk is now iffy.  
   MGROWGREWTOWRONGSIZE is an internal error and should be reported to Peter.
*/

int mtruncatefile(MOUNT_RECORD *mr,
		  CATALOG_RECORD *cr,
		  LONGWORD newsize);
/* only truncates to zero right now. */
