/* log.c
   Logging output
*/

#include <stdio.h>
#include <ctype.h>

#include "log.h"

#define DUMP_WIDTH 16

void dump(const unsigned char *text, unsigned length)
{
  unsigned i=0;
  while( i<length ) {
    unsigned j;

    printf("%04X  ", i);

    for( j=0; j<DUMP_WIDTH; j++ )
      if( i+j < length )
        printf("%02X ", (unsigned)text[i+j]);
      else
        printf("   ");
    printf("   ");
    for( j=0; j<DUMP_WIDTH; j++ )
      if( i+j < length ) {
        if( isprint(text[i+j]) )
          printf("%c", (unsigned)text[i+j]);
        else
          printf(".");
      }
    printf("\n");
    i += DUMP_WIDTH;
  }
}