#include "../defs.h"
#include "../errors.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "../DevSupport/readwrite.h"
#include "volinfo.h"
#include "../btree/btree.h"
#include "volbmap.h"
#include "volbmap_local.h"
#include <stdlib.h>
#include <stdio.h>

#define NODEBUG

#define sectorsperallocblock(mr) (((mr)->vib.AlBlkSiz)/((mr)->sr.sectsize))
#define startsectoffsbmap(mr) ((mr)->vib.VBMSt)
#define numbitsinfsbmap(mr) ((mr)->vib.NmAlBlks)

int readvolbmap(MOUNT_RECORD *mr)
{
  int vbmnumsects;
  int numread;

/* Should be no need to lock vib because the fields we need should never change
*/


  vbmnumsects=numbitsinfsbmap(mr)/mr->sr.sectsize/8;

  if ((numbitsinfsbmap(mr)%8) ||
      ((numbitsinfsbmap(mr)/8)%mr->sr.sectsize)) 
    vbmnumsects++;

  if ((mr->vbmap=(BYTE *) malloc(vbmnumsects*mr->sr.sectsize))==NULL) {
    return READVBMOUTOFMEM;
  }

  lock(mr->vbmaplock);

  if ((numread=readsects(mr, 
			 (SECTNUMTYPE) startsectoffsbmap(mr), 
			 vbmnumsects, 
			 (char *) mr->vbmap))!=vbmnumsects) {
    free(mr->vbmap);
    unlock(mr->vbmaplock);
    return READVBMCANTREAD;
  }

/*
#ifdef DEBUG
  printf("Volume Bitmap is:\n");
  printvolbmap(mr);
#endif
*/
  unlock(mr->vbmaplock);
#ifdef IFS
  mr->sr.volbitmap_dirty = 0;
#endif
  return 0;

}


    
int writevolbmap(MOUNT_RECORD *mr)
{
  int vbmnumsects;
  int numwritten;

#ifdef IFS
  if(!mr->sr.volbitmap_dirty)
    return 0;
#endif

/* Again, should be no need to lock vib */

  vbmnumsects=numbitsinfsbmap(mr)/mr->sr.sectsize/8;

  if ((numbitsinfsbmap(mr)%8) ||
      ((numbitsinfsbmap(mr)/8)%mr->sr.sectsize)) 
    vbmnumsects++;

#ifdef DEBUG
  printf("Trying to write %d(%d) (VBM)\n", 
	 startsectoffsbmap(mr),
	 vbmnumsects);
#endif

#ifdef USER
  lock(mr->vbmaplock);
#endif
  
  if ((numwritten=writesectsunbuf(mr, 
				  (SECTNUMTYPE)  startsectoffsbmap(mr), 
				  vbmnumsects, 
				  (char *) mr->vbmap))!=vbmnumsects) {
#ifdef DEBUG
    printf("writesects returned %d\n", numwritten);
#endif
    unlock(mr->vbmaplock);
    return WRITEVBMCANTWRITE;
  }

#ifdef USER  
  unlock(mr->vbmaplock);
#endif
  
#ifdef IFS
  mr->sr.volbitmap_dirty = 0;
#endif
  return 0;

}
    
  
#define isbitclear(t,n) (!(((t)>>(7-(n)))&0x1))
#define isbitset(t,n)   (((t)>>(7-(n)))&0x1)
#define isbyteclear(t)  (!(t))

#define nextblock       if ((curbyte*8+curbit)==(mr->vib.NmAlBlks-1)) {    \
                          curbyte=0; curbit=0;                    \
			} else {                                  \
			  if (curbit==7) {                        \
                            curbyte++; curbit=0;                  \
			  } else {                                \
			    curbit++;                             \
			  }                                       \
                        }

#define setbits(s,e)    for(i=(s);i<=(e);i++) {                \
			  vbm[i/8]|=0x80>>(i%8);                    \
			}           


#define curblock (curbyte*8+curbit)
#if 1
#define searchstartblock (mr->vib.AllocPtr)
#else
#define searchstartblock 0
#endif

#define lastblock (mr->vib.NmAlBlks-1)
                        
int alloccontiguousspace(MOUNT_RECORD *mr,
			 LONGWORD numblocks,
			 EXTENT_DESCRIPTOR *ed)
{
  BYTE *vbm; 
  int curbyte, curbit;
  int blockstart, blockend;
  int wrapped;
  int i;
  EXTENT_DESCRIPTOR curbested;

/*
#ifdef DEBUG
  printf("alloccontiguousspace(numblocks=%d)\n",numblocks);
  printvolbmap(mr);
#endif
*/

  lock(mr->viblock); lock(mr->vbmaplock);

  curbested.first=0;
  curbested.length=0;

  vbm=mr->vbmap;

  curbyte=searchstartblock/8;
  curbit=searchstartblock%8;
#if 0
  for(;curbyte<lastblock/8 && vbm[curbyte]==0xFF;curbyte++)
      ;
  curbit=0;
#endif

  wrapped=0;

  while (!wrapped) {
    
/* Find an empty block */

    while (!(isbitclear(vbm[curbyte],curbit))) { 
      nextblock;
      if (curblock==searchstartblock) {
	wrapped=1;
	break;
      }
    }

#ifdef DEBUG
    printf("Found Empty starting Block at %d\n", curblock);
#endif 

/* Now see if free extent is large enough */

#define blocksfound (blockend-blockstart+1)

    if (!wrapped) {
      blockstart=blockend=curblock;

/* Find the end of the free extent */

      while (blocksfound<numblocks) {
	if (curblock==lastblock)
	  break;
	nextblock;
	if (curblock==searchstartblock)
	  wrapped=1;
	if (isbitclear(vbm[curbyte],curbit)) 
	  blockend++;
	else
	  break;
      }

#ifdef DEBUG
      printf("ending of free range is %d, blocksfound=%d\n",curblock, blocksfound);
#endif

/* See if less than we need */

      if (blocksfound<numblocks) {

/* If less, then see if it's best so far */

	if (blocksfound>curbested.length) {
	  curbested.first=blockstart;
	  curbested.length=blocksfound;
	}

/* If enough, get out */

      } else {
	ed->first=blockstart;
	ed->length=blocksfound;
#ifdef DEBUG
	printf("Setting Bits on Range %d..%d\n", blockstart, blockend);
#endif

	setbits(blockstart,blockend);
	nextblock;
	mr->vib.AllocPtr=curblock;
	mr->vib.FreeBks-=blocksfound;

#ifdef IFS
	mr->sr.volinfo_dirty = 1;
	mr->sr.volbitmap_dirty = 1;
#endif
	unlock(mr->vbmaplock); unlock(mr->viblock);
/*
#ifdef DEBUG
	printvolbmap(mr);
	checkvbmap(mr);
#endif
*/
	return 0;
      }
    }
    nextblock;
    if (curblock==searchstartblock) 
      wrapped=1;
  }

/* OK, we didn't make our goal, so give back the current best */

  ed->first=curbested.first;
  ed->length=curbested.length;
#ifdef DEBUG
  printf("Best: setting bits on range %d..%d\n", curbested.first, curbested.length-1);
#endif

  setbits(curbested.first,curbested.first+curbested.length-1);

  mr->vib.AllocPtr=curbested.first+curbested.length;

  if (mr->vib.AllocPtr>mr->vib.NmAlBlks-1)
    mr->vib.AllocPtr=0;

  mr->vib.FreeBks-=curbested.length;

#ifdef IFS
  mr->sr.volinfo_dirty = 1;
  mr->sr.volbitmap_dirty = 1;
#endif
  unlock(mr->vbmaplock); unlock(mr->viblock);

#ifdef DEBUG
  printf("checkvbmap returned rc=%d\n", checkvbmap(mr));
#endif

  return 0;
}  


#define clearbits(s,e)    for(i=(s);i<=(e);i++) {                \
			    vbm[i/8]&=~(0x80>>(i%8));   \
         			}           


int freecontiguousspace(MOUNT_RECORD *mr,
			EXTENT_DESCRIPTOR *ed)
{
  int i;
  int startblock, endblock;
  BYTE *vbm;

  startblock=ed->first;
  endblock=ed->first+ed->length-1;

  lock(mr->viblock); lock(mr->vbmaplock);

  vbm=mr->vbmap;

  if (startblock>lastblock || endblock>lastblock) {
    unlock(mr->vbmaplock); unlock(mr->viblock);

    return FREECSBADRANGE;
  }

  clearbits(startblock,endblock);

  mr->vib.FreeBks+=ed->length;

#ifdef IFS
  mr->sr.volinfo_dirty = 1;
  mr->sr.volbitmap_dirty = 1;
#endif
  unlock(mr->vbmaplock); unlock(mr->viblock);

  return 0;
}
  



int checkvbmap(MOUNT_RECORD *mr)
{
  BYTE *vbm; 
  int curbyte, curbit;
  WORD freeblocksfound;
  
  curbyte=curbit=0;
  freeblocksfound=0;

  lock(mr->viblock); lock(mr->vbmaplock);

  vbm=mr->vbmap;
  
  while (1) { 
    if (isbitclear(vbm[curbyte],curbit))
      ++freeblocksfound;
    nextblock;
    if (curblock==0)
      break;
#ifdef DEBUG
/*    printf("block %5d\r",curblock);
*/
#endif
  }
  

#ifdef DEBUG
  printf("found %u free blocks in vbmap, vib reports %u\n",
	 freeblocksfound, mr->vib.FreeBks);
#endif

  if (mr->vib.FreeBks!=freeblocksfound) {
    unlock(mr->vbmaplock); unlock(mr->viblock);
  
    return CHKVBMAPBADVIBINFO;
  } else {
    unlock(mr->vbmaplock); unlock(mr->viblock);

    return 0;
  }
}


int allocspaceonbmap(MOUNT_RECORD *mr, 
		     LONGWORD blocks, 
		     EXTENT_DESCRIPTOR **edlist,
		     LONGWORD *numblocksactuallyfound)
{
  EXTENT_DESCRIPTOR *el, *tmp;
  int cured;
  int blocksleft;
  int rc;

#ifdef DEBUG
  printf("allocspaceonbmap(blocks=%d)\n",blocks);
#endif

  if ((el=(EXTENT_DESCRIPTOR *) 
       malloc(EDLISTALLOCUNITS*sizeof(EXTENT_DESCRIPTOR)))==NULL)
    return ALLOCSOUTOFMEM;

  cured=0;
  blocksleft=blocks;

  while (1) {
    if (!(cured%EDLISTALLOCUNITS)&&cured!=0) {
      if ((tmp=(EXTENT_DESCRIPTOR *)
	   realloc(el,(cured+EDLISTALLOCUNITS)*sizeof(EXTENT_DESCRIPTOR)))
	  ==NULL) {
	if (freespaceonbmap(mr,el,cured)) {
	  free(el);
	  return ALLOCSCANTDEALLOC1;
	} else {
	  free(el);
	  return ALLOCSOUTOFMEM;
	}
      } else {
	el=tmp;
      }
    }
    
    if ((rc=alloccontiguousspace(mr, blocksleft,&(el[cured])))) {
      if (freespaceonbmap(mr,el,cured)) {
	free(el);
	return ALLOCSCANTDEALLOC2;
      } else {
	free(el);
	return rc;
      }
    }

    if (el[cured].length==0) {
      *numblocksactuallyfound=blocks-blocksleft;
      *edlist=el;

      return cured;
    }

    blocksleft-=el[cured].length;

    if (blocksleft<0) {
      if (freespaceonbmap(mr,el,cured)) {
	free(el);
	return ALLOCSCANTDEALLOC3;
      } else {
	free(el);
	return ALLOCSOUTOFBOUNDS;
      }
    }

    if (blocksleft==0) {
      *numblocksactuallyfound=blocks;
      *edlist=el;
      return cured+1;
    }

    cured++;

  }
}
  
int freespace(MOUNT_RECORD *mr,
	      LONGWORD fid,
	      EXTENT_DESCRIPTOR *edlist,
	      int numeds,
	      WORD startblock,
	      int failrecoverymode)
{
  int i, rc, failrc;
  WORD curb;


/* Note! Assumes startblock is a valid first log block of an extent record */

  curb=startblock;

  failrc=0;

  for (i=0;i<numeds;i++) {
    if ((rc=freecontiguousspace(mr,&(edlist[i])))) {
      if (!failrc) failrc=rc;
    }
    if (!(i%3) && i>0) {
      if ((rc=DelExtentRecord(mr, fid, 1, curb))) {
	if (!failrc) {
	  failrc=rc;
	}
      }
    }
    curb+=edlist[i].length;
  }

  return failrc;
}
  
int freespaceonbmap(MOUNT_RECORD *mr, 
		    EXTENT_DESCRIPTOR *edlist, 
		    int numeds)
{
  int i, rc, failrc;

  failrc=0;

  for (i=0;i<numeds;i++) {
    if ((rc=freecontiguousspace(mr,&(edlist[i])))) {
      if (!failrc) failrc=rc;
    }
  }

  return failrc;
}

int printvolbmap(MOUNT_RECORD *mr)
{
  int startbit=0;
  int bit, byte, byteval;
  int set=0x80;
  
  for(byte=0; byte < 6144; byte++)
    {
      byteval = mr->vbmap[byte];
      for(bit=0; bit<8;bit++)
	{
	  if((byteval & 0x80) != set)
	    {
	      printf("bits %d to %d = %d\n",
		     startbit, byte*8+bit-1, set != 0);
	      startbit = byte*8+bit;
	      set = (byteval & 0x80);
	    }
	  byteval <<= 1;
	}
    }
  printf("bits %d to %d = %d\n",
	 startbit, 6144*8-1, set != 0);

  return 0;
}
