#include "../defs.h"
#include "../errors.h"
#include "../mountrec.h"
#include "../DevSupport/readwrite.h"
#include "partition.h"

#include <stdlib.h>
#ifdef DEBUG
#include <stdio.h>
#include "../../log.h"
#endif

/* Scan partition map for the first HFS partition */
int get_hfs_partition(MOUNT_RECORD *mr)
{
  BYTE *sectbuf, *tmp;
  WORD temp, partitions, partnum;
  LONGWORD templong;

  /* Guess at the sector size */
  mr->sr.sectsize=mr->sr.device_sectsize;

  if ((sectbuf=(BYTE *)malloc(mr->sr.device_sectsize))==NULL)
    return PARTOUTOFMEM;

  /*  
#ifdef DEBUG
  {
  int sect;
  do {
    printf("Enter sector, -1 to quit: ");
    scanf("%d", &sect);
    if(readabsolutesector(mr, sect, sectbuf))
      printf("Failed!\n");
    else
      dump(sectbuf, mr->sr.device_sectsize);
  } while(sect != -1);
  }
#endif
*/

  if (readabsolutesector(mr, 0, sectbuf)) {
    free(sectbuf);
    return PARTCANTREADSECTZERO;
  }

  /* This is the driver descriptor map */

  temp=reorderword(&(sectbuf[0x0]));
#ifdef DEBUG
  printf("ID word is %X\n", temp);
#endif

  /* If it's not a valid driver descriptor map, assume it an HFS floppy */
  if (temp!=PARTMAP_MAGIC) {
    /* Assume it's a 1.44 MB floppy and let readvolinfo deal with it */
    mr->sr.sectoffsettopartition=0;
    free(sectbuf);
    return 0;
  }

  /* OK, so it's a partitioned SCSI device */

  /* Get the true sector size */
  temp=reorderword(&(sectbuf[0x2]));
#ifdef DEBUG
  printf("Bytes Per Sector is %d\n", temp);
#endif
  mr->sr.sectsize=temp;

#ifdef DEBUG
  printf("%u blocks on device\n", reorderlongword(&(sectbuf[4])));
  printf("Continuing to Partition Map Partition..\n");
#endif

  if (temp > mr->sr.device_sectsize)
    if ((tmp=(char *) realloc(sectbuf, temp))==NULL) {
      free(sectbuf);
      return PARTOUTOFMEM;
    } else {
      sectbuf=tmp;
    }

  /* Read the first partition map entry */
  if(readabsolutesector(mr, 1, sectbuf)) {
    free(sectbuf);
    return PARTCANTREADPARTMAPSECT;
  }
  if(reorderword(&(sectbuf[0])) != PARTMAP_ENTRY_MAGIC) {
    free(sectbuf);
    return BADPARTITION;
  }
  /* Get the number of partitions */
  partitions = reorderlongword(&(sectbuf[4]));

  /* Scan the partition map entries until an HFS partition is found */
  partnum=1;
  while(partnum<=partitions) {
    if (readabsolutesector(mr, partnum, sectbuf)) {
      free(sectbuf);
      return PARTCANTREADPARTMAPSECT;
    }
    temp=reorderword(&(sectbuf[0]));

    /* See if it is a valid partition map entry */
    if (temp!=PARTMAP_ENTRY_MAGIC) {
      free(sectbuf);
      return BADPARTITION;
    }

    templong=reorderlongword(&(sectbuf[8]));
#ifdef DEBUG
    printf("Partition %hu starts at sector %u and has %u sectors\n",
	   partnum, templong, reorderlongword(&(sectbuf[0xc])));
#endif

    mr->sr.sectoffsettopartition=templong;

    sectbuf[0x50]=0;

#ifdef DEBUG
    printf("Partition Type Name is '%s'\n", &(sectbuf[0x30]));
#endif
    
    if (!strcmp(&(sectbuf[0x30]),MACHFSPART)) {
#ifdef DEBUG
      puts("HFS partition found.\n");
#endif
      free(sectbuf);
      return 0;
    }
    partnum++;
  }

  free(sectbuf);
  return NOTMACHFSPART;
}
