.*! html2ipf 0.4


:userdoc.

:title.ui_fte.fte - Keyboard Reference

:h1 id=0.PLAIN mode
:lm margin=1.:i1.PLAIN mode
:p.Here are listed the commonly used keyboard bindings defined in the
file ui_fte.fte. For complete list of defined keys see ui_fte.fte. 
:p.PLAIN mode is the default mode used for editing files. 
:p.All other modes inherit all definitions from this mode. 
:h2 id=1.Cursor Movement Commands
:lm margin=1.:i1.Cursor Movement Commands
:p.:dl compact tsize=10 break=all. 
:dt.Left 
:dd.Move cursor left one character. 
:dt.Right 
:dd.Move cursor right one character. 
:dt.Up 
:dd.Move cursor up one line. 
:dt.Down 
:dd.Move cursor down one line. 
:dt.Ctrl+Left 
:dd.Move cursor to the beginning of previous word. 
:dt.Ctrl+Right 
:dd.Move cursor to the beginning of next word. 
:dt.Home 
:dd.Move cursor to the beginning of current line. 
:dt.End 
:dd.Move cursor to the end of current line. 
:dt.Ctrl+Home 
:dd.Move cursor to the top of the window. 
:dt.Ctrl+End 
:dd.Move cursor to the bottom of the window. 
:dt.Ctrl+PgUp 
:dd.Move cursor to the beginning of the file. 
:dt.Ctrl+PgDn 
:dd.Move cursor to the end of the file. :edl.
:p.Shift key can be used with all of the above keys to mark or extend
blocks of text. 
:h2 id=2.Editing Commands
:lm margin=1.:i1.Editing Commands
:p.:dl compact tsize=10 break=all. 
:dt.Tab 
:dd.Insert a tab character or spaces to next tab stop. 
:dt.Enter 
:dd.Add new line after the current line and move to the beginning of it. 
:dt.Ctrl+Enter 
:dd.Split current line at cursor position. 
:dt.Shift+Enter 
:dd.Insert a new line before current one. 
:dt.Alt+Enter 
:dd.Add a new line after the current one. 
:dt.BackSpace 
:dd.Delete character before cursor. At the beginning of line, join current
line with the previous one. 
:dt.Delete 
:dd.Delete character under cursor. At the end of line or beyond, join the
current line with the next one. 
:dt.Ctrl+BackSpace 
:dd.Delete to the beginning of word. 
:dt.Ctrl+T 
:dd.Delete to the end of word. 
:dt.Ctrl+Y 
:dd.Delete current line. 
:dt.Ctrl+J 
:dd.Join current line with next one. 
:dt.Alt+BackSpace 
:dd.Undo 
:dt.Alt+Shift+BackSpace 
:dd.Redo :edl.
:h2 id=3.Block Commands
:lm margin=1.:i1.Block Commands
:p.:dl compact tsize=10 break=all. 
:dt.Esc 
:dd.Unmark current block. 
:dt.Ctrl+Ins 
:dd.Copy marked block to clipboard. 
:dt.Shift+Del 
:dd.Delete marked block to clipboard. 
:dt.Shift+Ins 
:dd.Paste clipboard at cursor as stream block. 
:dt.Alt+Ins 
:dd.Paste clipboard at cursor as column block. 
:dt.Ctrl+Del 
:dd.Delete marked block 
:dt.Alt+U 
:dd.Unindent block by one character. 
:dt.Alt+I 
:dd.Indent block by one character. 
:dt.Alt+A 
:dd.Start marking a stream block. 
:dt.Alt+L 
:dd.Start marking a line block. 
:dt.Alt+K 
:dd.Start marking a column block. :edl.
:h2 id=4.Search Commands
:lm margin=1.:i1.Search Commands
:p.:dl compact tsize=10 break=all. 
:dt.Ctrl+S 
:dd.Start incremental search 
:dt.Ctrl+F 
:dd.Search for a string with options 
:dt.Ctrl+R 
:dd.Find &amp. Replace string with options 
:dt.Ctrl+L 
:dd.Repeat last find 
:dt.Ctrl+B 
:dd.Repeat last find in reverse direction 
:dt.Ctrl+N 
:dd.Repeat last find once 
:dt.Alt+J 
:dd.Goto line 
:dt.Ctrl+C 
:dd.Goto column 
:dt.Alt+- 
:dd.Search for matching {}[](). 
:dt.Ctrl+P 0-9 
:dd.Place a bookmark (from 0 to 9). 
:dt.Ctrl+A 0-9 
:dd.Goto bookmark (from 0 to 9). :edl.
:h2 id=5.File Commands
:lm margin=1.:i1.File Commands
:p.:dl compact tsize=10 break=all. 
:dt.F2 
:dd.Save a file. 
:dt.Shift+F2 
:dd.Save a file under a new name. 
:dt.F3 
:dd.Open a file. 
:dt.Shift+F3 
:dd.Reload a file. 
:dt.F6 
:dd.Switch to next loaded file. 
:dt.Shift+F6 
:dd.Switch to previous loaded file. 
:dt.Ctrl+F10 
:dd.Close current file. 
:dt.Alt+0 
:dd.Display buffer list. 
:dt.Alt+1 - Alt+9 
:dd.Switch to file with specified number. Numbers are displayed on the
right side of the status line or in the first column in buffer list. :edl.
:h2 id=6.Other Commands
:lm margin=1.:i1.Other Commands
:p.:dl compact tsize=10 break=all. 
:dt.Ctrl+Q 
:dd.Quote next character :edl.
:h1 id=7.C mode
:lm margin=1.:i1.C mode
:p.C mode redefines some keys to automatically indent source code. :dl compact tsize=10 break=all. 
:dt.Tab 
:dd.Reindent current line. 
:dt.Alt+\ 
:dd.Reindent marked block 
:dt.{, }, ), ], &colon., # 
:dd.Reindent current line. 
:dt.Enter 
:dd.Add a line, move to next line and indent. 
:dt.Alt+Enter 
:dd.Add a line and indent. 
:dt.Shift+Enter 
:dd.Insert a blank line and move to proper indentation level. :edl.
:euserdoc.
