//
// $Header: D:/ext2-os2/include/linux/RCS/sched.h,v 6.0 1996/01/24 00:03:30 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.




#ifndef __LINUX_SCHED_H
#define __LINUX_SCHED_H

#ifndef OS2
#error "sched.h is OS/2 specific for the moment ..."
#endif


#include <os2/os2misc.h>
#include <linux/resource.h>
#include <linux/wait.h>
#include <infoseg.h>

//
// Dummy task_struct structure - This is to implement current->rlim[] in various VFS routines
//
struct task_struct {
    struct rlimit rlim[RLIM_NLIMITS];
};

extern struct task_struct current[];
extern long timezone;

//
// This is the current time in the OS/2 global infoseg (time in seconds since 1970-1-1)
// You MUST #include <infoseg.h> before this file
//
#if defined(MINIFSD)
#define CURRENT_TIME 0
#else
#define CURRENT_TIME (pSysInfoSeg->SIS_BigTime + timezone)
#endif


#ifndef MINIFSD
extern void __down(struct semaphore * sem);
extern void wake_up(void *wait);
extern void sleep_on(void *wait);
#else
extern void (*wake_up)();
extern void (*sleep_on)();
#endif

#if !defined(MICROFSD) && !defined(MINIFSD)
extern _inline void down(struct semaphore * sem)
{
#ifdef FS_TRACE_LOCKS
	kernel_printf("down(%lu)", &sem->wait);
#endif
	if (sem->count <= 0)
		__down(sem);
	sem->count--;
}

extern _inline void up(struct semaphore * sem)
{
#ifdef FS_TRACE_LOCKS
	kernel_printf("up(%lu)", &sem->wait);
#endif
	sem->count++;
	wake_up(&sem->wait);
}	
#endif

#endif

