/**********************************************************/
/*         PlusPak: B.U.G.S. DEMO for OS/2 Warp           */
/*                    Version 1.00                        */
/*                 Installation Program                   */
/*         (C) Copyright 1997 Cramon Utilities            */
/*       (C) Copyright 1997 Stardock Systems, Inc.        */
/**********************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Setup variables. */
InstallDir = ''
UnpackFile = 'BUGSZIP.EXE'
StartupDir = Directory()

/* Product Information */
'@cls'
Say 'PlusPak: B.U.G.S. DEMO Version 1.00 for OS/2.'
Say '(C) Copyright 1997 Cramon Utilities'
Say '(C) Copyright 1997 Stardock Systems, Inc.'
Say 'All rights reserved.'
Say 'Distribute freely!'
/* Query installation directory. */
Call GetBugsInstallDir

Call Install

Exit


GetBugsInstallDir:

    If InstallDir = '' Then Do
        Say
        Say 'Please enter the directory you wish to install to: '
        Call CharOut, '=> '
        Parse Pull InstallDir
        Say
    End
    If InstallDir = '' Then Do
        Say 'Error: Could not find installation dir.'
        Exit
    End

    /* Check if dir exists. */
    If Stream( InstallDir, 'c', 'query exists' ) = '' Then Do
        rc = SysMkDir( InstallDir )
        If rc <> 0 & rc <> 5 Then Do
            Say 'Error: Could not make directory ('InstallDir'), error code = ('rc')'
            Exit
        End
        Else If rc = 0 Then
            Say 'Directory ('InstallDir') created...'
    End

    /* Write installation directory. */
    Say 'Installation directory is ('InstallDir')'
    rc = SysIni( , 'BUGS', 'InstallDir', InstallDir )
    return


Install:

    /* Unpack files. */

        /* Have unpack file? */
        If Stream( UnpackFile, 'c', 'query exists' ) = '' Then Do
            Say 'Error: Could not find file 'UnpackFile'.'
            Exit
        End

        /* Unpack file to installation directory. */
        Call ChangeDriveAndPath InstallDir
        Say
        Say 'Unpacking installation files.'

        '@'StartupDir'\'UnpackFile' -o'
        If rc <> 0 Then Do
            Say 'Error ('rc') occurred unpacking files.'
            Exit
        End

        /* Change back to startup directory. */
        Call ChangeDriveAndPath StartupDir
        If FileSpec( Drive, StartupDir ) <> FileSpec( Drive, InstallDir ) Then
            '@cd 'FileSpec( Drive, InstallDir )'\'


    /* Create the object. */

        Say
        Say 'Creating objects.'

        /* Create folder. */
        rc = SysCreateObject(   'WPFolder',,
                                'PlusPak: B.U.G.S. DEMO',,
                                '<WP_DESKTOP>',,
                                'OBJECTID=<BUGS_FOLDER>;',
                                ';ICONVIEWPOS=33,33,34,34;ALWAYSSORT=YES;',
                                ';BACKGROUND='InstallDir'\resource\foldback.bmp;',
                                ';ICONFILE='InstallDir'\resource\bugsfldr.ico;',,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create the PlusPak: B.U.G.S. DEMO folder object.'

        /* Create program. */
        rc = SysCreateObject(   'WPProgram',,
                                'PlusPak: B.U.G.S. DEMO',,
                                '<BUGS_FOLDER>',,
                                'EXENAME='InstallDir'\BUGS.EXE;STARTUPDIR='InstallDir';OBJECTID=<BUGS>;',,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create PlusPak: B.U.G.S. DEMO object.'

        /* Create read. */
        rc = SysCreateObject(   'WPProgram',,
                                'PlusPak: B.U.G.S. DEMO^Readme',,
                                '<BUGS_FOLDER>',,
                                'EXENAME=e.exe;PARAMETERS='InstallDir'\BUGS.TXT;OBJECTID=<BUGS_README>;ICONFILE='InstallDir'\resource\bugstext.ico',,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create PlusPak: B.U.G.S. DEMO Readme object.'


        say 'Setting data file icons. Please wait...'
        /* Change icons in the data directory */
        string1 = InstallDir'\data\*.dat'
        string2 = InstallDir'\resource\bugsgraf.ico'

        call SysFileTree string1, 'file', 'O'
        do i=1 to file.0
            result = SysSetIcon(file.i, string2)
        end

        say 'Setting sound file icons. Please wait...'
        /* Change icons in the sound directory */
        string1 = InstallDir'\sound\*.wav'
        string2 = InstallDir'\resource\bugswave.ico'

        call SysFileTree string1, 'file', 'O'
        do i=1 to file.0
            result = SysSetIcon(file.i, string2)
        end

        /* Change icons in the sound directory */
        string1 = InstallDir'\sound'
        string2 = InstallDir'\resource\bugsfldr.ico'
        result = SysSetIcon(string1, string2)

        /* Change icons in the data directory */
        string1 = InstallDir'\data'
        string2 = InstallDir'\resource\bugsfldr.ico'
        result = SysSetIcon(string1, string2)

        /* Change icons in the resource directory */
        string1 = InstallDir'\resource'
        string2 = InstallDir'\resource\bugsfldr.ico'
        result = SysSetIcon(string1, string2)

        /* Change icons in the root directory */
        string1 = InstallDir
        string2 = InstallDir'\resource\bugsfldr.ico'
        result = SysSetIcon(string1, string2)

        /* Open folder. */
        Call SysSetObjectData '<BUGS_FOLDER>', 'OPEN=DEFAULT;'

        say
        say 'PlusPak: B.U.G.S. DEMO successfully installed...'

    return


ChangeDriveAndPath:
    Parse Arg DriveAndPath

    /* Get drive and path */
    Say
    Say 'Changing to 'DriveAndPath
    ChangeToDrive = FileSpec( Drive, DriveAndPath'\BORK' )
    ChangeToPath = FileSpec( Path, DriveAndPath'\BORK' )
    ChangeToPath = Left( ChangeToPath, Length( ChangeToPath ) - 1 )

    /* Change drive and path. */
    Say 'Changing drive to 'ChangeToDrive
    '@'ChangeToDrive
    If rc <> 0 Then Do
        Say 'Error: could not change drive.'
        Exit
    End
    Say 'Changing directory to 'ChangeToPath
    '@cd 'ChangeToPath
    If rc <> 0 Then Do
        Say 'Error: could not change directory.'
        Exit
    End

    return

