/*
 *      REMOVE.CMD - Animated Mouse Pointer for OS/2 - C.Langanke 1996 - Deinstallation
 *
 *      execute REMOVE /? to get online help in your language.
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT NAME HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 env       = 'OS2ENVIRONMENT';
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
 Redirection = '1>NUL 2>&1';
 '@ECHO OFF'
  
 /* some OS/2 Error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 /* load RexxUtil */ 
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;
  

 /* some defaults */
 Flag.Batch      = FALSE;

 ClassName     = 'WPAnimatedMousePointer';
 DeinstallResult = ERROR.NO_ERROR;
 CallDir       = GetCallDir();
 ReplaceExec   = CallDir'\WPSREPLC.PRG';

 /* get NLS settings */
 MessageFile   = Calldir'\INSTALL.MSG';
 IF (\FileExist(MessageFile)) THEN
 DO
    SAY CmdName': error: Message file 'MessageFile' not found.';
    SAY 'The program cannot be deinstalled. Run INSTALL first.';
    EXIT(ERROR.FILE_NOT_FOUND);
 END;

 SIGNAL ON HALT NAME HALT_NLS

 /* show Title */
 Title = '[2J'GetNlsString('Title', GetNlsString('DeInstall'));    

 /* show help */
 ARG Parms
 IF (POS('?', Parms) > 0) THEN
 DO
    SAY Title;
    SAY GetNlsString('DeinstHelp');
    EXIT(ERROR.NO_ERROR)
 END;
 DO i = 1 TO WORDS(Parms)
    ThisParm = TRANSLATE(WORD(Parms, i));
    IF (ThisParm = '/B') THEN
       Flag.Batch = TRUE;
 END;


 DO WHILE (TRUE)

    SAY Title;
    IF (\IsInstalled(ClassName)) THEN
    DO
       SAY GetNlsString('NotInstalled');
       LEAVE;
    END;

    /* should we install ? */
    IF (\ProceedWith(GetNlsString('QueryDeinst'))) THEN
       SIGNAL HALT;

    /* deinstall the program */
    SAY Title;
    /* unreplace the class */
    rc = ReplaceWpsClass( ReplaceExec, 'WPMouse', ClassName, InstallPath, 'WPAMPTR.DLL', FALSE);
    IF (rc \= ERROR.NO_ERROR) THEN
       LEAVE;

    /* destroy information object and shadow */
    rc = SysDestroyObject('<WPAMPTR_INFO>');
    rc = SysDestroyObject('<WPAMPTR_INFO_SHADOW>');

    /* we're done, so leave */
    SAY Title;
    SAY  GetNlsString('DeinstDone');
    LEAVE;

 END;

 EXIT(InstallResult);

/* ------------------------------------------------------------------------- */

HALT_NLS:
 SAY GetNlsString('Halt');
 EXIT(ERROR.GEN_FAILURE);

HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE
 PARSE ARG MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 Message = SysGetMessage(MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE EXPOSE ExitMessage
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE
 PARSE ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');
     
/* ========================================================================= */
ProceedWith: PROCEDURE EXPOSE NlsMsg. ExitMessage MessageFile Flag.
 PARSE ARG Prompt, Keys

 IF (Flag.Batch) THEN RETURN(1);

 ch            = ' ';
 IF (Keys = '') THEN
    ValidResponse = LEFT(GetNlsString(YesNoKeys), 2);
 ELSE
    ValidResponse = Keys;

 YesKey        = LEFT(ValidResponse, 1);
 NoKey         = RIGHT(ValidResponse, 1);

 SAY;
 CALL CHAROUT ,Prompt '('YesKey'/'NoKey') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY ch;
 SAY;
 RETURN(ch = YesKey);
   
/* ========================================================================= */
GetNlsString: PROCEDURE EXPOSE ERROR. MessageFile
 PARSE ARG MessageId, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 /* default values */
 Message     = '*** Message' Id 'not found. ***';

 /* default values */
 MessageFileIdText = 'WPAMPTR_MESSAGEFILE';

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId MessageLanguage MessageFileKeys MessageListcount
 IF ((MessageFileIdText \= MessageFileId) | (LENGTH(MessageFileKeys) \= 2))THEN
 DO
    SAY 'Invalid message file' MessageFile;
    EXIT(ERROR.INVALID_DATA);
 END;

 /* load Messagelist*/
 MessageList = '';
 DO i = 1 TO MessageListcount
    MessageList = MessageList LoadMsgString(i, MessageFile)
 END;

 /* handle special id YesNoKeys */
 IF (MessageId = 'YESNOKEYS') THEN
    RETURN(MessageFileKeys);

 /* read message ids */
 MessagePos   = WORDPOS(TRANSLATE(MessageId), TRANSLATE(MessageList));
 IF (MessagePos > 0) THEN
 DO
    ThisMessage = LoadMsgString(MessagePos + MessageListcount, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
    IF (ThisMessage \= '') THEN
       Message = ThisMessage;
 END;

 RETURN(Message);


/* ========================================================================= */
ReplaceWpsClass: PROCEDURE EXPOSE ERROR. Redirection MessageFile   
 PARSE ARG ReplaceExec, ClassName, ReplaceClassName, InstallPath, ClassDll, fReplace

 ReplaceResult    = ERROR.NO_ERROR;
 ClassDllFullname = InstallPath'\'ClassDll;
 ReplaceFlag      = 'U';
 IF (fReplace) THEN
    ReplaceFlag   = 'R';

 /* (un-)replacing */
  SAY GetNlsString('Unreplacing', ReplaceClassName);
 '' ReplaceExec ClassName ReplaceClassName ReplaceFlag ClassDllFullName Redirection
 ReplaceResult = rc;
 SAY; 

 IF (ReplaceResult \= ERROR.NO_ERROR) THEN
     SAY GetNlsString('UnreplaceError', ReplaceClassName, ReplaceResult);
 ELSE
    rc = SysSleep(1);

 RETURN(ReplaceResult);

/* ========================================================================= */
IsInstalled: PROCEDURE EXPOSE TRUE FALSE
 PARSE ARG ClassName

 ClassInstalled = FALSE;

 DO WHILE (TRUE)

    /* check class list */
    CALL SysQueryClassList "list."
    DO i = 1 to list.0
       PARSE VAR list.i ThisClass ThisDll
       IF (STRIP(Thisclass) = ClassName) THEN
       DO
          ClassInstalled = TRUE;
          LEAVE;
       END;
    END

    /* we're done */
    LEAVE;
 END;

 RETURN(ClassInstalled);

