/********************************************************************/
/*         MGA OS/2 PM drivers installation batch file              */
/********************************************************************/

'@ECHO OFF'
say 'Matrox Millennium/Mystique Driver'

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs


CurDir = Directory()
parse SOURCE cmdd
cmdd = word(cmdd,3)
SrcDrv = left(cmdd, length(cmdd) - length('install.cmd'))
Dstdrv = 'C:'           /* default value */
AutoInstall = 0         /* default value */

/********************************************************************/
/* Get arguments if any                                             */
/********************************************************************/

Parse Arg all

ArgCount=words(all)
if ArgCount > 4 then ArgCount = 4
srcset=0
dstset=0
If ArgCount > 0 then do i=1 to ArgCount
    ntmp = translate(word(all,i))
    select /* ntmp */
        when ntmp ='/U' then AutoInstall = 1

        otherwise do
            if srcset=0 then do
                Srcdrv=ntmp
                srcset=1
            end
            else do
                Dstdrv=ntmp
                dstset=1
            end
        end /* otherwise */
    end /* select ntmp */
end /* do i=1 to ArgCount */

if srcset=1 then signal FoundSrcDrv

SearchRep = 0
SearchAgain:
if stream(Srcdrv'MGAX64.DSC','C','query exists') \= "" then signal FoundSrcDrv
Srcdrv=Srcdrv'\OS2\'
if stream(Srcdrv'MGAX64.DSC','C','query exists') \= "" then signal FoundSrcDrv

SearchRep = SearchRep + 1

select
   when SearchRep=1 then do
        Srcdrv = CurDir
        signal SearchAgain
        end
   when SearchRep=2 then do
        DrvLetter = 'A'
        Srcdrv = DrvLetter':'
        signal SearchAgain
        end
    otherwise nop
end

if DrvLetter \= 'Z' then do
    DrvLetter= D2C(C2D(DrvLetter)+1)
    Srcdrv = DrvLetter':'
    signal SearchAgain
end

Srcdrv='A:'
signal NotFoundSrcDrv

FoundSrcDrv:
say 'Install from 'Srcdrv

/********************************************************************/
/* Search for OS2 system path in PATH environment                   */
/********************************************************************/

Path = translate(value('PATH',,'OS2ENVIRONMENT'))
if Path = '' then signal ENDSEARCH

ntmp = pos(':\OS2;', Path)
if ntmp = 0 then signal ENDSEARCH

BootedDrv = substr(Path, ntmp - 1, 2)
if dstset = 0 then Dstdrv = BootedDrv
if BootedDrv = Dstdrv then DstRunning = 1

FoundDstDrv:
say 'Install to   'Dstdrv

/*****************************************************************************/
/*                 Checking the default values                               */
/*****************************************************************************/

                                               /* checking source      */
lastChar = right(Srcdrv, 1)
if lastChar \= ":" & lastChar \= '\' then Srcdrv = Srcdrv'\'
if stream(Srcdrv'MGAX64.DSC', 'C', 'query exists') \= "" then signal CheckDst
Srcdrv=Srcdrv'OS2\'
if stream(Srcdrv'MGAX64.DSC', 'C', 'query exists') = "" then signal RESUME

CheckDst:

FileName=Dstdrv'\OS2KRNL'                       /* checking target      */
'attrib -r -s -h 'FileName
if stream(FileName, 'C', 'query exists') = "" then signal RESUME
'attrib +h +s +r 'FileName

signal StartInstall

/********************/
/* Ask the User     */
/********************/

NotFoundSrcDrv:
RESUME:
cls
say ''
say ''
say 'Source dir will be:' Srcdrv
say 'Destination drive will be:' Dstdrv
say 'Is the above information correct? (Y/N): Y'
pull answer
if answer = 'N' then signal askdrives

if stream(Srcdrv'MGAX64.DSC', 'C', 'query exists') \= "" then signal CheckDst1
FileName = Srcdrv'MGAX64.DSC'
Srcdrv=Srcdrv'\OS2\'
if stream(Srcdrv'MGAX64.DSC', 'C', 'query exists') = "" then signal usage0

CheckDst1:
FileName=Dstdrv'\OS2KRNL'
'attrib -r -s -h 'FileName
if stream(FileName, 'C', 'query exists') = "" then signal usage0
'attrib +h +s +r 'FileName

say 'Source Directory will be 'Srcdrv
say 'Ready to install? (Y/N): Y'
pull answer
if answer \= 'N' then signal StartInstall

say 'INSTALLATION ABORT'
signal end

StartInstall:
say 'PLEASE WAIT ...'

NewDir=directory(Dstdrv'\')             /* go to root off OS/2 drive */

/********************************************/
/* remove any MGA statement from CONFIG.SYS */
/********************************************/

InnF=Dstdrv'\CONFIG.MGA'
OutF=Dstdrv'\CONFIG.SYS'
'copy 'OutF' 'InnF' >nul'
'del 'OutF

do until lines(InnF) = 0
    InStr = linein(InnF)
    select
        when pos('VVGA.SYS', InStr) > 0     then nop
        when pos('VSVGA.SYS', InStr) > 0    then nop
        when pos('MGAKRNL.SYS', InStr) > 0  then nop    /* Terminator       */
        when pos('MGA=', InStr) > 0         then nop    /* Termin / Millen  */
        when pos('MGARES=', InStr) > 0      then nop    /* Terminator < 2.0 */
        when pos('VIO_MGA', InStr) > 0      then nop    /* Termin / Millen  */
        when pos('RAMBIOS.SYS', InStr) > 0  then nop    /* Terminator < 2.0 */
        when pos('VMGA.SYS', InStr) > 0     then nop    /* Terminator       */
        when pos('KMGAX64.SYS', InStr) > 0  then nop    /* Millennium       */
        when pos('VMGAX64.SYS', InStr) > 0  then nop    /* Millennium       */
        otherwise
        do
            if pos('LIBPATH=', InStr) > 0   then        do
                itmp = pos(':\MGA\OS', InStr)
                if itmp > 0 then stmp=delstr(InStr, itmp-1, 11)
                else stmp=InStr
                call lineout OutF, stmp
            end
            else do
                itmp = pos(':\MGA\OS2', InStr)
                if itmp = 0 then  call lineout OutF, InStr
                end
        end
    end
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'

/**********************************/
/* Call OS/2 Installation process */
/**********************************/

'if exist 'Dstdrv'\OS2\svgadata.pmi del 'Dstdrv'\OS2\svgadata.pmi > nul'
'if exist 'Dstdrv'\OS2\video.cfg del 'Dstdrv'\OS2\video.cfg > nul'

NewDir=directory(Dstdrv'\OS2\INSTALL')
'if exist MGA8.DSC del MGA8.DSC > nul'
'copy   'Srcdrv'MGAX64.DSC .>nul'


ver = SysOS2Ver()
option=''

if ver > '2.11' then do                             /* Warp 3 = 2.30 */
                                                    /* Merlin = 2.40 */
    if AutoInstall = 1
        then option=' /PD:'Srcdrv'MGAX64.DSC'
    if right(Srcdrv, 1) = '\'
        then Srcdrv = left(Srcdrv, length(Srcdrv) - 1)
    option = option' /S:'Srcdrv' /T:'Dstdrv'\'
end

/**************************************************/
/* Call dspinstl to install drivers               */
/**************************************************/

'DSPINSTL'option
IstRetCode = rc

/**************************************************************/
/* restore CONFIG.SYS and AUTOEXEC.BAT in case abort or error */
/**************************************************************/
if IstRetCode \= 0 then do
    NewDir=directory(Dstdrv'\')
    'copy config.mga config.sys >nul'
    'copy autoexec.mga autoexec.bat >nul 2>nul'
    'del  *.mga'
    say 'INSTALLATION ABORT'
    end

else do

    /**********************************************************************/
    /* Save a copy of the Matrox vvga.sys in \mga\os2 to copy to          */
    /* \os2\mdos in case dspinstl is used to reinstall the driver.        */
    /**********************************************************************/
    'copy 'Dstdrv'\os2\mdos\vvga.sys 'Dstdrv'\mga\os2 >nul'

    /**********************************************************************/
    /* Delete obsolete files.                                             */
    /* An old level mga.inf is identified by the existence of mgamon.exe. */
    /**********************************************************************/
    'if exist 'Dstdrv'\MGA\OS2\mgamon.exe    del 'Dstdrv'\MGA\OS2\mga.inf     2>nul'
    'if exist 'Dstdrv'\MGA\OS2\MGAMON.EXE    del 'Dstdrv'\MGA\OS2\MGAMON.EXE   >nul'
    'if exist 'Dstdrv'\MGA\OS2\syslevel.mil  del 'Dstdrv'\MGA\OS2\syslevel.mil >nul'

    /**********************************************************/
    /* If the installation target drive is the one that's     */
    /* currently booted, create the MGA objects.              */
    /**********************************************************/
    if DstRunning = 1
    then 'call' Dstdrv'\mga\os2\mgaobj'
    else do
        say 'To complete installation, boot from 'Dstdrv' and run MGAOBJ'
        say 'and then MGAHK, both from the 'Dstdrv'\MGA\OS2 directory.'
        end
    end

signal end

ASKDRIVES:
say 'Enter source drive ('Srcdrv')'
pull answer
if   answer = "" then nop
else Srcdrv = answer'\OS2'
say 'Enter destination drive ('Dstdrv')'
pull answer
if   answer = "" then nop
else Dstdrv = answer
signal RESUME

USAGE0:
say
say 'File' FileName 'does not exist.'
USAGE:
say ''
say 'Usage:'
say '   install [source path [destination path]] [/u]'
say
say 'Examples:'
say '   a:install'
say '   b:install b: d:'
say '   c:\temp\install c:\temp'
say '   e:\os2\install'

end:
call directory CurDir
exit x2d('FE00')
