
//===========================
// GameDlg.cpp
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Arcade Dialogs
// Class implementations
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#include <afxwin.h>
#include <afxcmn.h>
#include <afxres.h>

#include "resource.h"
#include "macros.h"
#include "hiscores.h"
#include "gamedlg.h"


//===========================
// CSpeedDialog

//-----------------
CSpeedDialog::CSpeedDialog(UINT id) : CDialog(id)
{
m_pslide = NULL;
m_iSpeed = MIN_FPS;
}

//-----------------
BOOL CSpeedDialog::OnInitDialog()
{
// Call base implementation
CDialog::OnInitDialog();

m_pslide = (CSliderCtrl *)GetDlgItem(IDC_SLIDER_SPEED);
m_pslide->SetRange(MIN_FPS,MAX_FPS);
m_pslide->SetTicFreq(5);
m_pslide->SetPos(m_iSpeed);

return TRUE;
}

//-----------------
BEGIN_MESSAGE_MAP(CSpeedDialog, CDialog)
   ON_WM_HSCROLL()
END_MESSAGE_MAP()

//-----------------
afx_msg void CSpeedDialog::OnHScroll(UINT iSBCode, UINT iPos, CScrollBar *pSB)
{
// pSB must point to our slider ctrl
if (pSB != (CScrollBar *)m_pslide) return;
m_iSpeed = m_pslide->GetPos();
}


//===========================
// CLevelDialog

//-----------------
CLevelDialog::CLevelDialog(UINT id) : CDialog(id)
{
m_pspin = NULL;
m_iLevel = 1;
}

//-----------------
BOOL CLevelDialog::OnInitDialog()
{
// Call base implementation
CDialog::OnInitDialog();

m_pspin = (CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_LEVEL);
m_pspin->SetBuddy(GetDlgItem(IDC_EDIT1));
m_pspin->SetRange(1,20);
m_pspin->SetPos(m_iLevel);

return TRUE;
}

//-----------------
void CLevelDialog::OnOK()
{
m_iLevel = m_pspin->GetPos();
EndDialog(IDOK);
// Call base implementation
/*CDialog::OnOK();*/
}

//-----------------
BEGIN_MESSAGE_MAP(CLevelDialog, CDialog)
END_MESSAGE_MAP()


//===========================
// CHighScoreDialog

//-----------------
CHighScoreDialog::CHighScoreDialog(UINT id) : CDialog(id)
{
m_plstScoreData = NULL;
m_plbRank = m_plbName = m_plbScore = NULL;
}

//-----------------
BOOL CHighScoreDialog::OnInitDialog()
{
// Call base implementation
CDialog::OnInitDialog();

m_plbRank = (CListBox*)GetDlgItem(IDC_LIST_RANK);
m_plbName = (CListBox*)GetDlgItem(IDC_LIST_NAME);
m_plbScore = (CListBox*)GetDlgItem(IDC_LIST_SCORE);
char szTemp[32];
for(int i=0; i < 10; i++)
   {
   sprintf(szTemp,"%2d:",i+1);
   m_plbRank->AddString(szTemp);
   m_plbName->AddString(m_plstScoreData->GetName(i));
   sprintf(szTemp,"%5d",m_plstScoreData->GetScore(i));
   m_plbScore->AddString(szTemp);
   }
return TRUE;
}

//-----------------
BEGIN_MESSAGE_MAP(CHighScoreDialog, CDialog)
END_MESSAGE_MAP()


//===========================
// CNewHighScoreDialog

//-----------------
CNewHighScoreDialog::CNewHighScoreDialog(UINT id) : CDialog(id)
{
m_pec = NULL;
}

//-----------------
BOOL CNewHighScoreDialog::OnInitDialog()
{
// Call base implementation
CDialog::OnInitDialog();

m_pec = (CEdit*)GetDlgItem(IDC_EDIT_NAME);
m_pec->SetWindowText(m_szName);

return TRUE;
}

//-----------------
void CNewHighScoreDialog::OnOK()
{
m_pec->GetWindowText(m_szName,15);
EndDialog(IDOK);
// Call base implementation
/*CDialog::OnOK();*/
}

//-----------------
BEGIN_MESSAGE_MAP(CNewHighScoreDialog, CDialog)
END_MESSAGE_MAP()

