
//===========================
// Xonix32.cpp
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Xonix32 main module
// Class implementations
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#include <afxwin.h>
#include <afxcmn.h>
#include <afxres.h>

#include "resource.h"
#include "macros.h"
#include "hiscores.h"
#include "gamewnd.h"
#include "xpoint.h"
#include "xbitmap.h"
#include "xonix32.h"


//===========================
// CGame

//-----------------
CGame::CGame(CGameWnd *pMainWnd)
{
//Attach to the frame-wnd obj
m_pGameWnd = pMainWnd;
m_pGameWnd->m_pGame = this;

//Copy shared resources from the frame-wnd obj
m_pdcCli = m_pGameWnd->m_pdcCli;
m_rcXCli = m_pGameWnd->m_rcCli;

//Fine-tune the virtual client rectangle
m_rcXCli.right = (OBJ_SIZE+(OBJ_MOVE*((m_rcXCli.right-OBJ_SIZE)/OBJ_MOVE)));
m_rcXCli.bottom = (OBJ_SIZE+(OBJ_MOVE*((m_rcXCli.bottom-OBJ_SIZE)/OBJ_MOVE)));

//Clear the msg overlay field
m_szMsgText[0] = '\0';
m_bStall = FALSE;

//Alloc obj arrays
m_pBDot = new XBDot[MAXBDOTS];
m_pDot = new XDot[MAXDOTS];
m_pLine = new XLine[MAXLINES];

//Set up shadow-bmp DC
m_dcMem.CreateCompatibleDC(m_pGameWnd->m_pdcCli);
m_gBmp.CreateCompatibleBitmap(m_pdcCli,m_pGameWnd->m_rcCli.right,m_pGameWnd->m_rcCli.bottom);
m_dcMem.SelectObject(&m_gBmp);
m_dcMem.SetBkColor(RGB_BLACK);
m_dcMem.SetBkMode(TRANSPARENT);

//Set up virtual bitmap
m_xBmp.Create(m_rcXCli.right,m_rcXCli.bottom);

//Load BMP objs
m_dcMemObj.CreateCompatibleDC(m_pdcCli);
m_gBmpGuy.LoadBitmap(IDB_GUY1);
m_gBmpBDot.LoadBitmap(IDB_BDOT1);
m_gBmpDot.LoadBitmap(IDB_DOT1);

//Create common GDI obj
m_gPenYellow.CreatePen(PS_SOLID,3,RGB_YELLOW);
m_gPenBlack.CreatePen(PS_SOLID,3,RGB_BLACK);
m_gFontFSys.CreateStockObject(SYSTEM_FIXED_FONT);

// Paint the splash screen
SplashScreen();
}

//-----------------
CGame::~CGame()
{
m_gPenYellow.DeleteObject();
m_gPenBlack.DeleteObject();
m_gBmpGuy.DeleteObject();
m_gBmpBDot.DeleteObject();
m_gBmpDot.DeleteObject();

delete [] m_pLine;
delete [] m_pDot;
delete [] m_pBDot;
}

//-----------------
UINT CGame::GameOver()
{
Paint(); //clear any previous messages

//Display msg
sprintf(m_szMsgText,"G A M E  O V E R");
Paint();
Sleep(1000);
SplashScreen();

return m_iScore;
}

//-----------------
void CGame::HandleKbd(UINT nChar)
{
switch (nChar)
   {
   //Movement keys
   /*case VK_SPACE: m_Guy.SetDir(0,0); break;*/
   case VK_LEFT:  m_Guy.SetDir(-OBJ_MOVE,0); break;
   case VK_UP:    m_Guy.SetDir(0,-OBJ_MOVE); break;
   case VK_RIGHT: m_Guy.SetDir(OBJ_MOVE,0); break;
   case VK_DOWN:  m_Guy.SetDir(0,OBJ_MOVE); break;
   
   //Cheat key
#ifndef RELEASE
   case VK_RETURN:
   if (m_pGameWnd->MessageBox("Jump ahead 5 levels?","Confirm Cheat Request...",
       MB_OKCANCEL|MB_ICONQUESTION) == IDOK)
      {
      m_iLevel+=5;
      m_nMen+=5; 

      Paint();
      Sleep(500); 
      NewLevel(TRUE);
      }
   break;
#endif //!release
   } //end of switch-block
}

//-----------------
void CGame::PauseGame(BOOL bPause)
{
return;
}

//-----------------
BOOL CGame::RunGame()
{
UINT i;
CPen *pOldPen;
CBitmap *pOldBmp;
BOOL bDead = FALSE, bDone = FALSE, bOldDraw = m_bDrawing;

//Check timer
if (--m_iTimeRemaining <= 0)
   {
   bDead = TRUE;
   sprintf(m_szMsgText,"Out of Time!");
   }

//Erase guy
pOldBmp = m_dcMemObj.SelectObject(&m_gBmpGuy);
 m_Guy.Draw(m_dcMemObj,m_dcMem);
m_dcMemObj.SelectObject(pOldBmp);

//Erase other objs
pOldBmp = m_dcMemObj.SelectObject(&m_gBmpBDot);
 for(i=0;i < m_nBDots;i++) m_pBDot[i].Draw(m_dcMemObj,m_dcMem);
m_dcMemObj.SelectObject(pOldBmp);

pOldBmp = m_dcMemObj.SelectObject(&m_gBmpDot);
 for(i=0;i < m_nDots;i++) m_pDot[i].Draw(m_dcMemObj,m_dcMem);
m_dcMemObj.SelectObject(pOldBmp);

pOldPen = m_dcMem.SelectObject(&m_gPenBlack);
 for(i=0;i < m_nLines;i++)
    {
    m_pLine[i].Draw(m_dcMem);
    m_pLine[i].EraseBG(m_xBmp);
    }
m_dcMem.SelectObject(pOldPen);

//Update guy and do RScan and such
if (m_bDrawing && m_Guy.CldRed(m_xBmp,TRUE)) bDead = TRUE;
m_Guy.Clip(m_rcXCli);
m_bDrawing = m_Guy.Update(m_dcMem, m_xBmp, m_bDrawing);

//Connected?
if (!bDead && bOldDraw && !m_bDrawing)
   {
   //Change red to blue on xBmp
   m_xBmp.Wipe(XBC_RED,XBC_BLUEGRN);
   
   //Mark white dots and yellowline endpoints on xBmp
   for(i=0;i < m_nDots;i++)
      {
      m_xBmp.SetPixel(m_pDot[i].x,m_pDot[i].y,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pDot[i].x+1,m_pDot[i].y,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pDot[i].x,m_pDot[i].y+1,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pDot[i].x+1,m_pDot[i].y+1,XBC_WHITE,TRUE);
      }
   for(i=0;i < m_nLines;i++)
      {
      m_xBmp.SetPixel(m_pLine[i].P0.x,m_pLine[i].P0.y,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P0.x+1,m_pLine[i].P0.y,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P0.x,m_pLine[i].P0.y+1,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P0.x+1,m_pLine[i].P0.y+1,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P1.x,m_pLine[i].P1.y,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P1.x+1,m_pLine[i].P1.y,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P1.x,m_pLine[i].P1.y+1,XBC_WHITE,TRUE);
      m_xBmp.SetPixel(m_pLine[i].P1.x+1,m_pLine[i].P1.y+1,XBC_WHITE,TRUE);
      }

   //Scan xBmp from four corners of current position
   UINT xx,yy;
   BOOL bFilled = FALSE;
   xx = m_Guy.x - OBJ_OFFSET; yy = m_Guy.y - OBJ_OFFSET;
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }
   xx = m_Guy.x - OBJ_OFFSET; yy = m_Guy.y + OBJ_OFFSET;
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }
   xx = m_Guy.x + OBJ_OFFSET; yy = m_Guy.y - OBJ_OFFSET;
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }
   xx = m_Guy.x + OBJ_OFFSET; yy = m_Guy.y + OBJ_OFFSET;
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }

   //Scan xBmp from four sides of previous position
   xx = (m_Guy.x-m_Guy.dx) - OBJ_OFFSET; yy = (m_Guy.y-m_Guy.dy);
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }
   xx = (m_Guy.x-m_Guy.dx) + OBJ_OFFSET; yy = (m_Guy.y-m_Guy.dy);
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }
   xx = (m_Guy.x-m_Guy.dx); yy = (m_Guy.y-m_Guy.dy) - OBJ_OFFSET;
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }
   xx = (m_Guy.x-m_Guy.dx); yy = (m_Guy.y-m_Guy.dy) + OBJ_OFFSET;
   if (!m_xBmp.GetPixel(xx,yy) && !m_xBmp.RScan(xx,yy))
      { m_xBmp.FloodFill(xx,yy,XBC_BLUEGRN); bFilled = TRUE; }

   //Remove dots and yellowline enpoints from xBmp
   for(i=0;i < m_nDots;i++)
      {
      m_xBmp.SetPixel(m_pDot[i].x,m_pDot[i].y,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pDot[i].x+1,m_pDot[i].y,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pDot[i].x,m_pDot[i].y+1,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pDot[i].x+1,m_pDot[i].y+1,XBC_WHITE,FALSE);
      }
   for(i=0;i < m_nLines;i++)
      {
      m_xBmp.SetPixel(m_pLine[i].P0.x,m_pLine[i].P0.y,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P0.x+1,m_pLine[i].P0.y,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P0.x,m_pLine[i].P0.y+1,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P0.x+1,m_pLine[i].P0.y+1,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P1.x,m_pLine[i].P1.y,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P1.x+1,m_pLine[i].P1.y,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P1.x,m_pLine[i].P1.y+1,XBC_WHITE,FALSE);
      m_xBmp.SetPixel(m_pLine[i].P1.x+1,m_pLine[i].P1.y+1,XBC_WHITE,FALSE);
      }

   //Cleanup after rscan calls
   m_xBmp.Wipe(XBC_GREY,XBC_NONE);

   //Stop the guy
   m_Guy.SetDir(0,0);

   //Refresh the shadow-ram from xBmp
   m_iFillFraction = m_xBmp.CalcFillFraction(m_xBmp.ExpandTo(m_dcMem));
   m_iFilledPixLine = 0;
   m_nFilledPix = 0;

   //Update status bar
   UpdateSB();
   } //end of connection if-block

//Update other obj positions and perform cld
for(i=0;i < m_nBDots;i++)
   {
   m_pBDot[i].Clip(m_rcXCli);
   m_pBDot[i].Update(m_xBmp);
   if (!m_bDrawing && m_pBDot[i].CheckDist(m_Guy) <= OBJ_SIZE) bDead = TRUE;
   }

for(i=0;i < m_nDots;i++)
   {
   m_pDot[i].Update(m_xBmp);
   if (m_bDrawing && m_pDot[i].CldRed(m_xBmp)) bDead = TRUE;
   }

for(i=0;i < m_nLines;i++)
   m_pLine[i].Update(m_xBmp);

//Draw objs
RenderObjs();

//Update fill percentage
m_nFilledPix += m_xBmp.CountFilledPix(m_iFilledPixLine,m_iFilledPixLine+20);
m_iFilledPixLine += 20;

if (m_iFilledPixLine >= (UINT)m_rcXCli.bottom)
   {
   m_iFillFraction = m_xBmp.CalcFillFraction(m_nFilledPix);
   m_iFilledPixLine = 0;
   m_nFilledPix = 0;
   }

//Check if we've won
if (m_iFillFraction >= 750)
   {
   bDone = TRUE;
   sprintf(m_szMsgText,"Level Complete!");
   }
   
//Check death flag
if (bDead)
   if (--m_nMen)
      {
      Paint();
      Sleep(1500);
      NewLevel(FALSE);
      return TRUE;
      }
   else
      {
      Paint();
      Sleep(1500);
      return FALSE; //game over
      }

//Check newlevel flag
if (bDone)
   {
   m_iLevel++;
   m_nMen++;
   m_iScore += 100+10*((1000/m_pGameWnd->m_iGameSpdDelay)-MIN_FPS);
   m_iScore += ((m_bBonusElligible) ? BONUS_CALC(m_iTimeRemaining,m_iLevelTimeLimit) : 0);

   Paint();
   Sleep(1500);
   NewLevel(TRUE);
   return TRUE;
   }

//Check quit flag
if (m_bQFlag) //escape was pressed
   return FALSE; //game over

//Continue running
return TRUE;
}

//-----------------
void CGame::RenderObjs()
{
UINT i;
CPen *pOldPen;
CBitmap *pOldBmp;

//Draw objs
pOldPen = m_dcMem.SelectObject(&m_gPenYellow);
 for(i=0;i < m_nLines;i++) m_pLine[i].Draw(m_dcMem);
m_dcMem.SelectObject(pOldPen);

pOldBmp = m_dcMemObj.SelectObject(&m_gBmpDot);
 for(i=0;i < m_nDots;i++) m_pDot[i].Draw(m_dcMemObj,m_dcMem);
m_dcMemObj.SelectObject(pOldBmp);

pOldBmp = m_dcMemObj.SelectObject(&m_gBmpBDot);
 for(i=0;i < m_nBDots;i++) m_pBDot[i].Draw(m_dcMemObj,m_dcMem);
m_dcMemObj.SelectObject(pOldBmp);

pOldBmp = m_dcMemObj.SelectObject(&m_gBmpGuy);
 m_Guy.Draw(m_dcMemObj,m_dcMem);
m_dcMemObj.SelectObject(pOldBmp);
}

//-----------------
void CGame::Paint()
{
//Msg stalling before bitblt wipe
if (m_bStall)
   {
   Sleep(1500);
   m_szMsgText[0] = '\0';
   m_bStall = FALSE;
   }

//BitBlt from shadow-bmp to client-area
m_pdcCli->BitBlt(0,0,m_pGameWnd->m_rcCli.right,m_pGameWnd->m_rcCli.bottom,&m_dcMem,0,0,SRCCOPY);

//Overlay messages (if any) onto shadow-bmp
if (m_szMsgText[0])
   {
   CFont *pOldFont = m_pdcCli->SelectObject(&m_gFontFSys);
    m_pdcCli->SetTextAlign(TA_BASELINE|TA_CENTER);
    m_pdcCli->SetTextColor(RGB_YELLOW2);
    m_pdcCli->TextOut((m_rcXCli.right/2),(m_rcXCli.bottom/2),m_szMsgText,strlen(m_szMsgText));
   m_pdcCli->SelectObject(pOldFont);

   // Set flag to cause delay before next repaint
   m_bStall = TRUE;
   }
}

//-----------------
void CGame::UpdateSB()
{
//Generate status bar text
sprintf(g_szBuffer,"Level:%d   Xonii:%d   Score:%d   Filled:%4.1f%%   Bonus:%d   Time:%d",
        m_iLevel,m_nMen,m_iScore,(float)(m_iFillFraction)/10.0,
        ((m_bBonusElligible) ? BONUS_CALC(m_iTimeRemaining,m_iLevelTimeLimit) : 0),
        (m_iTimeRemaining/NOM_FPS));
        

//Append fps info
#ifdef BENCH_FPS
sprintf(g_szBuffer,"%s     fps:%5.2f",
        g_szBuffer,m_pGameWnd->m_fFPS);
#endif //bench_fps

//Low-time warnings and bonus display
if (m_iTimeRemaining <= NOM_FPS)
   sprintf(g_szBuffer,"%s   <<< Out of Time!",g_szBuffer);
else if ((m_iTimeRemaining < 31*NOM_FPS) && !((m_iTimeRemaining/NOM_FPS)&0x0001)) //flashing
   sprintf(g_szBuffer,"%s   <<< Low Time!",g_szBuffer);

m_pGameWnd->m_sbarc.SetText(g_szBuffer,255,0);
m_pGameWnd->m_sbarc.UpdateWindow();
}

//-----------------
void CGame::NewLevel(BOOL bClear)
{
UINT i;
CRect rcTemp;

//Init vars
m_bDrawing = FALSE;
m_bQFlag = FALSE;
m_bBonusElligible = bClear;

m_nFilledPix = 0;
m_iFilledPixLine = 0;
m_iFillFraction = 0;

m_bStall = FALSE;
m_szMsgText[0] = '\0';

//Calculate time limit based on level
m_iLevelTimeLimit = NOM_FPS*MIN(60*5,60*m_iLevel);

if (!bClear && !m_iTimeRemaining) //if death due to timeout, halve the time limit!
   m_iTimeRemaining = m_iLevelTimeLimit /= 2;
if (bClear) m_iTimeRemaining = m_iLevelTimeLimit;

//Set starting position at top center of screen
m_Guy.SetPos((UINT)(OBJ_MOVE*(m_rcXCli.right/OBJ_MOVE)/2)-1,OBJ_MOVE-1);
m_Guy.SetDir(0,0);

//Randomize obj positions
m_nBDots = LEVEL2BDOTS(m_iLevel);
rcTemp.SetRect(20,m_rcXCli.bottom-10,m_rcXCli.right-20,m_rcXCli.bottom-8);
for(i=0;i < m_nBDots;i++)
   m_pBDot[i].Randomize(rcTemp,2,OBJ_MOVE-1);

if (bClear)
   {
   m_nDots = LEVEL2DOTS(m_iLevel);
   rcTemp.SetRect(50,50,m_rcXCli.right-50,m_rcXCli.bottom-50);
   for(i=0;i < m_nDots;i++)
      m_pDot[i].Randomize(rcTemp,1,OBJ_MOVE-1);

   m_nLines = LEVEL2LINES(m_iLevel);
   rcTemp.SetRect(50,50,m_rcXCli.right-50,m_rcXCli.bottom-50);
   for(i=0;i < m_nLines;i++)
      m_pLine[i].Randomize(rcTemp,1,OBJ_MOVE-2);
   }

//Draw init screen
if (bClear)
   {
   m_dcMem.FillSolidRect(m_pGameWnd->m_rcCli,RGB_BLUEGRN);
   m_xBmp.Clear();
   m_xBmp.FillSolidRect(m_rcXCli,XBC_BLUEGRN,TRUE);
   rcTemp = m_rcXCli;
   rcTemp.DeflateRect(BORDER_THICKNESS,BORDER_THICKNESS);
   m_xBmp.FillSolidRect(rcTemp,XBC_FULL,FALSE);
   }
else
   {
   m_xBmp.Wipe(XBC_RED,XBC_NONE); //remove redline
   }

//Refresh the shadow-ram from xBmp
m_iFillFraction = m_xBmp.CalcFillFraction(m_xBmp.ExpandTo(m_dcMem));

//Display msg
sprintf(m_szMsgText,"Ready...");

//Update status bar
UpdateSB();

//Draw objs
RenderObjs();
}

//-----------------
void CGame::NewGame(UINT iInitLevel)
{
//Reset all game-level vars
m_iLevel = iInitLevel;
m_iScore = 0;
m_nMen = 3;

//Init the first level
NewLevel(TRUE);
}

//-----------------
void CGame::SplashScreen()
{
long x,y;
CBitmap gBmpSplash;
CBitmap* pOldBmp;
CPen* pOldPen;
CRect rcTemp;

// Draw blue border
m_dcMem.FillSolidRect(m_pGameWnd->m_rcCli,RGB_BLUEGRN);
rcTemp = m_rcXCli;
rcTemp.DeflateRect(BORDER_THICKNESS,BORDER_THICKNESS);
m_dcMem.FillSolidRect(rcTemp,RGB_BLACK);

// Draw title bitmap
x = (m_pGameWnd->m_rcCli.right/2)-(121/2);
y = (m_pGameWnd->m_rcCli.bottom/2)-(47/2);
gBmpSplash.LoadBitmap(IDB_SPLASH); //121x47
pOldBmp = m_dcMemObj.SelectObject(&gBmpSplash);
 m_dcMem.BitBlt(x,y,121,47,&m_dcMemObj,0,0,SRCCOPY);
m_dcMemObj.SelectObject(pOldBmp);
gBmpSplash.DeleteObject();

// Draw yellowlines for "X"
x -= 15; y += 15;
m_pLine[0].P0.x = x-20; m_pLine[0].P0.y = y-40;
m_pLine[0].P1.x = x+20; m_pLine[0].P1.y = y+40;
m_pLine[1].P0.x = x-20; m_pLine[1].P0.y = y+40;
m_pLine[1].P1.x = x+20; m_pLine[1].P1.y = y-40;

pOldPen = m_dcMem.SelectObject(&m_gPenYellow);
 m_pLine[0].Draw(m_dcMem);
 m_pLine[1].Draw(m_dcMem);
m_dcMem.SelectObject(pOldPen);

// BitBlt
Paint();
}


//===========================
// CXonixApp

//-----------------
BOOL CXonixApp::InitInstance()
{
#ifdef _AFXDLL
Enable3dControls(); //when using mfc in a shared dll
#else //!_afxdll
Enable3dControlsStatic(); //when linking to mfc statically
#endif //_afxdll

// Register custom class
CString sClassName = AfxRegisterWndClass(0,LoadStandardCursor(IDC_ARROW),0,LoadIcon(IDI_ICON32));

// Render the main window
m_pMainWnd = new CGameWnd(sClassName,m_lpCmdLine);
m_pMainWnd->ShowWindow(m_nCmdShow);
m_pMainWnd->UpdateWindow();

// Insantiate the game object
m_pGame = new CGame((CGameWnd *)m_pMainWnd);

//Open an output file
#ifdef LOGFILE
g_pfLog = fopen("logfile.out","w");
#endif //logfile

return TRUE;
}

//-----------------
int CXonixApp::ExitInstance()
{
//Close the output file
#ifdef LOGFILE
fclose(g_pfLog);
#endif //logfile

// Delete the game object
delete m_pGame;

return 0;
}

//-----------------
BOOL CXonixApp::OnIdle(long lCount)
{
//Allow system processing
BOOL bMore = CWinApp::OnIdle(lCount);

//Check for NULL ptr
if (!m_pGame) return bMore;

//Idle-time processing (with hires timing) is used for the main loop
bMore |= m_pGame->m_pGameWnd->MainLoop();
bMore |= m_pGame->m_pGameWnd->AnimLoop();

//Allow NT systems to relenquish the remainder of the timeslice
//if (???WinNT???) Sleep(0);

return bMore;
}

//===========================
// Globals

#ifdef LOGFILE
FILE *g_pfLog;
#endif //logfile

char g_szBuffer[256];

CXonixApp theApp;
