
//===========================
// XPoint.h
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Point-class objects
// Class declarations
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#ifndef __XPOINT_H__
#define __XPOINT_H__

//Class dependencies
#include "xbitmap.h"

//-----------------
class XPoint
{
protected:
   BOOL m_bBlueBase;

public:
   UINT x,y;
   int dx,dy;

public:
   XPoint() { m_bBlueBase = FALSE; x=y=dx=dy=0; }
   //~XPoint();

   void SetPos(UINT xx, UINT yy) { x=xx; y=yy; }
   void SetDir(int xx, int yy) { dx=xx; dy=yy; }
   void Incr() { x += dx; y += dy; }
   void Decr() { x -= dx; y -= dy; }

   virtual void Randomize(CRect rc, UINT iMinD, UINT iMaxD);
   virtual BOOL Clip(CRect rc); //ret TRUE if out of bounds
   virtual BOOL Update(XBitmap &xBmp); //ret TRUE if bounce

   UINT CheckDist(XPoint &point) //ret approximation of distance between points
      { return (abs(x-point.x) + abs(y-point.y)); }
   void Draw(CDC &BmpDC, CDC &DC)
      { DC.BitBlt(x-OBJ_OFFSET,y-OBJ_OFFSET,OBJ_SIZE,OBJ_SIZE,&BmpDC,0,0,SRCINVERT); }
};

//-----------------
class XPointNoRed : public XPoint //this class adds redline cld
{
public:
   BOOL CldRed(XBitmap &xBmp, BOOL bThorough=FALSE); //ret TRUE if redline collision condition exists
};

//-----------------
class XGuy : public XPointNoRed
{
public:
   //XGuy();
   //~XGuy();
   BOOL Clip(CRect rc); //no bounce; ret TRUE if clipped
   BOOL Update(CDC &DC, XBitmap &xBmp, BOOL bDraw); //draw redline; ret TRUE if still drawing
};

//-----------------
class XDot : public XPointNoRed
{
public:
   XDot() { m_bBlueBase = FALSE; }
   //~XDot();
};

//-----------------
class XBDot : public XPoint
{
public:
   XBDot() { m_bBlueBase = TRUE; }
   //~XBDot();
   BOOL Clip(CRect rc); //bounce; ret TRUE if clipped
};

//-----------------
class XLine
{
public:
   XPoint P0, P1;

public:
   //XLine();
   //~XLine();
   void Randomize(CRect rc, UINT iMinD, UINT iMaxD)
      {
      P0.Randomize(rc,iMinD,iMaxD);
      P1.Randomize(rc,iMinD,iMaxD);
      }
   void Update(XBitmap &xBmp)
      {
      P0.Incr(); if (!P0.Update(xBmp)) P0.Decr();
      P1.Incr(); if (!P1.Update(xBmp)) P1.Decr();
      }
   void Draw(CDC &DC)
      { 
      DC.MoveTo(P0.x,P0.y); 
      DC.LineTo(P1.x,P1.y); 
      }
   void EraseBG(XBitmap &xBmp)
      {
      xBmp.Line(P0.x,P0.y,P1.x,P1.y,XBC_FULL,FALSE);
      }
};


#endif //include-guard
