
//===========================
// GameWnd.h
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Arcade Frame Window
// Class declaration
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#ifndef __GAMEWND_H__
#define __GAMEWND_H__

//Hires timing conversion function
double LI2Double(LARGE_INTEGER *pli);

//Class prototypes
class CGame;

//-----------------
class CGameWnd : public CFrameWnd
{
private:
   CGame *m_pGame;

   LARGE_INTEGER m_liTemp; //temp quadword timer value
   double m_dFreq; //hires timer frequency
   double m_dGameTime,m_dPrevGameTime; //hires OnIdle() loop timing
   double m_dAnimTime,m_dPrevAnimTime; //hires OnIdle() loop timing
   UINT m_iRefreshDelay, m_iGameSpdDelay, m_iClockDelay; //timer intervals (milliseconds)
   UINT m_iInitLevel; //starting level
   BOOL m_bRunning, m_bPaused; //control flags
   CScoreList m_lstHighScores; //high score table data

   UINT m_iWndSizeX, m_iWndSizeY; //overall window size
   CRect m_rcCli; //client-area rectangle
   CClientDC *m_pdcCli; //private dc for faster client-area refresh
   CFont m_gFontFSys; //fixedsys font for general purpose use
   CMenu m_menu; //main-frame menu-bar object
   CStatusBarCtrl m_sbarc; //main-frame status-bar common-ctrl object
   
#ifdef BENCH_FPS
   float m_fFPS;
#endif //BENCH_FPS

public:
   CGameWnd(CString sClassName, char *pszCmdLine);
   ~CGameWnd();

   //Primary game functions
   BOOL MainLoop();
   BOOL AnimLoop();
   void GameOver();

   //System event handlers for CGameWnd
   afx_msg void OnActivateApp(BOOL bActive, HTASK hTask);
   afx_msg BOOL OnEraseBkgnd(CDC *pDC);
   afx_msg void OnPaint();
   afx_msg void OnTimer(UINT nIDEvent);

   //UI event handlers
   afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);

   //Menu event handlers
   afx_msg void OnGameNew();
   afx_msg void OnGameNewUpdate(CCmdUI *pCmdUI);
   afx_msg void OnGamePause();
   afx_msg void OnGamePauseUpdate(CCmdUI *pCmdUI);
   afx_msg void OnGameEnd();
   afx_msg void OnGameEndUpdate(CCmdUI *pCmdUI);
   afx_msg void OnOptionsSpeed();
   afx_msg void OnOptionsSpeedUpdate(CCmdUI *pCmdUI);
   afx_msg void OnOptionsLevel();
   afx_msg void OnOptionsLevelUpdate(CCmdUI *pCmdUI);
   afx_msg void OnViewScores();
   afx_msg void OnViewScoresUpdate(CCmdUI *pCmdUI);
   afx_msg void OnHelpAbout();

   DECLARE_MESSAGE_MAP()

friend class CGame;
};


#endif //include-guard
