
//===========================
// Xonix32.h
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Xonix32 main module
// Class declarations
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#ifndef __XONIX32_H__
#define __XONIX32_H__

//Class prototypes and dependencies
class CGameWnd; 
#include "xbitmap.h"
#include "xpoint.h"

//===========================
// Class declarations

//-----------------
class CGame
{
private:
   //From frame wnd
   CClientDC *m_pdcCli; //dc for client area
   CRect m_rcXCli; //client area rect (adjusted)

   //DCs
   CDC m_dcMem; //dc for client-shadow bmp
   CDC m_dcMemObj; //for game obj bliting

   //GDI objs
   XBitmap m_xBmp; //stores blue/black background data
   CBitmap m_gBmp; //client-shadow bmp
   CBitmap m_gBmpGuy, m_gBmpBDot, m_gBmpDot; //obj-bmps
   CPen m_gPenYellow, m_gPenBlack;
   CFont m_gFontFSys;

   //Game objs
   UINT m_nBDots, m_nDots, m_nLines;
   XGuy m_Guy;
   XBDot *m_pBDot;
   XDot *m_pDot;
   XLine *m_pLine;
   
   //Misc game vars
   UINT m_nMen,m_iLevel,m_iScore; //the obvious game vars

   int m_iLevelTimeLimit, m_iTimeRemaining; //time vars

   UINT m_iFillFraction; //fraction of game surface filled (1000:100%)
   UINT m_nFilledPix; //temp accumulator for number of bluegrn pix
   UINT m_iFilledPixLine; //accumulator raster-marker
   
   BOOL m_bDrawing, m_bQFlag, m_bBonusElligible; //flags

   BOOL m_bStall; //pause flag for gamescreen overlay text
   char m_szMsgText[32]; //gamescreen overlay text

public:
   CGameWnd *m_pGameWnd; //ptr to frame wnd

   CGame(CGameWnd *pMainWnd);
   ~CGame();

   void ShowScores();
   void SplashScreen();
   void NewGame(UINT iInitLevel);
   void NewLevel(BOOL bClear);
   BOOL RunGame(); //ret bGameOver
   void PauseGame(BOOL bPause);
   void HandleKbd(UINT nChar);
   void UpdateSB();
  	void Paint();
   void RenderObjs();
   UINT GameOver(); //ret iScore
};

//-----------------
class CXonixApp : public CWinApp
{
private:
   CGame *m_pGame; //pointer to game object

public:
   //virtual BOOL InitApplication();
   virtual BOOL InitInstance();
   virtual int ExitInstance();
   virtual BOOL OnIdle(long lCount);
   //virtual BOOL IsIdleMessage(MSG* pMsg);
};


#endif //include-guard
