Manual REBEL DECADE 1.2 Contents

Preface and user definitions.
          
Ch. 1: INSTALLATION
      1.1. System requirements
      1.2. The installation
      1.3. Files and directories after installation
      1.4. The REBEL.CFG file
      1.5. Hints for system optimization
      1.6. The README file

Ch. 2: REBEL SCREEN (Not available in this manual)
	
Ch. 3: THE FIRST GAME
      3.1. Move input
      3.2. Manipulating moves
      3.3. Changing the chess program (briefly)
      3.4. Leaving the program

Ch. 4: GENERAL RULES FOR OPERATION
      4.1. Moving pieces for keyboard users
      4.2. Using the pulldown-menus
      4.3. Using the buttons
      4.4. Using Hotkeys
      4.5. Loading and saving files
           4.5.1. Loading files
           4.5.2. Saving files
           
Ch. 5: INFLUENCING THE CHESS ENGINE
      5.1. Changing the chess engine of REBEL DECADE 1.2
      5.2. The different time levels under LEVEL F2
      5.3. The different options under OPTIONS F3
           5.3.1. Permanent brain 
           5.3.2. Brute force
           5.3.3. Combination
           5.3.4. Selection
           5.3.5. Playing style
           5.3.6. Easy play    
           5.3.7. Hashtables    
      5.4. Book openings
           5.4.1. Loading opening books (DATA F4)
           5.4.2. Book opening on/off (SETTINGS F5)
           5.4.3. Alternative opening books

Ch. 6: DATABASE
      6.1. Database loading and saving
      6.2. Loading a game (DATA F4)
      6.3. Loading next game (DATA F4)
      6.4. Saving a game (DATA F4)
      6.5. Rewrite a game (DATA F4)
      6.6. Delete a game (DATA F4)
      6.7. Reorganisation (DATA F4)
      6.8. Search functions (DATA F4)
           6.8.1. Searching by name
           6.8.2. Searching by text 
           6.8.3. Searching by moves    
           6.8.4. Searching by position
      6.9. Overviews (DATA F4)
           6.9.1. Complete overview   
           6.9.2. Overview top 40 by percentage
           6.9.3. Overview top 40 by ELO-rating 
           6.9.4. Overview of tournaments
           6.9.5. Overview of matches     
           6.9.6. Overview of book openings
      6.10. Creating a new and empty database (DATA F4)
            
Ch. 7:  SCREEN SETTINGS
       7.1. Save original settings (START F1)
       7.2. Changing names (SETTINGS F5)
       7.3. Show material (SETTINGS F5)
       7.4. Show hint (SETTINGS F5)
       7.5. Show teacher (SETTINGS F5)
       7.6. Show variation (SETTINGS F5)
       7.7. Turn board (SETTINGS F5)
       7.8. Languages (SETTINGS F5)
       7.9. Changing colours (SETTINGS F5)
       7.10. Changing piece sets (SETTINGS F5)
       7.11. The comment field

Ch. 8: SETTING UP POSITIONS (POS F6)
       8.1. Set up a position (POS F6) 
       8.2. Make board empty (POS F6)
       8.3. Abort set up (POS F6) 
       8.4. White/black to move (POS F6)

Ch. 9: REMAINING OPTIONS
       9.1. Analysis mode (NIVO F2)
       9.2. Player-Player mode (OPTIONS F3)
       9.3. Automatic play (OPTIONS F3)
       9.4. Analyse game (OPTIONS F3)
       9.5. Analyse database (OPTIONS F3)
       9.6. Goto move number (OPTIONS F3)
       9.7. Search for move (OPTIONS F3)
       9.8. Goto end of game (OPTIONS F3)
       9.9. Replay game (OPTIONS F3)
       9.10. Write move comments (OPTIONS F3)
       9.11. Game to textfile (OPTIONS F3)
       9.12. Moves to Printer (OPTIONS F3)
       9.13. Starting game (DATA F4)
       9.14. Sound on/off (SETTINGS F5)
       9.15. Mouse on/off (SETTINGS F5)
       9.16. Swapping clocks
       9.17. Swapping names
       
Ch. 10: TROUBLE-SHOOTING
       10.1. AUTOEXEC.BAT problems
       10.2. Missing files

Ch. 11: THE MEPHISTO BOARD
       11.1. Moving a piece on the Mephisto Board
       11.2. Mephisto Board ON/OFF

Ch. 12: SHORT HISTORY



PREFACE AND USER DEFINITIONS.

Dear reader,
 
Welcome to the growing number of chess players who want to take
advantage of the PC. By obtaining REBEL DECADE 1.2 you have made a good choice in 
the area of computer chess software. Not only because the chess programs from
Ed Schrder belong to the group of the strongest programs available, but also
because of the fact that this program combines good chess with an build-in
database which will give you so much new and extra possibilities, that we are
convinced that you will apreciate the possibilities of your PC more and more,
but also, and that is of course the main point, you will even more enjoy the
game of chess.
        
The REBEL team from Schrder BV.

USER DEFINITIONS
          
COPYRIGHT
The REBEL DECADE 1.2 software is the exclusive property of Schrder BV and 
is protected by Dutch and International law. You are prohibited from
transferring this product in any way or form whatsoever.
It is forbidden to change, split, dissamble or produce any changed
form of this product.

LIMITED WARRANTY
The media upon which the program is recorded is warranted to be free
from defects for the standard guarantee specified by legislative
regulations. The warranty is void if the failure of the media is due
to accident, abuse or misapplication. Apart from this warranty
Schrder BV or his suppliers will not in any event be liable for any
loss, including consequential loss, caused by any error or defect
howsoever arising. In any case liability shall be limited to the 
amount actually paid by the purchaser for the software.

These conditions are governed by Dutch law.

Ch. 1: INSTALLATION

1.1. System requirements
The following PC specifications are required:
80386-processor or higher, VGA-card and monitor, minimum 2Mb internal memory, a
hard disk with at least 2 MB free space, MS-DOS 4.0 or higher.
Recommended is an extern disk-caching program (128 or 256 Kb).
This is especially desirable when using the database options.
        
1.2. The installation
* put the floppydisk in the flopp-drive of your PC;
* activate the drive (type for example "a:" + ENTER)
* type "install" + ENTER
* the screen will show you the default settings and will ask you for
  confirmation. 
* if you answer with "Y" the program will start the installation.
* answering "N" allows you of changing the settings.

1.3. Files and directories which must be present after installation

Files
* REBEL.EXE : the chess program
* REBEL.CFG : the user settings (see chapter 1.4)
* REBEL.BGN : information about the game you were in the last time 
              you used REBEL DECADE 1.2
* REBEL.TRL : the language file
* REBEL.GIF : the welcome screen (picture)
* BOOK.TRL  : the names of the book openings in available languages
* BOOK.TRX  : the corresponding moves with the BOOK.TRL file
           
 Directories
* BOOKS containing 3 book opening files:
 1. REBEL.MVS (400.000 moves)
 2. SMALL.MVS (100.000 moves)
 3. KASPAROV.MVS (100.000 moves)
* GAMES containing 4 databases:
 1. GAMESBASE:  containing more than 1000 (grand)master games.
 2. TACTICS  :  50 tactical positions with full explanation
 3. BT-2450  :  30 positions of the well-known BT-test in order to test 
                the strength of the computer
 4. BT-2630  :  the latest BT-test for strong programs
* TEXT in this directory the program will write all requested textfiles
* PIECES contains three different piece sets: REBEL, CREATIVE and BLOCK.PCS

Trouble-shooting in the event that certain files are missing.
No REBEL.CFG: the program will automatically take the default values
              after installation
No REBEL.BGN: the program will start up with a new game
No REBEL.TRL: the program will stop, restore this file from your floppy-disk
No REBEL.MVS: you will be prompted with a warning message, you will then 
              have the choice to either stop or to play on without an
              opening book
No REBEL.PCS: the program will stop, restore this file from your floppy-disk
No REBEL.GIF: the program will stop, restore this file from your floppy-disk

Should the program stop, you will have to restore the missing file(s)
from your floppy-disk or you have to install the program again.
          
1.4. The REBEL.CFG file      
The REBEL.CFG contains the following user settings
* name (and path) of the current opening book
* name (and path) of the current database
* name (and path) of the current piece set
* the screen colours
* turn board yes/no
* opening book on/off
* used language
* save main variation yes/no
* show main variation yes/no
* sound on/off
* show material yes/no
* show hint move yes/no
* mouse on/off

The fundamental choice is made NOT to save any changed settings of the
chess program. This means in practise that if you start REBEL DECADE 1.2 the
program automatically plays with the strongest settings.
An exception is made for the time level. This information is saved
in the REBEL.BGN file.

1.5. Hints for system optimalization
To obtain the fastest results with the databas, we advise you stongly the use
of disk-caching programs, such as Smartdrive or Norton Cache, since these
extremely speedup your Harddisk.
We have noticed an increase of disk speed of 400% using Smartdrive and
even an increase of 900% using the Norton Speedcache from Symantec by certain 
overviews in a big database.

1.6 README-file
A readme-file that will give you more detailed information about some aspects
and options of the program is available.
This README-file also contains lots of valuable hints and examples
about the use of the program.


Ch. 3: THE FIRST GAME 

If you want to play a game with white, just input the desired opening move and
the computer starts calculating its move.
If you wish to play with black, click the REBEL button, or press ALT_M.

3.1. Move input
You can input a move in different ways.
1) Click with the mouse on the piece you want to move.
   Click with the mouse on the square you want to go to.
2) Use the cursor keys to go to the square where the piece you want to
   move resides, and press ENTER. Drag the piece with the cursor keys to the
   square you want to go to, and press ENTER again.
3) Type the coordinates of the move in 4 characters. 
   For example type e2e4.        

You can use variations of these three systems if you wish.
If your move is legal, the piece is moved and the computer will start
evaluating it's own move.
4) If the indicated hint move is also your choice then you can speed up the
   input of that move by clicking on the hint move with the mouse. 
   Keyboard users can use ALT_H.
5) Mouse users can make use of the following quick input procedure:
   If the comment field contains hint moves from the opening book,
   then clicking on those moves will also execute them.
6) If you want the computer to play another book move, press F10.
   This is the so-called next best function and is only active  when the
   computer knows the current position from its book.
              
3.2. Manipulating moves 
The buttons provide you with a number of possibilities to manipulate the 
moves (for details, see 4.3)
Button    <<    fast takeback 3 moves
Button    <     takeback  move
Button  REBEL   force program to start calculating it's move, or if that is 
		already the case, force the program to play the best move 
                so far.
Button    >      move forward
Button    >>    3 moves forward

Mouse users have the possibility to click on any move in the Move section, for
super fast takeback! By accessing menu OPTIONS F3, you can also go to specific
moves (see 9.6, 9.7 and 9.8).

3.3. Changing the chess program (briefly)
In this chapter we briefly indicate the possibilities for changing
the evaluations of the program. For more details, we refer to chapter 5.   
* You can change the average time the computer uses to calculate a
  move via NIVO F2.
* You can change the program's thinking depth, the memory it uses,
  and the thinking when you are on the move via OPTIONS F3.
* You can change from which opening book you want to play or cancel
  the opening book completely via DATA F4 and SETTINGS F5.
             
3.4. Leaving the program
You leave the program by accessing START F1 Back to Dos or by 
pressing ALT_X. If you have changed any of the user settings, the program will
ask you if you want to save them or not. 

           
Ch. 4: GENERAL RULES CONCERNING OPERATING

Basically you can go back to the game by pressing ESC wherever you are in the
program. When in the database, mouse users can return to the game by clicking in
the upperleft corner of the screen.
        
4.1. Moving pieces for keyboard users
Use the cursor keys to go to the square where the piece you want
to move resides, and press ENTER. Drag the piece with the cursor keys 
to the square you want to go to, and press ENTER again.
PG-UP  square sloping right above
PG-DWN square sloping right down
       
4.2. Using the pull-down menus
The use of the 6 pull-down menus is similar to Windows.
There are two ways to operate them: clicking without holding the 
mouse, and clicking when holding the mouse.
If you click the mouse on one of the menus, the functions in the particular menu
will appear on your screen. Make your choice by clicking on one of the functions
inside the menu. If you click on a menu by holding the mouse you can drag the
mouse  to the desired function in the menu. If you release the mouse the
function will be executed immediately. In this case, the scroll bar will follow
the mouse movements.
Keyboard users can access the pull-down menus with the F1 to F6 buttons. 
The cursor keys will move the scroll bar to the desired function. 
Some functions in the pull-down menus have sub-menus, displayed as 
 or . You can access them by moving the mouse to the given 
direction. Keyboard users can use the cursor keys.
      
4.3. Using the buttons
You can operate the buttons by a short click with the mouse and the
button will light up shortly. 
Keyboard users can use the corresponding Hotkeys.

Keys Functions
  <<       Takeback three moves (Hotkey ALT_B) 
  <        Takeback a half-move (Hotkey "-")
 REBEL     Force the program to calculate a move or, if the program is already
           calculating, force the program to move. (Hotkey ALT_M). 
           This button will change into GAME in the analysis level which will
           allow you to restore to the moves that were current before you 
           started analysing.
           This button will change into EXIT while analysing a game or a 
           database and allows you to abort the analysis to return to the 
           current game.               
  >        Move forward a half-move (Hotkey "+")
  >>       Move forward three moves (Hotkey ALT_F)                

4.4. Using Hotkeys
Several Hotkeys are available, mostly based on pressing the ALT
button simultaneously with another key. Using hotkeys will result in a faster
and more convenient way of operating the program.

Overview
 ALT_B  = button <<
  "-"   = button <
 ALT_M  = button REBEL or, when in the database, swap display between 
          text and the three next moves.
  "+"   = button >
 ALT_F  = button >>
 ALT_G  = START F1-new game
 ALT_X  = START F1-back to DOS
 ALT_L  = DATA F4-load game
 ALT_N  = DATA F4-load next game
 ALT_I  = DATA F4-game info when a game is loaded.
 ALT_T  = If the teacher function is active, this will swap the current   
	  information in the comment field with the teacher info results.
          Within the database ALT_T will write to a text file.
 ALT_H  = Execute hint move if present.
      
4.5. Loading and saving files

4.5.1. Loading files
DATA F4-load database With this option you load/select another database.
DATA F4-load book With this option you load/select another opening library.
SETTINGS F5-piece set With this option you load/select another piece set. 
The default directories and filenames of the database, opening library and 
piece set will be saved in the REBEL.CFG file. The move section will change
in an alphabetic overview of the present subdirectories and files in the 
current selected directory.
By clicking on (sub)directories and harddisk(s), you can have access to
any file. Floppy drives are not available for loading and saving files in 
the REBEL program. You can easily load the desired file by clicking on it.
Keyboard users have to confirm their choice with pressing the ENTER key. For
fast scrolling a scrollbar is availbale for mouse users in addition to the
overview. Keyboard users can use the PG-UP, PG-DWN, HOME and END keys for this
purpose.
In the level section all available harddisks are displayed, for keyboard user
accessable with the left and right arrow keys.
To leave the option, press ESC or click outside the menu.

4.5.1. Saving files
Used in the following functions:
* OPTIONS F3-game to text file.
* DATA F4-create new database.
* OPTIONS F3-analyse database if the file ANALYSE.DAT already exist.
* DATA F4-overviews. 
In all cases you will be prompted to type a filename of your choice.
You are obliged to input a valid DOS file name. The program will warn
you if the filename is not valid. In case the file name already exists,
the program will ask for a confirmation to overwrite the existing file.
              
Ch. 5: INFLUENCING THE CHESS ENGINE

5.1. Changing the chess engine of REBEL DECADE 1.2
You can change the chess engine of the program in many ways.
Since the program always starts with the strongest settings, this 
means that every change you make will result in weakening the program.

5.2. The different time levels under LEVEL F2
At the start of the program, the playing level is taken from the
last time you used the program. By changing the level of play, you 
can make the program stronger or weaker. The general rule is: 
The more time you give to the program, the stronger it will play.

Overview
TIME       The program will play on the selected average time.
BLITZ      Play a game with a fixed amount of time. The program will warn 
           you if you exceeded the time limit. In this case you have lost 
           the game. You can see your remaining time in the time section.
HANDICAP   Same as BLITZ, but now you can reserve more time for yourself 
           and less for the computer. You can see your remaining time in 
           the time section.
TOURNAMENT Play a game on a desired tournament level.
           The program will warn you if you exceeded the time limit. 
           In this case you have lost the game.
           After the time control(s), you will receive the extra time needed.
           You can see your remaining time in the time section.
PLY        Let the program play on a fixed (ply) depth.
MATE       A special level for solving difficult Mate problems.
           The program will ONLY search for a possible move sequence to 
           achieve checkmate. If a mate is not possible at the current board
           position, the program will display: "No mate possible" and no 
           move is being given by the program.
USER       Same as TIME, but now you can define your own favourite level of
           play. You will be prompted to type the desired time. Type for 
           example 00:25 and the program will play at an average time of 
           25 seconds pro move.
INFINITE   The program will continue evaluating until you stop it 
           (i.e. with the REBEL button) or when a mate is found, or when the
           maximum ply depth is reached.
ANALYSIS   For this special level we refer to chapter 9.1.
 
5.3. The other options under OPTIONS F3
OPTIONS F3 contains a number of possibilities to change the chess
engine of the program.

5.3.1. Permanent brain 
With this option you can prevent the computer from thinking while
it is your time to move. This will make the program weaker of course. 
If the permanent brain is active, the computer will take full advantage 
while you are thinking about your move.

5.3.2. Brute force
Brute force is a specific method for computer chess. If brute force is active,
all possible positions will be evaluated, without regard to if they are good or
bad. The main advantage is that there is no risk that the computer will overlook
a move. The default setting, however, is not active. The program will now use
the selective method in which only the good moves will be evaluated. This will
speed up the search time such that the final results will be much better than
when brute force is active.

5.3.3. Combination
If combination is on, the program generally will find the right moves in
tactical positions quicker than when combination is off. By default, this option
is turned off, because it influences the program too much in normal play.

5.3.4. Selection
The program (when brute force is off) has it's own intelligent flexible
algorithm to decide if a given variation should be extended or not. This is
called "selection" and is based on a judgement by the program whether it makes
sense to extend a given variation or not. With this option you can turn off the
program algorithm and change it into a fixed depth of selection. You will have
the choice between 1 through 9. "N" is the default setting meaning Normal. 
If you were to choose selective 4, while the program was, for example,
on the 9e ply, this would mean that the calculations were done with the
settings: 5 ply brute force and 4 ply selective thereafter.
With Normal the whole selection scheme is totally flexible.

5.3.5. Playing style
You have the choice of 5 different playing styles ranging from agressive to
defensive. In the pull-down menu the actual playing style is displayed by the
corresponding uppercase letter.

5.3.6. Easy play
There are 3 levels of playing strength. If you select the novice option
here, you have the best possibility to beat the program.
In the pull-down menu the actual playing style is displayed by the corresponding
uppercase letter.
        
5.3.7. Hashtables     
The term hashtables stands for an algorithm in which the program stores the 
results of its evaluations into the PC memory.
This is very helpful for the program: When the program finds a position in the
hashtable that was already evaluated, then there is no need to evaluate the
position again since the result is already known.
This technique makes it possible to speed up the search process by a factor of
three, and even more in the endgame.
With this option you can turn the Hashtables on or off.

5.4. Book openings
      
5.4.1. Loading opening books (DATA F4)
At the start of the program, the book found in the REBEL.CFG will be loaded.
With this option you can switch to another opening book. For loading see chapter
4.3.1.
      
5.4.2. Book opening on/off (SETTINGS F5)
With SETTINGS F5-opening book, you can decide whether the computer is allowed to
use his opening book or not. If not, the program won't search for a move in 
its opening book and therefore the program will start the evaluation process
immediately, even at the first move of a new game.        
If you play from the opening book, the comment section will show you
which moves  are still available for the current position.
Additionally, the program knows about 300 openings by name. If the program
recognizes a variation, it will display the corresponding opening name in the
comment section.
        
5.4.3. Alternative opening books
In the near future, Schrder BV will release a lot of new opening books which
can be ordered seperately. These opening books are organized by opening name
(for example Spanish) or by famous players (for example Karpov) and so on. At
the release of REBEL DECADE 1.2, already 12.000.000 opening moves are available.
For more information and/or orders contact:
Schrder BV, p.o. box 6365, 7401 JJ Deventer, Holland.


Ch. 6: DATABASE

When you are currently processing databases from your Cdrom drive some options
are not active because of the fact that WRITING to Cdrom is not possible.

6.1. Database loading and saving
At the start of the program, the database found in the REBEL.CFG will be loaded.
You can switch to another database at any time (see DATA F4-load database,
chapter 4.3.1). The database uses files with the extensions DAT, IX1 and IX2.
Should you try to load a database while one of these files is missing, you will
be warned by an error message. You will also get an error message if you try to
create a new database with a name that already exists.              

6.2. Loading a game (DATA F4)
If you decide to load a game from the database, you'll get a new screen on 
which the first 20 games of the database (alphabetically ordered) are visible.
To view the next games in the database, you have two possibilities:
* You click on top of the screen on  (or the PG-DN key) and the
  next 20 games will appear (with  (or the PG-UP key) you can scroll 
  back for 20 pages);
* You click on top of the screen on the letter of the alphabet
  (or the corresponding key) and again 20 games become visible,
  starting with the selected letter.

Instead of the information in the Place columm, you can also get the information
of the next three moves. Click on Place and the program will show the moves.
Keyboard users can use ALT_M.
In the comment section, extra information of the game where the scroll 
bar is on, is available.
You can load a game by clicking on the desired game or by selecting
a game with the arrow keys and confirming it with the ENTER key.
           
6.3. Loading next game (DATA F4)
DATA F4-next game (or ALT_N) will load the next game available in
the database. All selections previously made will be taken into account. This
means practically that, if you have selected to see all the games of Nigel
Short, this function will load the next game of Nigel Short.
           
6.4. Saving a game (DATA F4)
You will be prompted to input some data belonging to the game to be saved
(names, ELO, date, result, some additional text).
Attached to the complete game (moves and move comments), this information will
be saved into the database. All items will be pre-filled (see the default bar).
With ENTER the information will be accepted. With SPACE all the information 
on the line the cursor is blinking will be cleared. If you want to change 
an item, simply type the desired information and press ENTER.

overview
NAME WHITE  :  a maximum of 20 characters. You are obliged to input a name.
               If you type nothing, the name will become Player as default.
NAME BLACK  :  a maximum  of 20 characters. You are obliged to input a name.
	       If you type nothing, the name will become REBEL DECADE 
ELO WHITE   :  the ELO-rating of the white player, this is not obliged, but
	       it is recommanded for the overviews (see  chapter 6.8).
               An ELO-rating between 1000 and 3400 will be accepted.
ELO BLACK   :  see ELO white.
PLACE       :  not obliged, maximum 39 characters.
DATE        :  not obliged, you can either input an exact date or a year.
	       Examples: 1995, 120795, 12-7-95 or 12-07-95
TOURNAMENT  :  not obliged, maximum 39 characters.
RESULT      :  not obliged, but is recommended for the overviews
	       Examples:
               White wins type 1-0 , 1 or simply +
               Black wins type 0-1 , 0 or simply -
               Draw  type  - , , 0.5 , or simply =
COMMENT     :  not obliged, maximum 72 characters, this is not a move comment 
	       but a game comment.
              
6.5. Rewrite a game (DATA F4)
The loaded game will be overwritten by the current game.
The original data of the loaded game will be lost. This function is especially
useful if you want to make some  (minor) changes to existing games, without the
need to delete the old game.

6.6. Delete a game (DATA F4)
You can select the desired game to be deleted in the database as
described in chapter 6.1. For reasons of security, you will be 
prompted should you indeed wish to delete the selected game.

6.7. Reorganisation (DATA F4)
Activating reorganisation will force the program to sort the entire database 
by name. Additionally, all deleted games will be permanently removed from the
database, thus increasing your free diskspace. Reorganisation is only useful 
if you have added or deleted games. 
Before starting the reorganisation, REBEL DECADE 1.2 will first inform you 
whether it makes sense to reorganise, by displaying how many bytes of free 
diskspace will be gained. There are other advantages in reorganisation: some 
search functions will be performed quicker, searching on moves, positions or 
text wil show the games alphabetically.
Depending on the size of the database, the reorganisation will take some time.
When reorganising, a temporary (and invisible) file will be created. If your
harddisk contains insufficient space, reorganising is impossible.

6.8. Search functions (DATA F4)
      
6.8.1. Searching on names 
You can input either one or two names here, both of which will be searched for
in the database. If you have typed just one name, the program will search for
all the games from that player. If you have typed two names, the program will
search for all the games played between those two players. This function works
via the famous BTREE+  principle and will select games  from a database of
1.000.000 games for example within seconds.

6.8.2. Searching on text  
First you will have the choice to decide which search criteria you wish to use.
The criteria are based on the and-and principle.
If you select a name, a date and a result, REBEL DECADE 1.2 will search for those
game(s) which contain that name, that date and that result. 
This can take some time depending on your hardware, the size of the database and
whether you have loaded a disk-caching program or not  (see also chapter 1.5).
If you have only selected names, the program will perform a quick search on
names (see 6.8.1). 
Overview     
NAMES :  optional, not obliged
DATE  :  optional, you can only input a year
TEXT  :  optional, maximum 39 characters
SCORE :  optional, see chapter 6.4
           
6.8.3. Searching on moves    
The program will search for games containing the exact moves of the currently
played game on the chessboard. This function is very useful for opening
preparation.
           
6.8.4. Searching on positions
The program will search for games with exactly the similar position as the one
on the chessboard. REBEL DECADE 1.2 will automatically recognize move 
transpositions, if relevant. This means that games started with "1.d4 d5 
2.Nf3" and "1.Nf3 d5 2.d4" are similar to this search function. This function 
is very useful for opening preparation.

6.9. Overviews (DATA F4)
There are six different overviews available. The contents of these overviews 
can be written to a text file by clicking on the TXT button in the info
section (ALT_T for keyboard users).

6.9.1. 
You will get a complete overview of all players in the database and their
results. All games played, with regard to their results, will be taken into
consideration and will lead to a new ELO rating of a given player in the
database. The meaning of the three ELO ratings is as follows: 
ORIGINAL : start ELO rating of a player.
AVERAGE  : avarage ELO rating of the opponents the player has played against.
NEW      : the new calculated ELO rating for this player.
           
6.9.2. Overview top 40 on percentage
You will get an overview of the best 40 players in the database, based on the
results of the games. The 40 players with the highest percentage will be
displayed. With PG-UP / PG-DWN you can switch between the two pages.
           
6.9.3. Overview top 40 on ELO-rating 
You will get an overview of the best 40 players in the database, based on the
new ELO results of the players. The 40 players with the highest ELO rating will
be displayed. With PG-UP / PG-DWN you can switch between the two pages.

6.9.4. Overview of tournaments 
You will be prompted to input the desired tournament (or a part of it). The
program will gather all the games played in this tournament and will sort the
results.
           
6.9.5. Overview of matches     
You will be prompted to input two player names.
The program will gather all the games both players have played and will show the
results. The games between those two players are also taken into consideration
and the final result will be displayed. This function is very useful if you 
want to know the results of matches played between two players.        

6.9.6. Overview of book openings
This function is useful:
* If you wish to see a full overview of the database concerning all the book
  openings played (make no selections)
* If you want to prepare yourself on a certain opponent (make a selection on
  the white or the black player name).
You will be prompted to make the desired selections for which to search for in
the database. The output is based on the generally known names of the book
openings played. You can only select one name, white or black, the program will
search for the desired player and colour.
        
6.10. Create a new and empty database (DATA F4)
With this option you can create your own desired database, for example in order
to collect (your own) games of the chessclub you are playing.


Ch. 7: SCREEN SETTINGS

With REBEL DECADE 1.2 you can choose which information you want on the screen.

7.1. Save settings / original settings (START F1)
At the START F1 menu, you can either save the current screen settings or restore
the original ones. If you have made some changes (for example you have changed
the colours of the board), you can save these settings with START F1-save
settings. The next time you start REBEL DECADE 1.2, the program will remember the
changes you have made. A second option is START F1-original settings. 
With this option you will return to the default settings.
           
7.2. Changing names (SETTINGS F5)
Here you can change the name of the white player, as well as the name of the
black player. The cursor will flash in the name section and you can type the
desired white or black name (maximum 12 characters).
When a game is loaded from the database with names longer than 12 characters,
only the first 12 characters will be displayed.
           
7.3. Show material (SETTINGS F5)
You can only switch this function on or off.
If show material is active, it shows you, in the material section, what the
material difference is on the board. You can see at one glance for example if
you are a pawn down or up.
If show material is not active, the space of the material section will be used
to make the move section bigger.

7.4. Show hint (SETTINGS F5)
You can only switch this function on or off.
If show hint is active then REBEL DECADE 1.2 will show you a move suggestion (if
available) right above the REBEL button. Clicking on this move will execute the
move immediately (ALT_H for keyboard users).
If show hint is not active, the screen space will be used to make the move
section bigger.

7.5. Show teacher (SETTINGS F5)
You can only switch this function on or off.
If teacher is active, REBEL DECADE 1.2 will show you how the program judges the 
current position. Mouse users Click in the info section and the teacher 
information will appear. Clicking in the info section again will show you the
previous information. Keyboard users use ALT_T here.
Four remarks about important squares of the current positions are given in the
left columm. In the right columm, a more text-based judgement is given of
important aspects of the current position. For a more detailed explanation, 
we refer you to the README-file.

7.6. Show variation (SETTINGS F5)     
You can only switch this function on or off.
If show variation is active, the program will show you the main variations in
the info section when the program is calculating its move. If show variation is
not active, this information is not displayed.
This will give you the opportunity to play a game against REBEL DECADE 1.2 without any
information from the program.
With SETTINGS F5-keep best line, you can decide whether REBEL DECADE 1.2 will put the
main variation in the move comment or not. It will save some diskspace if you
decide to put the game into the database, but on the other hand, you will lose
important information about the game.

7.7. Turn board (SETTINGS F5)
This option will give you the choice to turn the chessboard 180. This will 
give you the opportunity to play a game with the black pieces in front.

7.8. Languages (SETTINGS F5)
The program can be operated in several languages. With this option you can
choose one of these languages.
All present information on the screen will be given in the chosen language.
       
7.9. Changing colours (SETTINGS F5)
With this option you can change almost every item of the screen to your desired
colour. If you have made some changes, you can keep them with save settings (see
chapter 7.1).

7.10. Changing piece sets (SETTINGS F5)
The program contains three different piece sets.
With this option, you can load your favourite piece set.

7.11. The comment field
The comment field is used for several purposes:        

A) Information of the calculation results of the program in four lines.
The first three lines contain the main variations that REBEL DECADE 1.2 finds 
best for the given position. The fourth line shows some information about the
evaluation status at that moment.

EXAMPLES:
1) The fourth line could be:
   09:23  10.22 (43)  b5xa4 Pos/sec: 12.234 (3.890.345 pos. evaluated)  
   which tells you the following:
   - The program has used 9 minutes and 23 seconds so far.
   - The program performs a search depth of 10 ply's.
   - The program has already evaluated 22 moves of the 43 legal 
     possibilities of the tenth ply.
   - The program is now evaluating the move b5xa4.
   - The program has evaluated 12.234 positions in the previous second.
   - The program has evaluated 3.890.245 positions in total.    

2) One of the first three lines could be:
   00:04  4.05  0.15  b5xa4 Ra1xa4 Nf6-d5 Qg4-g7+
   which tells you the following:
   - After 4 seconds the program has found the displayed main line.
   - This main line is found at the fourth ply as fifth possibility
   - This main line is judged by the program with a score of 0.15.
           
If you turn off Show variation (see 7.6), only limited information is displayed.
This enables you to play a game against the program without the help of hint
moves, main lines and scores.

A) If move comment is available for a given move, this comment is displayed.
C) Used to show information by the following functions:
   DATA F4 Game Info.
   START F1 Program Info.
   START F1 Data Info.
D) If Teacher is on, the teacher function will display the results here when
   you click in the comment field (or press ALT_T).
E) If moves are found in the opening library, the program will display them
   here (see also 3.1.5).
F) Various (error) messages.
        
Ch. 8: SETTING UP POSITIONS (POS F6)
          
8.1. Set up a position (POS F6)        
With this function, you can insert or remove pieces from the board. 
If you enter this function at the move section, the 12 chess pieces will 
appear on your screen and you can select them with your mouse or keyboard.

SELECTING A PIECE
Mouse users with the left button you select a piece with the right button
you scroll to the next piece in the list.
Keyboard with the spacebar you select the next piece with "+" you change 
the colour of the selected piece.
                     
INSERTING A PIECE
Select a piece as described above.
Mouse users click on the square where you want the selected piece to be placed.
Keyboard select the desired square with the cursor keys. Press ENTER to place
the piece on the square.

REMOVING A PIECE
Mouse users click twice to clear the desired square.
Keyboard press Delete to clear the desired square.
        
When you leave the set-up function, the program will check the new position
according to the chess rules. If a position is illegal, you will be warned.
If you still decide to continue, the program will restore the position 
existing before the position mode was entered.
 
8.2. Make board empty (POS F6)
This function will automatically clear the whole board.
After that, the program jumps to Set up a position and you can insert your
desired position.
           
8.3. Abort set up (POS F6) 
If you decide to cancel the set up, this function will return to the game. If
you still decide to continue, the program will restore the position existing
before the position mode was entered.

8.4. White/black to move (POS F6)
After you have made changes to the board, you can exit the POSITION mode with
one of these 2 functions. You will return to the game, and the colour you have
chosen is at move.


Ch. 9: REMAINING OPTIONS

9.1. Analysis mode (NIVO F2)
This function allows you to analyse a game or a position in a comfortable way by
combining the Infinite level with the Player-Player option. The program will
start evaluating the current position until you decide to enter a move. The
program will execute this move and will start evaluating the new position
immediately. All take back and move forward facilities will remain, so you can
analyse a game without any obstacles.
The REBEL button is now changed into a GAME button. If you click on GAME, the
program will restore the original game  you have loaded or played. This gives
you the opportunity to analyse alternative moves or sub-variations of the game.
So with GAME  you can easily restore the original game without the need to
re-load the game from the database.
You can exit the analysis mode by selecting a new level (see NIVO F2).

9.2. Player-Player mode (OPTIONS F3)
Puts the program into sleep mode.
With this function you can enter a range of moves and the computer will not
disturb you with a counter move but the program  will still check your moves
on legality. You can make the program active again by clicking REBEL. 
From this point, the program will start calculating again.

9.3. Automatic play (OPTIONS F3)       
The program will play against itself from the current position. The program 
will continue playing until you interrupt it by clicking on REBEL or by a 
checkmate or a draw.
           
9.4. Analyse game (OPTIONS F3)
With this function you can analyse an entire game or just a part of it. 
You can also select which colour(s) of the game must be analysed 
(white, black or both). The program will start analysing the game at the 
current level and from the current position. 
In this way you can decide from which move on the analysis has to start. 
The REBEL button will change into an EXIT button which will give you the
possibility to abort the analysis.
The analysis results will be stored in the move comment and you can show the
results with the take back and move forward facilities after the analysis has
been finished.
The analysis will be executed in 2 stages. First the real move played in the
game will be analysed, and after that, REBEL DECADE 1.2 will analyse the position and
give its opinion. If REBEL DECADE 1.2 finds its move clearly better than the move
played in the game, the program will mark this move by inserting 2 extra "!" 
in the move comment. For a detailed example about the power of this function 
we refer to the README-file.
                   
9.5. Analyse database (OPTIONS F3)
With this function you can analyse an entire (position-based) database which is
especially handy for solving many difficult (test)positions. Every start
position in the currently loaded database will be analysed with regards to the
current level, and the results (last three main lines) will be written into the
move comment. 
The results will not be written in the current database but to a new database
named ANALYSE.DAT. When the analysis is finished, you can load this database and
view the results. The provided databases BT-2450.DAT and BT-2630.DAT are
especially very suitable for this function. The REBEL button has changed into an
EXIT button which will give you the possibility to abort the analysis. 
Keyboard users can press ESC to abort the analysis.

9.6. Goto Move number (OPTIONS F3)
With this function you can jump to any move you wish in a game. You will be
prompted to enter the desired move number. If you enter a number higher than 
the actual number of moves of the game, the program will go to the last move
of the game. If you want to go to the start of the game, enter 0.
           
9.7. Search for move (OPTIONS F3)
This function allows you to go to a move you still remember.
You will be prompted to enter the desired move.The move must be entered in
coordinates, for example e2-e4.  If this move exists in the game, the program
will perform a Goto Move and the desired position will appear.
        
9.8. Goto end of game (OPTIONS F3)
REBEL DECADE 1.2 will perform a Goto Move to the last move played in the game.

9.9. Replay game (OPTIONS F3)
This function allows you to replay/study a game at three different speeds 
(slow, normal and fast). The program will setup the start position and will
execute all moves at the speed you have chosen. 
You can watch the game and study the moves and move comments.
You can interrupt the replay by pressing the space bar. Pressing the space bar
again will force the program to continue the replay. If you wish to abort the
replay function, press ESC or click on a menu item.

9.10. Write move comments (OPTIONS F3)
With this function, you can simply supply every move with your comments. All
move comments will be written to the hard disk if you save the game. Your move
comments will always be visible in the info section. 
If you do not want to use move comments, you can turn this function off with
the SETTINGS F5-keep-best-line function (see 7.6).

9.11. Game to text file (OPTIONS F3)
With this function, you can write the current game to an ASCII text file
(move comments, names, date etc. included). 
You can read or print the created textfile with your favourite text editor.
REBEL DECADE 1.2 will prompt you for a legal DOS file name to write the data to.

9.12. Moves to Printer (OPTIONS F3)
If you activate this function, every move you play in a game will be outputted
directly to your printer.

The program cannot see whether your printer is properly connected or not. It
will be the responsibilty of the user to make sure the printer is connected
properly.
       
9.13. Starting game (DATA F4)
This function will restore a game that was active before you decided to change
the current game or before you loaded another game from the database. Very
useful in the following cases:
* If you accidentally started a New Game, this function can restore the
  previous game.
* If you have loaded 2 games from the database and you want to  return
  to the previous one.
                   
9.14. Sound on/off (SETTINGS F5)
This will give you the possibilty to turn on/off the PC's internal speaker.

9.15. Mouse on/off (SETTINGS F5)
This will give you the possibilty to turn on/off the mouse.
You can only turn on the mouse when a mouse driver is loaded.
 
9.16. Swapping clocks
Only mouse users have the possibilty to swap the 2 clocks in the time section.
This is executed by clicking in the time section.

9.17. Swapping names
Only mouse users have the possibilty to swap the two names in the names section.
This is executed by clicking in the names section.



Ch. 10: Trouble-shooting
   
10.1. AUTOEXEC.BAT problems
Some AUTOEXEC.BAT commands can disturb the correct functioning of REBEL DECADE 1.2.
The most important is the MODE instruction.
If you have problems with loading or running REBEL DECADE 1.2, we suggest removing
these lines in your AUTOEXEC.BAT file.
        
10.2. Missing files
If one of the following files is missing in the installed REBEL DECADE 1.2
directory, the program will not function:
 REBEL.TRL, 
 REBEL.GIF, 
 BOOK.TRL,
 BOOK.TRX, 
 REBEL.PCS.
Restore the missing file(s) from your floppy-disk.


Ch. 11: THE MEPHISTO BOARD

This PC-program is to be used with the beautiful Mephisto Board which makes
chess-playing against a computer so much more comfortable.
When activating the board in OPTIONS F3 it will automatically search for the
connection with the board. If everything is connected well, you will see that
every LED is checked for a short time. If the connection is not perfect
(no power or no proper connection with the printerport of your PC) a message
is shown and you have to press any key to be able to start playing without
the use of the board. If you solve the problem you have to activate the board
again in the OPTION F3 menu in order to play with the Mephisto Board. 

IMPORTANT !!
============
HOWEVER BE CAREFUL: ALWAYS ENSURE YOUR COMPUTER IS SWITCHED OFF BEFORE
CONNECTING OR DISCONNECTING PERIPHERALS. FAILURE TO DO SO MAY RESULT IN
DAMAGE TO YOUR EQUIPMENT.

After the program has recognized the board it will check the position of the
pieces on the board with the position of the game on the screen of your PC.
Remember that the board cannot recognize WHICH piece is on a square; it can
only recognize whether a square contains a piece or not.

If the position of the Mephisto Board is not equivalent with the game on the
screen you will hear a warning beep and the LED of a square of which the
contents should be changed will blink. As long as you have not corrected the
situation you will hear a beep with every move you make, for after every move
the positions are checked again.

11.1   Moving a piece on the Mephisto Board
In order to let the board send the right data to you PC, you have to lift the
piece you want to move from the board and put it on the desired square. 
For the procedure for special moves, like taking a piece, castling etc.: just
follow the official chessrules and it will be executed in the program in the
right way. When you make a mistake with your move (for instance: you forget
to move the castle with the castling) the LEDs of the board will blink. 
This can only be stopped by completing/correcting the move or by press the
ESC-key of your keyboard.
When you make use the ESC-key you will hear a beep with every move you make
until you have made the position of the Mephisto Board equivalent with the
position of the board of the PC-screen.

When the Mephisto advantage moves you can see the move on the Mephisto Board
because the relevant LEDs are blinking. Now you cannot make a move until you
have executed the move of the Mephisto advantage or until you press the
ESC-key of your keyboard. When you make use of the ESC-key you will hear a
beep with every move you make until you have made the position of the
Mephisto Board equivalent with the position of the board of the PC-screen.

When the Mephisto Board is active you can easily take back a move, 
move forward an existing move and start a new game:

TAKE BACK:     Just take the last moved piece back to the original field and
               the program will automatically recognizes this as a regular
               take-back
MOVE FORWARD:  When a game is loaded any you make the move that is the same
               as the move in the loaded game, the program will recognize
               this as a regular move forward. 
               
If you want the program to calculate again press or click REBEL.

NEW GAME:      When you put all the pieces back to the begin position the
               program will recognize this as a new game (ALT_G). 
               This only works when the program is not on the move and
               calculating.

11.2 Mephisto Board ON/OFF
With this option you can (de)-activate the Mephisto Board. 
The actual status will be shown in the OPTION F3 menu. 
Clicking on it will activate the board if it's not activated and will
deactivate it when activated. When starting the program it will automatically
search for the connection with the board. If everything ist connected well,
you will see that every LED is checked for a short time. If the connection is
not perfect (no power or no connection with the printerport of your PC) a 
message is shown and you have to press any key to be able to start playing
without the use of the board. If you solve the problem you have to activate
the board with this menu in order to play with the Mephisto Board.

AGAIN !!
========
BE CAREFUL: ALWAYS ENSURE YOUR COMPUTER IS SWITCHED OFF BEFORE CONNECTING OR
DISCONNECTING PERIPHERALS. FAILURE TO DO SO MAY RESULT IN DAMAGE TO YOUR
EQUIPMENT.


Ch. 12: SHORT HISTORY

Ed Schrder, born in The Hague, lives in Deventer and has been commercially
active with developing computer chess software since 1985. Since 1988, Ed has
been ranked amongst the best computer chess programmers in the world. Proof of
that was his victory in Vancouver 1991 where he, for the first time, became the
worldchampion in the category Microcomputers.
The following year, in Madrid, an improved version of his program was even able
to win the world champion title in all classes.
This performance was unique: it was the first time that a micro-computer program
had won this title. In the past, this title was always won by a mainframe
computer. This was not only a confirmation of Ed's qualities, but also a proof
that today's commercial chess programs are able to beat their bigger and
super-fast brothers.
Ed has also won the Dutch Championship for chess programs many times. His most
recent succes was achieved with a beta version (Gideon 2.0). REBEL 6.0 made a
big impression at the AEGON '94 human / computer tournament by being the best
performing computer of the tournament with a TPR ELO rating of 2461.


While creating REBEL DECADE 1.2, Ed was assisted by two other specialists,
Jeroen Noomen, who was (and, indeed for many years previously, has been) 
responsible for the openingbooks of Ed Schrder's programs, and Rob Kemper, 
who was responsible for the graphics and the IO.
        
Personally, Ed does not believe that a computer will ever beat the
human world champion in a match at tournament level, although... even
he is not so sure about that anymore!
In any event, Ed is still convinced that his program can perform still
better since he has enough ideas left with which to improve his program.
     
If you are interested in the latest developments on PC computer
chess, or if you have suggestions that can improve the program, we
invite you to drop us a line!

Please write it to:

  Schrder BV
  P.O. Box 6365
  7401 JJ Deventer
  The Netherlands

