/************************************************************/
/* Copyright 1993 Dave Merrill (dmerrill@cdc.hp.com         */
/* Permission to freely copy this program and modify it in  */
/* any way is hereby granted, provided you cut me in on any */
/* money you make off it, and share the source code for any */
/* really nifty enhancements you make.                      */
/************************************************************/

#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>

#define MAX_SCORE_DIFF 5
#define NUM_RACES 24
#define MAX_SHIPS 14

typedef struct {
		 int cost;
		 char race[20];
				 } ship;

static ship aliens[] =
{
		{ 5, "SHOFIXTI.SHP"  },
		{ 6, "ZOQFOT.SHP"    },
		{ 7, "UMGAH.SHP"     },
		{ 10, "THRADD.SHP"   },
		{ 13, "SYREEN.SHP"   },
		{ 10, "ILWRATH.SHP"  },
		{ 11, "HUMAN.SHP"    },
		{ 12, "VUX.SHP"      },
		{ 15, "ANDROSYN.SHP" },
		{ 16, "ARILOU.SHP"   },
		{ 16, "SUPOX.SHP"    },
                { 17, "SLYLANDR.SHP" },
		{ 17, "DRUUGE.SHP"   },
		{ 18, "SPATHI.SHP"   },
		{ 18, "MELNORME.SHP" },
		{ 19, "MMRNMHRM.SHP" },
		{ 20, "PKUNK.SHP"    },
		{ 21, "MYCON.SHP"    },
		{ 22, "UTWIG.SHP"    },
		{ 23, "ORZ.SHP"      },
		{ 23, "YEHAT.SHP"    },
		{ 28, "CHENJESU.SHP" },
		{ 30, "BLACKURQ.SHP" },
		{ 30, "CHMMR.SHP"    },
		{ 30, "URQUAN.SHP"   }
};

int maxloops=0;

FILE *logfile;

int gen_default_file()
{

	int i,j;
	int team1[MAX_SHIPS], ships1,
			team2[MAX_SHIPS], ships2;
	FILE *cfgfile;
	FILE *team1file;
	FILE *team2file;

	srand((unsigned)time(NULL));

	ships1=ships2=0;

	/* pick random ships for both teams */
	for (i=0;i<MAX_SHIPS;i++)
	{
		 team1[i]=rand()%NUM_RACES;
		 team2[i]=rand()%NUM_RACES;
		 ships1+=aliens[team1[i]].cost;
		 ships2+=aliens[team2[i]].cost;
	}

	while (abs(ships1-ships2) > MAX_SCORE_DIFF)
	{
			 i=rand()%MAX_SHIPS;
			 ships1-=aliens[team1[i]].cost;
			 team1[i]=rand()%NUM_RACES;
			 ships1+=aliens[team1[i]].cost;

			 if (abs(ships1-ships2) <= 5)
		break;

			 i=rand()%MAX_SHIPS;
			 ships2-=aliens[team2[i]].cost;
			 team2[i]=rand()%NUM_RACES;
			 ships2+=aliens[team2[i]].cost;
	}

	cfgfile=fopen("melee.cfg","w");
	team1file=fopen("team1.mle","w");
	team2file=fopen("team2.mle","w");

	fprintf(cfgfile,"73\nTeam 1\n");
	fprintf(team1file,"Team 1\n");
	fprintf(team2file,"Team 2\n");

	for (i=0;i<MAX_SHIPS;i++)
	{
		fprintf(cfgfile,"%s\n",aliens[team1[i]].race);
		fprintf(team1file,"%s\n",aliens[team1[i]].race);
	}

	fprintf(cfgfile,"102\nTeam 2\n");

	for (i=0;i<MAX_SHIPS;i++)
	{
    fprintf(cfgfile,"%s\n",aliens[team2[i]].race);
    fprintf(team2file,"%s\n",aliens[team2[i]].race);
	}

  printf("Name     Rating\n");
  printf("-------  ------\n");
  printf("Team  1: %d\n",ships1);
  printf("Team  2: %d\n",ships2);

	fclose(cfgfile);
  fclose(team1file);
  fclose(team2file);

  return((ships1+ships2)/2);
}

void print_team(team,nships)
int team[];
int nships;
{
  int i;

	for (i=0;i<nships;i++)
		fprintf(logfile,"%2d ",team[i]);
  
	fprintf(logfile,"\n");
}

void gen_team(num,score)
{
    char fname[16];
    int team[MAX_SHIPS];
    int teamval;
		FILE *teamfile;
		int nships;
    int i;
    int j;
    int nloops;

		fprintf(logfile,"\n\nGenerating team # %d\n",num);
		sprintf(fname,"team%d.mle",num);
		teamfile=fopen(fname,"w");
		fprintf(teamfile,"Team %d\n",num);

		nloops=0;
		teamval=nships=0;
		/* generate an initial team */
		for (i=0;i<MAX_SHIPS;i++)
    {
       if (teamval +  MAX_SCORE_DIFF < score)
       {
	   team[i]=rand()%NUM_RACES;
	   teamval+=aliens[team[i]].cost;
	   nships++;
       }
       else
	   team[i]=-1;
    }

		fprintf(logfile,"Initial team: (teamval==%d, target==%d)\n",teamval,score);
    print_team(team,nships);

		/* if not close enough, loop until it is */
    while (abs(teamval-score) > MAX_SCORE_DIFF)
    {
	if (nloops==100)
	{
	   printf("too many loops. Giving up...\n");
	   exit(3);
	   break;
	}

	nloops++;
	fprintf(logfile,"loop %d : ",nloops);

	if (teamval > score + MAX_SCORE_DIFF)
	{
		 fprintf(logfile,"Demoting ship (nships=%d) ",nships);

		 /* replace a ship with a ship of lesser value */
	   i=rand()%(nships-1);
	   if(team[i]!=0)
		 {
	      teamval-=aliens[team[i]].cost;
	      team[i]=rand()%team[i];
	      teamval+=aliens[team[i]].cost;
	   }

		 fprintf(logfile,"%d.  teamval==%d\n",i,teamval);
	   print_team(team,nships);
	}

	if ((nships < MAX_SHIPS) && (teamval + MAX_SCORE_DIFF < score))
	{
		 fprintf(logfile,"Added ship. ");

	   team[nships]=rand()%NUM_RACES;
	   teamval+=aliens[team[nships]].cost;
	   nships++;

		 fprintf(logfile,"teamval==%d\n",teamval);
	   print_team(team,nships);
	}

	if (nships > MAX_SHIPS)
	{
	   printf("Error adding ships %d\n",num);
	   exit(1);
	}

	if ((nships == MAX_SHIPS) && (teamval + MAX_SCORE_DIFF < score))
	{
		 fprintf(logfile,"Upgraded ship ");

	   i=rand()%nships;
	   teamval-=aliens[team[i]].cost;

	   team[i]=rand()%(NUM_RACES-team[i]) + team[i];

	   if (team[i] >= NUM_RACES)
	   {
	      printf("Error replacing ships\n");
	      exit(2);
	   }
	   teamval+=aliens[team[i]].cost;

		 fprintf(logfile,"%d.  teamval==%d\n",i,teamval);
	   print_team(team,nships);
	   
	   if (teamval<0)
	   {
	       printf("\nOOOPPPSSS!!!\n");
	       exit(4);
	   }
	}
    }

		fprintf(logfile,"\nFinal Team: (target %d)\n",score);
    print_team(team,nships);

    if (nloops>maxloops) maxloops=nloops;

    for(i=0;i<MAX_SHIPS;i++)
      if (team[i]==-1)
	 fprintf(teamfile,"\n");
      else
	 fprintf(teamfile,"%s\n",aliens[team[i]].race);

    printf("Team %2d: %d\n",num,teamval);

    fclose(teamfile);
}

main(argc,argv)
int argc;
char *argv[];
{
   int score;
   int i;
   int j;

   if (argc >2)
   {
       fprintf(stderr,"Usage: rndmelee [n]\n");
       fprintf(stderr,"\tn=number of additional teams\n");
       exit(1);
   }
   
	 logfile=fopen("rnd.log","w");

   score=gen_default_file();

   if (argc == 2)
   {
      sscanf(argv[1],"%d",&j);

      if (j<3)
	 fprintf(stderr,"Warning: at least two teams must be generated.\n");
      else
      {
	 for (i=3;i<=j;i++)
	    gen_team(i,score);
	 printf("maxloops == %d\n",maxloops);
      }
    }
    
    fclose(logfile);
}
