/*
   LORDED.C - LordEdit v1.00
   Copyright (C) 1994 by Life Force.
   You may use any of this code that you wish, as long as you
   give credit to Life Force.  If you use the spin function,
   you must give credit to Tolkien.
   Most of this code is ANSI C compatible.
   It will compile successfully under Borland's Turbo C++ v3.00
   for DOS.  You may have to make minor modifications for other
   compilers.

   Legend of the Red Dragon is Copyright (C) by Seth Able Robinson.

   last modification:  22 nov 1994
*/

#pragma warn -aus
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys\stat.h>


/*
   The monst structure is a direct port of Seth Able's Pascal
   definitions that he released.  In Pascal, the first element of
   a string is its length.  Thus, the three strings name, weapon,
   and death are preceded by a single char whose value is the
   length of the respective string.  As of LORD v3.20, there are
   eleven monsters for each of the twelve levels.  They are in
   order in the binary data file LENEMY.DAT.
*/

struct monst
{
	char        name_len;   /* length of name */
	char        name[60];   /* monster's name */
	long int	strength;   /* monster's attack strength */
	long int    gold;       /* amount of gold earned if killed */
	char        weapon_len; /* length of weapon description */
	char        weapon[60]; /* weapon description */
	long int    exp_points; /* experience points earned if killed */
	long int    hit_points;
	char        death_len;  /* length of death phrase */
	char        death[100]; /* displayed when monster is killed by power move */
} monster;


FILE    *lenemy;
void    open_file (void),
		read_monst (int which),
		write_monst (int which),
		pascal_str (int len, char *s),
		choose_level (void),
		choose_monster (void),
		display_monster (void),
		modify_monster (void),
		save_changes (void),
		display (char *filename),
		goxy(int x, int y),
		clear (void),
		spin (unsigned char *s),
		left (int amount),
		invalid (void);
long    size = (long) sizeof (struct monst);
int     level, mon, which, flag1 = 1, flag2 = 1, flag3 = 1;

/*===================================================================*/

void main (void)
{
	int throwaway;

	open_file();
	display ("OPENING.ANS");
	goxy (34, 23);
	while ( !kbhit() )
	{
		printf ("\x1b[1;37;40mPRESS A KEY");  /* switch color to white */
		left (11);
		spin ("PRESS A KEY");
		left (11);
	}
	throwaway = getch();
	printf ("\x1b[0;0;40m");  /* reset colors */

	while (1)
	{
		choose_level();
		if (!flag1) break;
		while (1)
		{
			choose_monster();
			if (!flag2) break;
			while (1)
			{
				display_monster();
				modify_monster();
				save_changes();
				if (!flag3) break;
			}
		}
	}
	printf ("\x1b[0;0;0m");  /* reset colors */
	fclose (lenemy);
}

/*===================================================================*/

void open_file (void)
{
	lenemy = fopen ("LENEMY.DAT", "rb+"); /* open existing file for */
										  /* reading & writing      */

	if (lenemy == NULL)
	{
		printf ("\n## Error:  unable to open LENEMY.DAT for input. \n");
		printf ("## Terminating... \n");
		exit (1);
	}
}

/*===================================================================*/

void read_monst (int which)
{
	fseek (lenemy, (size * (long) which), SEEK_SET);
	fread (&monster, (int) size, 1, lenemy);
}

/*===================================================================*/

void write_monst (int which)
{
	fseek (lenemy, (size * (long) which), SEEK_SET);
	fwrite (&monster, (int) size, 1, lenemy);
}

/*====================================================================*/
/* pascal_str displays a string that has been written from a Pascal   */
/* program.  len is the length of the string, s is the actual string. */
/* This function could probably be sped up quite a bit by using       */
/* pointers.                                                          */
/*====================================================================*/

void pascal_str (int len, char *s)
{
	register int i;

	for (i = 0; i < len; i++)
		putchar (s[i]);
}

/*===================================================================*/

void    choose_level (void)
{
	register int i;

	flag1 = 1;
choose_level_repeat:
	display ("SELLEVEL.ANS");
	goxy (31, 19);
	printf ("\x1b[1;37;46m");  /* switch color to light white on cyan */
	level = toupper (getche());
	if (!level) level = getche();  /* in case of local arrow keys */
	if ( (strchr ("123456789ABCQ", level)) == NULL )
	{
		invalid();
		goto choose_level_repeat;
	}

	if (level == 'Q')
	{
		flag1 = 0;
		return;
	}

/*
   We subtract from level since getche returns a char and we need
   an int.  This does the trick.  Take a look at an ASCII table if
   this doesn't make sense.
*/
	if (isalpha (level))
		level = (int) (level - 55);
	else
		level = (int) (level - 48);
}

/*===================================================================*/

void    choose_monster (void)
{
	register int i;

	flag2 = 1;
choose_monster_repeat:
	display ("SELMONST.ANS");
	printf ("\x1b[0;37;40m"); /* switch color to low white on black */

	for (i = 0; i < 11; i++)
	{
		read_monst (i + (level - 1) * 11);
		goxy (3, (4 + i) );
		pascal_str (monster.name_len, monster.name);
	}

	goxy (49, 17);
	printf ("\x1b[1;37;46m");  /* switch color to light white on cyan */
	printf ("%d", level);
	goxy (33, 19);

	mon = toupper (getche());
	if (!mon) mon = getche(); /* in case of local arrow keys */
	if ( (strchr ("123456789ABQ", mon)) == NULL )
	{
		invalid();
		goto choose_monster_repeat;
	}

	if (mon == 'Q')
	{
		flag2 = 0;
		return;
	}

/*
   We subtract from level since getche returns a char and we need
   an int.  This does the trick.  Take a look at an ASCII table if
   this doesn't make sense.
*/

	if (isalpha (mon))
		mon = (int) (mon - 55);
	else
		mon = (int) (mon - 48);
}

/*===================================================================*/

void    display_monster (void)
{

display_monster_repeat:
	read_monst ((mon - 1) + (level - 1) * 11);
	display ("MONSTAT.ANS");
	printf ("\x1b[0;37;40m"); /* switch color to low white on black */
	goxy (11, 4); pascal_str (monster.name_len, monster.name);
	goxy (15, 5); printf ("%ld", monster.strength);
	goxy (11, 6); printf ("%ld", monster.gold);
	goxy (13, 7); pascal_str (monster.weapon_len, monster.weapon);
	goxy (24, 8); printf ("%ld", monster.exp_points);
	goxy (17, 9); printf ("%ld", monster.hit_points);
	goxy (3, 12); pascal_str (monster.death_len, monster.death);

	goxy (34, 17);
	printf ("\x1b[1;37;46m");  /* switch color to light white on cyan */
	which = toupper (getche());
	if (!which) which = getche(); /* in case of local arrow keys */
	if ( (strchr ("NSGWEHDQ", which)) == NULL )
	{
		invalid();
		goto display_monster_repeat;
	}
}

/*===================================================================*/
/* In modify_monster,                                                */
/* the business about monster.name[strlen (monster.name) - 1] = '\0' */
/* is because fgets appends a \n which is unwanted.  The above       */
/* statement overwrites the \n with a \0.                            */
/*===================================================================*/

void    modify_monster (void)
{
	register int i;

	flag3 = 1;

	switch (which)
	{
		case 'N': fflush (stdin);
				  goxy (11, 4);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 11; i < 70; i++) putchar (' ');
				  goxy (11, 4);
				  fgets (monster.name, sizeof (monster.name), stdin);
				  monster.name[strlen (monster.name) - 1] = '\0';
				  monster.name_len = strlen (monster.name);
				  break;
		case 'S': goxy (15, 5);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 15; i < 25; i++) putchar (' ');
				  goxy (15, 5);
				  scanf ("%10ld", &monster.strength);
				  break;
		case 'G': goxy (11, 6);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 11; i < 21; i++) putchar (' ');
				  goxy (11, 6);
				  scanf ("%10ld", &monster.gold);
				  break;
		case 'W': fflush (stdin);
				  goxy (13, 7);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 13; i < 72; i++) putchar (' ');
				  goxy (13, 7);
				  fgets (monster.weapon, sizeof (monster.weapon), stdin);
				  monster.weapon[strlen (monster.weapon) - 1] = '\0';
				  monster.weapon_len = strlen (monster.weapon);
				  break;
		case 'E': goxy (24, 8);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 24; i < 34; i++) putchar (' ');
				  goxy (24, 8);
				  scanf ("%10ld", &monster.exp_points);
				  break;
		case 'H': goxy (17, 9);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 17; i < 27; i++) putchar (' ');
				  goxy (17, 9);
				  scanf ("%10ld", &monster.hit_points);
				  break;
		case 'D': fflush (stdin);
				  goxy (3, 12);
				  printf ("\x1b[1;37;44m"); /* white on blue */
				  for (i = 3; i < 78; i++) putchar (' ');
				  goxy (3, 13);
				  for (i = 3; i < 27; i++) putchar (' ');
				  goxy (3, 12);
				  fgets (monster.death, sizeof (monster.death), stdin);
				  monster.death[strlen (monster.death) - 1] = '\0';
				  monster.death_len = strlen (monster.death);
				  break;
		case 'Q': flag3 = 0; break;
		default:  invalid();
				  break;
	}
}

/*===================================================================*/

void save_changes (void)
{
	int yn;

	if (which != 'Q')
	{
save_changes_repeat:
		goxy (19, 19);
		printf ("\x1b[1;31;40m Keep this change? \x1b[1;37;46m \b"); /* red */
		yn = toupper (getche());
		if (! ( (yn == 'Y') || (yn == 'N') ))
			goto save_changes_repeat;
		if (yn == 'Y')
			write_monst ((mon - 1) + (level - 1) * 11);
	}
}

/*=========================================================================*/

void goxy (int x, int y)
{
	printf ("\x1b[%d;%dH", y, x);
}

/*=========================================================================*/

void display (char *filename)
{
	FILE    *fp;
	struct  stat    buff;
	char    *membuf;

	clear();  /* clear screen */

	if ( (fp = fopen (filename, "rb")) == NULL)
	{
		printf ("\n##Error:  unable to open %s for input. \n", filename);
		fclose (lenemy);
		exit (2);
	}

	stat (filename, &buff);

	if ( (membuf = malloc (buff.st_size + 1024)) == NULL) {
	  printf ("\n##Error:  unable to allocate memory for display()\n");
	  fclose (fp);
	  fclose (lenemy);
	  exit (2);
	}

	fread ( (void *)membuf, buff.st_size, 1, fp);
	fwrite ( (void *)membuf, buff.st_size, 1, stdout);
	fclose (fp);
	free (membuf);
}

/*=========================================================================*/

void clear (void)
{
	printf ("\x1b[0;0;0m");  /* reset colors */
	printf ("\x1b[2J");      /* clear screen */
}

/*=========================================================================*/
/* spin is a slightly modified version of Tolkien's spin function from     */
/* his ENHANCE.C.  If you use this function, you -must- give credit        */
/* to Tolkien.                                                             */
/*=========================================================================*/

void spin (unsigned char *s)
{
	register int i = 0,
				 dly = 17;

	printf ("\x1b[0;37;40m");  /* switch color to grey */
	while (s[i])
	{
		delay(dly); putchar('/');  left(1);
		delay(dly); putchar('-');  left(1);
		delay(dly); putchar('\\'); left(1);
		delay(dly); putchar('|');  left(1);
		delay(dly); putchar('/');  left(1);
		delay(dly); putchar('-');  left(1);
		delay(dly); putchar('\\'); left(1);
		delay(dly); putchar(s[i]); delay(dly);
		i++;
	}
}

/*=========================================================================*/

void left (int amount)
{
	printf ("\x1b[%dD", amount);
}

/*=========================================================================*/

void invalid (void)
{
	goxy (32, 23);
	printf ("\a\x1b[1;31;40mInvalid Choice!");
	sleep (1);
}

/*===EOF===================================================================*/