Rebids In Non-Competitive Bidding

Non-Competitive Bidding
Rebid Over a Single Raise
Rebid Over 1NT Response
Rebid After 1-Over-1 Response
Rebid After 2-Over-1 Response
Rebid After Opening a Preempt
Length-Showing Rebids
Blackwood Convention
Control-Asking Cue Bids
Partnership Harmony
Review Questions
//

Non-Competitive Bidding:

In this section we will be looking at rebids by the opening bidder and in many
cases, subsequent bids by both partners.

In these bidding sequences, E-W are not getting into the bidding.

In L1-BID4.CSC, we look at competitive bidding where both teams are bidding.

Before running this course, you should have already run through the first two
Level 1 courses. If you have not, please exit now and load L1-BID1.CSC and/or
L1-BID2.CSC.
//

Rebid Over a Single Raise:

Whenever someone bids (or plays) in bridge, you should ask yourself what the
bid or play indicates about the player's hand:

[Bid]
1S
Pass
2S
Pass
???

Q: Based on the bidding, how many points does North have?
   (1) < 6
   (2) 6 - 10
   (3) 10+

A: 2. A simple raise shows 6-10 points.

Q: How many Spades must North have at a minimum?

A: 3. North could have more than 3, but no fewer.

Like many other bids, you can usually figure out what to bid by adding your
partner's possible points to your own to see if you can make game. On the next
screen, we'll let you figure out your bid.
//

[S]
A Q x x x
K x
K J x x
x x x

Q: How many points does South have?

A: 14.

With partner's 6-10 points, your side has only 20-24 points. Without any
unusual features, game requires 26 points.

Therefore, you should usually pass a simple raise if you opened with less than
16 points.

With 16-17 points, you may have game if partner was at the top (9-10) of her
range, but not if she was at the bottom (6-8).

If you had 16-18 points, you would raise your partner's raise (to 3S in this
case). Then if partner is at the top of her range, she will raise to game.
//

[Bid]
1H
Pass
2H
Pass
4H

[S]
A K Q x x
K x x x x
K Q
x

If you start a Reverse by bidding 1H, intending to bid 1S next to show a
strong hand, but partner raises your Hearts, you should forget the Spades and
jump to game in Hearts.

This may seem odd when you have better Spades, but once you and your partner
have agreed to a suit, you should normally stick with it.

In fact, as we shall see later, once a suit has been bid and raised, bidding
another suit is consider a "cue bid" to show and Ace or King and not an
attempt to find a different trump suit.

With only 6-10 points in partner's hand, it is unlikely that you have slam.
If your hand were that good, you probably should have opened it 2 Clubs.
//

[Bid]
1H
Pass
2H
Pass
???

[S]
K x x
A J x x x
A x x x
x

Q: What do you bid next? (Always count your points first.)

A: Pass.

You have 14 total points. Partner has a maximum of 10. You need 26 for game.
//

[Bid]
1H
Pass
2H
Pass
???

[S]
K x x
A J x x x
A K x x
x

Q: How many points do you have now?

A: 17. -- including the 2-point doubleton.

Q: What should you respond to partner's raise?

A: 3H.

If partner is at the top of her range, she will raise to game; otherwise, she
will pass.
//

[Erase]
[S]
A x
A K Q x x x
x
K Q x x

This hand may be strong enough for a 2C opening. For game in Hearts, South
should be within 1 trick of making game in his own hand. Let's see...

Q: How many probable losers does South have assuming none of the suits are
wildly split. (ie: If 9 cards are out in a suit, assume they will split no
worse than 5-2-2.)

A: 5. One Spade, no Hearts, 1 Diamond, and three Clubs.

Q: What should South open with this hand?

A: 1H. South is short of game by 2 tricks and cannot open 2 Clubs.

[Bid]
1H
Pass
2H
Pass
???

Q: What should South bid in response to North's raise?

A: 4H. South has 20 total points, North has 6-10.
//

Rebid Over 1NT Response:

[Bid]
1H
Pass
1NT
Pass
???

[S]
A x x x
K J x x x
x
K Q x

Q: How many points does North have for her bid?

A: 6-10.

Q: How many points does South have?

A: 13. Partner does not like your Hearts and does not have 4 Spades to go with
yours (or she would have bid 1S instead of 1NT), so without a likely trump
suit, you should devalue your hand by not counting distribution (trumping)
points.

Q: With a maximum of 23 total points between N-S, what should South bid over
1NT?

A: Pass. 23 is not enough for game, which requires 26 points in a major suit
or notrump (29 in a minor suit).
//

[Bid]
1C
Pass
1NT
Pass
???

[S]
A x x x
x
K Q x
K J x x x

Q: Does North have 4 Diamonds, 4 Hearts or 4 Spades in her hand (based on her
bid)?

A: No. Partner would have mentioned 4 of another suit on the 1 level rather
than bid 1NT.

Q: Does partner have 5+ Clubs in her hand?

A: No. With 5 Clubs, partner would have raised to 2C rather than bid 1NT.

Since North can have no more than 3 Spades, 3 Hearts, 3 Diamonds and 4 Clubs,
you now know her exact distribution: 3-3-3-4.

To have any fewer of one suit would mean she would have to have more of some
other, which she cannot have. (Amazing, Holmes! Elementary, Watson.)
//

[Bid]
1C
Pass
1NT
Pass
???

[S]
A x x x
x
K Q x
K J x x x

Q: With South's cards, what should you bid next? (Base your bid on logic from
what you know about North's hand from the previous analysis.)

A: 2C.

You are much better off playing a known 5-4 Club fit than playing 1NT with no
Heart stoppers.

You do not have to worry about North thinking that your bid indicates a desire
to keep bidding.

North has indicated a weak hand with her 1NT response. She can only keep
bidding if you make a strong, forcing rebid.

A simple rebid of your suit is the weakest non-passing bid you can make.
//

[Bid]
1D
Pass
1NT
Pass
???

[S]
A x x x
x
K J x x x
K Q x

With your Diamond and Club holdings reversed from the last hand, you can no
longer assume that North has trump support in Diamonds.

You know that she does not have 4 Hearts or Spade, but you do not know if she
has more Clubs or Diamonds. She might very well have 3-3-1-6 distribution.

Unfortunately, if she does have 3-3-1-6, there is no way to find your 3-6 Club
fit. North is too weak to bid on the 2 level and you have no other bid you can
safely make.

In this situation, you can only pass and hope for the best.
//

Rebid After 1-Over-1 Response:

[Bid]
1H
Pass
1S
Pass
???

[S]
x x x x
A K Q x x
x
K x x

"1-Over-1" means that partner bid a new suit on the one level in response to
your opening bid.

Q: What point range can North have?
    (1) < 6.   (2) 6-10.   (3) 6-20.

A: 3. -- A 1-over-1 bid can show from 6 to 20 points. Additional bidding is
needed to narrow the range.

Q: How many points does South have?

A: 14. 12 HCP and a doubleton.
Since you are assured of at least a 4-4 fit in Spades, you must abandon your
excellent 5-card Heart suit and accept Spades as trumps.

If North has 6-10 points, you probably do not have game. But with more than
10, you are almost certain of game.
//

[Bid]
1H
Pass
1S
Pass
2S
Pass
4S

[N]
A Q J x
x x
A x x x
Q x x

[S]
K x x x
A Q x x x
K x x
x

With modest points (12-14) such as South has, you should give a simple raise
of partner's Spades and wait for North to clarify her holdings with additional
bidding.

In this case, North has 14 points and will go on to game at 4S.

If North had 6-10 points, she would have passed because South's simple raise
is relatively weak.

If North had 11-12 points, she would raise South's 2S bid to 3S, inviting
South to bid game with more than a bare minimum opener.
//

[Erase]
[Bid]
1H
Pass
1S
Pass
???

[S]
K x x x
A K Q x x
x
K J x

Q: How many total points does South have?

A: 18.

With 17-19 points, you have game unless partner is at the very bottom (6-7
points) of her range.

As always when the final contract depends on where partner is in her range,
you must put the question to her.

At the same time, you must show a strong hand. A simple raise shows a minimum,
so make a double raise by bidding 3S now.

If North has more than minimum, she will raise to 4; otherwise she will pass.
//

[Bid]
1H
Pass
1S
Pass
???

[S]
K x x x
A K Q x x
A
K J x

If you have an even stronger hand - one that was just short of a 2 Club
opener, you should raise partner straight to game.

Since partner has promised as few as 6 points, if you jump to 4S, she will
deduce that you have 20+ points to make a 26-point game.

If she has 12+ points to go with your 20+, she should press on to slam. She
might just bid 6S, or she might use a slam bidding convention to be covered
later.
//

[Bid]
1H
Pass
1S
Pass
???

[S]
x x x
A K Q x x
x x
K J x

When you have a hand like the one shown -
   - minimum points (13 HCP in this example),
   - less than 4 cards in partner's suit,
   - not enough length to rebid your suit,

the only bid left to you is 1NT

This is a weak rebid which North is free to pass.

However, if North has a very strong hand (15+ points), she may raise you to
game in NT.
//

[Erase]
[Bid]
1H
Pass
1S
Pass
1NT
Pass
???

[N]
K Q J x x x
x
x x x x
x x

If North has a hand unsuitable for NT and weak, like the one shown, she may
rebid her suit.

Like any simple rebid, this is a minimum bid which partner can pass.
//

[Erase]
[Bid,N]
1H
Pass
1S
Pass
1NT
Pass
???

[S]
K Q J x x x
x
K x x x
A x

Q: How many points does South have?

A: 16. Even if North has a minimum, South's 16 points should be enough to
assure game.

North's NT bid indicates that North does not have a void in Spades and
probably has more than 1, so a jump to 4S by South seems safe enough.

Because North's 1NT rebid is weak, it seems unlikely that N-S are missing
slam.
//

[Erase]
[Bid]
1H
Pass
1S
Pass
???

[S]
x x
A K J x x x
x x
K x x

With a minimum opening bid, no support for partner's suit, and more than 5
cards in your suit, such as South's hand, you should rebid your suit: 2H.

With one less Heart and one more Diamond, you canNOT rebid Hearts (not with
less than 6) and you do not have another suit, so you must bid 1NT.

Both of these are very weak bids and may be passed by a partner who was
responding with minimum points.
//

[Bid]
1H
Pass
1S
Pass
2C

[N]
A x x x
x x
x x x
K x x x

[S]
x x
A K J x x
x x
A Q x x

With a little bit stronger hand (14 HCP - don't count your distribution points
once a suit fit seems in doubt), you can bid a second suit if you have one.

With South's cards, you could bid 2C in the sequence shown. Partner can pass
2C. This is an exception to the new-suit-forcing rule.

When you bid a new suit at a level below 2 of your first suit, partner may
pass.

With the bidding sequence shown, neither North nor South have promised more
than minimum points.

With North's hand, it would be illogical to force North to raise Clubs to the
3 level, which is why this system allows North to pass in this sequence.
//

[Erase]
[Bid]
1H
Pass
1S
Pass
3H

[S]
Q x x
A K Q x x x
x x
A Q x

With a strong hand (17+ points) and a "self-sustaining" suit (at least 6 cards
headed by 3 of the top 4), make a jump rebid of your suit.

With a 6-7 point hand, partner will pass. With 8+ points, partner will raise
to game or explore for slam.
//

[Bid]
1H
Pass
1S
Pass
4H

[S]
K x
A K Q x x x
K Q x
A Q x

If you have a just-short-of-2C strength hand and a self-sustaining suit, you
have to jump to game.

There is too great a risk that if you bid anything else, partner will pass
with a 6-7 point hand and you will miss game.
//

[Bid]
1H
Pass
1S
Pass
???

[S]
x x
A K J x x
A x
A Q x x

If South has a strong hand, he must bid more vigorously than a mere 2C rebid.

3C is a jump-shift bid that is strong, although that tends to show more of a
two-suited hand.

Since South has a somewhat balanced hand with stoppers in every suit but
North's, a jump to 2NT might be a better bid.

With these hands, N-S have a very good chance of making either 3NT or 5C.
//

Rebid After 2-Over-1 Response:

[Bid]
1S
Pass
2C
Pass
???

[S]
A J x x x
Q x x
A K x
x x

Q: Review: At a minimum, how many points does North need to bid 2C over an
opening of 1S?

A: 10.

Q: Does North deny support for Spades by not raising them right away?

A: No. At this point you don't know if North can support Spades or not.
With a stronger-than-minimum hand, partner may delay raising your suit to
describe her hand.
//

[+]
Q: If North had a very good Club suit and 13+ points, what would she have bid?

A: 3C. -- a jump-shift. So you can assume either that North's Clubs are not
all that robust, or that North has fewer than 13 points.

If North subsequently makes strength-showing bids, you can assume that her
Clubs were biddable, but nothing like 5 or 6 cards headed by the Ace-King.
//

[+]
With the information we have deduced from North's bid, what does South bid?

He cannot rebid Spades because that would promise more length (6+). He cannot
raise Clubs with just 2 and cannot bid Hearts or Diamonds with just 3 each.

That only leaves a NT bid. If South had 16 points to add to North's 10+, South
could jump to game at 3NT.

But with just 14 points and these cards, South must be content to bid 2NT.

If partner is at a minimum, she should recognize they don't have the points
for game and should pass; otherwise, she should bid on.
//

[Erase]
[Bid]
1S
Pass
2C
Pass
???

[S]
A J x x x
A K x
x x
Q x x

Q: What should South bid?

A: 3C.

You cannot rebid your 5-card Spade suit.
You cannot bid any of the un-bid suits.
You cannot bid NT without a Diamond stopper.
That leaves a Club raise.
//

[Bid]
1S
Pass
2C
Pass
???

[S]
A J x x x x
K Q x
x
Q x x

Q: What should South bid?

A: 2S.

South has a rather minimal opener and (old refrain:) a rebid of the same suit
is about the weakest non-passing response you can make.

South could raise North's Clubs, but (old refrain:) it is better to be in a
major suit fit.

If North has a hand in the 10-12 range and at least 2 Spades, she will
probably pass.

If North has a hand in the 13+ range and at least 2 Spades, she will probably
raise to game (4S). If she is singleton or void in Spades, she will probably
have another suit to bid.
//

Rebid After Opening a Preempt:

[Bid]
3S
Dbl.
Pass
4H
???

[S]
K Q J x x x x x
-
x x x
x x

If you open with a preemptive bid, then as a general rule, you should not bid
again no matter what your partner or opponents bid.

In the bidding shown, you absolutely should not be tempted to bid 4S.

E-W may be missing a slam or they may not be able to make game, depending on
what North has.

Your original preempt has done its job. You have forced the opponents to make
a bid on the 4 level without being able to communicate with each other.

East had to guess at whether West was doubling for penalties or to try for
game.

If you bid again, you give the opponents a second chance to bid on to slam or
to double and set you when perhaps they could not have made game.
//

[Bid]
3S
Dbl.
5S
6H
???

Q: What should South bid?

A: Pass.

There is a good chance that partner extended your preempt to the 5 level to
try to induce E-W to bid a slam they cannot make.

If so, her plan worked. Don't muck it up by bidding again!
//

[Bid]
3S
Dbl.
Pass
4H
Pass
6H
Pass
Pass
???

Q: What should South bid?

A: Pass.

This is a very different situation in that West freely and strongly bid slam
and seems pretty sure of being able to make it.

If E-W are vulnerable and you are not, this certainly seems like an ideal time
to bid 6S and keep them from making a high-scoring slam.

However, this is where you have to trust your partner. You have already
described your hand.

Partner passed after West's 6H. North must feel that she has a chance to set
6H or she would have bid 6S herself.
//

Length-Showing Rebids:

In general, each time you rebid your suit WITHOUT BEING RAISED, you are
promising extra length.

When you open 1 of a major, you promise at least 5 in the suit. If you rebid
it once, you promise 6+. If you rebid it again, you promise 7+.

When you bid 1-over-1, you promise at least 4 in the suit. You must have 5 or
more to rebid your suit.

When you open 1 of a minor, you only promise 3 cards if it is a "convenient
minor". If you bid it again, you are showing a "real suit" and should have 5
or more.

If you open with 1, partner bids another suit, and you jump in your suit to
the 3 level or beyond, you are showing at least a 6-card suit headed by 3 of
the 4 top honors.
//

Blackwood Convention:

There are many "conventions" (bids that don't mean what they sound like
but are designed to convey specific information instead).

At this first level of CardShark Bridge Tutor, we will only get into a few
because it is important to learn the fundamentals first without trying to
learn all the exotic gadget bids.

One convention that is almost essential in bidding slams is some way of
finding out how many Aces and Kings your partner has.

In a slam, it is critical that you have control over every suit. In a
small slam, you can afford to lose (only) one trick, so a "second round"
control is acceptable in one suit, but you must have first round control
in the rest.

"First round control" is an Ace or a void in which you can trump.
"Second round control" could be KQ or a singleton.
//

[Erase]
[Bid]
2C
Pass
2H
Pass
2S
Pass
2NT
Pass
???

[S]
A K Q J x x
x
K Q J x
A x

There are several conventions for finding out how many Aces and Kings your
partner has, but the most popular is Blackwood.

You open the hand shown with 2 Clubs since you only have 4 losers (a Heart, 2
Diamonds and a Club).

Partner responds with 2 Hearts, which means that she has 6+ points.

If those 6+ points include the Ace of Hearts or Diamonds, you have a good shot
at slam. If she has both of the missing Aces, you have a sure small slam and a
chance at grand slam.

This is where the Blackwood Convention comes in. Partner's NT bid denies 3
Spades, but probably indicates 2, which is all the trump support you need.
//

[+]
[Bid+S]
4NT
Pass
???

[N]
x x
A K x x x
A x
x x x x

So you are ready to try for slam by asking for Aces. In Blackwood, you do that
by bidding 4NT.

Partner will recognize that you are bidding Blackwood and not raising her NT
bid and will bid up the suit ranks to show the number of Aces she has:

5C - none or all 4
5D - 1 Ace
5H - 2 Aces
5S - 3 Aces

Don't worry if you cannot remember immediately during the heat of bidding
that you bid 5H with 2 Aces, just mentally tick it off starting with the
lowest suit, Clubs, showing 0 (or 4) and work up the suit rankings.
//

[+]
[Bid+N]
5H
Pass
5NT
Pass
6D
Pass
???

If you find from your partner's response that your opponents have the two
missing Aces, you can sign off at 5 Spades.

If partner bids 5D to show 1 ace, you can bid 6 Spades. If partner shows 2
Aces, you might want to try 7 Spades, but it would be helpful to know how many
Kings partner has.

The second part of Blackwood is asking for Kings by bidding 5NT after
asking for Aces. Partner responds the same way as for Aces, but 1 level
higher:

6C - 0 or 4 Kings
6D - 1 King
6H - 2 Kings
6S - 3 Kings
//

[+]
[Bid+S]
7S

North has shown the 2 missing Aces and one King.

You will be able to discard your low Club on one of partner's Kings (it
doesn't matter which one), so you can bid a grand slam.
//

[Erase]
[S]
K x x
K x x x
Q x x
x x x

Q: What do you respond to partner's Blackwood 4NT?

A: 5C.

This indicates that you have all or none of the Aces.

Assuming partner has at least one Ace, she knows your bid shows none.

(It's very unlikely that you will progress to Blackwood without either partner
having an Ace.)
//

[Bid]
1NT
Pass
4NT
Pass
???

[S]
A x x x
K Q x
A T x
K Q x

Q: You open 1NT and partner responds with 4NT. What do you bid?

A: 6NT. (Trick question.)

4NT over a 1NT opening is not Blackwood.

If you still don't remember this response, review "Responses to 1NT" in
L1-BID2.CSC.
//

[Erase]
Some partnerships play that if you ask for Aces and find that your side
has them all, you MUST also ask for Kings.

This lets partner know that that your side DOES have all the Aces.

With first round controls assured, if partner has a long running side suit on
which you can discard your losers, she can bid a grand slam even though you do
not have all the Kings.
//

[Bid,N]
1S
Pass
2C
Pass
2H
Pass
4H
Pass
4NT
Pass
5D
Pass
5NT
Pass
6D
Pass
6H
Pass
???

[S]
x
Q x x x
x x
A K Q J x x

Q: What, if anything, should South bid now?

A: 7H. You know that your side has all the Aces because partner asked for
Kings after asking for Aces.

Since partner signed off with a small slam, you can assume that partner has
something like "A x" in some suit and signed off after finding out that you
did not have all the outstanding Kings.

However, partner has no way of knowing that you have a long, running Club suit
on which she can discard losers, so it's up to you to raise to the grand slam.

As shown in the last question, all the point count methods, bidding systems,
and conventions in the world are no substitute for the ability to make
deductions from the bidding and play of your partner and opponents.
//

Control-Asking Cue Bids:

A "cue bid" is an artificial bid of a suit that is not intended to show a real
suit. There are several types of "cue bids".

A Control-Asking cue bid is used, after partners have agreed on a trump suit,
to indicate an Ace or void in a side suit.

This is usually done to show an interest in slam and to find out which Aces or
voids and Kings or singletons partner has.

Once a player starts a cue bidding sequence, partner must respond with the
lowest possible bid that will show an Ace or void ("first round controls").

If you have no first round controls or if you have already shown them and the
sequence continues, you should make the next lowest bid that shows a King or
singleton.
//

You can deny any (more) controls by bidding the trump suit. Obviously, this
means that trumps are excluded from the control-asking sequence.

Control-asking cue bids might be used rather than Blackwood for a several
reasons:

(1) You can explore slam possibilities below the game level (which you cannot
do with Blackwood's 4NT).

(2) You can determine exactly which Aces and Kings partner has, rather than
just the quantity. This is crucial if you have a void.

(3) You can find out about voids and singletons, which you cannot do with
Blackwood.
//

[Erase]
[Bid,N]
1D
Pass
3D
Pass
3S
Pass
???

[S]
K Q x
A x
K J x x x
x x x

Q: What should South bid?

A: 4H.

Partner's bid of Spades after Diamonds have been agreed upon as trumps is an
Ace-showing cue bid.

You must show your next lowest Ace (your only one, in this case).
//

[Bid,N]
1D
Pass
3D
Pass
3S
Pass
???

[S]
K Q x
K x
A J x x x
x x x

Q: With the same sequence but new cards, what should South bid?

A: 4H. Bidding 4D would not show the Ace, it would deny any Aces or Kings by
rebidding the trump suit.

How does partner know that you are showing a King and not the Ace of Hearts?

He doesn't, unless he already has the Ace of Hearts.

Since North must have a very strong, slam-going hand to start a cue-bidding
sequence, there is a good chance that he does have the AH and was wondering
about the King.

Your cue-bidding of a King also tells partner that you have no Aces.
//

[Bid,N]
1D
Pass
3D
Pass
4C
Pass
???

[S]
K Q x
K x
J x x x x
A x x

In a similar sequence, North has started the cue-bid sequence with 4C instead
of the lower bid of 3S or 3H.

If the responder in the cue-bidding sequence, skips over one or more suits, it
indicates not having the Ace in those suits.

However, the partner trying for slam may skip over a level to the one directly
below (excluding the trump suit) the one in which he is interested.

Say that North has the AH and AS and wants to know if South has the King of
Hearts.

If North bid 3H to show his Ace, South would bid 4C...
//

[+]
Now North has to bid 4S to give South a chance to bid 5H to show the King of
Hearts and bidding has gone beyond game (5D).

North can instead forget showing his Aces and just bid 4C as shown.

Now South can bid 4H to show the King.

If South bids 4D to deny any Aces or Kings in Spades and Hearts, or even if
South can't figure out that North is not interested in her Clubs and bids 5C,
South can still stop the bidding at game (5D).
//

[Erase]
[Bid,N]
1H
Pass
1S
Pass
2C
Pass
4H
Pass
4S
Pass
??

[N]
A J x
A K Q x x
-
Q J T x x

[S]
K Q x x
J T x
Q J x x
A x

Q: With the hands and bidding shown, what should South bid?

A: 5C.

Since Hearts have been bid and raised, North's 4S bid is not attempting to
change the contract to 4S, it is a cue bid showing the Ace of Spades.

Partner is expected to bid her lowest Ace or if no Aces, then Kings, starting
with the lowest possible bid.

If partner has no Aces nor Kings, she should rebid the trump suit.
//

[+]
With the hands shown, North has a virtual cinch for slam if South has the Ace
or King of Clubs

If the opponents have the Ace, King of Clubs and take two tricks off the top,
North can go set before he gets started.

When North bids 4S, he is not necessarily showing the Ace or King of Spades.

He is starting a cue-bidding sequence in hopes that partner will show the Ace
or King of Clubs.

With the hands shown, when South bids 5C over 4S, North can then bid slam at 6
Hearts.
//

[+]
[S]
K Q x x
J T x
A x x x
K x

If South had the hand shown instead of the previous one in which she had the
Ace of Clubs, then over North's 4S cue bid, she would bid 5D to show the Ace
before showing the King.

North could find out about the Club King by bidding Spades again (5S) and sure
enough, South would show the King by bidding 6C.

However, if South does NOT have the KC, the only other bid she can make is 6H,
so you are at slam without wanting to be, so North cannot make the 5S cue bid.

This is a good illustration of the need for "bidding space". N-S run out of
room before they find out they have slam because of South's (quite proper)
jump to 4S.
//

[Bid,N]
1H
Pass
1S
Pass
2C
Pass
3H
Pass
3S
Pass
4D
Pass
4S
Pass
5C
Pass
6H

Ironically, if South's hand at not been good enough for the jump to 4H and she
had only jumped to 3H instead, the bidding could have gone as shown.

North would have had room for a second round of cue bidding, found out about
the Club King, and bid slam.
//

[Erase]
[Bid,N]
1NT
Pass
4H
Pass
4S
Pass
???

[S]
x x x
A Q J x x x
x x x
A

Q: What should South bid now?

A: 5C.

A suit does not have to be bid and raised to be the "agreed upon" trump suit.

In this bidding, North is assumed to have at least 2 Hearts, so South jumps
straight to game in Hearts with the known 6-2 or better fit.

The only possible reason for North to bid on is an interest in slam, so 4S HAS
to be a cue bid showing the Ace of Spades and asking for partner's Aces.

North might have a Club suit like "KQJTx" that will be good for discards in
slam if South has the Ace of Clubs (which he does, in this case).
//

[Erase]
[Bid]
1C
Pass
1H
Pass
1S
Pass
2C
Pass
2H

There is an exception to the concept that a "bid-and-raised" suit must be the
trump suit, and that is when a suit has not been directly raised and it is
obvious that the bidder is still fishing around for the best contract, such as
in the bidding shown.

Actually, any raise of an artificially bid suit cannot be considered as
"agreeing to a trump suit" until the original bidder reraises. In this case,
1C may be a "convenient minor" and artificial. North might be raising Clubs
with just 4 of them, expecting South to "correct" to another suit if Clubs
were not for real.

You should always be alert if partner has bid two suits and after you raise
one, partner bids the other. Rather than being a cue bid, he may be correcting
to his best suit.
//

Partnership Harmony:

[Bid,N]
1NT
Pass
4H
Pass
4S
Pass
???

[S]
x x x
A Q J x x x
x x x
A

This hand from the previous screen illustrates an important point about
partnership bidding:

You must always believe that your partner's bids mean exactly what they are
supposed to mean.

If you assume otherwise and bid what you feel like, you no longer have a
system, and bidding without a system is worse than bidding with occasional
errors.

In the previous bidding, North has to know that South would not have jumped to
game in Hearts without the necessary points and number of Hearts.

South has to know that partner would not take him out of a freely bid game in
Hearts just because North might like his Spade suit better, so North's bid HAS
to be a cue bid showing slam interest.
//

[Bid,N]
1S
Pass
2H
Pass
2S
Pass
2NT
Pass
3S
Pass
3NT
Pass
4S

;#1642998656
[N]
A K x x x x
J
A x x
K T x

[S]
J
K T x x x
K T x x
A x x

Here is an example of partnership trust gone awry. This is a hand from the
Bridge Baron computer game (BB is North).

BB's first rebid of 2S is too weak. A jump to 3S would have shown the 16+
points.

The 3S bid is plain wrong. Not only does it promise a 7-card suit, but it
raises South's weakish 2NT bid another level. With South bidding Hearts and
North having the other 2 suits stopped, there is nothing wrong with 2NT.

It's not clear why North was afraid of NT, but 3S was a poor bid and 4S was
inexcusable. Once you have described your hand, trust partner's bid.

BB's 4S bid would be understandable only if BB had a hand like
KQTxxxxx-x-x-Axx. If you get a human partner who does this kind of bull-headed
bidding, you will not enjoy the game very much.
;# 1642998660 - same thing happens in Hearts (1h,2h,3h,4h)
//

If there is a disagreement about what a bid or play should have meant in your
system, it is important to resolve the question (after the hand), but calmly
and rationally.

If either partner makes an occasional error in judgment, let it go. Everyone
makes errors, and those that fuss the loudest at their partners usually make
just as many errors themselves.

If South passes North's 4S here, it is probably because he has been berated to
the point that he lacks confidence to bid his hand.

If your partner frequently makes errors in judgment or forgets what to bid or
play, your choices are to live with it, to have them work through the
CardShark Bridge Tutor again, or to get a new partner, but questioning glares
and sounds of disgust (not to mention making comments) are illegal forms of
communication and have never been found to improve anyone's bidding or play.
//

Review Questions:

This course has tried to cover not only responses by the opening bidder, but
what the responder is expected to bid after the opener's rebid.

Following are some review questions that focus on the responder's bids.

Most of these answers are not something you can look up on a chart. They
require logic and common sense plus some basic point-count knowledge.

When presented with a deal, you should always count your points first.

When partner bids, you should always figure up -

(1) what distribution his bid indicates and
(2) what point range the bid indicates.
//

Many times you can figure out what you should bid next by adding your known
points to the range of points promised by partner and comparing it to the
points required for game (26 for NT or a major, 29 for a minor) or slam (33
for small, 37 for grand slam)

If your points plus partner's minimum are enough for game, you can bid it.

If you do not have enough for game with partner's minimum but you do if
partner is above minimum in his range, bid short of game and put the question
to partner.

If your points indicate that you have enough for slam (33+ points), indicate
an interest in slam by cue bidding an Ace (assuming you and partner have
agreed on a trump suit) or by bidding over game (eg: bid 5H over partner's
4H) or bid Blackwood yourself.
//

[Bid,N]
1C
Pass
1H
Pass
2C
Pass
???

[S]
K x x x
A x x x x
x x x
x x

Q: What should South bid in response to partner's rebid of Clubs?

A: Pass. Rebidding the same suit at the next level is about as weak a
bid as can be made (except passing).

Partner knows from your first bid that you may not be able to bid again and
that you may not have much trump support.

Partner may have a hand like this: xx-xx-KJx-AKxxxx.
With a more balanced hand, partner would have bid 1NT over your 1H response
rather than 2C. (You would also pass over 1NT.)

Do NOT bid your 4-card Spade suit. If partner had 4 Spades, he would have bid
them instead of rebidding Clubs.
//

[Bid,N]
1C
Pass
1H
Pass
2C
Pass
???

[S]
x x x
A x x x x
K x x x x
-

Q: What should South bid with these cards?

A: 2D.
This is a difficult hand. You have 10 points if trumps are Hearts or Diamonds
because of the void in Clubs.

But if you bid 2D and North rebids Clubs, which he might do with a hand like
KJx-xx-xx-AKxxxx, you are going to have to pass, and your hand is only worth 7
points in Clubs (or less, since you have no trump support).

Still, with 10 points, two 5-card suits, and a void in partner's suit, it is
probably worth trying to get partner into one of your suits.

If N-S have a total misfit, this attempt will make you go down another trick,
but there is a good chance that partner will have 3+ cards in one of your
suits.
//

[Bid,N]
1C
Pass
1H
Pass
1S
Pass
???

[S]
K Q J x
x x x x
x x
x x x

Q: What should you bid with South's cards?

A: Pass.

A new suit is not forcing unless it is bid above 2 of the level of the
original suit.

If partner had enough points for you to have any hope of game, he would have
made a much stronger bid than 1-over-1.

If you have a part score and need to be at the 2 level to bring it to game,
you can bid 2S. Partner will be aware of the score situation and pass.

Don't get over excited because partner has bid the suit where all your points
reside. You still only have 6 HCP.
//

[Bid,N]
1H
Pass
1S
Pass
3S
Pass
???

[S]
A K x x x
x x
x x x
x x x

Q: What should South bid?

A: Pass.

You do not have to remember what North's possible point ranges are on hands
like this.

All you have to remember is that partner has asked you to pass if you are at
the bottom of YOUR range and to bid otherwise.

Your 1-over-1 response has a range of 6-20 points. Your 7 HCP are very near
the bottom, so you should pass.

If partner had enough points to make game with you at a minimum, he would have
bid game himself instead of leaving it up to you.
//

[Bid,N]
1S
Pass
2H
Pass
3D
Pass
???

[S]
J x
K Q x x x
x x x
A Q x

Q: What should South bid?

A: 3NT. This is preferable to 5 of a minor.

North's hand is either a big 2-suiter (eg: AKxxx-/-KQJxxx-xx) or a slightly
more balanced hand without the Club stopper that would have let North bid NT
(eg: AKJxx-Jx-KQxx-xx).

Either way, if you bid 3NT, you are promising a stopper in the unbid suit.

[Bid+S]
3NT
Pass
4D
Pass
???

Q: After your 3NT bid, North bids 4D. What do you bid?

A: 5D. Do NOT pass! North is showing a highly distributional hand, but even
so, when North pulls you out of game (3NT) to a non-game (4D) bid after
bidding two suits, you are expected to bid game in the suit you prefer.
//

[Bid,N]
1H
Pass
1S
Pass
3S
Pass
???

[S]
A Q J x x
x x
x
A K x x x

Q: How many points does North's 3S bid show? (1) 13-16. (2) 17-18. (3) 19+.

A: 2. Game takes 26. North wants you to bid game with anything more than the
minimum 6-7, so she must have 17-18.

If you can bid game with as few as 8-9 points, then North must have around 26
minus 8-9 points.

Q: What should South bid?

A: 4C. South has 17 total points with Spades as trumps. Added to North's 17,
N-S have 34 -- enough for slam.

You can indicate an interest in slam (and also make sure that N-S are not
missing 2 Aces) by cue-bidding your Ace of Clubs. (Bidding 4NT Blackwood
Ace-asking would be just as good.)
//

[End]
