diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/ai.qc friend/ai.qc
--- v101qc/ai.qc	Thu Jul 25 01:51:22 1996
+++ friend/ai.qc	Thu Aug  8 21:27:05 1996
@@ -13,7 +13,7 @@
 The next path spot to walk toward.  If .enemy, ignore .movetarget.
 When an enemy is killed, the monster will try to return to it's path.
 
-.huntt_ime
+.hunt_time
 Set to time + something when the player is in sight, but movement straight for
 him is blocked.  This causes the monster to use wall following code for
 movement direction instead of sighting on the player.
@@ -326,12 +326,23 @@
 		sight_entity_time = time;
 	}
 	
-	self.show_hostile = time + 1;		// wake up other monsters
+	if(self.enemy!=self.friend) 
+		self.show_hostile = time + 1;	// wake up other monsters
 
 	SightSound ();
 	HuntTarget ();
 };
 
+void() FriendMove = 
+{
+	local float dir;
+
+	if(other != self.friend) return; // We don't want someone else pushing
+	dir = vectoyaw(other.velocity);
+	// dir_z = dir_z+1;
+	walkmove(dir, 7);
+};
+
 /*
 ===========
 FindTarget
@@ -349,9 +360,11 @@
 slower noticing monsters.
 ============
 */
+void(entity newfriend) player_addfriend;
+
 float() FindTarget =
 {
-	local entity	client;
+	local entity	client, oldself;
 	local float		r;
 
 // if the first spawnflag bit is set, the monster will only wake up on
@@ -413,6 +426,15 @@
 		}
 	}
 	
+	if(self.flags & FL_FRIENDLY || self.classname == "monster_dog" ) {
+		self.touch=FriendMove;
+		self.friend=self.enemy;
+		oldself=self;
+		self=self.friend;
+		player_addfriend(oldself);
+		self=oldself;
+	}
+
 	FoundTarget ();
 
 	return TRUE;
@@ -497,16 +519,27 @@
 The monster is staying in one place for a while, with slight angle turns
 =============
 */
+void() FriendMove;
 void() ai_stand =
 {
+	local float r;
 	if (FindTarget ())
 		return;
 	
 	if (time > self.pausetime)
 	{
-		self.th_walk ();
+		if(self.friend) {
+			self.touch=FriendMove; // Hack
+			r=range(self.friend);
+			if(r==RANGE_MELEE)
+				return;
+			else if(r==RANGE_MID)
+				self.th_walk ();
+			else
+				self.th_run ();
+		} else self.th_walk();
 		return;
-	}
+	} 
 	
 // change angle slightly
 
@@ -677,12 +710,22 @@
 void(float dist) ai_run =
 {
 	local	vector	delta;
+	local	float	test;
 	local	float	axis;
 	local	float	direct, ang_rint, ang_floor, ang_ceil;
 	
 	movedist = dist;
 // see if the enemy is dead
-	if (self.enemy.health <= 0)
+	if (self.classname == "monster_dog"
+		|| self.classname == "monster_shambler"
+		|| self.classname == "monster_demon") 
+		// Those guys are viscious
+			test=1;
+	else {
+		test = (self.enemy.flags & FL_MONSTER) == FL_MONSTER;
+		test = test + (self.enemy.classname == "player");
+	}
+	if (!test || self.enemy.health <= 0)
 	{
 		self.enemy = world;
 	// FIXME: look all around for other targets
@@ -693,7 +736,14 @@
 		}
 		else
 		{
-			if (self.movetarget)
+			if (self.friend)
+				if(self.friend.health > 0) {
+					self.enemy = self.friend;
+					HuntTarget();
+				} else {
+					self.friend=world;
+				}
+			else if (self.movetarget)
 				self.th_walk ();
 			else
 				self.th_stand ();
@@ -701,12 +751,24 @@
 		}
 	}
 
-	self.show_hostile = time + 1;		// wake up other monsters
 
 // check knowledge of enemy
 	enemy_vis = visible(self.enemy);
 	if (enemy_vis)
 		self.search_time = time + 5;
+
+// Okay, just find our friend
+	if(self.enemy == self.friend) {
+		// head straight in
+		if(range(self.friend) == RANGE_MELEE) {
+			self.pausetime=time+1;
+			self.th_stand();
+		} else
+			movetogoal (dist);		// done in C code...
+		return;
+	}
+		
+	self.show_hostile = time + 1;		// wake up other monsters
 
 // look for other coop players
 	if (coop && self.search_time < time)
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/client.qc friend/client.qc
--- v101qc/client.qc	Thu Jul 25 01:51:22 1996
+++ friend/client.qc	Fri Aug  9 20:45:23 1996
@@ -2,7 +2,7 @@
 // prototypes
 void () W_WeaponFrame;
 void() W_SetCurrentAmmo;
-void() player_pain;
+void(entity e, float f) player_pain;
 void() player_stand1;
 void (vector org) spawn_tfog;
 void (vector org, entity death_owner) spawn_tdeath;
@@ -57,7 +57,7 @@
 
 void() SetNewParms =
 {
-	parm1 = IT_SHOTGUN | IT_AXE;
+	parm1 = IT_SHOTGUN | IT_AXE | IT_EXTRA_WEAPON;
 	parm2 = 100;
 	parm3 = 0;
 	parm4 = 25;
@@ -466,6 +466,7 @@
 	self.invincible_finished = 0;
 	self.effects = 0;
 	self.invincible_time = 0;
+	self.friendlist=world;
 
 	DecodeLevelParms ();
 	
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/combat.qc friend/combat.qc
--- v101qc/combat.qc	Thu Jul 25 01:51:22 1996
+++ friend/combat.qc	Thu Aug  1 21:54:38 1996
@@ -149,7 +149,7 @@
 
 // check for godmode or invincibility
 	if (targ.flags & FL_GODMODE)
-		return;
+		take=0;
 	if (targ.invincible_finished >= time)
 	{
 		if (self.invincible_sound < time)
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/defs.qc friend/defs.qc
--- v101qc/defs.qc	Thu Jul 25 01:51:22 1996
+++ friend/defs.qc	Thu Aug  1 21:54:38 1996
@@ -240,6 +240,7 @@
 float	FL_PARTIALGROUND		= 1024;	// not all corners are valid
 float	FL_WATERJUMP			= 2048;	// player jumping out of water
 float	FL_JUMPRELEASED			= 4096;	// for jump debouncing
+float	FL_FRIENDLY			= 8192;
 
 // edict.movetype values
 float	MOVETYPE_NONE			= 0;	// never moves
@@ -690,4 +691,6 @@
 
 float(entity targ, entity inflictor) CanDamage;
 
-
+.entity	friend;
+.entity friendlist;
+.entity	listitem;
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/demon.qc friend/demon.qc
--- v101qc/demon.qc	Thu Jul 25 01:51:22 1996
+++ friend/demon.qc	Thu Aug  1 21:54:39 1996
@@ -177,23 +177,8 @@
 /*QUAKED monster_demon1 (1 0 0) (-32 -32 -24) (32 32 64) Ambush
 
 */
-void() monster_demon1 =
+void() _monster_demon1 =
 {
-	if (deathmatch)
-	{
-		remove(self);
-		return;
-	}
-	precache_model ("progs/demon.mdl");
-	precache_model ("progs/h_demon.mdl");
-
-	precache_sound ("demon/ddeath.wav");
-	precache_sound ("demon/dhit2.wav");
-	precache_sound ("demon/djump.wav");
-	precache_sound ("demon/dpain1.wav");
-	precache_sound ("demon/idle1.wav");
-	precache_sound ("demon/sight2.wav");
-
 	self.solid = SOLID_SLIDEBOX;
 	self.movetype = MOVETYPE_STEP;
 
@@ -213,6 +198,24 @@
 	walkmonster_start();
 };
 
+void () monster_demon1 =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model ("progs/demon.mdl");
+	precache_model ("progs/h_demon.mdl");
+
+	precache_sound ("demon/ddeath.wav");
+	precache_sound ("demon/dhit2.wav");
+	precache_sound ("demon/djump.wav");
+	precache_sound ("demon/dpain1.wav");
+	precache_sound ("demon/idle1.wav");
+	precache_sound ("demon/sight2.wav");
+	_monster_demon1();
+};
 
 /*
 ==============================================================================
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/dog.qc friend/dog.qc
--- v101qc/dog.qc	Thu Jul 25 01:51:22 1996
+++ friend/dog.qc	Thu Aug  1 21:54:39 1996
@@ -327,22 +327,9 @@
 /*QUAKED monster_dog (1 0 0) (-32 -32 -24) (32 32 40) Ambush
 
 */
-void() monster_dog =
-{
-	if (deathmatch)
-	{
-		remove(self);
-		return;
-	}
-	precache_model ("progs/h_dog.mdl");
-	precache_model ("progs/dog.mdl");
-
-	precache_sound ("dog/dattack1.wav");
-	precache_sound ("dog/ddeath.wav");
-	precache_sound ("dog/dpain1.wav");
-	precache_sound ("dog/dsight.wav");
-	precache_sound ("dog/idle.wav");
 
+void() _monster_dog =
+{
 	self.solid = SOLID_SLIDEBOX;
 	self.movetype = MOVETYPE_STEP;
 
@@ -360,4 +347,22 @@
 	self.th_missile = dog_leap1;
 
 	walkmonster_start();
+};
+
+void() monster_dog = {
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+
+	precache_model ("progs/h_dog.mdl");
+	precache_model ("progs/dog.mdl");
+
+	precache_sound ("dog/dattack1.wav");
+	precache_sound ("dog/ddeath.wav");
+	precache_sound ("dog/dpain1.wav");
+	precache_sound ("dog/dsight.wav");
+	precache_sound ("dog/idle.wav");
+	_monster_dog();
 };
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/llsubs.qc friend/llsubs.qc
--- v101qc/llsubs.qc	Wed Dec 31 18:00:00 1969
+++ friend/llsubs.qc	Thu Aug  1 21:54:39 1996
@@ -0,0 +1,40 @@
+entity(float size) SUB_Llinit =
+{
+	local float i=0;
+	local entity head, current;
+	head=world;
+	while(i<size) {
+		current=spawn();
+		current.chain=head;
+		head=current;
+	}
+	return head;
+};
+
+		
+entity(entity list, float index) SUB_Llaccess =
+{
+	local float i=0;
+	local entity here;
+	here=list;
+	while(i<index&&here!=world) {
+		here=here.chain;
+	}
+	return here.ent;
+};
+	
+void(void (entity e) f, entity list) SUB_Lliter =
+{
+	while(list!=world) {
+		f(list.ent);
+		list=list.chain;
+	}
+};
+
+entity(float (entity e) f, entity list) SUB_Llfind =
+{
+	while(list!=world) {
+		if (f(list.ent)) return list.ent;
+		list=list.chain;
+	}
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/monsters.qc friend/monsters.qc
--- v101qc/monsters.qc	Thu Jul 25 01:51:23 1996
+++ friend/monsters.qc	Thu Aug  1 21:54:39 1996
@@ -76,9 +76,15 @@
 	
 	if (!walkmove(0,0))
 	{
-		dprint ("walkmonster in wall at: ");
-		dprint (vtos(self.origin));
-		dprint ("\n");
+//		dprint ("walkmonster in wall at: ");
+//		dprint (vtos(self.origin));
+//		dprint ("\n");
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		ThrowGib ("progs/gib1.mdl", self.health);
+		ThrowGib ("progs/gib2.mdl", self.health);
+		ThrowGib ("progs/gib3.mdl", self.health);
+		remove(self);
+		return;
 	}
 	
 	self.takedamage = DAMAGE_AIM;
@@ -145,9 +151,15 @@
 
 	if (!walkmove(0,0))
 	{
-		dprint ("flymonster in wall at: ");
-		dprint (vtos(self.origin));
-		dprint ("\n");
+//		dprint ("flymonster in wall at: ");
+//		dprint (vtos(self.origin));
+//		dprint ("\n");
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		ThrowGib ("progs/gib1.mdl", self.health);
+		ThrowGib ("progs/gib2.mdl", self.health);
+		ThrowGib ("progs/gib3.mdl", self.health);
+		remove(self);
+		return;
 	}
 
 	if (self.target)
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/player.qc friend/player.qc
--- v101qc/player.qc	Thu Jul 25 01:51:23 1996
+++ friend/player.qc	Fri Aug  9 21:00:53 1996
@@ -334,8 +334,44 @@
 void()	player_axpain5 =	[	$axpain5,	player_axpain6	] {};
 void()	player_axpain6 =	[	$axpain6,	player_run	] {};
 
-void() player_pain =
+void(entity attacker, float take) player_pain =
 {
+	local entity list, previous, onefriend;
+	local entity oldself;
+
+	list=self.friendlist;
+	previous=world;
+	while(list) {
+dprint("a");
+		onefriend=list.listitem;
+		if(onefriend.friend!=self||onefriend.health <=0) {
+			if(previous) {
+dprint("b");
+				previous.chain=list.chain;
+				remove(list);
+				list=previous.chain;
+			} else {
+dprint("c");
+				self.friendlist=list.chain;
+				remove(list);
+				list=self.friendlist;
+			}
+		} else {
+			if(onefriend.enemy==onefriend.friend) {
+dprint("d");
+				onefriend.enemy=attacker;
+				oldself=self;
+				self=onefriend;
+				FoundTarget();
+				self=oldself;
+			}
+dprint("e");
+			previous=list;
+			list=list.chain;
+		}
+	}
+dprint("f\n");
+
 	if (self.weaponframe)
 		return;
 
@@ -589,6 +625,14 @@
 	self.nextthink = -1;
 };
 
+void(entity e) player_addfriend = {
+	local entity newfle;
+	newfle=spawn();
+	newfle.chain=self.friendlist;
+	newfle.listitem=e;
+	e.colormap=self.colormap; // Maybe
+	self.friendlist=newfle;
+};
 
 void()	player_diea1	=	[	$deatha1,	player_diea2	] {};
 void()	player_diea2	=	[	$deatha2,	player_diea3	] {};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/shambler.qc friend/shambler.qc
--- v101qc/shambler.qc	Thu Jul 25 01:51:24 1996
+++ friend/shambler.qc	Thu Aug  1 21:54:40 1996
@@ -326,6 +326,27 @@
 
 /*QUAKED monster_shambler (1 0 0) (-32 -32 -24) (32 32 64) Ambush
 */
+void() _monster_shambler =
+{
+
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+	setmodel (self, "progs/shambler.mdl");
+
+	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+	self.health = 600;
+
+	self.th_stand = sham_stand1;
+	self.th_walk = sham_walk1;
+	self.th_run = sham_run1;
+	self.th_die = sham_die;
+	self.th_melee = sham_melee;
+	self.th_missile = sham_magic1;
+	self.th_pain = sham_pain;
+	
+	walkmonster_start();
+};
+
 void() monster_shambler =
 {
 	if (deathmatch)
@@ -347,21 +368,5 @@
 	precache_sound ("shambler/melee1.wav");
 	precache_sound ("shambler/melee2.wav");
 	precache_sound ("shambler/smack.wav");
-
-	self.solid = SOLID_SLIDEBOX;
-	self.movetype = MOVETYPE_STEP;
-	setmodel (self, "progs/shambler.mdl");
-
-	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
-	self.health = 600;
-
-	self.th_stand = sham_stand1;
-	self.th_walk = sham_walk1;
-	self.th_run = sham_run1;
-	self.th_die = sham_die;
-	self.th_melee = sham_melee;
-	self.th_missile = sham_magic1;
-	self.th_pain = sham_pain;
-	
-	walkmonster_start();
+	_monster_shambler();
 };
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/soldier.qc friend/soldier.qc
--- v101qc/soldier.qc	Thu Jul 25 01:51:24 1996
+++ friend/soldier.qc	Thu Aug  1 21:54:40 1996
@@ -242,13 +242,34 @@
 
 /*QUAKED monster_army (1 0 0) (-16 -16 -24) (16 16 40) Ambush
 */
-void() monster_army =
+void() _monster_army =
 {	
+
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+
+	setmodel (self, "progs/soldier.mdl");
+
+	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = 30;
+
+	self.th_stand = army_stand1;
+	self.th_walk = army_walk1;
+	self.th_run = army_run1;
+	self.th_missile = army_atk1;
+	self.th_pain = army_pain;
+	self.th_die = army_die;
+
+	walkmonster_start ();
+};
+
+void() monster_army = {
 	if (deathmatch)
 	{
 		remove(self);
 		return;
 	}
+
 	precache_model ("progs/soldier.mdl");
 	precache_model ("progs/h_guard.mdl");
 	precache_model ("progs/gib1.mdl");
@@ -263,22 +284,5 @@
 	precache_sound ("soldier/sight1.wav");
 
 	precache_sound ("player/udeath.wav");		// gib death
-
-
-	self.solid = SOLID_SLIDEBOX;
-	self.movetype = MOVETYPE_STEP;
-
-	setmodel (self, "progs/soldier.mdl");
-
-	setsize (self, '-16 -16 -24', '16 16 40');
-	self.health = 30;
-
-	self.th_stand = army_stand1;
-	self.th_walk = army_walk1;
-	self.th_run = army_run1;
-	self.th_missile = army_atk1;
-	self.th_pain = army_pain;
-	self.th_die = army_die;
-
-	walkmonster_start ();
+	_monster_army();
 };
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/weapons.qc friend/weapons.qc
--- v101qc/weapons.qc	Thu Jul 25 01:51:24 1996
+++ friend/weapons.qc	Thu Aug  8 21:33:52 1996
@@ -1152,6 +1152,99 @@
 	dprint ("quad cheat\n");
 };
 
+void() _monster_dog;
+void() _monster_army;
+void() _monster_shambler;
+void() _monster_demon1;
+void(string model, float health) ThrowGib;
+void() walkmonster_start_go;
+void() walkmonster_start;
+void() FriendMove;
+
+void() EggTouch =
+{
+	local entity oldself;
+	oldself=self;
+
+	self=self.owner;
+	player_addfriend(oldself);
+	self=oldself;
+
+	self.touch=FriendMove;
+	self.friend=self.enemy=self.movetarget=self.goalentity=self.owner;
+	self.angles=self.owner.angles;
+	self.owner=world;
+	
+	if(random()>0.3) {
+		self.classname="monster_dog";
+		self.origin = self.origin + '0 0 41';
+		_monster_dog();
+	} else if(random()<0.9) {
+		self.classname="monster_army";
+		self.origin = self.origin + '0 0 41';
+		_monster_army();
+	} else if(random()<0.6) {
+		self.classname="monster_demon1";
+		self.origin = self.origin + '0 0 64';
+		_monster_demon1();
+	} else {
+		self.classname="monster_shambler";
+		self.origin = self.origin + '0 0 64';
+		_monster_shambler();
+	}
+
+//	Testing purposes...
+//	self.classname="monster_demon1";
+//	self.origin = self.origin + '0 0 64';
+//	_monster_demon1();
+
+	walkmonster_start_go();
+	FoundTarget();
+};
+
+void() SpawnFriendEgg =
+{
+	local	entity missile, mpuff;
+	
+	sound (self, CHAN_WEAPON, "player/lburn2.wav", 1, ATTN_NORM);
+
+	if(!(deathmatch || coop || (self.flags & FL_GODMODE)))
+		T_Damage(self,self,self,50);
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+	missile.classname = "grenade";
+	missile.touch = EggTouch;
+	missile.nextthink = time + 1;
+	missile.think = EggTouch;
+		
+// set missile speed	
+
+	makevectors (self.v_angle);
+
+	if (self.v_angle_x)
+		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else
+	{
+		missile.velocity = aim(self, 10000);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
+
+	missile.avelocity = '300 300 300';
+
+	missile.angles = vectoangles(missile.velocity);
+	
+	
+// set missile duration
+
+	setmodel (missile, "progs/zom_gib.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin);
+};
 /*
 ============
 ImpulseCommands
@@ -1170,6 +1263,8 @@
 	if (self.impulse == 11)
 		ServerflagsCommand ();
 
+	if (self.impulse == 250)
+		SpawnFriendEgg ();
 	if (self.impulse == 255)
 		QuadCheat ();
 		
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/world.qc friend/world.qc
--- v101qc/world.qc	Thu Jul 25 01:51:24 1996
+++ friend/world.qc	Thu Aug  1 21:54:40 1996
@@ -190,6 +190,64 @@
 	precache_sound ("misc/h2ohit1.wav");		// landing splash
 
 // setup precaches allways needed
+
+// Dog stuff
+	precache_model ("progs/h_dog.mdl");
+	precache_model ("progs/dog.mdl");
+
+	precache_sound ("dog/dattack1.wav");
+	precache_sound ("dog/ddeath.wav");
+	precache_sound ("dog/dpain1.wav");
+	precache_sound ("dog/dsight.wav");
+	precache_sound ("dog/idle.wav");
+// End dog stuff 
+
+// Soldier stuff
+	precache_model ("progs/soldier.mdl");
+	precache_model ("progs/h_guard.mdl");
+	precache_model ("progs/gib1.mdl");
+	precache_model ("progs/gib2.mdl");
+	precache_model ("progs/gib3.mdl");
+
+	precache_sound ("soldier/death1.wav");
+	precache_sound ("soldier/idle.wav");
+	precache_sound ("soldier/pain1.wav");
+	precache_sound ("soldier/pain2.wav");
+	precache_sound ("soldier/sattck1.wav");
+	precache_sound ("soldier/sight1.wav");
+
+	precache_sound ("player/udeath.wav");		// gib death
+// End of soldier stuff
+
+// Demon stuff
+	precache_model ("progs/demon.mdl");
+	precache_model ("progs/h_demon.mdl");
+
+	precache_sound ("demon/ddeath.wav");
+	precache_sound ("demon/dhit2.wav");
+	precache_sound ("demon/djump.wav");
+	precache_sound ("demon/dpain1.wav");
+	precache_sound ("demon/idle1.wav");
+	precache_sound ("demon/sight2.wav");
+// End of demon
+
+// Shambler
+	precache_model ("progs/shambler.mdl");
+	precache_model ("progs/s_light.mdl");
+	precache_model ("progs/h_shams.mdl");
+	precache_model ("progs/bolt.mdl");
+	
+	precache_sound ("shambler/sattck1.wav");
+	precache_sound ("shambler/sboom.wav");
+	precache_sound ("shambler/sdeath.wav");
+	precache_sound ("shambler/shurt2.wav");
+	precache_sound ("shambler/sidle.wav");
+	precache_sound ("shambler/ssight.wav");
+	precache_sound ("shambler/melee1.wav");
+	precache_sound ("shambler/melee2.wav");
+	precache_sound ("shambler/smack.wav");
+// End of shambler
+
 	precache_sound ("items/itembk2.wav");		// item respawn sound
 	precache_sound ("player/plyrjmp8.wav");		// player jump
 	precache_sound ("player/land.wav");			// player landing
