/**************************************************************************/
/*                              XFIND UTILITY  					    */
/*														    */
/*                                 M\Cooper						    */
/*                        3425 Chestnut Ridge Rd.					    */
/*                        Grantsville, MD 21536-9801				    */
/*                        --------------------------				    */
/*                        Email:  thegrendel@aol.com				    */
/*                                                                        */
/*                $2.00 to register the entire WORDY package	         */
/*														    */	
/**************************************************************************/

#include <conio.h>
#include "srch.h"
//srch.h (source) is part of the WORDY package


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 40
#define CR "\n"
#define FILE_SUFFIX ".fnd"
#define MAXLEN 30
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define DBLBAR 205
#define WILDCARD '?'
//Wildcard character in command line, may be changed

#define BUFFERSIZE 8192

char ad[] =
"XFIND utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536-9801";


void getword( char *lset, char *filename );
void center( char *strng );

typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char letterset [MAXLEN],
        filename [FILENAME_MAXLEN];

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts( "Enter a LETTER PATTERN to test [example ab?c??e... " );
	    gets( letterset );
     strcpy( filename, "word.lst" );  //default
	    }
	 else
     if( argc == NOARGS + 1 )
       {
	      strcpy( letterset, *(argv + 1) );
       strcpy( filename, "word.lst" ); //default
       }
   else
      {
      strcpy( letterset, *(argv + 1) );
      strcpy( filename, *(argv + 2) );
      }

	 getword( letterset, filename );
}


/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset	        */
/*                 Args in: char *letterset, char *word						  */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

Boolean wordtest( char *letterset, char *word )
{
	Boolean error_flag;
	static char dup_lset[ MAXLEN ];
	register unsigned int cnt = 0,
					  u,
					  v;

	 strcpy( dup_lset, letterset );
		 
	 u = strlen( word );
      v = strlen( letterset );

	 while( ( *letterset == *word ) || *letterset == WILDCARD )
	    {
	    letterset++;
	    word++;
	    cnt++;
	    }

	 if( u <= cnt && u == v )
		error_flag = TRUE;
	 else
		error_flag = FALSE;


		return( error_flag );
}

/**************************************************************************/

void getword( char *letter_set, char *filename )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
		messg [7];

	FILE *fptr,
		*tfile;
	int fnamelen;
	long wcount = 0L;

	   memset( bar, '*', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, DBLBAR, LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
	   strcat ( letter_set, CR );

	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
	   strcpy( targetfile, "matched.wds" );
	   /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open word file %s!", filename );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, 2 * BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 1 );

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 2 );

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take from 10 seconds or less [fast 486 machine]\n" );
	   printf( "to 5 minutes or more [slow 8088 with old hard drive].\n\n" );
	   printf( "Now searching 99,000+ word file and writing file of valid words.\n\n" );
	   /*****************************************/





	   sprintf( tempstr, "Words fitting the pattern of: %s\n", strupr( l_set ) );
	   center( tempstr );
	   fprintf( tfile, double_bar );
      fprintf( tfile, CR );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word ) )
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/

		  fprintf( tfile, bar );
      fprintf( tfile, CR );
		  sprintf( tempstr, "%ld words fit the pattern of %s.",
				 wcount, l_set );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  if( wcount == INCREMENT )
			strcpy( messg, "word" );
		  else
			strcpy( messg, "words" );
		  sprintf( tempstr,
				 "The file %s has %ld %s fitting the pattern of %s\7.",
				 targetfile, wcount, messg, l_set );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
