/*------------------------------------------------------------------
 * test_s.cmd :
 *------------------------------------------------------------------
 * 08-05-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

if RxFuncQuery("RoxLoadFuncs") then
   do
   rc = RxFuncAdd("RoxLoadFuncs","Rox","RoxLoadFuncs")
   rc = RoxLoadFuncs()
   end

rc = RoxLoad("socket.rox")

/*------------------------------------------------------------------
 * choose the port
 *------------------------------------------------------------------*/
port = 1923

/*------------------------------------------------------------------
 * create the initial socket
 *------------------------------------------------------------------*/
baseSock = RoxCreate("socket")

/*------------------------------------------------------------------
 * catch breaks
 *------------------------------------------------------------------*/
signal on halt

rc = .bindServer(baseSock,port)
if (rc <> 0) then
   do
   say "Error on SockBind:" .errno(baseSock)
   exit
   end

/*------------------------------------------------------------------
 * infinite loop to handle requests ...
 *------------------------------------------------------------------*/
do forever
   say "Waiting for client"

   /*---------------------------------------------------------------
    * accept a connection
    *---------------------------------------------------------------*/
   sock = .acceptClient(baseSock)
   if (sock = "") then
      do
      say "Error on SockAccept:" .errno(baseSock)
      rc = RoxDestroy(baseSock)
      exit
      end

   /*---------------------------------------------------------------
    * receive line from client
    *---------------------------------------------------------------*/
   line = .recvLine(sock)

   say "Received:" line

   line = reverse(line)

   /*---------------------------------------------------------------
    * send data back
    *---------------------------------------------------------------*/
   rc = .sendLine(sock,line)
   if (rc = -1) then
      do
      say "Error on SockSend:" .errno(sock)
      rc = RoxDestroy(sock)
      rc = RoxDestroy(baseSock)
      exit
      end

   /*---------------------------------------------------------------
    * close the new socket
    *---------------------------------------------------------------*/
   rc = RoxDestroy(sock)
   sock = ""
end

/*------------------------------------------------------------------
 * handle break by closing sockets
 *------------------------------------------------------------------*/
halt:

say
say "Quitting ..."

rc = RoxDestroy(baseSock)

if (sock <> "") then
   rc = RoxDestroy(sock)

