/*------------------------------------------------------------------
 * roxload.cmd :
 *------------------------------------------------------------------
 * 08-19-93 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

trace off
parse source . how .

if (how = "COMMAND") then
   Usage()

if RxFuncQuery("RoxLoadFuncs") then
   do
   rc = RxFuncAdd("RoxLoadFuncs","Rox","RoxLoadFuncs")
   rc = RoxLoadFuncs()
   end

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

/*------------------------------------------------------------------
 * get file name, check for existance
 *------------------------------------------------------------------*/
fileName = arg(1)

pathName = SysSearchPath("ROXPATH",fileName)
if (pathName <> "") then
   fileName = pathName

if ("" = stream(fileName,"C","QUERY EXISTS")) then
   do
   say "File '"fileName"' does not exist."
   return 1
   end

/*------------------------------------------------------------------
 * read the file
 *------------------------------------------------------------------*/
line.0 = 0

do i = 1 by 1 while (lines(fileName) > 0)
   line = linein(fileName)

   line.0 = i
   line.i = line
end

o = line.0 + 1
line.0 = o
line.o = ":*"

rc = stream(fileName,"C","CLOSE")

/*------------------------------------------------------------------
 * start processing
 *------------------------------------------------------------------*/
class      = ""
methodCode = ""
methodName = ""
inMethod   = 0
crlf       = d2c(13) || d2c(10)

do lineNo = 1 to line.0
   line = line.lineNo

   /*---------------------------------------------------------------
    * keyword found?
    *---------------------------------------------------------------*/
   if (substr(line,1,1) <> ":") then
      do
      if (inMethod) then
         methodCode = methodCode || line || crlf
      end

   else
      do

      /*------------------------------------------------------------
       * end method, if we're in one
       *------------------------------------------------------------*/
      if (inMethod) then
         do
         inMethod = 0
         rc = RoxClassAddMethod(class,methodName,methodCode)
         methodCode = ""
         methodName = ""
         end

      if (substr(line,1,2) = ":*") then
         iterate

      /*------------------------------------------------------------
       * handle keyword line
       *------------------------------------------------------------*/
      parse var line ":" key rest
      parse var rest rest1 .

      key = translate(key)
      select
         when (key = "CLASS") then
            do
            class = rest1
            rc = RoxAddClass(class)
            end

         when (key = "INCLUDE") then
            do
            rc = RoxLoad(rest1)
            end

         when (key = "INHERITS") then
            do i = 1 to words(rest)
               var = word(rest,i)
               rc = RoxClassAddInherit(class,var)
            end

         when (key = "VARS") then
            do i = 1 to words(rest)
               var = word(rest,i)
               rc = RoxClassAddVar(class,var)
            end

         when (key = "METHOD") then
            do
            inMethod   = 1
            methodName = rest1
            methodCode = ""
            end

         when (substr(key,1,1) = "*") then
            nop

         otherwise
            say "RoxLoad error : error in line '"line"'."
            return 0
            nop
      end
      end

end

return 0

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source os . me .

   if (os = "OS/2") then
      parse value filespec("name",me) with me "." .

   say "RoxLoad is intended to be used as a REXX function."
   exit
