#if defined(USEMIDAS)                // Compiling this program with USEMIDAS
	#include "midas\midas.h"     // means that you have agreed statements
#endif                               // in LICENSE.TXT
#include "scandef.h"                 // scan code definitions
#include "animate.h"                 // Animation routines: class ANIMATION
#include "font.h"                    // Font routines: class FONT
#include "pcx.h"                     // PCX routines: palette and background
#include "keyboard.h"                // Keyboard routines: interrupt handlers
#include "credits.h"                 // Credit routined: loading & displaying
#include <dir.h>

#define MAXBLOCKS 7                  // Maximal number of blocks in Cube
#define MAXPLAYERS 4                 // Maximal number of players in Cube
#define WIN 2                        // Define WIN = 2
#define LOSE 1                       // Define LOSE = 1
#define ARCADE 0x1E                  // Scan code for 'a'
#define BATTLE 0x30                  // Scan code for 'b'
#define COMBAT 0x2E                  // Scan code for 'c'
#define QUIT 0x01                    // Scan code for ESC
#define PARITY(x) (x-x/2*2)          // Macro for checking parity
#define PARAMETER(x, y) !memcmp( x, y, sizeof(y))
#define MINUS2PLUS(x) (x-(x+x))
#define FASTCOPY(x, y, c)  asm {            \
			    push ds;        \
			    les  di,[x];    \
			    lds  si,[y];    \
			    mov  cx, c / 4; \
			    db   0x66;      \
			    rep  movsw;     \
			    pop  ds;        \
			}


#if defined(USEMIDAS)
    mpModule   *mod;
    char modname[20] = "NORDTECH.S3M";
void uninstallMidas() {              // uninstall MIDAS on exit
    midasStopModule(mod);            // stop playing
    midasFreeModule(mod);            // free module
    midasClose();                    // close MIDAS
}
#endif

typedef struct {
    unsigned int kills;
    unsigned int wins;
} Someinfo;

char far *textscreen=(char far *)0xB8000000;
Someinfo       info[MAXPLAYERS];     // Information
char far       *backpcx = (char far *)farmalloc(64000); // background
unsigned char  players = 1,          // Default players
	       mode = ARCADE;        // Default playing mode
animation      block[MAXBLOCKS],     // Different blocks
	       shot[MAXPLAYERS],     // Flying bombs
	       cube[MAXPLAYERS],     // Cubes
	       back, live, bomb,     // indicators...
	       indicate;             // ...indicators
char           keys[MAXPLAYERS][5];  // Keys for different players
char           blockname[20] = "block1.jp"; // Default block name
char           levelname[20] = "rata00.lev"; // First level name
char           energy[MAXPLAYERS];   // Energy for players
unsigned char  lives[MAXPLAYERS],    // Lives for every cube
	       globlives,            // Global lives indicator
	       level = '0',          // Level
	       stage = '0',          // Stage
	       current = 0,          // Current player
	       alive = 1,            // How many players are still alive
	       launch[MAXPLAYERS];   // Launch indicator for players
int            x, y, sx, sy,         // For checking collision & other
	       bombs[MAXPLAYERS],    // Bombs for each player
	       viive = 10,           // Default delay
	       pois = LOSE,          // Exiting value for loop
	       help;                 // All-doing variable
FILE           *handle;              // All-doing file handle
#include "utils.h"                   // Some utils for game

void menu();                               // No parameters, just MENU
void gendefault(animation *ptr);           // Pointer to animation
void newscreen();                          // Update screen, no params.
void showstatus();                         // Show wins & kills
int  startinits();                         // Loop start initializations
void win_lose();                           // Win & lose routines
char chkblock(animation *ptr, int number); // Check collision to number
void clrblock(char hit);                   // Clear block where 'hit'
void flash();                              // Show some white light
void init();                               // Init cube locations
void checkkbd();                           // Check keyboard actions
void checkcol();                           // Check collisions
void check_kill();                         // Check killing-things
void checkalive();                         // Checks...
void typedocument(char *);                 // Document shower :)