/*
CUBE106.CPP done by Joonas Pihlajamaa alias Jokke.
Re-compiling this means that you have agreed statements
of README.DOC. Modified version can be used only with
own computer, distributing modified version is illegal !
*/
#define USEMIDAS                     // This game uses MIDAS SOUND SYSTEM,
				     // the best SOUND SYSTEM ever done !
#include "defines.h"                 // All data, function and header
				     // declarations

void loop() {                                     // The Main Loop
    for(;;) {                                     // The Loop
	if(startinits()) break;                   // Some checks etc.
	while(globlives && !pois) {               // Playing loop
	    for(x=0; x<MAXPLAYERS; x++)
		if(lives[x]) energy[x]=3;         // Init energies
	    init();                               // Init player locations
	    while(pois == FALSE) {                // Level loop
		checkalive();                     // Check if still alive
		for(current=0; current<players; current++) {  // Loop 1
		    if(launch[current]) shot[current].show(); // Show bombs
		    if(energy[current] && lives[current])
			cube[current].show(); // Show players
		}
		cube[0].onscreen();               // On screen
		for(current=players; current!=0; current--) { // Loop 1
		    if(energy[current-1] && lives[current-1]) {
			cube[current-1].hide();   // Hide
			cube[current-1].next();   // Move
			cube[current-1].animate();// Animate
		    }
		    if(launch[current-1]) {       // If shot
			shot[current-1].hide();   // Hide
			shot[current-1].next();   // Move
			shot[current-1].animate();// Animate
		    }
		}
		delay(viive);                     // Global delay ('-' & '+')
		for(current=0; current<players; current++) { // Loop 1
		    checkcol();                   // Check wall collisions
		    check_kill();                 // Check shootings etc.
		}
		checkkbd();                       // Check keyboard actions
	    }
	    win_lose();                           // winning and loosing
	}
    }
}

int main(int argc, char *argv[]) {
    printf("%s, compiled: %s, %s",__FILE__, __DATE__, __TIME__);
    printf("\nCode apart from MIDAS by Joonas Pihlajamaa");
    printf("\nArt by Jyri Pieniniemi");
    getch();

    for(x=0; x<argc; x++) {
#if defined(USEMIDAS)
	if(PARAMETER(argv[x], "/n")) {
	    memcpy(&modname, "            ", 11);
	    x++;
	    memcpy(&modname, argv[x], strlen(argv[x]));
	    printf("%s", modname);
	}
#endif
	if(PARAMETER(argv[x], "/h") || PARAMETER(argv[x], "/?")) {
	    textmode(0x03);
#if defined(USEMIDAS)
	    printf("\nSyntax: CUBE [/s <filename>.S3M][/c][/n][/h][/?]\n");
	    printf("\n  /h and /? :This help screen");
	    printf("\n     /s     :Sound setup\n");
	    printf("\n     /c     :Display credits\n");
	    printf("\n     /r     :Display the README file\n");
	    printf("\n     /n <music>.S3M : Music \n");
#else
	    printf("\nSyntax: CUBE [/c][/h][/?]\n");
	    printf("\n  /h and /? :This help screen");
	    printf("\n     /r     :Display the README file\n");
	    printf("\n     /c     :Display credits\n");
#endif
	    exit(0);
	}
	if(PARAMETER(argv[x], "/c")) {
	    textmode(0x13);
	    loadpal("backgrnd.pcx");
	    loadcredits("names.crd");             // load credits into memory
	    display();
	    textmode(0x03);
	    exit(0);
	}
	if(PARAMETER(argv[x], "/r")) {
	    typedocument("README.DOC");
	}
    }
    #if defined(USEMIDAS)                         // if MIDAS used
	int error, isConfig;                      // set integers for errors

	midasSetDefaults();                       // set MIDAS defaults
	error = fileExists("CUBE.CFG", &isConfig);// if exists CUBE.CFG
	if(error != OK) {                         // if something is wrong
	    printf("\nFailure\nLoading setup...");
	    sleep(1);
	    isConfig=0;
	}
	if(!isConfig || PARAMETER(argv[1], "/s") ) {
	    textmode(0x13);
	    _fmemcpy( dblbuf, screen, 64000);
	    changesound();
	} else {
	    midasLoadConfig("CUBE.CFG");          // load configuration file
	    midasInit();                          // init MIDAS
	    mod = midasLoadModule(modname, &mpS3M, NULL);
	    midasPlayModule(mod, 1);              // start playing
	}
	dsmSetMasterVolume(66);
	atexit(&uninstallMidas);                  // register uninstalling
    #endif                                        // routine, that's it
    setnewkbd();                                  // set new keyboard handler
    if(dblbuf != NULL && backpcx != NULL) {       // if enough memory
	handle=fopen("cube.kbd","rb");            // open CUBE.KBD
	if(handle != NULL) {                      // if exists
	    for(x=0; x<20; x++)                   // Loop 1
		keys[x/5][x-x/5*5]=fgetc(handle); // read keys
	    fclose(handle);                       // close handle
	} else {                                  // if not exists
	    printf("\nNeeds CUBE.KBD to run.\n"); // print error message
	    exit(1);                              // exit & uninstall MIDAS
	}
	textmode(0x13);                           // set 320 x 200 x 256 color
	shadetoblack("backgrnd.pcx", 0);
	loadpcx("start.pcx");
	cube[0].onscreen();
	shadefromblack("start.pcx",200);
	sleep(1);
	shadetoblack("start.pcx",40);
	loadpcx("backgrnd.pcx");                  // background from BACKGRND
	_fmemcpy( backpcx, dblbuf, 64000);        // background to buffer
	cube[0].loadobj("cube10.jp");              // load cube frame 0
	cube[0].loadobj("cube20.jp");              // load cube frame 1
	cube[0].loadobj("cube30.jp");              // load cube frame 2
	cube[0].loadobj("cube40.jp");              // load cube frame 3
	cube[1].loadobj("cube11.jp");              // load cube frame 0
	cube[1].loadobj("cube21.jp");              // load cube frame 1
	cube[1].loadobj("cube31.jp");              // load cube frame 2
	cube[1].loadobj("cube41.jp");              // load cube frame 3
	cube[2].loadobj("cube12.jp");              // load cube frame 0
	cube[2].loadobj("cube22.jp");              // load cube frame 1
	cube[2].loadobj("cube32.jp");              // load cube frame 2
	cube[2].loadobj("cube42.jp");              // load cube frame 3
	cube[3].loadobj("cube13.jp");              // load cube frame 0
	cube[3].loadobj("cube23.jp");              // load cube frame 1
	cube[3].loadobj("cube33.jp");              // load cube frame 2
	cube[3].loadobj("cube43.jp");              // load cube frame 3
	shot[0].loadobj("shot1.jp");              // load shot frame 0
	shot[0].loadobj("shot2.jp");              // load shot frame 1
	live.loadobj("block5.jp");
	bomb.loadobj("block4.jp");
	indicate.loadobj("indicate.jp");
	indicate.allocback(indicate.getxsize(), indicate.getysize());
	indicate.link(0);
	live.allocback(live.getxsize(), live.getysize());
	bomb.allocback(bomb.getxsize(), bomb.getysize());
	live.link(0);
	bomb.link(0);
	for(x=0; x<MAXBLOCKS; x++) {              // Loop 1
	    blockname[5]=x + '1';                 // set right block number
	    block[x].loadobj(blockname);          // load block
	    block[x].allocback( block[0].getxsize(), block[0].getysize() );
	    block[x].link(0);                     // link to frame 0
	}
	for(x=0; x<MAXPLAYERS; x++) {             // Loop 1
	    cube[x].setsize( cube[0].getxsize(), cube[0].getysize() ) ;// set
	    shot[x].setsize( shot[0].getxsize(), shot[0].getysize() ) ;// size
	    if(x != 0) {                          // Loop 2 not for cube zero
		for(y=0; y<4; y++) {              // Loop 2
		    shot[x].frame[y]=shot[0].frame[y]; // point to shot[0]'s
		}
	    }
	    gendefault(&cube[x]);                 // Generate default config
	    bombs[x] = 2;                         // Set bombs to 2
	    launch[x] = FALSE ;                   // set launch to false
	    gendefault(&shot[x]);                 // generate default config
	    info[x].kills=info[x].wins=0;         // Init KILLS and WINS
	}
	back.loadobj(levelname);                  // load first level
	newscreen();                              // Update screen
    } else {                                      // If not enough memory
	printf("\nNeeds more memory to allocate buffers.\n"); // error
	exit(1);                                  // exit & uninstall MIDAS
    }
    cube[0].onscreen();
    shadefromblack("backgrnd.pcx", 30);

    loop();                                       // The Main Loop

    for(x=0; x<32000; x++) {
	dblbuf[x*2+0]=0;
	dblbuf[x*2+1]=0;
    }
    cube[0].onscreen();
    shadefromblack("backgrnd.pcx",0);
    loadcredits("names.crd");                     // load credits into memory
    display();                                    // display credits
    textmode(0x03);                               // set text mode
    system("mem > status.mem");                   // amount of memory to file
    farfree(dblbuf);                              // free double buffer
    for(x=0; x<MAXBLOCKS; x++)                    // Loop 1
	block[x].destruct();                      // free blocks
    for(x=0; x<MAXPLAYERS; x++) {                 // Loop 1
	cube[x].destruct();                       // free cube frames
	shot[x].destruct();                       // free shot frames
    }
    setoldkbd();                                  // set old keyboard handler
    for(x=1; x<160*20; x+=2)
	textscreen[x]=57;
    system("TYPE TEXT.TXT");
    return(0);                                    // exit & uninstall MIDAS
}

void menu() {                                     // No parameters, just MENU
    back.destruct();                              // Prepare new level
    stand.openwindow(110,  82, 100, 52, 100);     // Open window for text
    stand.gprint("1-4 Set players",115, 83,50);   // Print..
    stand.gprint("a. Arcade game",115, 89,50);    // Some...
    stand.gprint("b. Battle game",115, 95,50);    // Text...
    stand.gprint("c. Combat game",115,101,50);    // Text...
    stand.gprint("k. change Keys",115,107,50);    // Text...
    stand.gprint("d. shell to Dos",115,113,50);
#if defined(USEMIDAS)
    stand.gprint("s. Sound setup",115,119,50);    // Text...
#endif
    back.onscreen();                              // On screen
    viimeisin=mode=0x02;                          // Prepare loop
    while(mode==0x02) {                           // Loop
	stand.gputc(players+'0',115,125,50);      // Show 'players'
	cube[0].onscreen();                       // On screen
	stand.gputc(players+'0',115,125,100);     // Clear 'players'
	if( viimeisin<0x06 && viimeisin>0x01 ) {  // If 1-4
	    mode=0x02;                            // Continue loop
	    players = viimeisin-1;                // Set 'players'
	} else {
	    mode=viimeisin;
	    switch(viimeisin) {
		case QUIT:
		case ARCADE:
		case BATTLE:
		case COMBAT: break;
		case   SxK : getkeys(); mode=0x02;
			     viimeisin=0x02;break;
		case   SxD : setoldkbd();
			     napit[SxD]=0;
			     textmode(0x03);
			     printf("\nReturn to CUBE's directory when typing EXIT");
			     system("\command.com");
			     textmode(0x13);
			     showscreen_down(200);
			     setnewkbd();
			     loadpal("backgrnd.pcx");
			     mode=viimeisin=0x02; break;
#if defined(USEMIDAS)
		case   SxS : napit[0x1F] = FALSE;
			     setoldkbd();
			     uninstallMidas();
			     changesound();
			     mode=0x02;
			     setnewkbd(); break;
#endif
		default: mode = ARCADE; break;
	    }
	}
    }
    stand.closewindow();                          // Close window
}
void gendefault(animation *ptr) {                 // Pointer to animation
    ptr->allocback(ptr->getxsize(), ptr->getysize()); // Allocate memory
    ptr->loop=TRUE;                               // Set looping
    ptr->framedel=5;                              // Set frame delay
    ptr->link(0);                                 // Link to frame zero
}
void newscreen() {                                // Update screen, no params.
    int x, y, c, n;                               // Some loop integers
    FASTCOPY(dblbuf, backpcx, 64000);             // PCX to double buffer
    back.setframe(0);                             // Set back to zero
    if(back.objptr != NULL) {
	farfree(back.objptr);                     // If memory allocated
	back.objptr=NULL;
    }
    back.allocback(back.getxsize(), back.getysize()); // Allocate memory
    for(x=0; x<32; x++)                           // Loop 1
	for(y=0; y<20; y++)                       // Loop 2
	    if(back.frame[0][y*32+x] != 0) {      // Show current block
		block[ back.frame[0][y*32+x] - 1].setloc(x*10,y*10);
		block[ back.frame[0][y*32+x] - 1].show();
	    }
    for(x=0; x<5; x++) {                          // Loop 1
	for(y=0; y<players; y++) {                // Loop 2
	    if(x==0 && y==0) {
		indicate.setloc(63, 2);
		indicate.show();
		indicate.setloc(223, 2);
		indicate.show();
		indicate.setloc(63, 192);
		indicate.show();
		indicate.setloc(223, 192);
		indicate.show();
	    }
	    if(bombs[y]>x) {                      // If bombs more than Loop 1
		bomb.setloc( (y >> 1) * 310, PARITY(y)*190 +     // Put bomb..
			      ( (PARITY(y) * -2 + 1) *(x*10)) ); // To place
		bomb.show();                      // And show it
	    }
	    if(lives[y]>x) {
		live.setloc( ((y >> 1) * -2 +1) *(x*10+10) +(y >> 1)* 310,
			      PARITY(y)*190 );
		live.show();                      // And show it
	    }
	    if(energy[y]>x) {
		for(c=0; c<5; c++)
		for(n=0; n<10; n++)
		dblbuf[(c+3+PARITY(y)*190) *320 +
		       (65+(y>>1)*160)+n+x*10]=100;
	    }
	}
    }
}
void showstatus() {
    int x;
    stand.gprint("        Pl 1:   Pl 2:   Pl 3:   Pl 4:     ",10,50,100);
    stand.gprint(" Kills:                                   ",10,60,100);
    stand.gprint(" Wins:                                    ",10,70,100);
    for(x=0; x<players; x++) {
	stand.guint(info[x].kills, 60 + x*8*6, 60, 100);
	stand.guint(info[x].wins, 60 + x*8*6, 70, 100);
    }
}
int startinits() {
    if(pois != WIN) {                         // If no lives left
	for(x=0; x<MAXPLAYERS; x++) {
	    bombs[x] = 2; // 2 bombs for everyone
	    lives[x] = 3; // 3 lives for everyone
	    info[x].kills=info[x].wins=0;     // Init KILLS and WINS
	}
	menu();                               // MENU
	globlives=players*3;                  // Set global lives
    }
    if(mode == QUIT) {
	shadetoblack("backgrnd.pcx", 30);
	return(1);                            // On ESC break The Loop
    }
    if(mode == ARCADE || mode == COMBAT)
	back.loadobj(levelname);              // ARCADE and COMBAT levels
    if(mode == BATTLE)
	back.loadobj("arena1.jp");            // BATTLE arena
    hidescreen_down(200);                     // Nice GFX
    newscreen();                              // Update screen
    showscreen_up(200);                       // Another nice GFX
    pois=FALSE;                               // Initialize (pois=out)
    return(0);
}
void win_lose() {
    if(pois==LOSE) {                      // If all players died
	for(x=0; x<players; x++)
	    if(lives[x])                  // if lives left
		pois=FALSE;               // set 'pois' to false
	for(x=0; x<players; x++)
	    launch[x]=FALSE;              // init launches
    } else if(pois==WIN) {                // if level completed
	for(x=0; x<players; x++)          // Loop 1
	    launch[x]=FALSE;              // init launches to false
	level++;                          // next level
	if(level>'9') {                   // if levels completed
	    level = '0';                  // set levels to zero
	    stage++;                      // and go to next stage
	}
	levelname[4]=level;               // set level
	levelname[5]=stage;               // and stage
	back.destruct();                  // prepare for loading
	handle=fopen(levelname, "rb");    // check if is more levels
	if(handle==NULL) {                // if no levels left
	    levelname[4]='0';             // set level to zero
	    levelname[5]='0';             // set stage to zero
	    stage='0';                    // set 'stage' to zero
	    level='0';                    // set 'level' to zero
	}
	fclose(handle);                   // close handle
	hidescreen_down(200);
	for(x=0; x<32000; x++)
	    dblbuf[x*2]=dblbuf[x*2+1]=0;
	showstatus();
	showscreen_down(200);
	sleep(2);
    }
}
char chkblock(animation *ptr, int number) {       // Check collision to number
    y  = ptr->gety();                             // Location...
    x  = ptr->getx();                             // Location...
    sy = ptr->getysize();                         // Size...
    sx = ptr->getxsize();                         // And size
    if(back.frame[0][   y   /10 *32 +   x    /10 ] == number) return(1); // TL
    if(back.frame[0][   y   /10 *32 + (x+sx) /10 ] == number) return(2); // TR
    if(back.frame[0][ (y+sy)/10 *32 +   x    /10 ] == number) return(3); // BL
    if(back.frame[0][ (y+sy)/10 *32 + (x+sx) /10 ] == number) return(4); // BR
    return(0);                                    // Return zero if no hit
}
void clrblock(char hit) {                         // Clear block where 'hit'
    if(hit==1) back.frame[0][   y    /10*32+   x    /10]=0;
    if(hit==2) back.frame[0][   y    /10*32+ (x+sx) /10]=0;
    if(hit==3) back.frame[0][ (y+sy) /10*32+   x    /10]=0;
    if(hit==4) back.frame[0][ (y+sy) /10*32+ (x+sx) /10]=0;
    newscreen();                                  // Update screen
}
void flash() {                                    // Show some white light
    for(x=0; x<32000; x++)                        // Loop 1
	screen[x*2]=screen[x*2+1]=254;            // White to two spots
}
void init() {                                     // Init cubelocations
    int x;                                        // Loop integer
    if(players > 0 && lives[0]) cube[0].setloc(11, 11);       // Player 1
    if(players > 1 && lives[1]) cube[1].setloc(11,179);       // Player 2
    if(players > 2 && lives[2]) cube[2].setloc(299,11);       // Player 3
    if(players > 3 && lives[3]) cube[3].setloc(299,179);      // Player 4
    for(x=0; x<players; x++) {                    // Loop 1
	cube[x].setspeed(0, 0);                   // Set moving to zero
	if(mode==COMBAT)
	    lives[x]=5;
    }
    newscreen();
    delay(500);                                  // Little delay
}
void checkkbd() {                                 // Check keyboard actions
    for(current=0; current<players; current++) {  // Check each players keys
	if(lives[current]) {
	if(napit[keys[current][0]] == 1) cube[current].setspeed( 0, -1);
	if(napit[keys[current][1]] == 1) cube[current].setspeed( 0,  1);
	if(napit[keys[current][2]] == 1) cube[current].setspeed(-1,  0);
	if(napit[keys[current][3]] == 1) cube[current].setspeed( 1,  0);
	if(napit[keys[current][4]] == 1) {        // Shooting key
	    if(!launch[current] && bombs[current] && energy[current]) {
		shot[current].setloc(  cube[current].getx(),
		cube[current].gety()  );          // location same with cube
		shot[current].setspeed(cube[current].getxspeed() *2,
		cube[current].getyspeed() *2);    // two times cube's speed
		bombs[current]--;                 // decrease 'bombs'
		launch[current]=TRUE;             // 'launch' is true
		newscreen();                      // slow update
	    }
	}
	}
    }
    if(napit[0x4A] == 1) if(viive) asm  dec  viive // Global speed increasing
    if(napit[0x4E] == 1) asm  inc  viive          // Global speed decreasing
    if(napit[0x01] == 1) {
	globlives=FALSE;                          // Quit game
	pois=TRUE;
    }
    if(napit[0x44] == 1) pois=WIN;                // The SECRET nextlevel key
    if(napit[0x3B] == 1) savescreen();
}
void checkcol() {                                 // Check collisions
    if( chkblock(&cube[current], 7) && energy[current] && lives[current]) {
	energy[current]=FALSE; // Undestroyable wall
	lives[current]--;
	newscreen();
    }
    if( chkblock(&cube[current], 1) && energy[current] && lives[current]) {
	energy[current]--; // Normal wall
	if(!energy[current]) lives[current]--;
	cube[current].setspeed(MINUS2PLUS(cube[current].getxspeed()),
			       MINUS2PLUS(cube[current].getyspeed()));
	newscreen();
    }
    if( chkblock(&cube[current], 2) && energy[current] && lives[current]) {
	energy[current]--; // Hidden wall
	if(!energy[current]) lives[current]--;
	cube[current].setspeed(MINUS2PLUS(cube[current].getxspeed()),
			       MINUS2PLUS(cube[current].getyspeed()));
	newscreen();
    }
    if( chkblock(&cube[current], 4)  && bombs[current] != 5 &&
	lives[current]) { // extra bomb
	bombs[current]++;                         // increase
	clrblock( chkblock(&cube[current], 4) );  // remove bonus
    }
    if( chkblock(&cube[current], 5) && lives[current] &&
	lives[current] != 5) { // extra life
	lives[current]++;                         // increase
	clrblock( chkblock(&cube[current], 5) );  // remove bonus
    }
    if( mode == COMBAT) {                          // if COMBAT mode
	if(chkblock(&cube[current], 6) && energy[current] && lives[current]) {
	    if(alive == 1) {                       // There can be only one !
		pois=WIN;			          // Someone wins
		info[current].wins++;
	    }
	    else if(bombs[current] != 5) {
		for(x=0; x<5; x++) {                  // Loop 1
		    bomb.setloc( (current >> 1) * 310, PARITY(current)*190 +
			       ( (PARITY(current) * -2 + 1) *(x*10)) );
		    bomb.show();
		}
		bombs[current] = 5;
	    }
	}
    } else {
	if(chkblock(&cube[current], 6) && energy[current] && lives[current]) {
	    pois=WIN;                             // EXITLEVEL
	    info[current].wins++;
	}
    }
    if(launch[current]) {                         // Bomb check
	if(chkblock(&shot[current], 7))
	    launch[current]=FALSE;
	if(chkblock(&shot[current], 1)) {         // If hit
	    clrblock(chkblock(&shot[current], 1));// Clear block
	    flash();                              // Flash !
	    launch[current]=FALSE;                // Next bomb not launched
	}
    }
}
void check_kill() {
    if( cube[current].getcolstatus() && energy[current]) {
	energy[current]=FALSE;    // If hit on edge of screen
	lives[current]--;
	newscreen();
    }
    for(x=current+1; x<players; x++) { // Loop for everyone
	if( cube[current].getspritecol(&cube[x]) && // If hit
	energy[x] && energy[current]) {             // another player
	    energy[x]=energy[current]=FALSE;        // energies to 0
	    lives[current]--;
	    lives[x]--;
	    newscreen();
	}
	if( cube[current].getspritecol(&shot[x]) && // If hit
	launch[x] && energy[current]) {             // bomb
	    energy[current]--;
	    launch[x]=FALSE;
	    if(!energy[current]) {
		lives[current]--;
		info[x].kills++;
	    }
	    cube[current].setspeed(MINUS2PLUS(cube[current].getxspeed()),
				   MINUS2PLUS(cube[current].getyspeed()));
	    newscreen();
	}
	if( cube[x].getspritecol(&shot[current]) && // If own
	energy[x] && launch[current]) {             // bomb hit
	    energy[x]--;
	    launch[current]=FALSE;        // kill player
	    if(!energy[x]) {
		lives[x]--;
		info[current].kills++;
	    }
	    cube[x].setspeed(MINUS2PLUS(cube[x].getxspeed()),
			     MINUS2PLUS(cube[x].getyspeed()));
	    newscreen();
	}
    }
}
void checkalive() {
    alive = 0;                        // default is no one alive
    globlives = 0;
    for(x=0; x<players; x++) {        // Check for players
	if(energy[x]!=FALSE)          // If someone haves energy
	    alive++;                  // IT'S ALIVE !
	if(lives[x])
	    globlives+=lives[x];
    }
    if(!alive) pois=TRUE;             // If no one's alive -> quit
}