#include <string.h>

class font {
	char far *fontptr;
	char far *window;
	int x;
	int y;
	int xsize;
	int ysize;
public:
	font(char *);
	destruct();

	void gprint(char *, int x, int y, int color, ...);
	void gputc(char ch, int x, int y, int color);
	void gint(int normal, int x, int y, int color);
	void guint(WORD normal, int x, int y, int color);
	void openwindow(int a, int b, int ba, int bb, int color);
	void closewindow();
};

font::font(char *tiednimi) {
	FILE *handle;
	WORD pointer;

	handle=fopen(tiednimi, "rb");
	window=NULL;
	fontptr=(char far *)farmalloc(256*40);
	if(fontptr!=NULL && handle!=NULL) {
		for(pointer=0; pointer<256*40; pointer++)
			fontptr[pointer]=fgetc(handle);
		fcloseall();
	} else {
		textmode(0x03);
		printf("Out of memory when loading font : %s",tiednimi);
		exit(1);
	}
}

void font::gprint(char *string, int x, int y, int color, ...) {
	int c;
	for(c=0; c<strlen(string); c++)
		gputc(string[c], x+c*6, y, color);
}

void font::gputc(char ch, int x, int y, int color) {
	int bx, by;
	for(bx=0; bx<5; bx++)
		for(by=0; by<8; by++)
			if(fontptr[256*5*by +  ch*5+bx ]==1)
				dblbuf[(by+y)*320+bx+x]=color;
}

void font::gint(int normal, int x, int y, int color) {
    char *string=(char *)malloc(20);
    if(string == NULL) {
	itoa(normal, string, 10);
	gprint(string, x, y, color);
	free(string);
    }
}

void font::guint(WORD normal, int x, int y, int color) {
    char *string=(char *)malloc(20);
    if(string != NULL) {
	itoa(normal, string, 10);
	gprint(string, x, y, color);
	free(string);
    }
}

void font::openwindow(int a, int b, int ba, int bb, int color) {
	int n, i;
	if(window!=NULL) {
		for(n=0; n<xsize; n++)
			for(i=0; i<ysize; i++)
				dblbuf[(i+y)*320+n+x]=window[i*xsize+n];
		farfree(window);
		window=NULL;
	}
	x=a; y=b; xsize=ba; ysize=bb;
	window=(char far *)farmalloc(xsize*ysize);
	if(window!=NULL) {
	    for(n=0; n<xsize; n++)
		for(i=0; i<ysize; i++) {
		    window[i*xsize+n]=dblbuf[(i+y)*320+n+x];
		    if(color!=TRANS) dblbuf[(i+y)*320+n+x]=color;
		}
	} else exit(1);
}

void font::closewindow() {
	int n, i;
	if(window!=NULL) {
		for(n=0; n<xsize; n++)
			for(i=0; i<ysize; i++)
				dblbuf[(i+y)*320+n+x]=window[i*xsize+n];
		farfree(window);
	}
	window=NULL;
}