C  DESCRIPTION OF THE DATABASE FORMAT
C
C
C  THE DATA FILE CONTAINS SEVERAL SECTIONS.  EACH BEGINS WITH A LINE CONTAINING
C  A NUMBER IDENTIFYING THE SECTION, AND ENDS WITH A LINE CONTAINING "-1".
C
C  SECTION 1: LONG FORM DESCRIPTIONS.  EACH LINE CONTAINS A LOCATION NUMBER,
C       A COMMA, AND A LINE OF TEXT.  THE SET OF (NECESSARILY ADJACENT) LINES
C       WHOSE NUMBERS ARE X FORM THE LONG DESCRIPTION OF LOCATION X.
C  SECTION 2: SHORT FORM DESCRIPTIONS.  SAME FORMAT AS LONG FORM.  NOT ALL
C       PLACES HAVE SHORT DESCRIPTIONS.
C  SECTION 3: TRAVEL TABLE.  EACH LINE CONTAINS A LOCATION NUMBER (X), A SECOND
C       LOCATION NUMBER (Y), AND A LIST OF MOTION NUMBERS (SEE SECTION 4).
C       EACH MOTION REPRESENTS A VERB WHICH WILL GO TO Y IF CURRENTLY AT X.
C       Y, IN TURN, IS INTERPRETED AS FOLLOWS.  LET M=Y/1000, N=Y MOD 1000.
C              IF N<=300       IT IS THE LOCATION TO GO TO.
C               IF 300<N<=500   N=300 IS USED IN A COMPUTED GOTO TO
C                                       A SECTION OF SPECIAL CODE.
C               IF N>500        MESSAGE N-500 FROM SECTION 6 IS PRINTED,
C                                       AND HE STAYS WHEREVER HE IS.
C       MEANWHILE, M SPECIFIES THE CONDITIONS ON THE MOTION.
C               IF M=0          IT'S UNCONDITIONAL.
C               IF 0<M<100      IT IS DONE WITH M% PROBABILITY.
C               IF M=100        UNCONDITIONAL, BUT FORBIDDEN TO DWARVES.
C               IF 100<M<=200   HE MUST BE CARRYING OBJECT M-100.
C               IF 200<M<=300   MUST BE CARRYING OR IN SAME ROOM AS M-200.
C               IF 300<M<=400   PROP(M MOD 100) MUST *NOT* BE 0.
C               IF 400<M<=500   PROP(M MOD 100) MUST *NOT* BE 1.
C               IF 500<M<=600   PROP(M MOD 100) MUST *NOT* BE 2, ETC.
C       IF THE CONDITION (IF ANY) IS NOT MET, THEN THE NEXT *DIFFERENT*
C       "DESTINATION" VALUE IS USED (UNLESS IT FAILS TO MEET *ITS* CONDITIONS,
C       IN WHICH CASE THE NEXT IS FOUND, ETC.).  TYPICALLY, THE NEXT DEST WILL
C       BE FOR ONE OF THE SAME VERBS, SO THAT ITS ONLY USE IS AS THE ALTERNATE
C       DESTINATION FOR THOSE VERBS.  FOR INSTANCE:
C               15      110022  29      31      34     35     23     43
C               15      14      29
C       THIS SAYS THAT, FROM LOC 15, ANY OF THE VERBS 29, 31, ETC., WILL TAKE
C       HIM TO 22 IF HE'S CARRYING OBJECT 10, AND OTHERWISE WILL GO TO 14.
C               11      303008  49
C               11      9       50
C       THIS SAYS THAT, FROM 11, 49 TAKES HIM TO 8 UNLESS PROP(3)=0, IN WHICH
C       CASE HE GOES TO 9.  VERB 50 TAKES HIM TO 9 REGARDLESS OF PROP(3).
C  SECTION 4: VOCABULARY.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C       FIVE-LETTER WORD.  CALL M=N/1000.  IF M=0, THEN THE WORD IS A MOTION
C       VERB FOR USE IN TRAVELLING (SEE SECTION 3).  ELSE, IF M=1, THE WORD IS
C       AN OBJECT.  ELSE, IF M=2, THE WORD IS AN ACTION VERB (SUCH AS "CARRY"
C       OR "ATTACK").  ELSE, IF M=3, THE WORD IS A SPECIAL CASE VERB (SUCH AS
C       "DIG") AND N MOD 1000 IS AN INDEX INTO SECTION 6.  OBJECTS FROM 50 TO
C       (CURRENTLY, ANYWAY) 79 ARE CONSIDERED TREASURES (FOR PIRATE, CLOSEOUT).
C  SECTION 5: OBJECT DESCRIPTIONS.  EACH LINE CONTAINS A NUMBER (N), A TAB,
C       AND A MESSAGE.  IF N IS FROM 1 TO 100, THE MESSAGE IS THE "INVENTORY"
C       MESSAGE FOR OBJECT N.  OTHERWISE, N SHOULD BE 000, 100, 200, ETC., AND
C       THE MESSAGE SHOULD BE THE DESCRIPTION OF THE PRECEDING OBJECT WHEN ITS
C       PROP VALUE IS N/100.  THE N/100 IS USED ONLY TO DISTINGUISH MULTIPLE
C       MESSAGES FROM MULTI-LINE MESSAGES; THE PROP INFO ACTUALLY REQUIRES ALL
C       MESSAGES FOR AN OBJECT TO BE PRESENT AND CONSECUTIVE.  PROPERTIES WHICH
C       PRODUCE NO MESSAGE SHOULD BE GIVEN THE MESSAGE ">$<".
C  SECTION 6: ARBITRARY MESSAGES.  SAME FORMAT AS SECTIONS 1, 2, AND 5, EXCEPT
C       THE NUMBERS BEAR NO RELATION TO ANYTHING (EXCEPT FOR SPECIAL VERBS
C       IN SECTION 4).
C  SECTION 7: OBJECT LOCATIONS.  EACH LINE CONTAINS AN OBJECT NUMBER AND ITS
C       INITIAL LOCATION (ZERO (OR OMITTED) IF NONE).  IF THE OBJECT IS
C       IMMOVABLE, THE LOCATION IS FOLLOWED BY A "-1".  IF IT HAS TWO LOCATIONS
C       (E.G., THE GRATE) THE FIRST LOCATION IS FOLLOWED WITH THE SECOND, AND
C       THE OBJECT IS ASSUMED TO BE IMMOVABLE.
C  SECTION 8: ACTION DEFAULTS.  EACH LINE CONTAINS AN "ACTION-VERB" NUMBER AND
C       THE INDEX (IN SECTION 6) OF THE DEFAULT MESSAGE FOR THE VERB.
C  SECTION 9: LIQUID ASSETS, ETC.  EACH LINE CONTAINS A NUMBER (N) AND UP TO 20
C       LOCATION NUMBERS. BIT N (WHERE 0 IS THE UNITS BIT) IS SET IN COND(LOC)
C       FOR EACH LOC GIVEN.  THE COND BITS CURRENTLY ASSIGNED ARE:
C               0       LIGHT
C               1       IF BIT 2 IS ON; ON FOR OIL, OFF FOR WATER
C               2       LIQUID ASSET, SEE BIT 1
C               3       PIRATE DOESN'T GO HERE UNLESS FOLLOWING PLAYER
C       OTHER BITS ARE USED TO INDICATE AREAS OF INTEREST TO "HINT" ROUTINES:
C               4       TRYING TO GET INTO CAVE
C               5       TRYING TO CATCH BIRD
C               6       TRYING TO DEAL WITH SNAKE
C               7       LOST IN MAZE
C               8       PONDERING DARK ROOM
C               9       AT WITT'S END
C       COND(LOC) IS SET TO 2, OVERRIDING ALL OTHER BITS, IF LOC HAS FORCED
C       MOTION.
C  SECTION 10: CLASS MESSAGES.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C       MESSAGE DESCRIBING A CLASSIFICATION OF PLAYER.  THE SCORING SECTION
C       SELECTS THE APPROPRIATE MESSAGE, WHERE EACH MESSAGE IS CONSIDERED TO
C       APPLY TO PLAYERS WHOSE SCORES ARE HIGHER THAN THE PREVIOUS N BUT NOT
C       HIGHER THAN THIS N.  NOTE THAT THESE SCORES PROBABLY CHANGE WITH EVERY
C       MODIFICATION (AND PARTICULARLY EXPANSION) OF THE PROGRAM.
C  SECTION 11: HINTS.  EACH LINE CONTAINS A HINT NUMBER (CORRESPONDING TO A
C       COND BIT, SEE SECTION 9), THE NUMBER OF TURNS HE MUST BE AT THE RIGHT
C       LOC(S) BEFORE TRIGGERING THE HINT, THE POINTS DEDUCTED FOR TAKING THE
C       HINT, THE MESSAGE NUMBER (SECTION 6) OF THE QUESTION, AND THE MESSAGE
C       NUMBER OF THE HINT.  THESE VALUES ARE STASHED IN THE "HINTS" ARRAY,
C       HNTMAX IS SET TO THE MAX HINT NUMBER (<>= HNTSIZ).  NUMBERS 1-3 ARE
C       UNUSABLE SINCE COND BITS ARE OTHERWISE ASSIGNED, SO 2 IS USED TO
C       REMEMBER IF HE'S READ THE CLUE IN THE REPOSITORY, AND 3 IS USED TO
C       REMEMBER WHETHER HE ASKED FOR INSTRUCTIONS (GETS MORE TURNS, BUT LOSES
C       POINTS).
C  SECTION 12: MAGIC MESSAGES.  IDENTICAL TO SECTION 6 EXCEPT PUT IN A SEPARATE
C       SECTION FOR EASIER REFERENCE.  MAGIC MESSAGES ARE USED BY THE STARTUP,
C       MAINTENANCE MODE, AND RELATED ROUTINES.
C  SECTION 0: END OF DATABASE.
