@echo off
echo Welcome to the SimCity 2000(TM) Version 1.1 Updater!
echo.
echo This will update all versions of SimCity 2000 to the most recent
echo version (v1.10). It will not alter any saved games or scenarios.
echo.

rem *********************************************************************** 
rem The contents of this disk or self-extracting archive must be copied
rem into the SimCity 2000 directory in order for the patch to function.
rem *********************************************************************** 

rem Make sure we're even in the right place
if not exist sc2000.exe goto wrongdir

rem Check for foreign versions first
filelen sc2000.dat 2627010 2629981 2698683 2689206 >nul
if errorlevel 4 goto foreign
if errorlevel 3 goto foreign
if errorlevel 2 goto us
if errorlevel 1 goto patchaus
goto bad

:patchaus
echo Patching Australian release.
patch.exe austral.rtp 
goto good

:us
rem Now sort thru US versions
filelen sc2000.exe 1046112 1052000 1059744 >nul

if errorlevel 3 goto already
if errorlevel 2 goto patch101
if errorlevel 1 goto patch100

:foreign
echo Your version of SimCity 2000 is not a standard release version; it has
echo either been modified or updated in a way we cannot handle (i.e. is an
echo early beta patch) or is a foreign-language version which is not
echo compatible with this updater. Reinstall SimCity 2000 from your original 
echo distribution disks and then re-run the patch. If you still receive
echo this error message you will need new disks to upgrade to version 1.1.
goto bad

:patch100
echo Patching v1.00.
patch.exe SC2fix.rtp
goto good

:patch101
echo Patching v1.01.
patch.exe SC101AA.rtp
goto good

:already
echo You are already using SimCity 2000 v1.1. You do not need to re-update.
goto bad

:wrongdir
echo The patch does not run directly from the floppy disk; its files
echo must be copied into the SimCity 2000 directory, i.e. 
echo COPY A:*.* C:\SC2000 or similar; and then the patch may be executed
echo in that directory.
goto bad
        
:foriegn
echo This patch is unable to patch foreign language releases of 
echo SimCity 2000. You will need new disks in order to upgrade.
goto bad

:bad
echo.
echo The patch did not complete successfully. Check the error messages you
echo received, verify that the instructions were followed properly, and 
echo then contact Maxis Customer Support.
goto end

:good
copy a32awe32.dll .\sound
echo.
echo The patch completed successfully. Enjoy SimCity 2000!

rem *********************************************************************** 
rem
rem                          Credits in brief
rem
rem *********************************************************************** 
rem
rem Batch file misprogramming by Aaron "Dr Emu" Shephard; RTPatching by
rem Michael Gilmartin; Project management by Chris "WEISS.C" Weiss; Lead
rem QA/Testing by Mike Gilmartin. Any questions you have will be answered 
rem by our crack team of Technical Support Weenies, headed by Roger J., 
rem and blamed on our crack team of QA/Testing folks, led by Alan B.
rem
rem And thanks to all of our devoted Maxis customers, waiting patiently
rem for so long for this patch... enjoy!
rem
rem *********************************************************************** 

:end

